/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.util;

import com.iscobol.compiler.ErrorInCompilationException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.FileFinder;
import com.iscobol.compiler.InvokeNotifier;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.remote.RemoteError;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IscobolNatureExt;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.license.LicenseController;
import com.iscobol.plugins.editor.license.MissingLicenseException;
import com.iscobol.plugins.editor.util.CopyFileName;
import com.iscobol.plugins.editor.util.ErrorObj;
import com.iscobol.plugins.editor.util.ErrorsExt;
import com.iscobol.plugins.editor.util.InternalErrorException;
import com.iscobol.plugins.editor.util.ProjectClassLoader;
import com.iscobol.plugins.editor.util.ProjectFileFinder;
import com.iscobol.plugins.editor.util.ProjectSettingList;
import com.iscobol.plugins.editor.util.SettingList;
import com.iscobol.plugins.editor.util.SettingMode;
import com.iscobol.plugins.editor.util.SettingModeListener;
import com.iscobol.plugins.editor.util.operations.CreateFileOperation;
import com.iscobol.plugins.editor.util.operations.CreateFolderOperation;
import com.iscobol.plugins.editor.util.operations.CreateLinkFileOperation;
import com.iscobol.plugins.editor.util.operations.DeleteFileOperation;
import com.iscobol.plugins.editor.util.operations.DeleteFolderOperation;
import com.iscobol.plugins.editor.util.operations.ModifyFileOperation;
import com.iscobol.plugins.editor.views.IIscobolNavigator;
import com.iscobol.rts.Config;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

/*
 * Exception performing whole class analysis ignored.
 */
public class PluginUtilities {
    public static final OutputStream dummyOutputStream = new /* Unavailable Anonymous Inner Class!! */;
    public static final String TAIL_DELIM_STRING = " =():\".,";
    public static final String HEAD_DELIM_STRING = " =(:\",";
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    public static final int UNKNOWN_FORMAT = 0;
    public static final int ANSI_FORMAT = 1;
    public static final int TERMINAL_FORMAT = 2;
    public static final int FREE_FORMAT = 3;
    public static final int MIXED_FORMAT = 4;
    public static final String ISCOBOL_NATURE_ID = "com.iscobol.plugins.editor.IscobolEditor.IscobolNature";
    public static final String ISCOBOL_NATURE_EXT_ID = "com.iscobol.plugins.editor.IscobolEditor.IscobolNatureExt";
    public static final String ISCOBOL_HTML_NATURE_ID = "com.iscobol.plugins.HtmlAndroid.IscobolHtmlAndroidNature";
    public static final String LIBRARIES_PLUGIN_ID = "com.iscobol.plugins.libraries";
    public static final String EDITOR_PLUGIN_ID = "com.iscobol.plugins.editor.IscobolEditor";
    public static final String WEBDIRECTLAUNCHER_PLUGIN_ID = "com.iscobol.plugins.webdirectlauncher";
    public static final String SCREENPAINTER_PLUGIN_ID = "com.iscobol.plugins.screenpainter.IscobolScreenPainter";
    public static final String HTML_ANDROID_PLUGIN_ID = "com.iscobol.plugins.HtmlAndroid";
    public static final String[] SOURCE_FORMAT_OPTIONS = new String[]{"-sa", "-st", "-sf", "-smat"};
    public static final String ISCOBOL_NAVIGATOR_VIEW_ID = "com.iscobol.plugins.editor.views.IscobolNavigator";
    public static final String ISCOBOL_STRUCTURAL_VIEW_ID = "com.iscobol.plugins.screenpainter.views.IscobolStructuralView";
    public static final String ISCOBOL_FILE_VIEW_ID = "com.iscobol.plugins.screenpainter.views.IscobolFileView";
    public static final String ISCOBOL_DATA_VIEW_ID = "com.iscobol.plugins.screenpainter.views.IscobolDataView";
    private static final String oneAlpha = "(.)*((\\p{Alpha})|[-])(.)*";
    private static final String domainIdentifier = "((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})";
    private static final String domainNameRule = "(((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum}))((\\.)(((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})))*";
    private static Hashtable<IResource, PropertyChangeSupport> resourceListeners = new Hashtable();
    private static Vector<SettingModeListener> settingModeListeners = new Vector();
    private static int browserIdProg;

    public static File getStateLocation() {
        IPath iPath = IscobolEditorPlugin.getDefault().getStateLocation();
        if (iPath != null) {
            return iPath.toFile();
        }
        return null;
    }

    private static void checkFilename(String string, OptionList optionList) throws InternalErrorException {
        if (string.endsWith(".err") && (optionList.getOption("-eo=") != null || optionList.getOption("-ef") != null)) {
            throw new InternalErrorException(string + ": " + IsresourceBundle.getString((String)"incomp_opt_msg") + " " + "-ef");
        }
        if (string.endsWith(".list") && (optionList.getOption("-lo=") != null || optionList.getOption("-lf") != null)) {
            throw new InternalErrorException(string + ": " + IsresourceBundle.getString((String)"incomp_opt_msg") + " " + "-lf");
        }
    }

    public static boolean isSourceFormat(String string) {
        for (int i = 0; i < SOURCE_FORMAT_OPTIONS.length; ++i) {
            if (!string.equals(SOURCE_FORMAT_OPTIONS[i])) continue;
            return true;
        }
        return false;
    }

    public static String getPropertyFileLocation(IProject iProject) {
        try {
            IFile iFile;
            IFolder iFolder = PluginUtilities.getResourcesFolder((IProject)iProject);
            if (iFolder != null && (iFile = iFolder.getFile((IPath)new Path("iscobol.properties"))).exists()) {
                return iFile.getLocation().toOSString();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static Pcc pccAnalyze(String string, OptionList optionList, String string2, Errors errors, Reader reader, IResource iResource, InvokeNotifier invokeNotifier, FileFinder fileFinder) {
        String string3;
        try {
            LicenseController.licinfo((byte[])PluginUtilities.getCompA(), (byte[])PluginUtilities.getCompB(), (byte[])PluginUtilities.getCompC());
        }
        catch (MissingLicenseException missingLicenseException) {
            throw new InternalErrorException("isCOBOL Compiler: " + missingLicenseException.getMessage());
        }
        PrintStream printStream = System.err;
        PrintStream printStream2 = System.out;
        PrintStream printStream3 = new PrintStream(dummyOutputStream);
        System.setOut(printStream3);
        System.setErr(printStream3);
        PluginUtilities.checkFilename((String)string, (OptionList)optionList);
        if (iResource != null && fileFinder == null) {
            fileFinder = new ProjectFileFinder(iResource.getProject(), string2, optionList.getOption("-ce="));
        }
        Pcc.resetAllCounters();
        Pcc.setInvokeNotifier((InvokeNotifier)invokeNotifier);
        HashMap[] hashMapArray = null;
        if (iResource != null && iResource.getProject() != null && (string3 = PluginUtilities.getPropertyFileLocation((IProject)iResource.getProject())) != null) {
            hashMapArray = PluginUtilities.setProperties((String)string3);
        }
        string3 = Pcc.analyze((String)string, (OptionList)optionList, (Errors)errors, (Reader)reader, (FileFinder)fileFinder);
        if (hashMapArray != null) {
            PluginUtilities.restoreProperties(hashMapArray);
        }
        System.setOut(printStream2);
        System.setErr(printStream);
        Pcc.setInvokeNotifier(null);
        return string3;
    }

    public static Pcc pccRun(String string, String string2, String string3, OptionList optionList, String string4, String string5, Reader reader, boolean bl, IResource iResource) {
        return PluginUtilities.pccRun((String)string, (String)string2, (String)string3, (OptionList)optionList, (String)string4, (String)string5, (Reader)reader, (boolean)false, (boolean)bl, (IResource)iResource);
    }

    public static Pcc pccRun(String string, String string2, String string3, OptionList optionList, String string4, String string5, Reader reader, boolean bl, boolean bl2, IResource iResource) throws InternalErrorException {
        try {
            LicenseController.licinfo((byte[])PluginUtilities.getRtmA(), (byte[])PluginUtilities.getRtmB(), (byte[])PluginUtilities.getRtmC());
        }
        catch (MissingLicenseException missingLicenseException) {
            throw new InternalErrorException("isCOBOL Compiler: " + missingLicenseException.getMessage());
        }
        PrintStream printStream = System.err;
        PrintStream printStream2 = System.out;
        PrintStream printStream3 = new PrintStream(dummyOutputStream);
        System.setOut(printStream3);
        System.setErr(printStream3);
        if (string2 != null && string2.length() > 0 && !string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        PluginUtilities.checkFilename((String)string, (OptionList)optionList);
        ProjectFileFinder projectFileFinder = null;
        if (iResource != null) {
            projectFileFinder = new ProjectFileFinder(iResource.getProject(), string4, optionList.getOption("-ce="));
        }
        Pcc.resetAllCounters();
        HashMap[] hashMapArray = null;
        if (string3 != null) {
            hashMapArray = PluginUtilities.setProperties((String)string3);
        }
        Pcc pcc = null;
        try {
            pcc = Pcc.run((String)string, (String)string2, (OptionList)optionList, (String)string5, (Errors)new ErrorsExt(bl), (Reader)reader, (boolean)bl2, (FileFinder)projectFileFinder);
        }
        catch (ErrorInCompilationException errorInCompilationException) {
            pcc = errorInCompilationException.pcc;
        }
        if (hashMapArray != null) {
            PluginUtilities.restoreProperties((HashMap[])hashMapArray);
        }
        System.setOut(printStream2);
        System.setErr(printStream);
        return pcc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, String>[] setProperties(String string) {
        Properties properties = new Properties();
        HashMap[] hashMapArray = new HashMap[]{new HashMap(), new HashMap()};
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.startsWith("iscobol.")) {
                hashMapArray[0].put(string2, Config.getProperty((String)string2, null));
                Config.setProperty((String)string2, (String)properties.getProperty(string2));
                continue;
            }
            hashMapArray[1].put(string2, System.getProperty(string2));
            System.setProperty(string2, properties.getProperty(string2));
        }
        return hashMapArray;
    }

    private static void restoreProperties(HashMap<String, String>[] hashMapArray) {
        String string;
        for (String string2 : hashMapArray[0].keySet()) {
            string = hashMapArray[0].get(string2);
            if (string != null) {
                Config.setProperty((String)string2, (String)string);
                continue;
            }
            Config.unsetProperty((String)string2);
        }
        for (String string2 : hashMapArray[1].keySet()) {
            string = hashMapArray[1].get(string2);
            if (string != null) {
                System.setProperty(string2, string);
                continue;
            }
            System.clearProperty(string2);
        }
    }

    public static CopyFileName[] getCopyFileNames(Vector vector) {
        try {
            CopyFileName[] copyFileNameArray = new CopyFileName[vector.size()];
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String[] stringArray = (String[])vector.elementAt(i);
                copyFileNameArray[i] = new CopyFileName(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2]);
            }
            return copyFileNameArray;
        }
        catch (Exception exception) {
            return new CopyFileName[0];
        }
    }

    public static String getPluginInstallLocation(String string) throws IOException, URISyntaxException {
        Bundle bundle = Platform.getBundle((String)string);
        if (bundle == null) {
            return null;
        }
        URL uRL = FileLocator.toFileURL((URL)bundle.getEntry("/"));
        String string2 = uRL.getPath();
        if (Platform.getOS().equals("win32")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    public static boolean loadAndCheckClass(String string, String string2) {
        URLClassLoader uRLClassLoader = null;
        try {
            URL[] uRLArray = new URL[]{new File(string2).toURI().toURL()};
            uRLClassLoader = new URLClassLoader(uRLArray, PluginUtilities.class.getClassLoader());
            Class<?> clazz = uRLClassLoader.loadClass(string);
            return clazz.getMethod("main", String[].class) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Bundle getIscobolNativeLibraryPlugin() {
        String string = "com.iscobol.plugins.libraries." + Platform.getOS() + "." + Platform.getWS() + "." + Platform.getOSArch();
        return Platform.getBundle((String)string);
    }

    public static String getIscobolNativeLibraryPath() {
        try {
            Bundle bundle = PluginUtilities.getIscobolNativeLibraryPlugin();
            if (bundle != null) {
                URL uRL = FileLocator.toFileURL((URL)bundle.getEntry("/"));
                String string = uRL.getPath();
                if (Platform.getOS().equals("win32")) {
                    string = string.substring(1);
                }
                return string;
            }
        }
        catch (Exception exception) {
            PluginUtilities.log((Throwable)exception);
        }
        return "";
    }

    public static String getIscobolLibraryPath() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = PluginUtilities.getPluginInstallLocation((String)"com.iscobol.plugins.libraries");
            if (string == null) {
                return "";
            }
            File file = new File(string);
            stringBuffer.append(file.getAbsolutePath() + File.separator + "config");
            File[] fileArray = new File(file.getAbsolutePath() + File.separator + "libs").listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
            for (int i = 0; i < fileArray.length; ++i) {
                stringBuffer.append(File.pathSeparator);
                stringBuffer.append(fileArray[i].getAbsolutePath());
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            PluginUtilities.log((Throwable)exception);
            return "";
        }
    }

    public static String getWD2LibraryPath() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = PluginUtilities.getPluginInstallLocation((String)"com.iscobol.plugins.webdirectlauncher");
            if (string == null) {
                return "";
            }
            File file = new File(string);
            stringBuffer.append(file.getAbsolutePath() + File.separator + "bin");
            File[] fileArray = new File(file.getAbsolutePath() + File.separator + "libs").listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
            for (int i = 0; i < fileArray.length; ++i) {
                stringBuffer.append(File.pathSeparator);
                stringBuffer.append(fileArray[i].getAbsolutePath());
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            PluginUtilities.log((Throwable)exception);
            return "";
        }
    }

    public static String getIscobolConfigPath() {
        try {
            return PluginUtilities.getPluginInstallLocation((String)"com.iscobol.plugins.libraries") + "/config";
        }
        catch (Exception exception) {
            PluginUtilities.log((Throwable)exception);
            return "";
        }
    }

    public static void openBrowser(String string) {
        PluginUtilities.openBrowser((String)string, (int)32);
    }

    public static void openBrowser(String string, int n) {
        Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void addPropertyChangeListener(IResource iResource, PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)resourceListeners.get(iResource);
        if (propertyChangeSupport == null) {
            propertyChangeSupport = new PropertyChangeSupport(iResource);
            resourceListeners.put(iResource, propertyChangeSupport);
        }
        propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(IResource iResource) {
        PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)resourceListeners.get(iResource);
        if (propertyChangeSupport != null) {
            PropertyChangeListener[] propertyChangeListenerArray = propertyChangeSupport.getPropertyChangeListeners();
            for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
                propertyChangeSupport.removePropertyChangeListener(propertyChangeListenerArray[i]);
            }
            resourceListeners.remove(iResource);
        }
    }

    public static void removePropertyChangeListener(IResource iResource, PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)resourceListeners.get(iResource);
        if (propertyChangeSupport != null) {
            propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
            if (propertyChangeSupport.getPropertyChangeListeners().length == 0) {
                resourceListeners.remove(iResource);
            }
        }
    }

    private static IscobolNatureExt checkNature(IProject iProject) throws InternalErrorException {
        try {
            if (iProject == null || iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") == null) {
                throw new InternalErrorException();
            }
            IscobolNatureExt iscobolNatureExt = (IscobolNatureExt)iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNatureExt");
            if (iscobolNatureExt == null) {
                IProjectDescription iProjectDescription = iProject.getDescription();
                String[] stringArray = iProjectDescription.getNatureIds();
                String[] stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[stringArray.length] = "com.iscobol.plugins.editor.IscobolEditor.IscobolNatureExt";
                iProjectDescription.setNatureIds(stringArray2);
                iProject.setDescription(iProjectDescription, null);
                iscobolNatureExt = (IscobolNatureExt)iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNatureExt");
            }
            return iscobolNatureExt;
        }
        catch (CoreException coreException) {
            PluginUtilities.log((Throwable)coreException);
            throw new InternalErrorException((Throwable)coreException);
        }
    }

    public static void removePersistentProperties(IFile iFile) {
        IscobolNatureExt iscobolNatureExt = null;
        try {
            iscobolNatureExt = PluginUtilities.checkNature((IProject)iFile.getProject());
        }
        catch (InternalErrorException internalErrorException) {
            return;
        }
        String string = iFile.getFullPath().toPortableString();
        iscobolNatureExt.getProjectSettings().removeFileSettingList(string);
    }

    public static void copyPersistentProperties(IResource iResource, IResource iResource2) {
        if (iResource.getProject() != iResource2.getProject() || iResource.getType() != 1 || iResource2.getType() != 1) {
            return;
        }
        IscobolNatureExt iscobolNatureExt = null;
        try {
            iscobolNatureExt = PluginUtilities.checkNature((IProject)iResource.getProject());
        }
        catch (InternalErrorException internalErrorException) {
            return;
        }
        String string = iResource.getFullPath().toPortableString();
        SettingList settingList = iscobolNatureExt.getProjectSettings().getFileSettingList(string);
        if (settingList == null) {
            return;
        }
        string = iResource2.getFullPath().toPortableString();
        SettingList settingList2 = iscobolNatureExt.getProjectSettings().getFileSettingList(string);
        if (settingList2 == null) {
            settingList2 = new SettingList(string);
            iscobolNatureExt.getProjectSettings().putFileSettingList(settingList2);
        }
        Hashtable hashtable = settingList.getModes();
        for (String string2 : hashtable.keySet()) {
            SettingMode settingMode = (SettingMode)hashtable.get(string2);
            SettingMode settingMode2 = settingList2.getMode(string2);
            if (settingMode2 == null) {
                settingMode2 = new SettingMode(string2);
                settingList2.addMode(settingMode2);
            }
            settingMode2.setProperties(settingMode.getProperties());
        }
    }

    public static void setPersistentProperty(IResource iResource, String string, String string2, String string3) {
        SettingList settingList = PluginUtilities.getSettingList((IResource)iResource, (boolean)true);
        if (settingList != null) {
            if (string == null) {
                string = "Default";
            }
            if (settingList.hasMode(string)) {
                String string4 = settingList.getProperty(string, string2);
                if (iResource.getType() != 4) {
                    if (string3 == null) {
                        settingList.putProperty(string, string2, "___iscobol.option.false");
                    } else {
                        settingList.putProperty(string, string2, string3);
                    }
                } else if (string3 == null || string3.equals("___iscobol.option.false")) {
                    settingList.removeProperty(string, string2);
                } else {
                    settingList.putProperty(string, string2, string3);
                }
                PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)resourceListeners.get(iResource);
                if (propertyChangeSupport != null) {
                    propertyChangeSupport.firePropertyChange(string2, string4, string3);
                }
            }
        }
    }

    public static String getPersistentProperty(IResource iResource, String string, String string2) {
        SettingList settingList = PluginUtilities.getSettingList((IResource)iResource, (boolean)false);
        if (settingList != null) {
            if (string == null) {
                string = "Default";
            }
            if (settingList.hasMode(string)) {
                return settingList.getProperty(string, string2);
            }
        }
        return null;
    }

    public static ArrayList getAllOptions(IResource iResource, String string) {
        SettingList settingList = PluginUtilities.getSettingList((IResource)iResource, (boolean)false);
        if (settingList != null) {
            if (string == null) {
                string = "Default";
            }
            if (settingList.hasMode(string)) {
                return settingList.getAllProperty(string);
            }
        }
        return null;
    }

    public static void removePersistentProperty(IResource iResource, String string, String string2) {
        SettingList settingList = PluginUtilities.getSettingList((IResource)iResource, (boolean)false);
        if (settingList != null) {
            if (string == null) {
                string = "Default";
            }
            if (settingList.hasMode(string)) {
                settingList.removeProperty(string, string2);
            }
        }
    }

    public static void putSettingList(SettingList settingList, IProject iProject) {
        IscobolNatureExt iscobolNatureExt = null;
        try {
            iscobolNatureExt = PluginUtilities.checkNature((IProject)iProject);
        }
        catch (InternalErrorException internalErrorException) {
            return;
        }
        iscobolNatureExt.getProjectSettings().putFileSettingList(settingList);
    }

    public static SettingList getSettingList(IResource iResource, boolean bl) {
        IscobolNatureExt iscobolNatureExt = null;
        try {
            iscobolNatureExt = PluginUtilities.checkNature((IProject)iResource.getProject());
        }
        catch (InternalErrorException internalErrorException) {
            return null;
        }
        ProjectSettingList projectSettingList = null;
        if (iResource.getType() == 1) {
            String string = iResource.getFullPath().toPortableString();
            projectSettingList = iscobolNatureExt.getProjectSettings().getFileSettingList(string);
            if (projectSettingList == null && bl) {
                projectSettingList = new SettingList(string);
                iscobolNatureExt.getProjectSettings().putFileSettingList((SettingList)projectSettingList);
                Hashtable hashtable = iscobolNatureExt.getProjectSettings().getModes();
                for (SettingMode settingMode : hashtable.values()) {
                    if (SettingMode.isFixedMode((String)settingMode.getName())) continue;
                    SettingMode settingMode2 = new SettingMode(settingMode.getName());
                    projectSettingList.addMode(settingMode2);
                }
            }
        } else if (iResource.getType() == 4) {
            projectSettingList = iscobolNatureExt.getProjectSettings();
        }
        return projectSettingList;
    }

    public static String getCurrentSettingMode(IResource iResource) {
        SettingList settingList = PluginUtilities.getSettingList((IResource)iResource, (boolean)false);
        if (settingList != null) {
            if (iResource.getType() == 4) {
                return settingList.getCurrentMode();
            }
            String string = settingList.getCurrentMode();
            if (string == null) {
                try {
                    ProjectSettingList projectSettingList = ((IscobolNatureExt)iResource.getProject().getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNatureExt")).getProjectSettings();
                    return projectSettingList.getCurrentMode();
                }
                catch (CoreException coreException) {}
            } else {
                return string;
            }
        }
        return null;
    }

    public static void setCurrentSettingMode(String string, IResource iResource) {
        SettingList settingList = PluginUtilities.getSettingList((IResource)iResource, (boolean)true);
        if (settingList != null) {
            settingList.setCurrentMode(string);
        }
    }

    public static boolean hasSpecificSettings(IResource iResource) {
        if (!(iResource instanceof IFile) || !PluginUtilities.isSourceFile((IFile)((IFile)iResource))) {
            return false;
        }
        String string = PluginUtilities.getPersistentProperty((IResource)iResource.getProject(), (String)"Default", (String)"iscobol.checkfileopt");
        if (string == null || !string.equals("___iscobol.option.true")) {
            return false;
        }
        SettingList settingList = PluginUtilities.getSettingList((IResource)iResource, (boolean)false);
        if (settingList == null) {
            return false;
        }
        if (settingList.getCurrentMode() != null) {
            return true;
        }
        Hashtable hashtable = settingList.getModes();
        for (SettingMode settingMode : hashtable.values()) {
            if (settingMode.getName().equals("Default") || settingMode.getPropertyCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public static void addSettingMode(String string, IResource iResource) {
        if (SettingMode.isFixedMode((String)string)) {
            return;
        }
        SettingList settingList = PluginUtilities.getSettingList((IResource)iResource, (boolean)true);
        if (settingList != null) {
            settingList.addMode(new SettingMode(string));
        }
        if (settingList instanceof ProjectSettingList) {
            ProjectSettingList projectSettingList = (ProjectSettingList)settingList;
            for (SettingList settingList2 : projectSettingList.getFileSettings().values()) {
                if (settingList2.hasMode(string)) continue;
                settingList2.addMode(new SettingMode(string));
            }
        }
        for (SettingModeListener settingModeListener : settingModeListeners) {
            settingModeListener.settingModeAdded(string, iResource);
        }
    }

    public static void removeSettingMode(String string, IResource iResource) {
        if (SettingMode.isFixedMode((String)string)) {
            return;
        }
        SettingList settingList = PluginUtilities.getSettingList((IResource)iResource, (boolean)false);
        if (settingList != null) {
            settingList.removeMode(string);
        }
        if (settingList instanceof ProjectSettingList) {
            ProjectSettingList projectSettingList = (ProjectSettingList)settingList;
            SettingModeListener settingModeListener = projectSettingList.getFileSettings().values().iterator();
            while (settingModeListener.hasNext()) {
                ((SettingList)settingModeListener.next()).removeMode(string);
            }
        }
        for (SettingModeListener settingModeListener : settingModeListeners) {
            settingModeListener.settingModeRemoved(string, iResource);
        }
    }

    public static void copySettingMode(String string, String string2, IResource iResource) {
        if (SettingMode.isFixedMode((String)string2)) {
            return;
        }
        SettingList settingList = PluginUtilities.getSettingList((IResource)iResource, (boolean)false);
        if (settingList != null) {
            SettingMode settingMode = settingList.getMode(string);
            SettingMode settingMode2 = settingList.getMode(string2);
            if (settingMode != null && settingMode2 != null) {
                settingMode2.setProperties(settingMode.getProperties());
            }
        }
    }

    public static String[] getSettingModes(IResource iResource) {
        SettingList settingList = PluginUtilities.getSettingList((IResource)iResource, (boolean)false);
        if (settingList != null) {
            Hashtable hashtable = settingList.getModes();
            Object[] objectArray = new String[hashtable.size()];
            int n = 0;
            Iterator iterator = hashtable.keySet().iterator();
            while (iterator.hasNext()) {
                objectArray[n++] = (String)iterator.next();
            }
            Arrays.sort(objectArray);
            return objectArray;
        }
        return null;
    }

    public static void setResourcePersistentProperty(IResource iResource, String string, String string2) {
        try {
            QualifiedName qualifiedName = new QualifiedName("iscobol", string);
            iResource.setPersistentProperty(qualifiedName, string2);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static String getResourcePersistentProperty(IResource iResource, String string) {
        try {
            return iResource.getPersistentProperty(new QualifiedName("iscobol", string));
        }
        catch (CoreException coreException) {
            PluginUtilities.log((Throwable)coreException);
            return null;
        }
    }

    public static void saveProjectOptions(IProject iProject) {
        IscobolNatureExt iscobolNatureExt = null;
        try {
            iscobolNatureExt = PluginUtilities.checkNature((IProject)iProject);
            iscobolNatureExt.saveOptions();
        }
        catch (InternalErrorException internalErrorException) {
            // empty catch block
        }
    }

    public static IFile getFile(String string, IProject iProject, String string2) {
        IFile iFile = iProject.getFile(string);
        if (iFile.exists()) {
            return iFile;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            iFile = iProject.getFile(string3 + "/" + string);
            if (!iFile.exists()) continue;
            return iFile;
        }
        return null;
    }

    public static String getAbsoluteSourcePath(IscobolEditor iscobolEditor, String string) {
        String string2 = PluginUtilities.getSourcePath((IProject)iscobolEditor.getProject(), (String)string);
        if (string2 == null) {
            return null;
        }
        StringBuffer stringBuffer = PluginUtilities.buildAbsolutePathList((String)string2, (IProject)iscobolEditor.getProject());
        if (iscobolEditor.getFileEditorInput() != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparator);
            }
            stringBuffer.append(iscobolEditor.getFileEditorInput().getPath().removeLastSegments(1));
        }
        return stringBuffer.toString();
    }

    public static String getAbsoluteSourcePath(IResource iResource, String string) {
        String string2 = PluginUtilities.getSourcePath((IProject)iResource.getProject(), (String)string);
        if (string2 == null) {
            return null;
        }
        StringBuffer stringBuffer = PluginUtilities.buildAbsolutePathList((String)string2, (IProject)iResource.getProject());
        if (iResource != iResource.getProject()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparator);
            }
            stringBuffer.append(iResource.getLocation().removeLastSegments(1));
        }
        return stringBuffer.toString();
    }

    public static ProjectClassLoader getClassLoader(IProject iProject, String string) {
        URL[] uRLArray;
        Object object;
        if (iProject == null) {
            return null;
        }
        String string2 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.classpath");
        URL uRL = null;
        try {
            object = PluginUtilities.getOutputFolder((IProject)iProject, (String)string);
            if (object != null) {
                uRL = new File((String)object).toURI().toURL();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 != null) {
            object = new StringTokenizer(string2, File.pathSeparator);
            Vector<URL> vector = new Vector<URL>();
            while (((StringTokenizer)object).hasMoreTokens()) {
                File file = new File(((StringTokenizer)object).nextToken());
                if (!file.exists()) continue;
                try {
                    vector.addElement(file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (uRL != null) {
                uRLArray = new URL[vector.size() + 1];
                uRLArray[vector.size()] = uRL;
            } else {
                uRLArray = new URL[vector.size()];
            }
            for (int i = 0; i < vector.size(); ++i) {
                uRLArray[i] = (URL)vector.elementAt(i);
            }
        } else {
            uRLArray = uRL != null ? new URL[]{uRL} : new URL[]{};
        }
        return new ProjectClassLoader(iProject, uRLArray, PluginUtilities.class.getClassLoader());
    }

    public static String getSourcePath(IProject iProject, String string) {
        if (iProject == null) {
            return null;
        }
        String string2 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)string, (String)"-sp=");
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static ArrayList getAllOption(IProject iProject, String string) {
        if (iProject == null) {
            return null;
        }
        ArrayList arrayList = PluginUtilities.getAllOptions((IResource)iProject, (String)string);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    public static IscobolEditor getActiveIscobolEditor() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (!(iEditorPart instanceof IscobolEditor)) {
            return null;
        }
        return (IscobolEditor)iEditorPart;
    }

    public static String getIscobolClassName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        string2 = string.toUpperCase();
        int n = string2.lastIndexOf(46);
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        string2 = string2.replace('-', '_');
        return string2;
    }

    public static File getProjectLocation(IProject iProject) throws CoreException {
        return iProject.getLocation().toFile();
    }

    public static IContainer[] getCopyFolders(IProject iProject, String string) throws CoreException {
        String string2 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)string, (String)"-sp=");
        if (string2 == null) {
            return new IContainer[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        ArrayList<IContainer> arrayList = new ArrayList<IContainer>();
        while (stringTokenizer.hasMoreTokens()) {
            IContainer iContainer = PluginUtilities.getWorkspaceFolder((IProject)iProject, (String)stringTokenizer.nextToken());
            if (iContainer == null) continue;
            arrayList.add(iContainer);
        }
        IContainer[] iContainerArray = new IContainer[arrayList.size()];
        arrayList.toArray(iContainerArray);
        return iContainerArray;
    }

    public static String getOutputFolder(IProject iProject, String string) throws CoreException {
        String string2 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)string, (String)"-od=");
        if (string2 == null || string2.equals("___iscobol.option.false")) {
            return null;
        }
        File file = new File(string2);
        if (file.isAbsolute()) {
            return string2;
        }
        IContainer iContainer = PluginUtilities.getFolder((IProject)iProject, (String)string2);
        if (iContainer != null && iContainer.exists()) {
            return iContainer.getLocation().toString();
        }
        return null;
    }

    public static String getAbsolutePath(IProject iProject, String string) {
        return PluginUtilities.getWorkspaceFolderPath((IProject)iProject, (String)string);
    }

    public static IContainer getScreenFolder(IProject iProject) throws CoreException {
        if (!PluginUtilities.checkScreenBundle()) {
            return null;
        }
        String string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"screendir");
        if (string == null) {
            return null;
        }
        return PluginUtilities.getFolder((IProject)iProject, (String)string);
    }

    public static IFolder getResourcesFolder(IProject iProject) throws CoreException {
        String string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"resourcesdir");
        if (string == null) {
            return null;
        }
        IContainer iContainer = PluginUtilities.getFolder((IProject)iProject, (String)string);
        if (iContainer == null || iContainer.getType() != 2) {
            return null;
        }
        return (IFolder)iContainer;
    }

    public static IFolder getScreenProgramCopyFolder(IProject iProject) throws CoreException {
        String string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"screencopydir");
        if (string == null) {
            return null;
        }
        IContainer iContainer = PluginUtilities.getFolder((IProject)iProject, (String)string);
        if (iContainer == null || iContainer.getType() != 2) {
            return null;
        }
        return (IFolder)iContainer;
    }

    public static IFolder getFileLayoutCopyFolder(IProject iProject) throws CoreException {
        String string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"fdslcopydir");
        if (string == null) {
            return null;
        }
        IContainer iContainer = PluginUtilities.getFolder((IProject)iProject, (String)string);
        if (iContainer == null || iContainer.getType() != 2) {
            return null;
        }
        return (IFolder)iContainer;
    }

    public static IContainer getFDFolder(IProject iProject) throws CoreException {
        if (!PluginUtilities.checkScreenBundle()) {
            return null;
        }
        String string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"fddir");
        if (string == null) {
            return null;
        }
        return PluginUtilities.getFolder((IProject)iProject, (String)string);
    }

    public static IContainer getHtmlAndroidFolder(IProject iProject) throws CoreException {
        if (Platform.getBundle((String)"com.iscobol.plugins.HtmlAndroid") == null) {
            return null;
        }
        String string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"html_androiddir");
        if (string == null) {
            return null;
        }
        return PluginUtilities.getFolder((IProject)iProject, (String)string);
    }

    public static IContainer getSourceFolder(IProject iProject) throws CoreException {
        return PluginUtilities.getSourceFolder((IProject)iProject, (String)PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"sourcedir"));
    }

    public static IFolder getTranslatedFolder(IProject iProject) throws CoreException {
        Path path = new Path("translated");
        IFolder iFolder = iProject.getFolder((IPath)path);
        if (!iProject.exists((IPath)path)) {
            PluginUtilities.createFolder((IFolder)iFolder);
        }
        return iFolder;
    }

    public static IContainer getSourceFolder(IProject iProject, String string) throws CoreException {
        if (string == null) {
            string = "source";
        }
        return PluginUtilities.getFolder((IProject)iProject, (String)string);
    }

    public static IContainer getFolder(IProject iProject, String string) throws CoreException {
        Object object = null;
        object = string.length() == 0 || string.equals("/") ? iProject : iProject.getFolder(string);
        return object;
    }

    public static StringBuffer buildAbsolutePathList(String string, IProject iProject) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (n > 0) {
                stringBuffer.append(File.pathSeparator);
            }
            stringBuffer.append(PluginUtilities.getAbsolutePath((IProject)iProject, (String)string2));
            ++n;
        }
        return stringBuffer;
    }

    public static String makeRelative(String string, String string2) {
        return PluginUtilities.makeRelative((File)new File(string), (File)new File(string2));
    }

    public static String makeRelative(File file, String string) {
        return PluginUtilities.makeRelative((File)file, (File)new File(string));
    }

    public static String makeRelative(String string, IProject iProject) {
        File file;
        File file2 = iProject.getLocation().toFile();
        if (file2.equals(file = new File(string))) {
            return "/";
        }
        return PluginUtilities.makeRelative((File)file, (File)file2);
    }

    public static String makeRelative(File file, File file2) {
        File file3;
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer(file.getName());
        for (file3 = file.getParentFile(); file3 != null && !file3.equals(file2); file3 = file3.getParentFile()) {
            stringBuffer.insert(0, file3.getName() + "/");
        }
        return file3 != null ? stringBuffer.toString() : file.getAbsolutePath();
    }

    public static IFile getFileForLocation(String string) {
        IFile[] iFileArray;
        for (IFile iFile : iFileArray = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new File(string).toURI())) {
            if (!iFile.exists()) continue;
            return iFile;
        }
        return null;
    }

    public static IContainer getContainerForLocation(String string) {
        IContainer[] iContainerArray;
        for (IContainer iContainer : iContainerArray = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(new File(string).toURI())) {
            if (!iContainer.exists()) continue;
            return iContainer;
        }
        return null;
    }

    public static boolean isAnsiFormat(IResource iResource, String string) {
        return PluginUtilities.getFormat((IResource)iResource, (String)string) == 1;
    }

    public static boolean isTerminalFormat(IResource iResource, String string) {
        return PluginUtilities.getFormat((IResource)iResource, (String)string) == 2;
    }

    public static boolean isFreeFormat(IResource iResource, String string) {
        return PluginUtilities.getFormat((IResource)iResource, (String)string) == 3;
    }

    public static int getFormat(IResource iResource, String string) {
        int n = 0;
        for (int i = 0; i < SOURCE_FORMAT_OPTIONS.length; ++i) {
            if (!PluginUtilities.isFormat((IResource)iResource, (String)string, (String)SOURCE_FORMAT_OPTIONS[i])) continue;
            n = i + 1;
            break;
        }
        if (n == 0 && !(iResource instanceof IProject) && iResource.getProject() != null) {
            n = PluginUtilities.getFormat((IResource)iResource.getProject(), (String)string);
        }
        return n;
    }

    public static String getFormatOption(int n) {
        if (n > 0 && n <= SOURCE_FORMAT_OPTIONS.length) {
            return SOURCE_FORMAT_OPTIONS[n - 1];
        }
        return null;
    }

    public static String getFormatOption(IResource iResource, String string) {
        String string2 = null;
        for (int i = 0; i < SOURCE_FORMAT_OPTIONS.length; ++i) {
            if (!PluginUtilities.isFormat((IResource)iResource, (String)string, (String)SOURCE_FORMAT_OPTIONS[i])) continue;
            string2 = SOURCE_FORMAT_OPTIONS[i];
            break;
        }
        if (string2 == null && !(iResource instanceof IProject) && iResource.getProject() != null) {
            string2 = PluginUtilities.getFormatOption((IResource)iResource.getProject(), (String)string);
        }
        return string2;
    }

    private static boolean isFormat(IResource iResource, String string, String string2) {
        String string3 = PluginUtilities.getPersistentProperty((IResource)iResource, (String)string, (String)string2);
        return string3 != null && string3.equals("___iscobol.option.true");
    }

    public static String toString(Method method, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        StringBuffer stringBuffer3 = new StringBuffer();
        if (stringBuffer2 != null) {
            stringBuffer2.append(method.getName());
        }
        stringBuffer3.append(method.getName() + "( ");
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length > 0 && stringBuffer2 != null) {
            stringBuffer2.append(" ( ");
        }
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer2.append("${");
            stringBuffer3.append(PluginUtilities.toString(classArray[i], (StringBuffer)stringBuffer2));
            stringBuffer2.append("_").append(i).append("}");
            if (i >= classArray.length - 1) continue;
            stringBuffer3.append(", ");
            if (stringBuffer2 == null) continue;
            stringBuffer2.append(" ");
        }
        stringBuffer3.append(" ) ");
        if (classArray.length > 0 && stringBuffer2 != null) {
            stringBuffer2.append(" )");
        }
        stringBuffer3.append(PluginUtilities.toString(method.getReturnType(), null));
        if (stringBuffer != null) {
            stringBuffer.append(PluginUtilities.toString(method.getDeclaringClass(), null));
        }
        return stringBuffer3.toString();
    }

    public static String toString(Constructor constructor, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        StringBuffer stringBuffer3 = new StringBuffer();
        if (stringBuffer2 != null) {
            stringBuffer2.append("new");
        }
        stringBuffer3.append("new( ");
        Class<?>[] classArray = constructor.getParameterTypes();
        if (classArray.length > 0 && stringBuffer2 != null) {
            stringBuffer2.append(" ( ");
        }
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer2.append("${");
            stringBuffer3.append(PluginUtilities.toString(classArray[i], (StringBuffer)stringBuffer2));
            stringBuffer2.append("_").append(i).append("}");
            if (i >= classArray.length - 1) continue;
            stringBuffer3.append(", ");
            if (stringBuffer2 == null) continue;
            stringBuffer2.append(" ");
        }
        stringBuffer3.append(" ) ");
        if (classArray.length > 0 && stringBuffer2 != null) {
            stringBuffer2.append(" )");
        }
        if (stringBuffer != null) {
            stringBuffer.append(PluginUtilities.toString(constructor.getDeclaringClass(), null));
        }
        return stringBuffer3.toString();
    }

    public static String toString(Field field, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(field.getName()).append(" ");
        stringBuffer2.append(PluginUtilities.toString(field.getType(), null));
        if (stringBuffer != null) {
            stringBuffer.append(PluginUtilities.toString(field.getDeclaringClass(), null));
        }
        return stringBuffer2.toString();
    }

    public static String toString(Class clazz, StringBuffer stringBuffer) {
        int n;
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 0;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n2;
        }
        if (clazz == Void.TYPE) {
            stringBuffer2.append("void");
        } else if (clazz == Boolean.TYPE) {
            stringBuffer2.append("boolean");
        } else if (clazz == Byte.TYPE) {
            stringBuffer2.append("byte");
        } else if (clazz == Short.TYPE) {
            stringBuffer2.append("short");
        } else if (clazz == Integer.TYPE) {
            stringBuffer2.append("int");
        } else if (clazz == Long.TYPE) {
            stringBuffer2.append("long");
        } else if (clazz == Float.TYPE) {
            stringBuffer2.append("float");
        } else if (clazz == Double.TYPE) {
            stringBuffer2.append("double");
        } else if (clazz == Character.TYPE) {
            stringBuffer2.append("char");
        } else {
            stringBuffer2.append(clazz.getName().replace('$', '.'));
        }
        if (stringBuffer != null) {
            n = stringBuffer2.lastIndexOf(".");
            if (n >= 0) {
                stringBuffer.append("J" + stringBuffer2.substring(n + 1, stringBuffer2.length()));
            } else {
                stringBuffer.append("J" + stringBuffer2);
            }
        }
        if (n2 > 0) {
            for (n = 0; n < n2; ++n) {
                stringBuffer2.append("[]");
                if (stringBuffer == null) continue;
                stringBuffer.append("_a");
            }
        }
        return stringBuffer2.toString();
    }

    public static void log(String string, Throwable throwable) {
        ConsolePlugin.log((IStatus)ConsolePlugin.newErrorStatus((String)string, (Throwable)throwable));
    }

    public static void log(Throwable throwable) {
        PluginUtilities.log((String)throwable.toString(), (Throwable)throwable);
    }

    public static void log(String string) {
        PluginUtilities.log((String)string, null);
    }

    public static void logError(String string) {
        PluginUtilities.logMessage((String)string, (int)1);
    }

    public static void logMessage(String string, int n) {
        if (string == null) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public static void refreshIscobolNavigators(Object object) {
        IIscobolNavigator[] iIscobolNavigatorArray = PluginUtilities.findIscobolNavigators();
        for (int i = 0; i < iIscobolNavigatorArray.length; ++i) {
            iIscobolNavigatorArray[i].refresh(object);
        }
    }

    public static IViewPart findView(String string) {
        ArrayList arrayList = new ArrayList();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return arrayList.isEmpty() ? null : (IViewPart)arrayList.get(0);
    }

    public static IIscobolNavigator[] findIscobolNavigators() {
        ArrayList arrayList = new ArrayList();
        new /* Unavailable Anonymous Inner Class!! */.start();
        IIscobolNavigator[] iIscobolNavigatorArray = new IIscobolNavigator[arrayList.size()];
        arrayList.toArray(iIscobolNavigatorArray);
        return iIscobolNavigatorArray;
    }

    public static IIscobolNavigator findFileNavigator() {
        ArrayList arrayList = new ArrayList();
        new /* Unavailable Anonymous Inner Class!! */.start();
        if (arrayList.size() > 0) {
            return (IIscobolNavigator)arrayList.get(0);
        }
        return null;
    }

    public static boolean isCopyFolder(IContainer iContainer) {
        if (iContainer.getProject() == null) {
            return false;
        }
        String string = PluginUtilities.getPersistentProperty((IResource)iContainer.getProject(), (String)PluginUtilities.getCurrentSettingMode((IResource)iContainer.getProject()), (String)"-sp=");
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            IContainer iContainer2 = PluginUtilities.getWorkspaceFolder((IProject)iContainer.getProject(), (String)stringTokenizer.nextToken());
            if (iContainer2 == null || !iContainer2.equals(iContainer)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkScreenBundle() {
        return Platform.getBundle((String)"com.iscobol.plugins.screenpainter.IscobolScreenPainter") != null;
    }

    public static boolean isScreenFolder(IContainer iContainer) {
        return PluginUtilities.checkScreenBundle() && PluginUtilities.isFolder((IContainer)iContainer, (String)"Default", (String)"screendir");
    }

    public static boolean isFDFolder(IContainer iContainer) {
        return PluginUtilities.checkScreenBundle() && PluginUtilities.isFolder((IContainer)iContainer, (String)"Default", (String)"fddir");
    }

    public static boolean isOutputFolder(IContainer iContainer) {
        return PluginUtilities.isFolder((IContainer)iContainer, (String)PluginUtilities.getCurrentSettingMode((IResource)iContainer.getProject()), (String)"-od=");
    }

    public static boolean isListFolder(IContainer iContainer) {
        return PluginUtilities.isFolder((IContainer)iContainer, (String)PluginUtilities.getCurrentSettingMode((IResource)iContainer.getProject()), (String)"-lo=");
    }

    public static boolean isErrFolder(IContainer iContainer) {
        return PluginUtilities.isFolder((IContainer)iContainer, (String)PluginUtilities.getCurrentSettingMode((IResource)iContainer.getProject()), (String)"-eo=");
    }

    public static boolean isEfdFolder(IContainer iContainer) {
        return PluginUtilities.isFolder((IContainer)iContainer, (String)PluginUtilities.getCurrentSettingMode((IResource)iContainer.getProject()), (String)"-efo=");
    }

    private static boolean isFolder(IContainer iContainer, String string, String string2) {
        if (iContainer.getProject() == null) {
            return false;
        }
        String string3 = PluginUtilities.getPersistentProperty((IResource)iContainer.getProject(), (String)string, (String)string2);
        if (string3 == null) {
            return false;
        }
        try {
            return PluginUtilities.getFolder((IProject)iContainer.getProject(), (String)string3).equals(iContainer);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isSourceFolder(IContainer iContainer) {
        try {
            if (iContainer.getProject() == null) {
                return false;
            }
            return PluginUtilities.getSourceFolder((IProject)iContainer.getProject()).equals(iContainer);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isInSourceFolder(IFile iFile) {
        return PluginUtilities.isInSourceFolder((IContainer)iFile.getParent());
    }

    public static boolean isInSourceFolder(IContainer iContainer) {
        try {
            IProject iProject = iContainer.getProject();
            if (iProject == null || iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") == null) {
                return false;
            }
            IContainer iContainer2 = PluginUtilities.getSourceFolder((IProject)iProject);
            IContainer iContainer3 = iContainer;
            while (!(iContainer3 instanceof IWorkspaceRoot)) {
                if (iContainer3.equals(iContainer2)) {
                    return true;
                }
                iContainer3 = iContainer3.getParent();
            }
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isTextFile(IFile iFile) {
        try {
            IEditorDescriptor iEditorDescriptor = IDE.getEditorDescriptor((IFile)iFile);
            return iEditorDescriptor == null || iEditorDescriptor.getId().equals(IscobolEditor.ID) || iEditorDescriptor.getId().equals("org.eclipse.ui.DefaultTextEditor");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isSourceFile(IFile iFile) {
        return PluginUtilities.isInSourceFolder((IFile)iFile);
    }

    public static boolean isCopyFile(IFile iFile, String string) {
        try {
            if (string != null && (string.equals("def") || string.equals("cpy") || string.equals("evt") || string.equals("prd"))) {
                return true;
            }
            IProject iProject = iFile.getProject();
            if (iProject == null || iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") == null) {
                return false;
            }
            IContainer[] iContainerArray = PluginUtilities.getCopyFolders((IProject)iProject, (String)PluginUtilities.getCurrentSettingMode((IResource)iProject));
            boolean bl = false;
            for (int i = 0; !bl && i < iContainerArray.length; ++i) {
                IContainer iContainer = iFile.getParent();
                while (!bl && !(iContainer instanceof IWorkspaceRoot)) {
                    if (iContainer.equals(iContainerArray[i])) {
                        bl = true;
                    }
                    iContainer = iContainer.getParent();
                }
            }
            if (!bl) {
                return false;
            }
            IEditorDescriptor iEditorDescriptor = IDE.getEditorDescriptor((IFile)iFile);
            return iEditorDescriptor == null || iEditorDescriptor.getId().equals(IscobolEditor.ID) || iEditorDescriptor.getId().equals("org.eclipse.ui.DefaultTextEditor");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static void handleExecutionException(ExecutionException executionException) {
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createFile(IFile iFile, InputStream inputStream) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            CreateFileOperation createFileOperation;
            if (inputStream == null) {
                byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                createFileOperation = new CreateFileOperation(iFile, (InputStream)byteArrayInputStream);
            } else {
                createFileOperation = new CreateFileOperation(iFile, inputStream);
            }
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)createFileOperation, null, null);
            boolean bl = true;
            return bl;
        }
        catch (ExecutionException executionException) {
            PluginUtilities.handleExecutionException((ExecutionException)executionException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createLinkFile(IFile iFile, URI uRI) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            CreateLinkFileOperation createLinkFileOperation = new CreateLinkFileOperation(iFile, uRI, "com.iscobol.plugins.editor.IscobolEditor");
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)createLinkFileOperation, null, null);
            boolean bl = true;
            return bl;
        }
        catch (ExecutionException executionException) {
            PluginUtilities.handleExecutionException((ExecutionException)executionException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean modifyFile(IFile iFile, InputStream inputStream, boolean bl) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            ModifyFileOperation modifyFileOperation;
            if (inputStream == null) {
                byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                modifyFileOperation = new ModifyFileOperation(iFile, (InputStream)byteArrayInputStream, bl);
            } else {
                modifyFileOperation = new ModifyFileOperation(iFile, inputStream, bl);
            }
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)modifyFileOperation, null, null);
            boolean bl2 = true;
            return bl2;
        }
        catch (ExecutionException executionException) {
            PluginUtilities.handleExecutionException((ExecutionException)executionException);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean deleteFile(IFile iFile, boolean bl) {
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)new DeleteFileOperation(iFile, bl), null, null);
            return true;
        }
        catch (ExecutionException executionException) {
            PluginUtilities.handleExecutionException((ExecutionException)executionException);
            return false;
        }
    }

    public static boolean deleteFolder(IFolder iFolder) {
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)new DeleteFolderOperation(iFolder), null, null);
            return true;
        }
        catch (ExecutionException executionException) {
            PluginUtilities.handleExecutionException((ExecutionException)executionException);
            return false;
        }
    }

    public static boolean createFolder(IFolder iFolder) {
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)new CreateFolderOperation(iFolder), null, null);
            return true;
        }
        catch (ExecutionException executionException) {
            PluginUtilities.handleExecutionException((ExecutionException)executionException);
            return false;
        }
    }

    public static IResource findMember(IContainer iContainer, IPath iPath) {
        return PluginUtilities.findMember((IContainer)iContainer, (IPath)iPath, (boolean)Platform.getOS().equals("win32"));
    }

    public static IResource findMember(IContainer iContainer, IPath iPath, boolean bl) {
        try {
            String[] stringArray = iPath.segments();
            for (int i = 0; i < stringArray.length; ++i) {
                IResource[] iResourceArray = iContainer.members();
                boolean bl2 = false;
                for (int j = 0; j < iResourceArray.length && !bl2; ++j) {
                    IPath iPath2;
                    String string = stringArray[i];
                    if (bl) {
                        string = string.toLowerCase();
                    }
                    String string2 = iResourceArray[j].getName();
                    if (bl) {
                        string2 = string2.toLowerCase();
                    }
                    if (!string.equals(string2) || (iPath2 = iResourceArray[j].getLocation()) == null || !iPath2.toFile().exists()) continue;
                    if (i == stringArray.length - 1) {
                        return iResourceArray[j];
                    }
                    if (!(iResourceArray[j] instanceof IContainer)) continue;
                    iContainer = (IContainer)iResourceArray[j];
                    bl2 = true;
                }
                if (bl2) continue;
                return null;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static String findVariableName(String string, int n, boolean bl) {
        int n2;
        if (n < 0 || n >= string.length()) {
            return null;
        }
        String string2 = "";
        String string3 = "";
        String string4 = " =():\".,";
        char[] cArray = string4.toCharArray();
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n), string4, true);
        if (stringTokenizer.hasMoreTokens()) {
            int n3;
            String string5 = stringTokenizer.nextToken();
            n2 = 1;
            for (n3 = 0; n3 < cArray.length && n2 != 0; n2 &= cArray[n3] != string5.charAt(0) ? 1 : 0, ++n3) {
            }
            if (n2 != 0) {
                string3 = string5;
            }
            while (stringTokenizer.hasMoreTokens() && (string5 = stringTokenizer.nextToken()).equals(" ")) {
                string3 = string3 + string5;
            }
            if (string5.equalsIgnoreCase("of") || string5.equalsIgnoreCase("in")) {
                string3 = string3 + string5;
                while (stringTokenizer.hasMoreTokens() && (string5 = stringTokenizer.nextToken()).equals(" ")) {
                    string3 = string3 + string5;
                }
                String string6 = PluginUtilities.findVariableName((String)string, (int)(n + string3.length()), (boolean)false);
                if (string6 != null) {
                    string3 = string3 + string6;
                }
            } else if (string5.equals("(")) {
                n3 = 1;
                string3 = string3 + string5;
                while (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                    string3 = string3 + string5;
                    if (string5.equals("(")) {
                        ++n3;
                    }
                    if (!string5.equals(")")) continue;
                    if (n3 <= 1) break;
                    --n3;
                }
            }
        }
        if (bl) {
            string4 = " =(:\",";
            cArray = string4.toCharArray();
            stringTokenizer = new StringTokenizer(string.substring(0, n), string4, true);
            int n4 = stringTokenizer.countTokens();
            if (n4 > 0) {
                for (n2 = 0; n2 < n4 - 1; ++n2) {
                    stringTokenizer.nextToken();
                }
                String string7 = stringTokenizer.nextToken();
                boolean bl2 = true;
                for (int i = 0; i < cArray.length && bl2; bl2 &= cArray[i] != string7.charAt(0), ++i) {
                }
                if (bl2) {
                    string2 = string7;
                }
            }
        }
        return string2 + string3;
    }

    public static String getSuggestedFileName(IContainer iContainer, String string, String string2) {
        String string3;
        if (iContainer == null) {
            return string + "1" + string2;
        }
        int n = 1;
        while (iContainer.getFile((IPath)new Path(string3 = string + Integer.toString(n) + string2)).exists()) {
            ++n;
        }
        return string3;
    }

    public static String getStringValue(String string, String string2, IPreferenceStore iPreferenceStore) {
        return PluginUtilities.getStringValue((String)("iscobol.newproject." + string2 + "." + string), (IPreferenceStore)iPreferenceStore);
    }

    public static boolean containsKey(String string, String string2, IPreferenceStore iPreferenceStore) {
        return iPreferenceStore.contains("iscobol.newproject." + string2 + "." + string);
    }

    public static String getDefaultString(String string, String string2, IPreferenceStore iPreferenceStore) {
        return iPreferenceStore.getDefaultString("iscobol.newproject." + string2 + "." + string);
    }

    public static boolean getDefaultBoolean(String string, String string2, IPreferenceStore iPreferenceStore) {
        return iPreferenceStore.getDefaultBoolean("iscobol.newproject." + string2 + "." + string);
    }

    public static String getStringValue(String string, IPreferenceStore iPreferenceStore) {
        if (iPreferenceStore.contains(string)) {
            return iPreferenceStore.getString(string);
        }
        return iPreferenceStore.getDefaultString(string);
    }

    public static boolean getBooleanValue(String string, String string2, IPreferenceStore iPreferenceStore) {
        return PluginUtilities.getBooleanValue((String)("iscobol.newproject." + string2 + "." + string), (IPreferenceStore)iPreferenceStore);
    }

    public static boolean getBooleanValue(String string, IPreferenceStore iPreferenceStore) {
        if (iPreferenceStore.contains(string)) {
            return iPreferenceStore.getBoolean(string);
        }
        return iPreferenceStore.getDefaultBoolean(string);
    }

    public static int getIntValue(String string, IPreferenceStore iPreferenceStore) {
        if (iPreferenceStore.contains(string)) {
            return iPreferenceStore.getInt(string);
        }
        return iPreferenceStore.getDefaultInt(string);
    }

    public static void setStringValue(String string, String string2, String string3, IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setValue("iscobol.newproject." + string2 + "." + string, string3);
    }

    public static <T> T castOrAdapt(Object object, Class<T> clazz) throws ClassCastException {
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        if (object instanceof IAdaptable) {
            return (T)((IAdaptable)object).getAdapter(clazz);
        }
        throw new ClassCastException(object.getClass().getName());
    }

    public static IFile findCopyFile(String string, String string2, IProject iProject) {
        String string3 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)string2, (String)"-sp=");
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                IFile iFile;
                IContainer iContainer = PluginUtilities.getWorkspaceFolder((IProject)iProject, (String)stringTokenizer.nextToken());
                if (iContainer == null || (iFile = PluginUtilities.findRecur((IContainer)iContainer, (Path)new Path(string))) == null) continue;
                return iFile;
            }
        }
        return null;
    }

    private static IFile findRecur(IContainer iContainer, Path path) {
        IResource iResource = PluginUtilities.findMember((IContainer)iContainer, (IPath)path);
        if (iResource instanceof IFile) {
            return (IFile)iResource;
        }
        try {
            IResource[] iResourceArray = iContainer.members();
            for (int i = 0; i < iResourceArray.length; ++i) {
                if (!(iResourceArray[i] instanceof IFolder) || (iResource = PluginUtilities.findRecur((IContainer)((IFolder)iResourceArray[i]), (Path)path)) == null) continue;
                return (IFile)iResource;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static boolean validatePortNumber(String string) {
        boolean bl = false;
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                bl = n >= 1 && n <= 65535;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bl;
    }

    public static boolean validateHostName(String string) {
        if (string == null || string.length() > 63) {
            return false;
        }
        return string.matches("(((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum}))((\\.)(((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})))*") && string.matches("(.)*((\\p{Alpha})|[-])(.)*") || PluginUtilities.validateIPAddress((String)string);
    }

    public static boolean validateIPAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                if (n >= 0 && n <= 255) continue;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    public static ErrorObj convertToErrorObj(Object object) {
        if (object instanceof ErrorObj) {
            return (ErrorObj)object;
        }
        if (object instanceof String) {
            return new ErrorObj(0, 0, 0, 0, null, (String)object, null);
        }
        if (object instanceof RemoteError) {
            RemoteError remoteError = (RemoteError)object;
            return new ErrorObj(remoteError.getErrorNumber(), remoteError.getErrorType(), remoteError.getLineNumber(), remoteError.getOffset(), remoteError.getFilename(), remoteError.getMessage(), remoteError.getOther());
        }
        return null;
    }

    public static IscobolEditor findIscobolEditorForInput(IFile iFile) {
        if (iFile == null) {
            return null;
        }
        return PluginUtilities.findIscobolEditorForInput((IEditorInput)new FileEditorInput(iFile));
    }

    public static IscobolEditor findIscobolEditorForInput(IEditorInput iEditorInput) {
        if (iEditorInput == null) {
            return null;
        }
        IscobolEditor[] iscobolEditorArray = new IscobolEditor[1];
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return iscobolEditorArray[0];
    }

    public static IscobolEditor[] findIscobolEditorsForInput(IFile iFile) {
        if (iFile == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return arrayList.toArray(new IscobolEditor[arrayList.size()]);
    }

    public static String getScreenPainterLibraryPath() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Location location = Platform.getInstallLocation();
            if (location != null && location.getURL() != null) {
                File file = new File(location.getURL().getPath());
                if ((file = new File(file.getAbsolutePath() + File.separator + "plugins")).exists()) {
                    File[] fileArray = file.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
                    for (int i = 0; i < fileArray.length; ++i) {
                        stringBuffer.append(File.pathSeparator).append(fileArray[i].getAbsolutePath());
                    }
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            PluginUtilities.log((Throwable)exception);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIscobolRelease() {
        String string = null;
        BufferedReader bufferedReader = null;
        try {
            Bundle bundle = Platform.getBundle((String)"com.iscobol.plugins.editor.IscobolEditor");
            bufferedReader = new BufferedReader(new InputStreamReader(bundle.getEntry("META-INF/MANIFEST.MF").openStream()));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.startsWith("Bundle-Version:")) {
                    String[] stringArray = string2.substring(15).trim().split("\\.");
                    string = "isCOBOL" + stringArray[0] + "R" + stringArray[1];
                    break;
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    public static Version getEclipseVersion() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.platform");
        if (bundle == null) {
            return null;
        }
        return bundle.getVersion();
    }

    private static boolean isThisEclipseVersionOrGreater(int n, int n2) {
        Version version = PluginUtilities.getEclipseVersion();
        return version != null && (version.getMajor() > n || version.getMajor() == n && version.getMinor() >= n2);
    }

    public static boolean isEclipse3_2OrGreater() {
        return PluginUtilities.isThisEclipseVersionOrGreater((int)3, (int)2);
    }

    public static boolean isEclipse3_3OrGreater() {
        return PluginUtilities.isThisEclipseVersionOrGreater((int)3, (int)3);
    }

    public static boolean isEclipse3_4OrGreater() {
        return PluginUtilities.isThisEclipseVersionOrGreater((int)3, (int)4);
    }

    public static boolean isEclipse3_5OrGreater() {
        return PluginUtilities.isThisEclipseVersionOrGreater((int)3, (int)5);
    }

    public static boolean isEclipse3_6OrGreater() {
        return PluginUtilities.isThisEclipseVersionOrGreater((int)3, (int)6);
    }

    public static boolean isEclipse3_7OrGreater() {
        return PluginUtilities.isThisEclipseVersionOrGreater((int)3, (int)7);
    }

    public static boolean isEclipse4_2OrGreater() {
        return PluginUtilities.isThisEclipseVersionOrGreater((int)4, (int)2);
    }

    public static boolean isEclipse4_3OrGreater() {
        return PluginUtilities.isThisEclipseVersionOrGreater((int)4, (int)3);
    }

    public static boolean isEclipse4_4OrGreater() {
        return PluginUtilities.isThisEclipseVersionOrGreater((int)4, (int)4);
    }

    public static void addSettingModeListener(SettingModeListener settingModeListener) {
        settingModeListeners.addElement(settingModeListener);
    }

    public static void removeSettingModeListener(SettingModeListener settingModeListener) {
        settingModeListeners.removeElement(settingModeListener);
    }

    public static boolean equals(Object object, Object object2) {
        if (object != null) {
            if (object2 != null) {
                return object.equals(object2);
            }
            return false;
        }
        return object2 == null;
    }

    public static void checkClassName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        PluginUtilities.classForName((String)string, (ClassLoader)classLoader);
    }

    public static Class classForName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        ClassNotFoundException classNotFoundException = null;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        while (true) {
            try {
                return Class.forName(string, false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                int n;
                if (classNotFoundException == null) {
                    classNotFoundException = classNotFoundException2;
                }
                if ((n = string.lastIndexOf(46)) >= 0) {
                    string = string.substring(0, n) + '$' + string.substring(n + 1);
                    continue;
                }
                throw classNotFoundException;
            }
            break;
        }
    }

    public static void mergeSort(Object[] objectArray, Comparator comparator, boolean bl) {
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator is null");
        }
        Object[] objectArray2 = new Object[objectArray.length];
        PluginUtilities.mergeSort((Object[])objectArray, (Object[])objectArray2, (int)0, (int)(objectArray.length - 1), (Comparator)comparator, (boolean)bl);
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2, Comparator comparator, boolean bl) {
        if (n < n2) {
            int n3 = (n + n2) / 2;
            PluginUtilities.mergeSort((Object[])objectArray, (Object[])objectArray2, (int)n, (int)n3, (Comparator)comparator, (boolean)bl);
            PluginUtilities.mergeSort((Object[])objectArray, (Object[])objectArray2, (int)(n3 + 1), (int)n2, (Comparator)comparator, (boolean)bl);
            PluginUtilities.merge((Object[])objectArray, (Object[])objectArray2, (int)n, (int)(n3 + 1), (int)n2, (Comparator)comparator, (boolean)bl);
        }
    }

    private static void merge(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, Comparator comparator, boolean bl) {
        int n4 = n2 - 1;
        int n5 = n;
        int n6 = n3 - n + 1;
        while (n <= n4 && n2 <= n3) {
            if (bl) {
                if (comparator.compare(objectArray[n2], objectArray[n]) <= 0) {
                    objectArray2[n5++] = objectArray[n++];
                    continue;
                }
                objectArray2[n5++] = objectArray[n2++];
                continue;
            }
            if (comparator.compare(objectArray[n], objectArray[n2]) <= 0) {
                objectArray2[n5++] = objectArray[n++];
                continue;
            }
            objectArray2[n5++] = objectArray[n2++];
        }
        while (n <= n4) {
            objectArray2[n5++] = objectArray[n++];
        }
        while (n2 <= n3) {
            objectArray2[n5++] = objectArray[n2++];
        }
        int n7 = 0;
        while (n7 < n6) {
            objectArray[n3] = objectArray2[n3];
            ++n7;
            --n3;
        }
    }

    public static boolean isValidPathName(String string) {
        return !string.matches(".*[;,\\(\\)].*");
    }

    public static boolean isValidIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isLetterOrDigit(cArray[i])) continue;
            if (i == 0 || i == cArray.length - 1) {
                return false;
            }
            if (cArray[i] == '-' || cArray[i] == '_') continue;
            return false;
        }
        return true;
    }

    public static String getProjectRootDir(IProject iProject) throws CoreException {
        return iProject.getLocation().toString();
    }

    private static IContainer getFolder(IProject iProject, String string, boolean bl) {
        if (string.equals("/")) {
            return iProject;
        }
        IFolder iFolder = iProject.getFolder(string);
        if (!bl || iFolder.exists()) {
            return iFolder;
        }
        return null;
    }

    public static String getWorkspaceFolderPath(IProject iProject, String string) {
        int n;
        if (string == null || string.length() == 0 || string.equals("/")) {
            return iProject.getLocation().toString();
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            return string;
        }
        if (string.startsWith("${") && (n = string.indexOf(125)) >= 0) {
            String string2 = string.substring(2, n);
            IProject iProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject(string2);
            if (iProject2 == null || !iProject2.exists() || !iProject2.isOpen()) {
                return string;
            }
            if (n < string.length() - 1) {
                string = string.substring(n + 1);
                return PluginUtilities.getFolder((IProject)iProject2, (String)string, (boolean)false).getLocation().toString();
            }
            return iProject2.getLocation().toString();
        }
        return PluginUtilities.getFolder((IProject)iProject, (String)string, (boolean)false).getLocation().toString();
    }

    public static IContainer getWorkspaceFolder(IProject iProject, String string) {
        int n;
        if (string == null || string.length() == 0 || string.equals("/")) {
            return iProject;
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            return PluginUtilities.getContainerForLocation((String)string);
        }
        if (string.startsWith("${") && (n = string.indexOf(125)) >= 0) {
            String string2 = string.substring(2, n);
            IProject iProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject(string2);
            if (iProject2 == null || !iProject2.exists() || !iProject2.isOpen()) {
                return null;
            }
            if (n < string.length() - 1) {
                string = string.substring(n + 1);
                return PluginUtilities.getFolder((IProject)iProject2, (String)string, (boolean)true);
            }
            return iProject2;
        }
        return PluginUtilities.getFolder((IProject)iProject, (String)string, (boolean)true);
    }

    public static boolean isAnsiFixedFormat(int n) {
        return n == 1 || n == 4;
    }

    public static boolean isTerminalFormat(int n) {
        return n == 2;
    }

    public static boolean isFreeFormat(int n) {
        return n == 3;
    }

    public static IIscobolNavigator findStructuralNavigator() {
        ArrayList arrayList = new ArrayList();
        new /* Unavailable Anonymous Inner Class!! */.start();
        if (arrayList.size() > 0) {
            return (IIscobolNavigator)arrayList.get(0);
        }
        return null;
    }

    public static IIscobolNavigator findDataNavigator() {
        ArrayList arrayList = new ArrayList();
        new /* Unavailable Anonymous Inner Class!! */.start();
        if (arrayList.size() > 0) {
            return (IIscobolNavigator)arrayList.get(0);
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow[] iWorkbenchWindowArray = new IWorkbenchWindow[1];
        new /* Unavailable Anonymous Inner Class!! */.start();
        return iWorkbenchWindowArray[0];
    }

    private static byte[] get(String string, String string2) {
        try {
            Field field = Class.forName(string).getDeclaredField(string2);
            field.setAccessible(true);
            return (byte[])field.get(null);
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    private static byte[] getCompA() {
        return PluginUtilities.get((String)IsresourceBundle.getString((String)"iscobol.comp.class"), (String)"a");
    }

    private static byte[] getCompB() {
        return PluginUtilities.get((String)IsresourceBundle.getString((String)"iscobol.comp.class"), (String)"b");
    }

    private static byte[] getCompC() {
        return PluginUtilities.get((String)IsresourceBundle.getString((String)"iscobol.comp.class"), (String)"c");
    }

    private static byte[] getRtmA() {
        return PluginUtilities.get((String)IsresourceBundle.getString((String)"iscobol.rtm.class"), (String)"a");
    }

    private static byte[] getRtmB() {
        return PluginUtilities.get((String)IsresourceBundle.getString((String)"iscobol.rtm.class"), (String)"b");
    }

    private static byte[] getRtmC() {
        return PluginUtilities.get((String)IsresourceBundle.getString((String)"iscobol.rtm.class"), (String)"c");
    }

    public static Set<String> getAllowedBuildExtensions(IProject iProject) {
        TreeSet<String> treeSet = Platform.getOS().equals("win32") ? new TreeSet(new /* Unavailable Anonymous Inner Class!! */) : new TreeSet<String>();
        String string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.filterexts");
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                treeSet.add(stringTokenizer.nextToken().substring(2));
            }
        }
        return treeSet;
    }

    static /* synthetic */ int access$004() {
        return ++browserIdProg;
    }
}

