/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.util.operations;

import com.iscobol.plugins.editor.util.operations.WorkspaceOperation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateFileOperation
extends WorkspaceOperation {
    private IFile file;
    private byte[] contents;

    public CreateFileOperation(IFile iFile, InputStream inputStream) {
        super("Create file '" + iFile.getFullPath() + "'");
        this.file = iFile;
        if (inputStream != null) {
            try {
                this.contents = new byte[inputStream.available()];
                inputStream.read(this.contents, 0, this.contents.length);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        if (this.contents != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.contents);
            try {
                this.file.create((InputStream)byteArrayInputStream, true, iProgressMonitor);
            }
            finally {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.file.create(null, true, iProgressMonitor);
    }

    public void doUndo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        this.file.delete(true, iProgressMonitor);
    }
}

