/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PropertyPage;

public class ClasspathPage
extends PropertyPage
implements IWizardPage {
    public static final String rcsid = "$Id: ClasspathPage.java,v 1.6 2008/12/12 11:16:04 gianni Exp $";
    private IWizard wizard;
    private IWizardPage prevPage;
    private IWizardPage nextPage;
    private Tree tree;

    public ClasspathPage() {
        this.setTitle(IsresourceBundle.getString((String)"class_path_title"));
        this.noDefaultAndApplyButton();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public String getName() {
        return "";
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    public void setWizard(IWizard iWizard) {
        this.wizard = iWizard;
    }

    public void setNextPage(IWizardPage iWizardPage) {
        this.nextPage = iWizardPage;
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    public void setPreviousPage(IWizardPage iWizardPage) {
        this.prevPage = iWizardPage;
    }

    public IWizardPage getPreviousPage() {
        return this.prevPage;
    }

    public boolean isPageComplete() {
        return true;
    }

    private boolean isJar(String string) {
        return string.endsWith(".jar") || string.endsWith(".zip");
    }

    public Control createContents(Composite composite) {
        TreeItem treeItem;
        String string;
        StringTokenizer stringTokenizer;
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        group.setText(IsresourceBundle.getString((String)"jar_class_lbl"));
        this.tree = new Tree((Composite)group, 2050);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 500;
        this.tree.setLayoutData((Object)gridData);
        String string2 = null;
        IProject iProject = null;
        try {
            iProject = (IProject)PluginUtilities.castOrAdapt((Object)this.getElement(), IProject.class);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (iProject != null) {
            string2 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.classpath");
        }
        if (string2 != null) {
            stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                treeItem = new TreeItem(this.tree, 0);
                treeItem.setText(string);
                if (this.isJar(string)) {
                    treeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/jar.gif"));
                    continue;
                }
                treeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/folder.gif"));
            }
        }
        stringTokenizer = new Composite((Composite)group, 0);
        gridLayout = new GridLayout();
        stringTokenizer.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        stringTokenizer.setLayoutData(gridData);
        string = new Button((Composite)stringTokenizer, 8);
        string.setText(IsresourceBundle.getString((String)"add_jar_lbl"));
        gridData = new GridData(2);
        string.setLayoutData((Object)gridData);
        string.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData(768);
        string.setLayoutData((Object)gridData);
        treeItem = new Button((Composite)stringTokenizer, 8);
        treeItem.setText(IsresourceBundle.getString((String)"add_class_fld_lbl"));
        gridData = new GridData(2);
        treeItem.setLayoutData((Object)gridData);
        treeItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button button = new Button((Composite)stringTokenizer, 8);
        button.setText(IsresourceBundle.getString((String)"remove_lbl"));
        gridData = new GridData(2);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData(768);
        button.setLayoutData((Object)gridData);
        return group;
    }

    public boolean isValid() {
        return true;
    }

    public boolean performOk() {
        IProject iProject = null;
        try {
            iProject = (IProject)PluginUtilities.castOrAdapt((Object)this.getElement(), IProject.class);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this.performOk(iProject);
    }

    public boolean performOk(IProject iProject) {
        String string = this.getClasspath();
        if (iProject != null) {
            PluginUtilities.setPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.classpath", (String)string);
            PluginUtilities.saveProjectOptions((IProject)iProject);
        }
        return true;
    }

    private String getClasspath() {
        if (this.tree.isDisposed()) {
            return null;
        }
        TreeItem[] treeItemArray = this.tree.getItems();
        if (treeItemArray != null && treeItemArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(treeItemArray[0].getText());
            for (int i = 1; i < treeItemArray.length; ++i) {
                stringBuffer.append(File.pathSeparator).append(treeItemArray[i].getText());
            }
            return stringBuffer.toString();
        }
        return "";
    }

    static /* synthetic */ Tree access$000(ClasspathPage classpathPage) {
        return classpathPage.tree;
    }
}

