/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PropertyPage;

public class FilterExtensionsPage
extends PropertyPage
implements IWizardPage {
    private static final LinkedHashSet<String> FIXED_EXTENSIONS = new LinkedHashSet();
    private IWizard wizard;
    private IWizardPage prevPage;
    private IWizardPage nextPage;
    private Text otherTxt;
    private Tree extensionsTree;

    public boolean canFlipToNextPage() {
        return this.validate();
    }

    private boolean validate() {
        if (this.otherTxt.getText().length() > 0) {
            String string = "(\\*\\.\\w+)(\\;\\*\\.\\w+)*";
            if (!this.otherTxt.getText().matches(string)) {
                this.setErrorMessage("Invalid extensions list: the value must be in the format '*.ext1[;...;*.extN]'");
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public String getName() {
        return "Filter extensions";
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    protected void performDefaults() {
        super.performDefaults();
        for (TreeItem treeItem : this.extensionsTree.getItems()) {
            treeItem.setChecked(false);
        }
        this.otherTxt.setText("");
    }

    public void setWizard(IWizard iWizard) {
        this.wizard = iWizard;
    }

    public void setNextPage(IWizardPage iWizardPage) {
        this.nextPage = iWizardPage;
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    public void setPreviousPage(IWizardPage iWizardPage) {
        this.prevPage = iWizardPage;
    }

    public IWizardPage getPreviousPage() {
        return this.prevPage;
    }

    public boolean isPageComplete() {
        return this.validate();
    }

    private IProject getProject() {
        IProject iProject = null;
        try {
            iProject = (IProject)PluginUtilities.castOrAdapt((Object)this.getElement(), IProject.class);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return iProject;
    }

    public Control createContents(Composite composite) {
        String string;
        TreeItem treeItem;
        String string22;
        this.setTitle("Filter extensions");
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Compile only the source files with the following extensions");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.extensionsTree = new Tree(composite2, 2080);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.extensionsTree.setLayoutData((Object)gridData);
        for (String string22 : FIXED_EXTENSIONS) {
            treeItem = new TreeItem(this.extensionsTree, 0);
            treeItem.setText(string22);
        }
        Button button = new Button(composite2, 8);
        button.setText(IsresourceBundle.getString((String)"select_all_lbl"));
        button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        string22 = new Button(composite2, 8);
        string22.setText(IsresourceBundle.getString((String)"deselect_all_lbl"));
        string22.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        treeItem = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        treeItem.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        treeItem.setLayoutData((Object)gridData);
        label = new Label((Composite)treeItem, 0);
        label.setText("Other extensions:");
        this.otherTxt = new Text((Composite)treeItem, 2048);
        gridData = new GridData(768);
        this.otherTxt.setLayoutData((Object)gridData);
        IProject iProject = this.getProject();
        if (iProject != null && (string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.filterexts")) != null) {
            String string3 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                boolean bl = false;
                for (TreeItem treeItem2 : this.extensionsTree.getItems()) {
                    if (!treeItem2.getText().equals(string4)) continue;
                    treeItem2.setChecked(true);
                    bl = true;
                    break;
                }
                if (bl) continue;
                if (string3.length() > 0) {
                    string3 = string3 + ";";
                }
                string3 = string3 + string4;
            }
            this.otherTxt.setText(string3);
        }
        this.otherTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    public boolean isValid() {
        return this.validate();
    }

    public boolean performOk() {
        IProject iProject = this.getProject();
        if (iProject != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (TreeItem treeItem : this.extensionsTree.getItems()) {
                if (!treeItem.getChecked()) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(';');
                }
                stringBuilder.append(treeItem.getText());
            }
            if (this.otherTxt.getText().length() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(';');
                }
                stringBuilder.append(this.otherTxt.getText());
            }
            PluginUtilities.setPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.filterexts", (String)stringBuilder.toString());
            PluginUtilities.saveProjectOptions((IProject)iProject);
        }
        return true;
    }

    static /* synthetic */ Tree access$000(FilterExtensionsPage filterExtensionsPage) {
        return filterExtensionsPage.extensionsTree;
    }

    static /* synthetic */ boolean access$100(FilterExtensionsPage filterExtensionsPage) {
        return filterExtensionsPage.validate();
    }

    static {
        FIXED_EXTENSIONS.add("*.cbl");
        FIXED_EXTENSIONS.add("*.list");
        FIXED_EXTENSIONS.add("*.cl2");
        FIXED_EXTENSIONS.add("*.cob");
        FIXED_EXTENSIONS.add("*.pco");
    }
}

