/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class IscobolNewProgramPage
extends WizardNewFileCreationPage {
    private static final String eol = System.getProperty("line.separator", "\n");
    public static final String rcsid = "$Id: IscobolNewProgramPage.java,v 1.7 2008/12/12 11:14:37 gianni Exp $";
    private Text linkedFileTxt;
    private boolean advancedControlVisible;
    private ModifyListener modifyListener = new /* Unavailable Anonymous Inner Class!! */;

    public IscobolNewProgramPage(IStructuredSelection iStructuredSelection) {
        super(IsresourceBundle.getString((String)"new_program_title"), iStructuredSelection);
        this.setDescription(IsresourceBundle.getString((String)"new_program_desc"));
    }

    protected void handleAdvancedButtonSelect() {
        super.handleAdvancedButtonSelect();
        boolean bl = this.advancedControlVisible = !this.advancedControlVisible;
        if (this.linkedFileTxt != null && !this.linkedFileTxt.isDisposed()) {
            this.linkedFileTxt.removeModifyListener(this.modifyListener);
        }
        if (this.advancedControlVisible) {
            this.findLinkedFileTxt((Composite)this.getControl(), 0);
        } else {
            this.linkedFileTxt = null;
        }
        if (this.linkedFileTxt != null && !this.linkedFileTxt.isDisposed()) {
            this.linkedFileTxt.addModifyListener(this.modifyListener);
        }
    }

    private int findLinkedFileTxt(Composite composite, int n) {
        Control[] controlArray = composite.getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            if (controlArray[i] instanceof Text) {
                if (n < 2) {
                    ++n;
                    continue;
                }
                this.linkedFileTxt = (Text)controlArray[i];
                return ++n;
            }
            if (!(controlArray[i] instanceof Composite) || (n = this.findLinkedFileTxt((Composite)controlArray[i], n)) != 3) continue;
            return n;
        }
        return n;
    }

    private boolean isIscobolHtmlProject(IProject iProject) {
        try {
            return iProject != null && iProject.getNature("com.iscobol.plugins.HtmlAndroid.IscobolHtmlAndroidNature") != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public IFile createNewFile() {
        IFile iFile;
        CobolFormatter cobolFormatter = new CobolFormatter(true);
        String string = this.getFileName();
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n >= 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1);
        }
        if (string2 == null) {
            if (n >= 0) {
                this.setFileName(string + "cbl");
            } else {
                this.setFileName(string + ".cbl");
            }
        }
        if ((iFile = super.createNewFile()) == null || iFile.isLinked()) {
            return iFile;
        }
        IProject iProject = iFile.getProject();
        boolean bl = this.isIscobolHtmlProject(iProject);
        String string3 = string.toUpperCase();
        if (n >= 0) {
            string3 = string3.substring(0, n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(cobolFormatter.formatLine("IDENTIFICATION DIVISION.")).append(eol);
        stringBuilder.append(cobolFormatter.formatLine("PROGRAM-ID. " + string3 + "."));
        stringBuilder.append(cobolFormatter.formatLine("AUTHOR. " + System.getProperty("user.name", "") + ".")).append(eol);
        stringBuilder.append(cobolFormatter.formatLine("ENVIRONMENT DIVISION.")).append(eol);
        stringBuilder.append(cobolFormatter.formatLine("CONFIGURATION SECTION.")).append(eol);
        if (bl) {
            stringBuilder.append(cobolFormatter.formatLine("REPOSITORY."));
            stringBuilder.append(cobolFormatter.formatLine("   CLASS WEB-AREA AS \"com.iscobol.rts.HTTPHandler\""));
            stringBuilder.append(cobolFormatter.formatLine("   .")).append(eol);
        }
        stringBuilder.append(cobolFormatter.formatLine("INPUT-OUTPUT SECTION.")).append(eol);
        stringBuilder.append(cobolFormatter.formatLine("DATA DIVISION.")).append(eol);
        stringBuilder.append(cobolFormatter.formatLine("FILE SECTION.")).append(eol);
        stringBuilder.append(cobolFormatter.formatLine("WORKING-STORAGE SECTION.")).append(eol);
        stringBuilder.append(cobolFormatter.formatLine("LINKAGE SECTION."));
        if (bl) {
            stringBuilder.append(cobolFormatter.formatLine("01 LNK-AREA OBJECT REFERENCE WEB-AREA."));
        }
        stringBuilder.append(eol);
        if (!bl) {
            stringBuilder.append(cobolFormatter.formatLine("SCREEN SECTION.")).append(eol);
        }
        String string4 = "PROCEDURE DIVISION";
        if (bl) {
            string4 = string4 + " USING LNK-AREA";
        }
        string4 = string4 + ".";
        stringBuilder.append(cobolFormatter.formatLine(string4)).append(eol);
        stringBuilder.append(cobolFormatter.formatLine("MAIN."));
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuilder.toString().getBytes());
        PluginUtilities.modifyFile((IFile)iFile, (InputStream)byteArrayInputStream, (boolean)true);
        try {
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IEditorDescriptor iEditorDescriptor = IDE.getDefaultEditor((IFile)iFile);
        if (iEditorDescriptor == null || !iEditorDescriptor.getId().equals(IscobolEditor.ID)) {
            IDE.setDefaultEditor((IFile)iFile, (String)IscobolEditor.ID);
        }
        return iFile;
    }

    protected boolean validatePage() {
        boolean bl = super.validatePage();
        if (!bl) {
            return bl;
        }
        IPath iPath = this.getContainerFullPath();
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
        if (!(iResource instanceof IContainer) || !PluginUtilities.isInSourceFolder((IContainer)((IContainer)iResource))) {
            this.setErrorMessage(IsresourceBundle.getString((String)"file_not_in_src_fld_msg"));
            bl = false;
        } else {
            this.setErrorMessage(null);
        }
        return bl;
    }

    static /* synthetic */ Text access$000(IscobolNewProgramPage iscobolNewProgramPage) {
        return iscobolNewProgramPage.linkedFileTxt;
    }
}

