/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IscobolNatureExt;
import com.iscobol.plugins.editor.util.ProjectSettingList;
import com.iscobol.plugins.editor.wizards.InvalidPropertyFileException;
import com.iscobol.plugins.editor.wizards.IscobolPropertiesImportExportPage;
import com.iscobol.plugins.editor.wizards.IscobolPropertiesImportExportPage2;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class IscobolPropertiesImportWizard
extends Wizard
implements IImportWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private IscobolPropertiesImportExportPage page1;
    private IscobolPropertiesImportExportPage2 page2;

    public IscobolPropertiesImportWizard() {
        this.setWindowTitle("Import Project Properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performFinish() {
        IProject iProject = this.page1.getParentProject();
        if (iProject == null) {
            return false;
        }
        IscobolNatureExt iscobolNatureExt = null;
        try {
            iscobolNatureExt = (IscobolNatureExt)iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNatureExt");
        }
        catch (CoreException coreException) {
            return false;
        }
        if (iscobolNatureExt == null) {
            return false;
        }
        String string = this.page2.getPropFileName();
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        Path path = new Path(".iscoboloptions");
        IFile iFile = iProject.getFile((IPath)path);
        try {
            iscobolNatureExt.checkExists(iFile, path);
        }
        catch (CoreException coreException) {
            return false;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            ProjectSettingList projectSettingList = IscobolNatureExt.loadOptions((InputStream)fileInputStream);
            if (projectSettingList == null) {
                throw new InvalidPropertyFileException();
            }
            projectSettingList.setFileSettings(new Hashtable());
            iscobolNatureExt.setProjectSettings(projectSettingList);
            iscobolNatureExt.saveOptions();
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
    }

    public void addPages() {
        this.page1 = new IscobolPropertiesImportExportPage(IscobolPropertiesImportExportPage.class.getName(), this.selection, true);
        this.page1.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.page1);
        this.page2 = new IscobolPropertiesImportExportPage2(IscobolPropertiesImportExportPage.class.getName(), true);
        this.page2.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.page2);
        this.page2.setPreviousPage((IWizardPage)this.page1);
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }
}

