/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.preferences.IscobolPreferenceInitializer;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.wizards.IscobolWorkspaceSettingsExportPage;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class IscobolWorkspaceSettingsExportWizard
extends Wizard
implements IExportWizard {
    private IWorkbench workbench;
    private IscobolWorkspaceSettingsExportPage page;

    public IscobolWorkspaceSettingsExportWizard() {
        this.setWindowTitle("Export Workspace settings");
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
    }

    private void exportSettings(String string) throws Exception {
        String string2 = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        IscobolEditorPlugin.exportSettings((String)string2, (String)string);
        int n = IscobolPreferenceInitializer.getValueFromPreferences((String)"iscobol.preferences.numsavedsettings", (int)5);
        String string3 = IscobolPreferenceInitializer.getValueFromPreferences((String)"iscobol.preferences.savedsettings", (String)"");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
        while (stringTokenizer.hasMoreTokens()) {
            linkedHashSet.add(stringTokenizer.nextToken());
        }
        if (!linkedHashSet.contains(string)) {
            if (linkedHashSet.isEmpty()) {
                string3 = string;
            } else {
                if (linkedHashSet.size() == n) {
                    string3 = string3.substring(0, string3.lastIndexOf(59));
                }
                string3 = string + ";" + string3;
            }
            IscobolPreferenceInitializer.setValueToPreferences((String)"iscobol.preferences.savedsettings", (String)string3);
        }
    }

    public boolean performFinish() {
        String string = this.page.getPreferenceFile();
        if (string != null) {
            try {
                this.exportSettings(string);
                return true;
            }
            catch (Exception exception) {
                PluginUtilities.log((Throwable)exception);
                return false;
            }
        }
        return false;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    private IscobolWorkspaceSettingsExportPage createPage() {
        return new IscobolWorkspaceSettingsExportPage();
    }

    public void addPages() {
        this.page = this.createPage();
        this.page.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.page);
    }
}

