/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.wizards.IscobolWorkspaceSettingsImportPage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class IscobolWorkspaceSettingsImportWizard
extends Wizard
implements IImportWizard {
    private IWorkbench workbench;
    private IscobolWorkspaceSettingsImportPage page;

    public IscobolWorkspaceSettingsImportWizard() {
        this.setWindowTitle("Import Workspace Settings");
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
    }

    private void importSettings(String string) throws Exception {
        String string2 = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        IscobolEditorPlugin.importSettings((String)string2, (String)string);
        Shell shell = this.getContainer().getShell();
        MessageDialog messageDialog = new MessageDialog(shell, shell.getText(), shell.getImage(), IsresourceBundle.getString((String)"settings_imported_msg"), 2, new String[]{"Restart", "Continue"}, 1);
        int n = messageDialog.open();
        if (n == 0) {
            PlatformUI.getWorkbench().restart();
        }
    }

    public boolean performFinish() {
        String string = this.page.getPreferenceFile();
        if (string != null) {
            try {
                this.importSettings(string);
                return true;
            }
            catch (Exception exception) {
                PluginUtilities.log((Throwable)exception);
                return false;
            }
        }
        return false;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    private IscobolWorkspaceSettingsImportPage createPage() {
        return new IscobolWorkspaceSettingsImportPage();
    }

    public void addPages() {
        this.page = this.createPage();
        this.page.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.page);
    }
}

