/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.views.IIscobolNavigator;
import com.iscobol.plugins.editor.wizards.NewLinkedFilesPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewLinkedFilesWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private NewLinkedFilesPage page;

    public NewLinkedFilesWizard() {
        this.setWindowTitle(IsresourceBundle.getString((String)"new_linked_files_title"));
    }

    public boolean performFinish() {
        IFile[] iFileArray = this.page.createFiles();
        if (iFileArray != null && iFileArray.length > 0) {
            IIscobolNavigator iIscobolNavigator = PluginUtilities.findFileNavigator();
            BasicNewResourceWizard.selectAndReveal((IResource)iFileArray[0].getParent(), (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
            if (iIscobolNavigator != null) {
                iIscobolNavigator.refresh((Object)iFileArray[0].getProject());
                if (!iIscobolNavigator.isVisible()) {
                    iIscobolNavigator.getViewSite().getPage().bringToTop((IWorkbenchPart)iIscobolNavigator);
                }
            }
        }
        return this.page.isPageComplete();
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void addPages() {
        try {
            this.adjustSelection();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.page = new NewLinkedFilesPage("NewLinkedFilesPage", IsresourceBundle.getString((String)"new_linked_files2_title"), null);
        this.page.init(this.workbench, this.selection);
        this.page.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.page);
    }

    protected void adjustSelection() throws CoreException {
        IContainer iContainer;
        IResource iResource;
        IProject iProject;
        Object object;
        if (this.selection != null && !this.selection.isEmpty() && (object = this.selection.getFirstElement()) instanceof IResource && (iProject = (iResource = (IResource)object).getProject()) != null && iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") != null && (iContainer = this.getDefaultFolder(iProject)) != null) {
            this.selection = new StructuredSelection((Object)iContainer);
        }
    }

    protected IContainer getDefaultFolder(IProject iProject) throws CoreException {
        String string = PluginUtilities.getCurrentSettingMode((IResource)iProject);
        IContainer[] iContainerArray = PluginUtilities.getCopyFolders((IProject)iProject, (String)string);
        if (iContainerArray != null && iContainerArray.length > 0) {
            return iContainerArray[0];
        }
        return null;
    }
}

