/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.wizards.ProjectAsStandaloneExecutableExportPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ProjectAsStandaloneExecutableExportPage2
extends WizardPage {
    private Text destFolderTxt;
    private Text destArchiveTxt;
    private Text jvmArgsTxt;
    private Text programArgsTxt;
    private Text execNameTxt;
    private Button destFolderBrowseBtn;
    private Button destArchiveBrowseBtn;
    private Button destFolderBtn;
    private Button destArchiveBtn;
    private Button exportSourcesBtn;
    private Combo mainProgramCmb;
    private String destFolder;
    private String destArchive;
    private String jvmArgs;
    private String programArgs;
    private String execName;
    private IFile mainProgram;
    private boolean exportSources;
    private IProject selProject;
    private ModifyListener ml = new /* Unavailable Anonymous Inner Class!! */;

    public ProjectAsStandaloneExecutableExportPage2(String string) {
        super(string, "Export Project As Standalone Executable", null);
    }

    private boolean validatePage() {
        boolean bl = this.validateDestination() & this.validateMainProgram() & this.validateExportSources() & this.validateJVMArgs() & this.validateProgramArgs() & this.validateExecutableName();
        if (bl) {
            this.setPageValid();
        }
        return bl;
    }

    private boolean validateDestination() {
        if (this.destFolderBtn.getSelection()) {
            this.destFolder = this.destFolderTxt.getText();
            this.destArchive = null;
            if (this.destFolder.length() == 0) {
                this.destFolder = null;
                this.setPageInvalid(IsresourceBundle.getString((String)"destdir_must_spec_lbl"));
                return false;
            }
            this.setLastExportDestinationFolder(this.destFolder);
            this.setLastExportArchiveFile("");
        } else if (this.destArchiveBtn.getSelection()) {
            this.destArchive = this.destArchiveTxt.getText();
            this.destFolder = null;
            if (this.destArchive.length() == 0) {
                this.destArchive = null;
                this.setPageInvalid(IsresourceBundle.getString((String)"archive_must_spec_lbl"));
                return false;
            }
            this.setLastExportDestinationFolder("");
            this.setLastExportArchiveFile(this.destArchive);
        }
        return true;
    }

    private boolean validateMainProgram() {
        if (this.mainProgramCmb.getSelectionIndex() < 0) {
            this.mainProgram = null;
            this.setPageInvalid("Set the Main Program");
            return false;
        }
        this.mainProgram = (IFile)this.mainProgramCmb.getData(this.mainProgramCmb.getText());
        String string = this.mainProgram.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        this.setLastExportMainProgram(string);
        return true;
    }

    private boolean validateExportSources() {
        this.exportSources = this.exportSourcesBtn.getSelection();
        this.setLastExportSources(this.exportSources);
        return true;
    }

    private boolean validateJVMArgs() {
        this.jvmArgs = this.jvmArgsTxt.getText();
        this.setLastExportJvmArguments(this.jvmArgs);
        return true;
    }

    private boolean validateProgramArgs() {
        this.programArgs = this.programArgsTxt.getText();
        this.setLastExportProgramArguments(this.programArgs);
        return true;
    }

    private boolean validateExecutableName() {
        this.execName = this.execNameTxt.getText();
        char[] cArray = this.execName.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\"': 
                case '*': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '>': 
                case '\\': 
                case '|': {
                    this.execName = null;
                    this.setPageInvalid("Invalid Executable Name");
                    return false;
                }
            }
        }
        this.setLastExportExecutableName(this.execName);
        return true;
    }

    protected void setPageValid() {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }

    protected void setPageInvalid(String string) {
        this.setErrorMessage(string);
        this.setMessage(null);
        this.setPageComplete(false);
    }

    public void createControl(Composite composite) {
        String string;
        String string2;
        String string3;
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setText("Main");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        Label label = new Label((Composite)group, 0);
        label.setText("Main Program");
        this.mainProgramCmb = new Combo((Composite)group, 2056);
        gridData = new GridData(768);
        this.mainProgramCmb.setLayoutData((Object)gridData);
        label = new Label((Composite)group, 0);
        label.setText("JVM Arguments");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.jvmArgsTxt = new Text((Composite)group, 2626);
        gridData = new GridData(768);
        gridData.heightHint = 50;
        gridData.horizontalSpan = 2;
        this.jvmArgsTxt.setLayoutData((Object)gridData);
        label = new Label((Composite)group, 0);
        label.setText("Program Arguments");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.programArgsTxt = new Text((Composite)group, 2626);
        gridData = new GridData(768);
        gridData.heightHint = 50;
        gridData.horizontalSpan = 2;
        this.programArgsTxt.setLayoutData((Object)gridData);
        Group group2 = new Group(composite2, 0);
        group2.setText("Destination");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        group2.setLayoutData((Object)gridData);
        this.destFolderBtn = new Button((Composite)group2, 16);
        this.destFolderBtn.setText("Directory");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.destFolderBtn.setLayoutData((Object)gridData);
        this.destFolderTxt = new Text((Composite)group2, 2048);
        gridData = new GridData(768);
        this.destFolderTxt.setLayoutData((Object)gridData);
        this.destFolderBrowseBtn = new Button((Composite)group2, 8);
        this.destFolderBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.destArchiveBtn = new Button((Composite)group2, 16);
        this.destArchiveBtn.setText("Archive File");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.destArchiveBtn.setLayoutData((Object)gridData);
        this.destArchiveTxt = new Text((Composite)group2, 2048);
        gridData = new GridData(768);
        this.destArchiveTxt.setLayoutData((Object)gridData);
        this.destArchiveBrowseBtn = new Button((Composite)group2, 8);
        this.destArchiveBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.exportSourcesBtn = new Button(composite2, 32);
        this.exportSourcesBtn.setText("Export Sources");
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(768));
        label = new Label(composite3, 0);
        label.setText("Executable Name:");
        this.execNameTxt = new Text(composite3, 2048);
        this.execNameTxt.setLayoutData((Object)new GridData(768));
        this.setSelectedProject(((ProjectAsStandaloneExecutableExportPage)this.getPreviousPage()).getProject());
        String string4 = this.getLastExportMainProgram();
        for (int i = 0; i < this.mainProgramCmb.getItemCount(); ++i) {
            if (!this.mainProgramCmb.getItem(i).equals(string4)) continue;
            this.mainProgram = (IFile)this.mainProgramCmb.getData(string4);
            this.mainProgramCmb.select(i);
            break;
        }
        if ((string3 = this.getLastExportExecutableName()).length() > 0) {
            this.execNameTxt.setText(string3);
            this.execName = string3;
        }
        if ((string2 = this.getLastExportJvmArguments()).length() > 0) {
            this.jvmArgsTxt.setText(string2);
            this.jvmArgs = string2;
        }
        if ((string = this.getLastExportProgramArguments()).length() > 0) {
            this.programArgsTxt.setText(string);
            this.programArgs = string;
        }
        this.exportSources = this.getLastExportSources();
        this.exportSourcesBtn.setSelection(this.exportSources);
        this.destFolder = this.getLastExportDestinationFolder();
        this.destArchive = this.getLastExportArchiveFile();
        if (this.destFolder.length() > 0) {
            this.destFolderBtn.setSelection(true);
            this.destFolderTxt.setEnabled(true);
            this.destFolderBrowseBtn.setEnabled(true);
            this.destArchiveBtn.setSelection(false);
            this.destArchiveTxt.setEnabled(false);
            this.destArchiveBrowseBtn.setEnabled(false);
            this.destFolderTxt.setText(this.destFolder);
        } else if (this.destArchive.length() > 0) {
            this.destFolderBtn.setSelection(false);
            this.destFolderTxt.setEnabled(false);
            this.destFolderBrowseBtn.setEnabled(false);
            this.destArchiveBtn.setSelection(true);
            this.destArchiveTxt.setEnabled(true);
            this.destArchiveBrowseBtn.setEnabled(true);
            this.destArchiveTxt.setText(this.destArchive);
        } else {
            this.destFolderBtn.setSelection(true);
            this.destFolderTxt.setEnabled(true);
            this.destFolderBrowseBtn.setEnabled(true);
            this.destArchiveBtn.setSelection(false);
            this.destArchiveTxt.setEnabled(false);
            this.destArchiveBrowseBtn.setEnabled(false);
        }
        this.destFolderTxt.addModifyListener(this.ml);
        this.destArchiveTxt.addModifyListener(this.ml);
        this.jvmArgsTxt.addModifyListener(this.ml);
        this.programArgsTxt.addModifyListener(this.ml);
        this.mainProgramCmb.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.execNameTxt.addModifyListener(this.ml);
        this.destFolderBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.destArchiveBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.exportSourcesBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.destFolderBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.destArchiveBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.validatePage();
    }

    void setLastExportDestinationFolder(String string) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.export.lastfolder", string);
    }

    String getLastExportDestinationFolder() {
        return IscobolEditorPlugin.getDefault().getPreferenceStore().getString("iscobol.export.lastfolder");
    }

    void setLastExportArchiveFile(String string) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.export.lastarchivefile", string);
    }

    String getLastExportArchiveFile() {
        return IscobolEditorPlugin.getDefault().getPreferenceStore().getString("iscobol.export.lastarchivefile");
    }

    void setLastExportJvmArguments(String string) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.export.lastjvmargs", string);
    }

    String getLastExportJvmArguments() {
        return IscobolEditorPlugin.getDefault().getPreferenceStore().getString("iscobol.export.lastjvmargs");
    }

    void setLastExportSources(boolean bl) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.export.source", bl);
    }

    boolean getLastExportSources() {
        return IscobolEditorPlugin.getDefault().getPreferenceStore().getBoolean("iscobol.export.source");
    }

    void setLastExportMainProgram(String string) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.export.lastprogram", string);
    }

    String getLastExportMainProgram() {
        return IscobolEditorPlugin.getDefault().getPreferenceStore().getString("iscobol.export.lastprogram");
    }

    void setLastExportExecutableName(String string) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.export.execname", string);
    }

    String getLastExportExecutableName() {
        return IscobolEditorPlugin.getDefault().getPreferenceStore().getString("iscobol.export.execname");
    }

    void setLastExportProgramArguments(String string) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.export.lastprogargs", string);
    }

    String getLastExportProgramArguments() {
        return IscobolEditorPlugin.getDefault().getPreferenceStore().getString("iscobol.export.lastprogargs");
    }

    void setSelectedProject(IProject iProject) {
        this.selProject = iProject;
        if (this.selProject != null) {
            try {
                IContainer iContainer = PluginUtilities.getSourceFolder((IProject)this.selProject);
                this.loadPrognameCombo(iContainer);
            }
            catch (CoreException coreException) {}
        } else {
            this.mainProgramCmb.removeAll();
        }
    }

    public String getDestinationFolder() {
        return this.destFolder;
    }

    public String getArchiveFile() {
        return this.destArchive;
    }

    public IFile getMainProgram() {
        return this.mainProgram;
    }

    public String getExecutableName() {
        return this.execName;
    }

    public String getJVMArguments() {
        return this.jvmArgs;
    }

    public String getProgramArguments() {
        return this.programArgs;
    }

    public boolean getExportSources() {
        return this.exportSources;
    }

    private void loadPrognameCombo(IContainer iContainer) throws CoreException {
        this.mainProgramCmb.removeAll();
        IResource[] iResourceArray = iContainer.members();
        block4: for (int i = 0; i < iResourceArray.length; ++i) {
            switch (iResourceArray[i].getType()) {
                case 1: {
                    String string = iResourceArray[i].getName();
                    int n = string.lastIndexOf(46);
                    if (n >= 0) {
                        string = string.substring(0, n);
                    }
                    this.mainProgramCmb.add(string);
                    this.mainProgramCmb.setData(string, (Object)iResourceArray[i]);
                    continue block4;
                }
                case 2: 
                case 4: {
                    this.loadPrognameCombo((IContainer)iResourceArray[i]);
                }
            }
        }
    }

    static /* synthetic */ boolean access$000(ProjectAsStandaloneExecutableExportPage2 projectAsStandaloneExecutableExportPage2) {
        return projectAsStandaloneExecutableExportPage2.validatePage();
    }

    static /* synthetic */ ModifyListener access$100(ProjectAsStandaloneExecutableExportPage2 projectAsStandaloneExecutableExportPage2) {
        return projectAsStandaloneExecutableExportPage2.ml;
    }

    static /* synthetic */ Text access$200(ProjectAsStandaloneExecutableExportPage2 projectAsStandaloneExecutableExportPage2) {
        return projectAsStandaloneExecutableExportPage2.execNameTxt;
    }

    static /* synthetic */ Combo access$300(ProjectAsStandaloneExecutableExportPage2 projectAsStandaloneExecutableExportPage2) {
        return projectAsStandaloneExecutableExportPage2.mainProgramCmb;
    }

    static /* synthetic */ Text access$400(ProjectAsStandaloneExecutableExportPage2 projectAsStandaloneExecutableExportPage2) {
        return projectAsStandaloneExecutableExportPage2.destFolderTxt;
    }

    static /* synthetic */ Text access$500(ProjectAsStandaloneExecutableExportPage2 projectAsStandaloneExecutableExportPage2) {
        return projectAsStandaloneExecutableExportPage2.destArchiveTxt;
    }

    static /* synthetic */ Button access$600(ProjectAsStandaloneExecutableExportPage2 projectAsStandaloneExecutableExportPage2) {
        return projectAsStandaloneExecutableExportPage2.destFolderBtn;
    }

    static /* synthetic */ Button access$700(ProjectAsStandaloneExecutableExportPage2 projectAsStandaloneExecutableExportPage2) {
        return projectAsStandaloneExecutableExportPage2.destFolderBrowseBtn;
    }

    static /* synthetic */ Button access$800(ProjectAsStandaloneExecutableExportPage2 projectAsStandaloneExecutableExportPage2) {
        return projectAsStandaloneExecutableExportPage2.destArchiveBrowseBtn;
    }

    static /* synthetic */ Button access$900(ProjectAsStandaloneExecutableExportPage2 projectAsStandaloneExecutableExportPage2) {
        return projectAsStandaloneExecutableExportPage2.destArchiveBtn;
    }
}

