/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.wizards.ProjectAsStandaloneExecutableExportPage;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ProjectAsStandaloneExecutableExportPage3
extends WizardPage {
    private Tree cpTree;
    private File[] pathsToExport;
    private IProject selProject;

    public ProjectAsStandaloneExecutableExportPage3(String string) {
        super(string, "Export Project As Standalone Executable", null);
    }

    void setLastExportPaths(String string) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.export.paths", string);
    }

    String getLastExportPaths() {
        return IscobolEditorPlugin.getDefault().getPreferenceStore().getString("iscobol.export.paths");
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setText("Export external JARs and Class Folders");
        gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        group.setLayoutData((Object)gridData);
        this.cpTree = new Tree((Composite)group, 2080);
        this.cpTree.setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite((Composite)group, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        composite3.setLayoutData((Object)gridData);
        Button button = new Button(composite3, 8);
        button.setText(IsresourceBundle.getString((String)"select_all_lbl"));
        button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button button2 = new Button(composite3, 8);
        button2.setText(IsresourceBundle.getString((String)"deselect_all_lbl"));
        button2.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cpTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setSelectedProject(((ProjectAsStandaloneExecutableExportPage)this.getWizard().getPages()[0]).getProject());
        String string = this.getLastExportPaths();
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            block0: while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                for (int i = 0; i < this.cpTree.getItemCount(); ++i) {
                    if (!this.cpTree.getItem(i).getText().equals(string2)) continue;
                    this.cpTree.getItem(i).setChecked(true);
                    continue block0;
                }
            }
            this.setPaths(false);
        }
    }

    void setSelectedProject(IProject iProject) {
        this.selProject = iProject;
        if (this.selProject != null) {
            this.loadTree();
        } else {
            this.cpTree.removeAll();
        }
    }

    private void loadTree() {
        this.cpTree.removeAll();
        String string = PluginUtilities.getPersistentProperty((IResource)this.selProject, (String)"Default", (String)"iscobol.classpath");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                TreeItem treeItem = new TreeItem(this.cpTree, 0);
                treeItem.setText(string2);
                if (this.isJar(string2)) {
                    treeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/jar.gif"));
                    continue;
                }
                treeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/folder.gif"));
            }
        }
    }

    private boolean isJar(String string) {
        return string.endsWith(".jar") || string.endsWith(".zip");
    }

    private void setPaths(boolean bl) {
        TreeItem[] treeItemArray = this.cpTree.getItems();
        ArrayList<File> arrayList = new ArrayList<File>();
        StringBuffer stringBuffer = null;
        if (bl) {
            stringBuffer = new StringBuffer();
        }
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (!treeItemArray[i].getChecked()) continue;
            arrayList.add(new File(treeItemArray[i].getText()));
            if (!bl) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(";");
            }
            stringBuffer.append(treeItemArray[i].getText());
        }
        this.pathsToExport = arrayList.toArray(new File[arrayList.size()]);
        if (bl) {
            this.setLastExportPaths(stringBuffer.toString());
        }
    }

    public File[] getPathsToExport() {
        return this.pathsToExport;
    }

    static /* synthetic */ Tree access$000(ProjectAsStandaloneExecutableExportPage3 projectAsStandaloneExecutableExportPage3) {
        return projectAsStandaloneExecutableExportPage3.cpTree;
    }

    static /* synthetic */ void access$100(ProjectAsStandaloneExecutableExportPage3 projectAsStandaloneExecutableExportPage3, boolean bl) {
        projectAsStandaloneExecutableExportPage3.setPaths(bl);
    }
}

