/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor;

import com.iscobol.plugins.editor.IscobolDoubleClickSelector;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.debug.DisplayVariableTextHover;
import com.iscobol.plugins.editor.util.IsFragment;
import com.iscobol.plugins.editor.util.VarDecl;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class DisplayCobolElementTextHover
implements ITextHover {
    private IscobolDoubleClickSelector dblClickSelector = new IscobolDoubleClickSelector();
    private IscobolEditor editor;
    private DisplayVariableTextHover displayVarHover;

    public DisplayCobolElementTextHover(IscobolEditor iscobolEditor) {
        this.editor = iscobolEditor;
        this.displayVarHover = new DisplayVariableTextHover(iscobolEditor);
    }

    private SimpleMarkerAnnotation findMarkerAnnotation(ISourceViewer iSourceViewer, int n) {
        try {
            IRegion iRegion = iSourceViewer.getDocument().getLineInformation(n);
            IAnnotationModel iAnnotationModel = iSourceViewer.getAnnotationModel();
            if (iAnnotationModel != null) {
                Iterator iterator = iAnnotationModel.getAnnotationIterator();
                while (iterator.hasNext()) {
                    Position position;
                    Annotation annotation = (Annotation)iterator.next();
                    if (!(annotation instanceof SimpleMarkerAnnotation) || (position = iAnnotationModel.getPosition(annotation)) == null || !position.overlapsWith(iRegion.getOffset(), iRegion.getLength())) continue;
                    return (SimpleMarkerAnnotation)annotation;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        AnnotationModel annotationModel;
        IMarker iMarker;
        Object object;
        String string = this.displayVarHover.getHoverInfo(iTextViewer, iRegion);
        if (string == null) {
            try {
                SimpleMarkerAnnotation simpleMarkerAnnotation = this.findMarkerAnnotation((ISourceViewer)iTextViewer, iTextViewer.getDocument().getLineOfOffset(iRegion.getOffset()));
                if (simpleMarkerAnnotation != null) {
                    string = "______STANDARD_CONTENT_TYPE" + simpleMarkerAnnotation.getText();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (string == null) {
            boolean bl = IscobolEditorPlugin.getDefault().getPreferenceStore().getBoolean("iscobol.showtooltipmousehover.enabled");
            if (iRegion != null && bl) {
                try {
                    this.dblClickSelector.init(iTextViewer, iRegion.getOffset());
                    if (this.dblClickSelector.matchWord(true)) {
                        int n = this.dblClickSelector.getStartPosition();
                        int n2 = this.dblClickSelector.getEndPosition() - n;
                        if (n2 > 0) {
                            object = iTextViewer.getDocument().get(n, n2).trim();
                            iMarker = this.editor.findSelectedFragment((String)object);
                            string = this.getDescription((IsFragment)iMarker);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        if (string == null && (annotationModel = (AnnotationModel)this.editor.getViewer().getAnnotationModel()) != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                int n;
                Annotation annotation = (Annotation)iterator.next();
                if (!(annotation instanceof SimpleMarkerAnnotation) || (object = annotationModel.getPosition(annotation)) == null || !object.overlapsWith(iRegion.getOffset(), iRegion.getLength()) || (n = (iMarker = ((SimpleMarkerAnnotation)annotation).getMarker()).getAttribute("severity", 0)) != 2 && n != 1 || (string = iMarker.getAttribute("message", null)) == null) continue;
                string = "______STANDARD_CONTENT_TYPE" + string;
            }
        }
        return string;
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        Point point = iTextViewer.getSelectedRange();
        if (point.x <= n && n < point.x + point.y) {
            return new Region(point.x, point.y);
        }
        return new Region(n, 0);
    }

    private String getDescription(IsFragment isFragment) {
        if (isFragment == null) {
            return null;
        }
        if (isFragment instanceof VarDecl) {
            StringBuilder stringBuilder = new StringBuilder("______STANDARD_CONTENT_TYPE");
            VarDecl varDecl = (VarDecl)isFragment;
            int n = varDecl.getLevel();
            if (n < 10) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n + " ");
            stringBuilder.append(varDecl.getName());
            if (varDecl.hasNoLevel78_88Children()) {
                stringBuilder.append(" group-item");
            } else if (varDecl.isObjectReference()) {
                stringBuilder.append(" object reference " + varDecl.getTypename());
            } else if (varDecl.getGraphicControlType() >= 0) {
                stringBuilder.append(" ");
                switch (varDecl.getGraphicControlType()) {
                    case 1: {
                        stringBuilder.append("Label");
                        break;
                    }
                    case 2: {
                        stringBuilder.append("Entry-Field");
                        break;
                    }
                    case 3: {
                        stringBuilder.append("Push-Button");
                        break;
                    }
                    case 4: {
                        stringBuilder.append("Check-Box");
                        break;
                    }
                    case 5: {
                        stringBuilder.append("Radio-Button");
                        break;
                    }
                    case 6: {
                        stringBuilder.append("Scroll-Bar");
                        break;
                    }
                    case 7: {
                        stringBuilder.append("List-Box");
                        break;
                    }
                    case 8: {
                        stringBuilder.append("Combo-Box");
                        break;
                    }
                    case 9: {
                        stringBuilder.append("Frame");
                        break;
                    }
                    case 10: {
                        stringBuilder.append("Tab-Control");
                        break;
                    }
                    case 11: {
                        stringBuilder.append("Bar");
                        break;
                    }
                    case 12: {
                        stringBuilder.append("Grid");
                        break;
                    }
                    case 13: {
                        stringBuilder.append("Bitmap");
                        break;
                    }
                    case 14: {
                        stringBuilder.append("Tree-View");
                        break;
                    }
                    case 15: {
                        stringBuilder.append("Web-Browser");
                        break;
                    }
                    case 16: {
                        stringBuilder.append("Ole");
                        break;
                    }
                    case 17: {
                        stringBuilder.append("Status-Bar");
                        break;
                    }
                    case 18: {
                        stringBuilder.append("Slider");
                        break;
                    }
                    case 19: {
                        stringBuilder.append("Java-Bean");
                        break;
                    }
                    case 20: {
                        stringBuilder.append("Date-Entry");
                        break;
                    }
                    default: {
                        stringBuilder.append("Unknown type");
                        break;
                    }
                }
            } else {
                if (varDecl.getPicture() != null) {
                    stringBuilder.append(" pic " + varDecl.getPicture());
                }
                if (varDecl.getUsage() != null) {
                    stringBuilder.append(" " + varDecl.getUsage());
                }
                if (varDecl.getValue() != null) {
                    stringBuilder.append(" value " + varDecl.getValue());
                }
            }
            return stringBuilder.toString();
        }
        return null;
    }
}

