/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor;

import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.plugins.editor.IscobolSourceViewerConfiguration;
import com.iscobol.plugins.editor.Tokens;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.util.Hashtable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class IscobolAutoEditStrategy
implements IAutoEditStrategy {
    private final String eol;
    private static final Hashtable nrw = new Hashtable();
    private DefaultIndentLineAutoEditStrategy defaultStrategy = new DefaultIndentLineAutoEditStrategy();
    private IscobolSourceViewerConfiguration configuration;

    public IscobolAutoEditStrategy(IscobolSourceViewerConfiguration iscobolSourceViewerConfiguration) {
        this.configuration = iscobolSourceViewerConfiguration;
        this.eol = this.configuration.getEditor().getViewer().getTextWidget().getLineDelimiter();
    }

    private boolean isCommentLine(String string, int n) {
        int n2;
        return n > 6 && string.charAt(6) == '*' || (n2 = string.indexOf("*>")) >= 0 && n2 + 1 < n || (n2 = string.indexOf("|")) >= 0 && n2 < n;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        block42: {
            String string;
            int n;
            void var12_27;
            if (documentCommand.text.equals("\t") && this.configuration.getEditor().getInsertSpacesForTab()) {
                int n2;
                int n3;
                boolean bl = this.configuration.getEditor().isInInsertMode();
                IRegion iRegion = null;
                try {
                    iRegion = iDocument.getLineInformationOfOffset(documentCommand.offset);
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
                int n4 = documentCommand.offset - iRegion.getOffset();
                int[] nArray = this.configuration.getEditor().getTabStops();
                boolean bl2 = false;
                for (n3 = 0; n3 < nArray.length && !bl2; ++n3) {
                    n2 = nArray[n3] - 1 - n4;
                    if (n2 <= 0) continue;
                    documentCommand.text = this.getSpaces(n2);
                    bl2 = true;
                }
                if (!bl2) {
                    n3 = nArray.length > 0 ? nArray[nArray.length - 1] : 0;
                    int n5 = this.configuration.getEditor().getTabWidth();
                    n3 += n5;
                    while (!bl2) {
                        n2 = n3 - 1 - n4;
                        if (n2 > 0) {
                            documentCommand.text = this.getSpaces(n2);
                            bl2 = true;
                        }
                        n3 += n5;
                    }
                    if (!bl2) {
                        documentCommand.text = this.getSpaces(n3 - n4);
                    }
                }
                if (bl) {
                    if (!PluginUtilities.isAnsiFixedFormat((int)this.configuration.getEditor().getFormat())) return;
                    String string2 = null;
                    String string3 = null;
                    try {
                        string2 = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        return;
                    }
                    if (this.isCommentLine(string2, n4)) return;
                    string3 = string2.length() > 72 ? string2.substring(0, 72) : string2;
                    if (n4 >= (string3 = string3.replaceAll("\\s*$", "")).length()) return;
                    if (string3.length() + documentCommand.text.length() > 72) {
                        documentCommand.doit = false;
                        documentCommand.text = "";
                        documentCommand.length = 0;
                        return;
                    }
                    if (string2.length() <= 72) return;
                    String string4 = documentCommand.text;
                    documentCommand.text = documentCommand.text + string2.substring(n4, 72 - string4.length());
                    documentCommand.length = documentCommand.text.length();
                    documentCommand.caretOffset = iRegion.getOffset() + n4 + string4.length();
                    return;
                }
                documentCommand.length = Math.min(documentCommand.text.length(), iRegion.getLength() - n4);
                return;
            }
            if (documentCommand.text == null || TextUtilities.endsWith((String[])iDocument.getLegalLineDelimiters(), (String)documentCommand.text) != -1) break block42;
            String string5 = null;
            int n6 = 0;
            IRegion iRegion = null;
            try {
                iRegion = iDocument.getLineInformationOfOffset(documentCommand.offset);
                string5 = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                n6 = documentCommand.offset - iRegion.getOffset();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            int n7 = documentCommand.text.indexOf(this.eol);
            String string6 = n7 >= 0 && n7 < documentCommand.text.length() ? documentCommand.text.substring(0, n7) : documentCommand.text;
            string5 = new StringBuilder(string5).replace(n6, Math.min(n6 + documentCommand.length, string5.length()), string6).toString();
            int n8 = this.configuration.getEditor().getFormat();
            TokenList tokenList = PreProcessor.tokenizer((StringBuffer)new StringBuffer(string5), (char)'.', (boolean)false, (Hashtable)nrw);
            String string7 = null;
            int n9 = -1;
            Token token = tokenList.getFirstWithSep();
            while (var12_27 != null && string7 == null) {
                if (this.isComment(var12_27.getWord(), var12_27.getOffset(), n8)) {
                    return;
                }
                if (var12_27.getOffset() + var12_27.getWord().length() > n6) {
                    string7 = var12_27.getWord();
                    n9 = var12_27.getOffset();
                }
                Token token2 = tokenList.getNextWithSep();
            }
            if (string7 == null || n9 == n6 && documentCommand.length > 0) {
                return;
            }
            String string8 = string7.toUpperCase();
            String string9 = (String)Tokens.endTokens.get(string8);
            if (string9 == null) return;
            int n10 = 0;
            try {
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            int n11 = -1;
            int n12 = 0;
            int n13 = n10;
            block15: for (n10 = iDocument.getLineOfOffset(documentCommand.offset); n10 >= 0; --n10) {
                try {
                    iRegion = iDocument.getLineInformation(n10);
                    string5 = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
                tokenList = PreProcessor.tokenizer((StringBuffer)new StringBuffer(string5), (char)'.', (boolean)true, (Hashtable)nrw);
                Token token3 = tokenList.getFirstWithSep();
                while (token3 != null && !this.isComment(token3.getWord(), token3.getOffset(), n8)) {
                    block44: {
                        block45: {
                            String string10;
                            block43: {
                                string10 = token3.getWord().toUpperCase();
                                if (!string10.equals(string8)) break block43;
                                ++n12;
                                break block44;
                            }
                            if (!string10.equals(string9)) break block44;
                            if (!string9.equals("PERFORM")) break block45;
                            n = tokenList.getCurrentIndex();
                            string = tokenList.getNext();
                            tokenList.getAt(n);
                            if (string != null && string.getToknum() == 10009) break block44;
                        }
                        if (n12 == 0) {
                            n11 = token3.getOffset();
                            break block15;
                        }
                        --n12;
                    }
                    token3 = tokenList.getNextWithSep();
                }
            }
            if (n11 < 0 || n10 >= n13) return;
            int n14 = n11 - n9;
            if (n14 > 0) {
                documentCommand.offset -= n6 - n9;
                documentCommand.length += n6 - n9;
                int n15 = n9 + string7.length() - n6;
                if (n15 >= 0) {
                    if (n15 <= documentCommand.text.length()) {
                        documentCommand.text = this.getSpaces(n14) + string7 + documentCommand.text.substring(n15);
                        return;
                    } else {
                        documentCommand.length += n15 - documentCommand.text.length();
                        documentCommand.text = this.getSpaces(n14) + string7;
                    }
                    return;
                } else {
                    documentCommand.text = this.getSpaces(n14) + string7 + documentCommand.text;
                }
                return;
            }
            if (n14 >= 0) return;
            int n16 = n6 - n9 - n14;
            n = n9 + string7.length() - n6;
            try {
                string = iDocument.get(documentCommand.offset - n16, -n14).trim();
                if (string.length() > 0) {
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            documentCommand.offset -= n16;
            documentCommand.length += n16;
            if (n >= 0) {
                if (n <= documentCommand.text.length()) {
                    documentCommand.text = string7 + documentCommand.text.substring(n);
                    return;
                } else {
                    documentCommand.length += n - documentCommand.text.length();
                    documentCommand.text = string7;
                }
                return;
            } else {
                documentCommand.text = string7 + documentCommand.text;
            }
            return;
        }
        this.defaultCustomizeDocumentCommand(iDocument, documentCommand);
    }

    private void defaultCustomizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        this.defaultStrategy.customizeDocumentCommand(iDocument, documentCommand);
    }

    private boolean isComment(String string, int n, int n2) {
        return string.startsWith("*>") || string.startsWith("|") || string.equals("*") && n == 0 && PluginUtilities.isTerminalFormat((int)n2) || string.equals("*") && n == 6 && PluginUtilities.isAnsiFixedFormat((int)n2);
    }

    private String getSpaces(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }
}

