/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor;

import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.plugins.editor.IscobolActionContributor;
import com.iscobol.plugins.editor.IscobolDoubleClickSelector;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorEvent;
import com.iscobol.plugins.editor.IscobolEditorListener;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IscobolOutlinePage;
import com.iscobol.plugins.editor.IscobolProjectionViewer;
import com.iscobol.plugins.editor.IscobolSourceViewerConfiguration;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.Tokens;
import com.iscobol.plugins.editor.actions.ExpandTabsToSpacesAction;
import com.iscobol.plugins.editor.actions.OpenDeclarationAction;
import com.iscobol.plugins.editor.actions.ToggleFoldingAction;
import com.iscobol.plugins.editor.annotations.CopyAnnotation;
import com.iscobol.plugins.editor.annotations.ProblemAnnotation;
import com.iscobol.plugins.editor.annotations.SpellingProblem;
import com.iscobol.plugins.editor.util.ColorProvider;
import com.iscobol.plugins.editor.util.ErrorObj;
import com.iscobol.plugins.editor.util.IsFragment;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.util.PreferenceConverter;
import com.iscobol.plugins.editor.util.VarDecl;
import com.iscobol.plugins.editor.views.IIscobolNavigator;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * Exception performing whole class analysis ignored.
 */
public class IscobolEditor
extends TextEditor
implements LineStyleListener,
LineBackgroundListener {
    public static final String ID = IscobolEditor.class.getName();
    private static final int highlightDelay = 300;
    private TextPaintListener textPaintListener;
    private Timer highlighterTimer = new Timer();
    private CaretListener caretListener;
    private int lastHorizontalPixel = -1;
    private boolean synchOutline = true;
    private MarginPainter[] ansiMarginPainters;
    private MarginPainter[] terminalMarginPainters;
    private ProjectionSupport projectionSupport;
    private Hashtable<Position, ProblemAnnotation> problemAnnotations = new Hashtable();
    private IscobolActionContributor actionContributor;
    private IProject project;
    private Position debugCurrentLine;
    private ProjectionAnnotationModel annotationModel;
    private List<ProjectionAnnotation> oldAnnotations = new ArrayList();
    private Hashtable copyAnnotations = new Hashtable();
    protected ContentOutlinePage outlinePage;
    private int lastTextEventOffs = -1;
    private int format;
    private boolean decPointComma;
    private int editorFormat = 0;
    private IscobolProjectionViewer viewer;
    private String inheritsClass;
    private String[] implementsClasses;
    private String progname = "";
    private boolean isFoldingEnabled = true;
    private int reconcilingEnabled = 0;
    private boolean isSourceFormatEnabled;
    private boolean isSyntaxHighlightingEnabled = true;
    private boolean isShowVerticalLinesEnabled;
    private IPropertyChangeListener ipropchangelist;
    private PropertyChangeListener formatchangelistener;
    private Image oldImage;
    private int lastMouseDownLine;
    private HorizontalRuler horizontalRuler;
    private String lastSelectedFragment;
    private boolean needRefreshOnClose;
    private IscobolDoubleClickSelector selector = new IscobolDoubleClickSelector();
    private Vector<IscobolEditorListener> editorListeners = new Vector();

    public IscobolEditor() {
        IPreferenceStore iPreferenceStore = this.getPluginPreferenceStore();
        this.ipropchangelist = new /* Unavailable Anonymous Inner Class!! */;
        iPreferenceStore.addPropertyChangeListener(this.ipropchangelist);
    }

    public boolean isInInsertMode() {
        return super.isInInsertMode();
    }

    void setHorizontalRulerVisible(boolean bl) {
        int n;
        if (this.horizontalRuler == null) {
            return;
        }
        this.horizontalRuler.setVisible(bl);
        GridData gridData = (GridData)this.horizontalRuler.getLayoutData();
        if (bl) {
            this.horizontalRuler.getClass();
            n = 25;
        } else {
            n = 0;
        }
        gridData.heightHint = n;
        this.horizontalRuler.getParent().layout();
    }

    private void doReconcile() {
        this.getConfiguration().getReconciler((ISourceViewer)this.getViewer()).getReconcilingStrategy("__dftl_partition_content_type").reconcile(null);
    }

    private boolean isActiveEditor() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() == this;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isStatement(String string) {
        return Tokens.statements.contains(string.toUpperCase());
    }

    public void setSite(IWorkbenchPartSite iWorkbenchPartSite) {
        super.setSite(iWorkbenchPartSite);
    }

    public void setFocus() {
        int n;
        this.lastHorizontalPixel = -1;
        super.setFocus();
        boolean bl = IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.folding.enabled");
        if (this.isFoldingEnabled != bl) {
            this.isFoldingEnabled = bl;
            if (this.getViewer().canDoOperation(19)) {
                this.getViewer().doOperation(19);
            }
            if (bl) {
                this.restoreFoldingStructure();
            }
        }
        if (this.reconcilingEnabled != (n = IscobolEditorPlugin.getIntFromStore((String)"iscobol.reconciling.enabled"))) {
            this.reconcilingEnabled = n;
            if (n == 0) {
                this.doReconcile();
            }
        }
        if (this.isSourceFormatEnabled != (bl = IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.sourceformat.enabled"))) {
            this.isSourceFormatEnabled = bl;
            this.rebuildImage(this.getViewer().getTextWidget());
        }
        if (this.isShowVerticalLinesEnabled != (bl = IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.syntaxcoloring.showareadelimiterlines"))) {
            this.isShowVerticalLinesEnabled = bl;
            this.drawVerticalLines();
        }
        if (this.isSyntaxHighlightingEnabled != (bl = IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.syntaxhighlighting.enabled"))) {
            this.isSyntaxHighlightingEnabled = bl;
            this.redraw();
        }
    }

    public void putCopyAnnotation(int n, CopyAnnotation copyAnnotation) {
        this.copyAnnotations.put(new Integer(n), copyAnnotation);
        this.putCopyAnnotation(n, copyAnnotation, this.getViewer().getAnnotationModel());
    }

    protected void putCopyAnnotation(int n, CopyAnnotation copyAnnotation, IAnnotationModel iAnnotationModel) {
        try {
            if (iAnnotationModel != null) {
                iAnnotationModel.addAnnotation((Annotation)copyAnnotation, new Position(this.getViewer().getDocument().getLineOffset(n)));
            }
        }
        catch (BadLocationException badLocationException) {
            PluginUtilities.log((Throwable)badLocationException);
        }
    }

    public CopyAnnotation getCopyAnnotation(int n) {
        return (CopyAnnotation)this.copyAnnotations.get(new Integer(n));
    }

    public void clearCopyAnnotations() {
        this.clearCopyAnnotations(this.getViewer().getAnnotationModel());
        this.copyAnnotations.clear();
    }

    protected void clearCopyAnnotations(IAnnotationModel iAnnotationModel) {
        if (iAnnotationModel != null) {
            ArrayList<CopyAnnotation> arrayList = new ArrayList<CopyAnnotation>();
            Iterator iterator = iAnnotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof CopyAnnotation)) continue;
                arrayList.add((CopyAnnotation)e);
            }
            for (CopyAnnotation copyAnnotation : arrayList) {
                iAnnotationModel.removeAnnotation((Annotation)copyAnnotation);
            }
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
    }

    public ISelection doGetSelection() {
        return super.doGetSelection();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        super.doSave(iProgressMonitor);
        this.fireEditorSavedEvent();
    }

    public void doSetSelection(ISelection iSelection) {
        super.doSetSelection(iSelection);
    }

    private boolean hasMultiLineSelection(StyledText styledText) {
        Point point = styledText.getSelection();
        try {
            int n = styledText.getLineAtOffset(point.x);
            int n2 = styledText.getLineAtOffset(point.y);
            return n != n2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public void lineGetBackground(LineBackgroundEvent lineBackgroundEvent) {
        boolean bl;
        Position position = new Position(lineBackgroundEvent.lineOffset);
        boolean bl2 = bl = this.debugCurrentLine != null && this.debugCurrentLine.equals((Object)position);
        if (bl) {
            ColorProvider colorProvider = IscobolEditorPlugin.getDefault().getColorProvider();
            lineBackgroundEvent.lineBackground = colorProvider.getColor(colorProvider.CURRENT_LINE_BKG);
        } else {
            int n = this.viewer.getTextWidget().getCaretOffset();
            int n2 = lineBackgroundEvent.lineText.length();
            if (lineBackgroundEvent.lineOffset <= n && n <= lineBackgroundEvent.lineOffset + n2 && !this.hasMultiLineSelection(this.viewer.getTextWidget())) {
                ColorProvider colorProvider = IscobolEditorPlugin.getDefault().getColorProvider();
                IPreferenceStore iPreferenceStore = ((MySourceViewerDecorationSupport)this.fSourceViewerDecorationSupport).store;
                IscobolEditorPlugin.getDefault().getPreferenceStore();
                RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"currentLineColor");
                lineBackgroundEvent.lineBackground = colorProvider.getColor(rGB);
            }
        }
    }

    public void lineGetStyle(LineStyleEvent lineStyleEvent) {
        lineStyleEvent.styles = IscobolEditor.lineGetStyle((String)lineStyleEvent.lineText, (int)lineStyleEvent.lineOffset, (IscobolEditor)this, (boolean)this.isSyntaxHighlightingEnabled);
    }

    private static int addStyleRanges(Vector vector, int n, int n2, int n3, String string, IscobolEditor iscobolEditor, Color color, boolean bl, boolean bl2, boolean bl3, ColorProvider colorProvider) {
        StyleRange styleRange;
        int n4;
        int n5 = string.length();
        int n6 = n2 - n3 - 1;
        if (n6 < 0) {
            n2 -= n6;
            n5 += n6;
        }
        if ((n4 = n2 + n5 - 1) < n2) {
            return n3;
        }
        if (bl) {
            styleRange = new StyleRange(n + n2, n4 - n2 + 1, colorProvider.getColor(colorProvider.CURRENT_LINE_FRG), null);
            vector.addElement(styleRange);
        } else {
            styleRange = new StyleRange(n + n2, string.length(), color, null);
            vector.addElement(styleRange);
        }
        if (bl2 || bl3) {
            styleRange.underline = true;
            styleRange.underlineStyle = 3;
            styleRange.underlineColor = colorProvider.getColor(bl2 ? new RGB(255, 0, 0) : new RGB(244, 200, 45));
        }
        if (iscobolEditor != null && iscobolEditor.lastSelectedFragment != null && string.equalsIgnoreCase(iscobolEditor.lastSelectedFragment)) {
            styleRange.background = colorProvider.getColor(JFaceResources.getColorRegistry().getRGB("com.iscobol.plugins.editor.memberHighlight.Background"));
        }
        return n4;
    }

    public static StyleRange[] lineGetStyle(String string, int n, IscobolEditor iscobolEditor) {
        return IscobolEditor.lineGetStyle((String)string, (int)n, (IscobolEditor)iscobolEditor, (boolean)IscobolEditorPlugin.getDefault().isSyntaxHighlightingEnabled());
    }

    private static int getRealOffset(int n, String string) {
        int n2 = IscobolEditorPlugin.getDefault().getTabWidth();
        int n3 = n;
        for (int i = 0; i < n3; ++i) {
            if (string.charAt(i) != '\t') continue;
            n += n2 - 1;
        }
        return n;
    }

    private static String getStrLiteral(String string) {
        if (string.length() > 1) {
            switch (string.charAt(0)) {
                case 'H': 
                case 'R': 
                case 'X': {
                    return string.substring(1);
                }
                case 'N': {
                    switch (string.charAt(1)) {
                        case 'X': {
                            return string.substring(2);
                        }
                    }
                    return string.substring(1);
                }
            }
        }
        return string;
    }

    public static StyleRange[] lineGetStyle(String string, int n, IscobolEditor iscobolEditor, boolean bl) {
        int n2;
        TokenList tokenList;
        ColorProvider colorProvider;
        Vector vector = new Vector();
        Position position = new Position(n, string.length());
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (iscobolEditor != null) {
            bl2 = iscobolEditor.debugCurrentLine != null && iscobolEditor.debugCurrentLine.equals((Object)position);
            colorProvider = iscobolEditor.getViewer().getAnnotationModel();
            if (colorProvider != null) {
                Iterator iterator = colorProvider.getAnnotationIterator();
                while (iterator.hasNext()) {
                    Annotation annotation = (Annotation)iterator.next();
                    if (!(annotation instanceof SimpleMarkerAnnotation) || (tokenList = colorProvider.getPosition(annotation)) == null || !tokenList.overlapsWith(position.offset, position.length)) continue;
                    IMarker iMarker = ((SimpleMarkerAnnotation)annotation).getMarker();
                    n2 = iMarker.getAttribute("severity", 0);
                    if (n2 == 2) {
                        bl3 = true;
                        continue;
                    }
                    if (n2 != 1) continue;
                    bl4 = true;
                }
            }
        }
        colorProvider = IscobolEditorPlugin.getDefault().getColorProvider();
        int n3 = string.length();
        int n4 = -1;
        if (bl) {
            int n5;
            tokenList = PreProcessor.tokenizer((StringBuffer)new StringBuffer(string), (char)'.', (boolean)true, (boolean)true, null);
            boolean bl5 = true;
            n2 = iscobolEditor != null ? iscobolEditor.getFormat() : 0;
            Token token = tokenList.getFirstWithSep();
            Token token2 = null;
            block10: while (token != null) {
                switch (token.getToknum()) {
                    case 10005: {
                        n4 = IscobolEditor.addStyleRanges(vector, (int)n, (int)token.getOffset(), (int)n4, (String)token.getWord(), (IscobolEditor)iscobolEditor, (Color)colorProvider.getColor(colorProvider.COMMENTS_FRG), (boolean)bl2, (boolean)bl3, (boolean)bl4, (ColorProvider)colorProvider);
                        break;
                    }
                    case 10016: {
                        if (token.getWord().startsWith("*>") || token.getWord().startsWith("|")) {
                            n4 = IscobolEditor.addStyleRanges(vector, (int)n, (int)token.getOffset(), (int)n4, (String)token.getWord(), (IscobolEditor)iscobolEditor, (Color)colorProvider.getColor(colorProvider.COMMENTS_FRG), (boolean)bl2, (boolean)bl3, (boolean)bl4, (ColorProvider)colorProvider);
                            bl5 = IscobolEditor.isFirstToken((Token)token, (int)n2);
                            break;
                        }
                        if (token.getWord().trim().length() > 0) {
                            bl5 = IscobolEditor.isFirstToken((Token)token, (int)n2);
                        }
                        n4 = IscobolEditor.addStyleRanges(vector, (int)n, (int)token.getOffset(), (int)n4, (String)token.getWord(), (IscobolEditor)iscobolEditor, null, (boolean)bl2, (boolean)bl3, (boolean)bl4, (ColorProvider)colorProvider);
                        break;
                    }
                    case 10002: {
                        n4 = bl5 && Tokens.getLevelNumber((String)token.getWord()) > 0 ? IscobolEditor.addStyleRanges(vector, (int)n, (int)token.getOffset(), (int)n4, (String)token.getWord(), (IscobolEditor)iscobolEditor, (Color)colorProvider.getColor(colorProvider.LEVEL_NUMBER_FRG), (boolean)bl2, (boolean)bl3, (boolean)bl4, (ColorProvider)colorProvider) : IscobolEditor.addStyleRanges(vector, (int)n, (int)token.getOffset(), (int)n4, (String)token.getWord(), (IscobolEditor)iscobolEditor, (Color)colorProvider.getColor(colorProvider.NUMERIC_CONST_FRG), (boolean)bl2, (boolean)bl3, (boolean)bl4, (ColorProvider)colorProvider);
                        bl5 = IscobolEditor.isFirstToken((Token)token, (int)n2);
                        break;
                    }
                    case 10017: {
                        n4 = IscobolEditor.addStyleRanges(vector, (int)n, (int)token.getOffset(), (int)n4, (String)token.getWord(), (IscobolEditor)iscobolEditor, (Color)colorProvider.getColor(colorProvider.NUMERIC_CONST_FRG), (boolean)bl2, (boolean)bl3, (boolean)bl4, (ColorProvider)colorProvider);
                        bl5 = IscobolEditor.isFirstToken((Token)token, (int)n2);
                        break;
                    }
                    case 10001: 
                    case 10024: {
                        n4 = IscobolEditor.addStyleRanges(vector, (int)n, (int)token.getOffset(), (int)n4, (String)IscobolEditor.getStrLiteral((String)token.getWord()), (IscobolEditor)iscobolEditor, (Color)colorProvider.getColor(colorProvider.STRING_CONST_FRG), (boolean)bl2, (boolean)bl3, (boolean)bl4, (ColorProvider)colorProvider);
                        bl5 = IscobolEditor.isFirstToken((Token)token, (int)n2);
                        break;
                    }
                    case 512: 
                    case 513: 
                    case 570: 
                    case 571: 
                    case 594: 
                    case 595: 
                    case 654: 
                    case 655: 
                    case 729: 
                    case 730: 
                    case 840: 
                    case 842: 
                    case 843: {
                        n4 = IscobolEditor.addStyleRanges(vector, (int)n, (int)token.getOffset(), (int)n4, (String)token.getWord(), (IscobolEditor)iscobolEditor, (Color)colorProvider.getColor(colorProvider.FIGURATIVE_CONST_FRG), (boolean)bl2, (boolean)bl3, (boolean)bl4, (ColorProvider)colorProvider);
                        bl5 = IscobolEditor.isFirstToken((Token)token, (int)n2);
                        break;
                    }
                    case 36: 
                    case 42: 
                    case 47: {
                        if (PluginUtilities.isAnsiFixedFormat((int)n2) && IscobolEditor.getRealOffset((int)token.getOffset(), (String)string) == 6 || PluginUtilities.isTerminalFormat((int)n2) && token.getOffset() == 0) {
                            n4 = IscobolEditor.addStyleRanges(vector, (int)n, (int)token.getOffset(), (int)n4, (String)string.substring(token.getOffset(), n3), (IscobolEditor)iscobolEditor, (Color)colorProvider.getColor(colorProvider.COMMENTS_FRG), (boolean)bl2, (boolean)bl3, (boolean)bl4, (ColorProvider)colorProvider);
                            break block10;
                        }
                        n4 = IscobolEditor.addStyleRanges(vector, (int)n, (int)token.getOffset(), (int)n4, (String)token.getWord(), (IscobolEditor)iscobolEditor, null, (boolean)bl2, (boolean)bl3, (boolean)bl4, (ColorProvider)colorProvider);
                        break;
                    }
                    default: {
                        n4 = Tokens.statements.contains(token.getWord().toUpperCase()) ? IscobolEditor.addStyleRanges(vector, (int)n, (int)token.getOffset(), (int)n4, (String)token.getWord(), (IscobolEditor)iscobolEditor, (Color)colorProvider.getColor(colorProvider.STATEMENTS_FRG), (boolean)bl2, (boolean)bl3, (boolean)bl4, (ColorProvider)colorProvider) : (Tokens.keywords.contains(token.getWord().toUpperCase()) || Tokens.guiwords.contains(token.getWord().toUpperCase()) ? IscobolEditor.addStyleRanges(vector, (int)n, (int)token.getOffset(), (int)n4, (String)token.getWord(), (IscobolEditor)iscobolEditor, (Color)colorProvider.getColor(colorProvider.KEYWORDS_FRG), (boolean)bl2, (boolean)bl3, (boolean)bl4, (ColorProvider)colorProvider) : IscobolEditor.addStyleRanges(vector, (int)n, (int)token.getOffset(), (int)n4, (String)token.getWord(), (IscobolEditor)iscobolEditor, null, (boolean)bl2, (boolean)bl3, (boolean)bl4, (ColorProvider)colorProvider));
                        bl5 = IscobolEditor.isFirstToken((Token)token, (int)n2);
                    }
                }
                token2 = token;
                token = tokenList.getNextWithSep();
            }
            if (PluginUtilities.isAnsiFixedFormat((int)n2) && token2 != null && (n5 = token2.getOffset() + token2.getWord().length()) < string.length()) {
                CharSequence charSequence;
                String string2 = string;
                if (string.length() > 72) {
                    string2 = string.substring(0, 72);
                } else if (string.length() < 72) {
                    charSequence = new StringBuilder(string);
                    for (int i = string.length(); i < 72; ++i) {
                        ((StringBuilder)charSequence).append(' ');
                    }
                    string2 = ((StringBuilder)charSequence).toString();
                }
                charSequence = string2.substring(n5, string2.length());
                if (((String)charSequence).length() > 0 && (((String)charSequence).charAt(0) == '\"' || ((String)charSequence).charAt(0) == '\'')) {
                    IscobolEditor.addStyleRanges(vector, (int)n, (int)n5, (int)n4, (String)charSequence, (IscobolEditor)iscobolEditor, (Color)colorProvider.getColor(colorProvider.STRING_CONST_FRG), (boolean)bl2, (boolean)bl3, (boolean)bl4, (ColorProvider)colorProvider);
                }
            }
        } else {
            n4 = IscobolEditor.addStyleRanges(vector, (int)n, (int)0, (int)n4, (String)string, (IscobolEditor)iscobolEditor, null, (boolean)bl2, (boolean)bl3, (boolean)bl4, (ColorProvider)colorProvider);
        }
        StyleRange[] styleRangeArray = new StyleRange[vector.size()];
        vector.toArray(styleRangeArray);
        return styleRangeArray;
    }

    private static boolean isFirstToken(Token token, int n) {
        return n == 1 && token.getOffset() < 7;
    }

    protected boolean canOpenIscobolCopyViewEditor() {
        return this.getFileEditorInput() != null;
    }

    protected boolean canOpenServiceEditor() {
        return this.getFileEditorInput() != null;
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction textOperationAction = new TextOperationAction(IsresourceBundle.getBundle(), "codeCompletition.", (ITextEditor)this, 13);
        textOperationAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("CodeCompletitionAction", (IAction)textOperationAction);
        textOperationAction = new ToggleFoldingAction(IsresourceBundle.getBundle(), "enableFoldingAction.", (ITextEditor)this);
        textOperationAction.setActionDefinitionId("org.eclipse.ui.edit.text.folding.toggle");
        this.setAction("EnableFolding", (IAction)textOperationAction);
        textOperationAction = new ExpandTabsToSpacesAction(IsresourceBundle.getBundle(), "expandTabsToSpacesAction.", (ITextEditor)this);
        this.setAction("com.iscobol.plugins.editor.actions.ExpandTabsToSpacesAction", (IAction)textOperationAction);
        OpenDeclarationAction openDeclarationAction = new OpenDeclarationAction(this);
        this.setAction("com.iscobol.plugins.editor.actions.OpenDeclarationAction", (IAction)openDeclarationAction);
        if (this.getViewer() != null && this.getViewer().getTextWidget() != null) {
            this.getViewer().getTextWidget().addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
            this.getViewer().getTextWidget().addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
            this.caretListener = new /* Unavailable Anonymous Inner Class!! */;
            this.getViewer().getTextWidget().addCaretListener(this.caretListener);
        }
    }

    void highlightSelectedFragment() {
        if (this.getViewer() != null && this.getViewer().getTextWidget() != null) {
            this.selector.init((ITextViewer)this.getViewer(), this.getViewer().getTextWidget().getCaretOffset());
            if (this.selector.matchWord()) {
                int n = this.selector.getStartPosition();
                int n2 = this.selector.getEndPosition() - n;
                if (n2 > 0) {
                    try {
                        String string = this.getViewer().getDocument().get(n, n2).trim();
                        IsFragment isFragment = this.findSelectedFragment(string);
                        if (isFragment != null) {
                            this.lastSelectedFragment = string;
                            this.redraw();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected void insertAfter(IMenuManager iMenuManager, String string, IContributionItem iContributionItem) {
        try {
            iMenuManager.insertAfter(string, iContributionItem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            iMenuManager.add(iContributionItem);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.editorContextMenuAboutToShow(iMenuManager);
        if (this.getViewer() != null && this.getViewer().getTextWidget() != null) {
            OpenDeclarationAction openDeclarationAction;
            String string = this.getViewer().getTextWidget().getSelectionText();
            IsFragment isFragment = this.findSelectedFragment(string);
            if (isFragment == null && this.lastSelectedFragment != null) {
                isFragment = this.findSelectedFragment(this.lastSelectedFragment);
            }
            if (isFragment != null) {
                openDeclarationAction = (OpenDeclarationAction)this.getAction("com.iscobol.plugins.editor.actions.OpenDeclarationAction");
                openDeclarationAction.setSelection(isFragment);
                iMenuManager.add((IAction)openDeclarationAction);
            }
            if (this.canOpenIscobolCopyViewEditor()) {
                openDeclarationAction = new /* Unavailable Anonymous Inner Class!! */;
                openDeclarationAction.setText(IsresourceBundle.getString((String)"open_is_exp_editor_lbl") + "\tF4");
                iMenuManager.add((IAction)openDeclarationAction);
                openDeclarationAction = new /* Unavailable Anonymous Inner Class!! */;
                openDeclarationAction.setText(IsresourceBundle.getString((String)"open_srv_editor_lbl") + "\tF6");
                iMenuManager.add((IAction)openDeclarationAction);
            }
        }
        this.addAction(iMenuManager, "CodeCompletitionAction");
    }

    private void openIscobolExpandedEditor() {
        this.openEditor("com.iscobol.plugins.editor.IscobolExpandedCopyEditor");
    }

    private void openServiceEditor() {
        this.openEditor("iscobolscreenpainter.ServiceEditor");
    }

    private void openEditor(String string) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(this.getFileEditorInput().getFile()), string, true, 3);
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    public int getSourceFormat() {
        return this.editorFormat;
    }

    public void setSourceFormatAnsi() {
        this.editorFormat = 1;
        this.refreshEditor();
        this.fireSourceFormatChangedEvent();
    }

    public void setSourceFormatTerminal() {
        this.editorFormat = 2;
        this.refreshEditor();
        this.fireSourceFormatChangedEvent();
    }

    public void setSourceFormatDefault() {
        this.editorFormat = 0;
        this.refreshEditor();
        this.fireSourceFormatChangedEvent();
    }

    protected void fireSourceFormatChangedEvent() {
        if (this.editorListeners.size() > 0) {
            IscobolEditorEvent iscobolEditorEvent = new IscobolEditorEvent(this);
            for (IscobolEditorListener iscobolEditorListener : this.editorListeners) {
                iscobolEditorListener.sourceFormatChanged(iscobolEditorEvent);
            }
        }
    }

    protected void fireEditorSavedEvent() {
        if (this.editorListeners.size() > 0) {
            IscobolEditorEvent iscobolEditorEvent = new IscobolEditorEvent(this);
            for (IscobolEditorListener iscobolEditorListener : this.editorListeners) {
                iscobolEditorListener.editorSaved(iscobolEditorEvent);
            }
        }
    }

    public IsFragment findSelectedFragment(String string) {
        IsFragment isFragment = ((IscobolOutlinePage)this.getOutlinePage()).getInput();
        VarDecl varDecl = null;
        if (isFragment != null && (varDecl = isFragment.getVarDecl(string)) == null) {
            IsFragment[] isFragmentArray = isFragment.getParagraphs(false);
            for (int i = 0; i < isFragmentArray.length && varDecl == null; ++i) {
                if (!isFragmentArray[i].getName().equalsIgnoreCase(string)) continue;
                varDecl = isFragmentArray[i];
            }
        }
        return varDecl;
    }

    public void addIscobolEditorListener(IscobolEditorListener iscobolEditorListener) {
        if (!this.editorListeners.contains(iscobolEditorListener)) {
            this.editorListeners.addElement(iscobolEditorListener);
        }
    }

    public void removeIscobolEditorListener(IscobolEditorListener iscobolEditorListener) {
        this.editorListeners.removeElement(iscobolEditorListener);
    }

    public boolean isNeedRefreshOnClose() {
        return this.needRefreshOnClose;
    }

    protected void handleVisibleDocumentChanged(DocumentEvent documentEvent) {
    }

    public void setNeedRefreshOnClose(boolean bl) {
        if (this.getFileEditorInput() != null) {
            this.needRefreshOnClose = bl;
        }
    }

    private void saveProjectionAnnotationsState() {
        if (this.annotationModel == null) {
            return;
        }
        IFile iFile = ((FileEditorInput)this.getEditorInput()).getFile();
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.annotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Position position;
            Annotation annotation = (Annotation)iterator.next();
            if (!(annotation instanceof ProjectionAnnotation) || !((ProjectionAnnotation)annotation).isCollapsed() || (position = this.annotationModel.getPosition(annotation)) == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(';');
            }
            stringBuilder.append(position.getOffset()).append(',').append(position.getLength());
        }
        PluginUtilities.setResourcePersistentProperty((IResource)iFile, (String)"clp_prj_ann", (String)stringBuilder.toString());
    }

    private Set<Position> getCollapsedPositions() {
        IFile iFile = ((FileEditorInput)this.getEditorInput()).getFile();
        String string = PluginUtilities.getResourcePersistentProperty((IResource)iFile, (String)"clp_prj_ann");
        if (string != null && string.length() > 0) {
            HashSet<Position> hashSet = new HashSet<Position>();
            for (String string2 : string.split(";")) {
                String[] stringArray = string2.split("\\,");
                hashSet.add(new Position(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1])));
            }
            return hashSet;
        }
        return null;
    }

    public void dispose() {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof FileEditorInput) {
            PluginUtilities.removePropertyChangeListener((IResource)((FileEditorInput)iEditorInput).getFile(), (PropertyChangeListener)this.formatchangelistener);
            this.saveProjectionAnnotationsState();
        }
        if (this.project != null && this.formatchangelistener != null) {
            PluginUtilities.removePropertyChangeListener((IResource)this.project, (PropertyChangeListener)this.formatchangelistener);
        }
        if (this.ipropchangelist != null) {
            this.getPluginPreferenceStore().removePropertyChangeListener(this.ipropchangelist);
        }
        if (this.getOutlinePage() instanceof IscobolOutlinePage) {
            ((IscobolOutlinePage)this.getOutlinePage()).setInput(null);
        }
        this.oldAnnotations = null;
        this.copyAnnotations.clear();
        if (this.oldImage != null) {
            this.oldImage.dispose();
        }
        this.getConfiguration().dispose();
        if (this.needRefreshOnClose) {
            try {
                this.getFileEditorInput().getFile().refreshLocal(0, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        super.dispose();
    }

    public ContentOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new IscobolOutlinePage(this);
        }
        return this.outlinePage;
    }

    public String getLastSelectedFragment() {
        return this.lastSelectedFragment;
    }

    public Object getAdapter(Class clazz) {
        Object object;
        if (clazz == IEditorPart.class) {
            return this;
        }
        if (clazz == IShowInSource.class) {
            FileEditorInput fileEditorInput = this.getFileEditorInput();
            if (fileEditorInput != null) {
                return new /* Unavailable Anonymous Inner Class!! */;
            }
            IEditorSite iEditorSite = this.getEditorSite();
            if (iEditorSite instanceof MultiPageEditorSite) {
                MultiPageEditorSite multiPageEditorSite = (MultiPageEditorSite)iEditorSite;
                return multiPageEditorSite.getMultiPageEditor().getAdapter(clazz);
            }
            return null;
        }
        if (IContentOutlinePage.class.equals((Object)clazz)) {
            return this.getOutlinePage();
        }
        if (this.projectionSupport != null && (object = this.projectionSupport.getAdapter(this.getSourceViewer(), clazz)) != null) {
            return object;
        }
        return super.getAdapter(clazz);
    }

    public int getContentsForPcc(StringBuilder stringBuilder) {
        if (this.getViewer() != null) {
            stringBuilder.append(this.getViewer().getDocument().get());
        }
        return 0;
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.initializeConfiguration();
    }

    public int getLastMouseDownLine() {
        return this.lastMouseDownLine;
    }

    protected void initializeConfiguration() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new IscobolSourceViewerConfiguration(this));
    }

    public IscobolSourceViewerConfiguration getConfiguration() {
        return (IscobolSourceViewerConfiguration)super.getSourceViewerConfiguration();
    }

    public boolean isFoldingEnabled() {
        return this.isFoldingEnabled;
    }

    public boolean isReconcilingEnabled() {
        return this.reconcilingEnabled == 0;
    }

    public boolean isSourceFormatEnabled() {
        return this.isSourceFormatEnabled;
    }

    public boolean isShowVerticalLinesEnabled() {
        return this.isShowVerticalLinesEnabled;
    }

    public boolean isSyntaxHighlightingEnabled() {
        return this.isSyntaxHighlightingEnabled;
    }

    protected void intRulerContextMenuAboutToShow(IMenuManager iMenuManager) {
        IAction iAction = this.getAction("RulerClick");
        if (iAction != null) {
            iMenuManager.add(iAction);
        }
        iAction = this.getAction("EnableFolding");
        IPreferenceStore iPreferenceStore = this.getPluginPreferenceStore();
        if (iAction != null) {
            iAction.setChecked(this.isFoldingEnabled);
            iMenuManager.add(iAction);
        }
        8 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        iMenuManager.add((IAction)var4_4);
        9 var5_5 = new /* Unavailable Anonymous Inner Class!! */;
        iMenuManager.add((IAction)var5_5);
        int n = IscobolEditorPlugin.getIntFromStore((String)"iscobol.reconciling.enabled");
        MenuManager menuManager = new MenuManager(IsresourceBundle.getString((String)"en_reconc_lbl"));
        10 var8_8 = new /* Unavailable Anonymous Inner Class!! */;
        menuManager.add((IAction)var8_8);
        11 var9_9 = new /* Unavailable Anonymous Inner Class!! */;
        menuManager.add((IAction)var9_9);
        12 var10_10 = new /* Unavailable Anonymous Inner Class!! */;
        menuManager.add((IAction)var10_10);
        switch (n) {
            case 1: {
                var9_9.setChecked(true);
                break;
            }
            case 2: {
                var10_10.setChecked(true);
                break;
            }
            default: {
                var8_8.setChecked(true);
            }
        }
        iMenuManager.add((IContributionItem)menuManager);
        iAction = this.getAction("com.iscobol.plugins.editor.actions.ExpandTabsToSpacesAction");
        if (iAction != null) {
            iMenuManager.add(iAction);
        }
    }

    protected final void rulerContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.rulerContextMenuAboutToShow(iMenuManager);
        this.intRulerContextMenuAboutToShow(iMenuManager);
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer iSourceViewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new MySourceViewerDecorationSupport(iSourceViewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        this.viewer = new IscobolProjectionViewer(this, composite, iVerticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), n);
        this.viewer.addTextListener((ITextListener)new /* Unavailable Anonymous Inner Class!! */);
        this.getSourceViewerDecorationSupport((ISourceViewer)this.viewer);
        this.viewer.getTextWidget().addLineStyleListener((LineStyleListener)this);
        this.viewer.addMyLineBackgroundListener((LineBackgroundListener)this);
        this.viewer.getTextWidget().addListener(9, (Listener)this.getTextPaintListener());
        this.viewer.getTextWidget().addListener(11, (Listener)this.getTextPaintListener());
        this.ansiMarginPainters = new MarginPainter[5];
        this.ansiMarginPainters[0] = new MarginPainter((ITextViewer)this.viewer);
        this.ansiMarginPainters[0].setMarginRulerColumn(6);
        this.ansiMarginPainters[1] = new MarginPainter((ITextViewer)this.viewer);
        this.ansiMarginPainters[1].setMarginRulerColumn(7);
        this.ansiMarginPainters[2] = new MarginPainter((ITextViewer)this.viewer);
        this.ansiMarginPainters[2].setMarginRulerColumn(11);
        this.ansiMarginPainters[3] = new MarginPainter((ITextViewer)this.viewer);
        this.ansiMarginPainters[3].setMarginRulerColumn(72);
        this.ansiMarginPainters[4] = new MarginPainter((ITextViewer)this.viewer);
        this.ansiMarginPainters[4].setMarginRulerColumn(80);
        this.terminalMarginPainters = new MarginPainter[2];
        this.terminalMarginPainters[0] = new MarginPainter((ITextViewer)this.viewer);
        this.terminalMarginPainters[0].setMarginRulerColumn(1);
        this.terminalMarginPainters[1] = new MarginPainter((ITextViewer)this.viewer);
        this.terminalMarginPainters[1].setMarginRulerColumn(5);
        return this.viewer;
    }

    private TextPaintListener getTextPaintListener() {
        if (this.textPaintListener == null) {
            this.textPaintListener = new TextPaintListener(this, null);
        }
        return this.textPaintListener;
    }

    public void refreshEditor() {
        if (this.getViewer() == null || this.getViewer().getTextWidget() == null || this.getViewer().getTextWidget().isDisposed()) {
            return;
        }
        this.drawVerticalLines();
        this.rebuildImage(this.viewer.getTextWidget());
    }

    private void drawVerticalLines() {
        int n;
        ColorProvider colorProvider;
        if (PluginUtilities.isAnsiFixedFormat((int)this.getFormat()) && this.isShowVerticalLinesEnabled()) {
            colorProvider = IscobolEditorPlugin.getDefault().getColorProvider();
            for (n = 0; n < this.ansiMarginPainters.length; ++n) {
                this.ansiMarginPainters[n].initialize();
                this.ansiMarginPainters[n].setMarginRulerColor(colorProvider.getColor(colorProvider.DELIMITER_AREA_FRG));
                this.ansiMarginPainters[n].paint(8);
            }
        } else {
            for (int i = 0; i < this.ansiMarginPainters.length; ++i) {
                this.ansiMarginPainters[i].deactivate(false);
            }
        }
        if (PluginUtilities.isTerminalFormat((int)this.getFormat()) && this.isShowVerticalLinesEnabled()) {
            colorProvider = IscobolEditorPlugin.getDefault().getColorProvider();
            for (n = 0; n < this.terminalMarginPainters.length; ++n) {
                this.terminalMarginPainters[n].initialize();
                this.terminalMarginPainters[n].setMarginRulerColor(colorProvider.getColor(colorProvider.DELIMITER_AREA_FRG));
                this.terminalMarginPainters[n].paint(8);
            }
        } else {
            for (int i = 0; i < this.terminalMarginPainters.length; ++i) {
                this.terminalMarginPainters[i].deactivate(false);
            }
        }
    }

    private void rebuildImage(StyledText styledText) {
        if (styledText == null) {
            return;
        }
        Image image = null;
        int n = this.getFormat();
        if ((PluginUtilities.isAnsiFixedFormat((int)n) || PluginUtilities.isTerminalFormat((int)n)) && this.isSourceFormatEnabled()) {
            Rectangle rectangle = styledText.getClientArea();
            int n2 = styledText.getHorizontalPixel();
            image = new Image((Device)styledText.getDisplay(), Math.max(rectangle.width, 1), 1);
            GC gC = new GC((Drawable)image);
            gC.setFont(styledText.getFont());
            int n3 = gC.getFontMetrics().getAverageCharWidth();
            Color color = gC.getBackground();
            Color color2 = gC.getForeground();
            ColorProvider colorProvider = IscobolEditorPlugin.getDefault().getColorProvider();
            if (PluginUtilities.isAnsiFixedFormat((int)n)) {
                int n4;
                int n5;
                if (n2 < n3 * 6) {
                    n5 = rectangle.x;
                    n4 = n3 * 6 - n2;
                    gC.setBackground(colorProvider.getColor(colorProvider.SEQ_NUM_BKG));
                    gC.fillRectangle(n5, rectangle.y, n4, 1);
                }
                if (n2 < n3 * 7) {
                    n5 = rectangle.x + Math.max(0, n3 * 6 - n2);
                    n4 = n3 - Math.max(0, n2 - n3 * 6);
                    gC.setBackground(colorProvider.getColor(colorProvider.IND_AREA_BKG));
                    gC.fillRectangle(n5, rectangle.y, n4, 1);
                }
                if (n2 < n3 * 11) {
                    n5 = rectangle.x + Math.max(0, n3 * 7 - n2);
                    n4 = n3 * 4 - Math.max(0, n2 - n3 * 7);
                    gC.setBackground(colorProvider.getColor(colorProvider.AREA_A_BKG));
                    gC.fillRectangle(n5, rectangle.y, n4, 1);
                }
                if (n2 < n3 * 72) {
                    n5 = rectangle.x + Math.max(0, n3 * 11 - n2);
                    n4 = n3 * 61 - Math.max(0, n2 - n3 * 11);
                    gC.setBackground(colorProvider.getColor(colorProvider.AREA_B_BKG));
                    gC.fillRectangle(n5, rectangle.y, n4, 1);
                }
                if (n2 < n3 * 80) {
                    n5 = rectangle.x + Math.max(0, n3 * 72 - n2);
                    n4 = n3 * 8 - Math.max(0, n2 - n3 * 72);
                    gC.setBackground(colorProvider.getColor(colorProvider.IDEN_AREA_BKG));
                    gC.fillRectangle(n5, rectangle.y, n4, rectangle.height);
                }
            } else {
                int n6;
                int n7;
                if (n2 < n3) {
                    n7 = rectangle.x;
                    n6 = n3 - n2;
                    gC.setBackground(colorProvider.getColor(colorProvider.IND_AREA_BKG));
                    gC.fillRectangle(n7, rectangle.y, n6, 1);
                }
                if (n2 < n3 * 5) {
                    n7 = rectangle.x + Math.max(0, n3 - n2);
                    n6 = n3 * 4 - Math.max(0, n2 - n3);
                    gC.setBackground(colorProvider.getColor(colorProvider.AREA_A_BKG));
                    gC.fillRectangle(n7, rectangle.y, n6, 1);
                }
                gC.setBackground(colorProvider.getColor(colorProvider.AREA_B_BKG));
                n7 = rectangle.x + Math.max(0, n3 * 5 - n2);
                gC.fillRectangle(n7, rectangle.y, rectangle.width - n7, 1);
            }
            gC.setBackground(color);
            gC.setForeground(color2);
            gC.dispose();
        }
        styledText.setBackgroundImage(image);
        if (this.oldImage != null) {
            this.oldImage.dispose();
        }
        this.oldImage = image;
    }

    public IVerticalRuler getVRuler() {
        return super.getVerticalRuler();
    }

    public void createPartControl(Composite composite) {
        int n;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 0;
        composite2.setLayout((Layout)gridLayout);
        this.horizontalRuler = new HorizontalRuler(this, composite2, 0);
        boolean bl = IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.showhruler");
        this.horizontalRuler.setVisible(bl);
        GridData gridData = new GridData(768);
        if (bl) {
            this.horizontalRuler.getClass();
            n = 25;
        } else {
            n = 0;
        }
        gridData.heightHint = n;
        this.horizontalRuler.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(1808));
        composite3.setLayout((Layout)new FillLayout());
        super.createPartControl(composite3);
        this.projectionSupport = new ProjectionSupport((ProjectionViewer)this.viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.projectionSupport.setHoverControlCreator((IInformationControlCreator)new /* Unavailable Anonymous Inner Class!! */);
        this.projectionSupport.install();
        this.viewer.doOperation(19);
        this.annotationModel = this.viewer.getProjectionAnnotationModel();
        AnnotationModel annotationModel = (AnnotationModel)this.viewer.getAnnotationModel();
        15 var8_8 = new /* Unavailable Anonymous Inner Class!! */;
        annotationModel.addAnnotationModelListener((IAnnotationModelListener)var8_8);
        this.annotationModel.addAnnotationModelListener((IAnnotationModelListener)var8_8);
        IVerticalRuler iVerticalRuler = this.getVerticalRuler();
        iVerticalRuler.getControl().addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void setupDocument(IDocument iDocument) {
        if (iDocument instanceof IDocumentExtension3) {
            IDocumentExtension3 iDocumentExtension3 = (IDocumentExtension3)iDocument;
            FastPartitioner fastPartitioner = new FastPartitioner((IPartitionTokenScanner)IscobolEditorPlugin.getDefault().getIscobolPartitionScanner(), new String[0]);
            fastPartitioner.connect(iDocument);
            iDocumentExtension3.setDocumentPartitioner("__iscobol_partitioning", (IDocumentPartitioner)fastPartitioner);
        }
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        if (iEditorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
            IFile iFile = fileEditorInput.getFile();
            this.project = iFile.getProject();
            String string = PluginUtilities.getCurrentSettingMode((IResource)iFile);
            this.format = string != null ? PluginUtilities.getFormat((IResource)iFile, (String)string) : PluginUtilities.getFormat((IResource)iFile.getProject(), (String)PluginUtilities.getCurrentSettingMode((IResource)iFile.getProject()));
            PluginUtilities.addPropertyChangeListener((IResource)iFile, (PropertyChangeListener)this.getFormatChangeListener());
            PluginUtilities.addPropertyChangeListener((IResource)this.project, (PropertyChangeListener)this.getFormatChangeListener());
        } else {
            this.project = (IProject)iEditorInput.getAdapter(IProject.class);
        }
        super.doSetInput(iEditorInput);
        this.setupDocument(this.getDocumentProvider().getDocument((Object)this.getEditorInput()));
    }

    private PropertyChangeListener getFormatChangeListener() {
        if (this.formatchangelistener == null) {
            this.formatchangelistener = new /* Unavailable Anonymous Inner Class!! */;
        }
        return this.formatchangelistener;
    }

    public IPreferenceStore getEditorPreferences() {
        return super.getPreferenceStore();
    }

    public IPreferenceStore getPluginPreferenceStore() {
        return IscobolEditorPlugin.getDefault().getPreferenceStore();
    }

    public int getTabWidth() {
        int n = this.getPluginPreferenceStore().contains("iscobol.tabwidth") ? this.getPluginPreferenceStore().getInt("iscobol.tabwidth") : this.getPluginPreferenceStore().getDefaultInt("iscobol.tabwidth");
        return n;
    }

    public boolean getInsertSpacesForTab() {
        boolean bl = this.getPluginPreferenceStore().contains("iscobol.insertspaces") ? this.getPluginPreferenceStore().getBoolean("iscobol.insertspaces") : this.getPluginPreferenceStore().getDefaultBoolean("iscobol.insertspaces");
        return bl;
    }

    public int[] getTabStops() {
        String string = "";
        switch (this.getFormat()) {
            case 1: 
            case 4: {
                if (this.getPluginPreferenceStore().contains("iscobol.tabs.ansi")) {
                    string = this.getPluginPreferenceStore().getString("iscobol.tabs.ansi");
                    break;
                }
                string = this.getPluginPreferenceStore().getDefaultString("iscobol.tabs.ansi");
                break;
            }
            case 2: {
                string = this.getPluginPreferenceStore().contains("iscobol.tabs.terminal") ? this.getPluginPreferenceStore().getString("iscobol.tabs.terminal") : this.getPluginPreferenceStore().getDefaultString("iscobol.tabs.terminal");
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return nArray;
    }

    public String getTabSpaces() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.getTabWidth();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public FileEditorInput getFileEditorInput() {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof FileEditorInput) {
            return (FileEditorInput)iEditorInput;
        }
        return null;
    }

    public int getFormat() {
        if (this.editorFormat != 0) {
            return this.editorFormat;
        }
        return this.format;
    }

    void setFormat(int n) {
        if (this.format != n) {
            this.format = n;
            Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected void adjustHighlightRange(int n, int n2) {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
            iTextViewerExtension5.exposeModelRange((IRegion)new Region(n, n2));
        }
    }

    public IscobolProjectionViewer getViewer() {
        return this.viewer;
    }

    public void setDebugCurrentLine(int n, String string) {
        try {
            if (this.getViewer() != null && this.getViewer().getTextWidget() != null) {
                IDocument iDocument = this.getViewer().getDocument();
                this.debugCurrentLine = new Position(iDocument.getLineOffset(n));
                this.getViewer().revealRange(iDocument.getLineOffset(n), iDocument.getLineLength(n));
                this.getViewer().getTextWidget().redraw();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void resetDebugCurrentLine() {
        this.debugCurrentLine = null;
        if (this.getViewer() != null && this.getViewer().getTextWidget() != null) {
            this.getViewer().getTextWidget().redraw();
        }
    }

    public void redraw() {
        IscobolProjectionViewer iscobolProjectionViewer = this.getViewer();
        if (iscobolProjectionViewer != null && iscobolProjectionViewer.getTextWidget() != null) {
            iscobolProjectionViewer.getTextWidget().redraw();
        }
    }

    public void redrawLine(int n) {
        try {
            IscobolProjectionViewer iscobolProjectionViewer = this.getViewer();
            if (iscobolProjectionViewer != null) {
                IDocument iDocument = iscobolProjectionViewer.getDocument();
                if (iscobolProjectionViewer.getTextWidget() != null) {
                    iscobolProjectionViewer.getTextWidget().redrawRange(iDocument.getLineOffset(n), iDocument.getLineLength(n), true);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public IscobolActionContributor getContributor() {
        return this.actionContributor;
    }

    public void setContributor(IscobolActionContributor iscobolActionContributor) {
        this.actionContributor = iscobolActionContributor;
    }

    public int findAndSelect(int n, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.viewer.findAndSelect(n, string, bl, bl2, bl3, bl4);
    }

    public void updateFoldingStructure(List<Position> list, IsFragment isFragment, boolean bl) {
        if (this.isFoldingEnabled()) {
            this.updateFoldingStructure(list, bl);
        }
        ((IscobolOutlinePage)this.getOutlinePage()).setInput(isFragment);
        IIscobolNavigator iIscobolNavigator = PluginUtilities.findFileNavigator();
        IEditorInput iEditorInput = this.getEditorInput();
        if (iIscobolNavigator != null && iEditorInput instanceof FileEditorInput) {
            iIscobolNavigator.refresh((Object)((FileEditorInput)iEditorInput).getFile());
        }
    }

    private void updateFoldingStructure(List<Position> list, boolean bl) {
        if (this.oldAnnotations == null) {
            return;
        }
        boolean bl2 = this.synchOutline;
        this.synchOutline = false;
        HashMap<ProjectionAnnotation, Position> hashMap = new HashMap<ProjectionAnnotation, Position>();
        Set set = null;
        if (bl && this.getEditorInput() instanceof FileEditorInput) {
            set = this.getCollapsedPositions();
        }
        ArrayList<ProjectionAnnotation> arrayList = new ArrayList<ProjectionAnnotation>();
        ArrayList<ProjectionAnnotation> arrayList2 = new ArrayList<ProjectionAnnotation>();
        List list2 = this.oldAnnotations;
        for (int i = 0; i < list.size(); ++i) {
            ProjectionAnnotation projectionAnnotation = null;
            for (ProjectionAnnotation projectionAnnotation2 : list2) {
                Position position = this.annotationModel.getPosition((Annotation)projectionAnnotation2);
                if (position == null || !position.equals((Object)list.get(i))) continue;
                projectionAnnotation = projectionAnnotation2;
                break;
            }
            if (projectionAnnotation != null) {
                if (projectionAnnotation.isCollapsed()) {
                    projectionAnnotation.markCollapsed();
                }
                arrayList.add(projectionAnnotation);
                list2.remove(projectionAnnotation);
                arrayList2.add(projectionAnnotation);
                continue;
            }
            ProjectionAnnotation projectionAnnotation3 = new ProjectionAnnotation();
            hashMap.put(projectionAnnotation3, list.get(i));
            if (set != null && set.contains(list.get(i))) {
                projectionAnnotation3.markCollapsed();
            }
            arrayList2.add(projectionAnnotation3);
        }
        this.annotationModel.modifyAnnotations(list2.toArray(new Annotation[list2.size()]), hashMap, arrayList.toArray(new Annotation[arrayList.size()]));
        this.oldAnnotations = arrayList2;
        this.synchOutline = bl2;
    }

    private void restoreFoldingStructure() {
        boolean bl = this.synchOutline;
        this.synchOutline = false;
        IsFragment isFragment = ((IscobolOutlinePage)this.getOutlinePage()).getInput();
        ArrayList arrayList = new ArrayList();
        IsFragment[] isFragmentArray = isFragment.getChildren();
        if (isFragmentArray == null) {
            return;
        }
        for (int i = 0; i < isFragmentArray.length; ++i) {
            this.visit(isFragmentArray[i], arrayList);
        }
        this.updateFoldingStructure(arrayList, false);
        this.synchOutline = bl;
    }

    private void visit(IsFragment isFragment, ArrayList arrayList) {
        IsFragment[] isFragmentArray;
        if (isFragment.getPosition() != null) {
            arrayList.add(isFragment.getPosition());
        }
        if ((isFragmentArray = isFragment.getChildren()) == null) {
            return;
        }
        for (int i = 0; i < isFragmentArray.length; ++i) {
            this.visit(isFragmentArray[i], arrayList);
        }
    }

    public IsFragment getFragmentAtLine(int n) {
        IsFragment isFragment = ((IscobolOutlinePage)this.getOutlinePage()).getInput();
        String string = null;
        FileEditorInput fileEditorInput = this.getFileEditorInput();
        if (fileEditorInput != null) {
            string = fileEditorInput.getFile().getName();
        }
        if (isFragment != null) {
            return this.getFragmentAtLine(n, string, isFragment);
        }
        return null;
    }

    private IsFragment getFragmentAtLine(int n, String string, IsFragment isFragment) {
        IsFragment[] isFragmentArray = isFragment.getChildren();
        if (isFragmentArray.length > 0) {
            for (int i = 0; i < isFragmentArray.length; ++i) {
                IsFragment isFragment2 = this.getFragmentAtLine(n, string, isFragmentArray[i]);
                if (isFragment2 == null) continue;
                return isFragment2;
            }
        }
        if (this.isFragmentAtLine(n, string, isFragment)) {
            return isFragment;
        }
        return null;
    }

    protected boolean isFragmentAtLine(int n, String string, IsFragment isFragment) {
        String string2;
        String string3 = string2 = isFragment.getFilename() != null ? new File(isFragment.getFilename()).getName() : null;
        return PluginUtilities.equals((Object)string, string2) && n >= isFragment.getStartLine() && (isFragment.getType() == 5 ? n < isFragment.getEndLine() : n <= isFragment.getEndLine());
    }

    private IsFragment getCurrFragment(IsFragment isFragment) {
        Position position = isFragment.getPosition();
        IsFragment isFragment2 = null;
        if (position != null && this.lastTextEventOffs >= position.getOffset() && this.lastTextEventOffs < position.getOffset() + position.getLength()) {
            if (isFragment.getType() == 4) {
                isFragment2 = isFragment;
            } else {
                IsFragment[] isFragmentArray = isFragment.getChildren();
                if (isFragmentArray != null) {
                    for (int i = 0; isFragment2 == null && i < isFragmentArray.length; ++i) {
                        isFragment2 = this.getCurrFragment(isFragmentArray[i]);
                    }
                }
            }
        }
        return isFragment2;
    }

    public IsFragment getProgramFragment() {
        return ((IscobolOutlinePage)this.getOutlinePage()).getInput();
    }

    public IsFragment getCurrFragment() {
        IsFragment isFragment = this.getProgramFragment();
        IsFragment isFragment2 = null;
        if (isFragment != null) {
            if (isFragment.getType() == 1) {
                isFragment2 = isFragment;
            } else {
                IsFragment[] isFragmentArray = isFragment.getChildren();
                for (int i = 0; isFragment2 == null && i < isFragmentArray.length; ++i) {
                    isFragment2 = this.getCurrFragment(isFragmentArray[i]);
                }
            }
        }
        return isFragment2;
    }

    public void setInheritsClass(String string) {
        this.inheritsClass = string;
    }

    public String getInheritsClass() {
        return this.inheritsClass;
    }

    public void setImplementsClasses(String[] stringArray) {
        this.implementsClasses = stringArray;
    }

    public String[] getImplementsClasses() {
        return this.implementsClasses;
    }

    public void setProgName(String string) {
        this.progname = string;
    }

    public String getProgName() {
        return this.progname;
    }

    public void putProblemAnnotation(ErrorObj errorObj, int n, int n2, ProblemAnnotation problemAnnotation) {
        this.getEditorSite().getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void putProblemAnnotation(ErrorObj errorObj, Position position, ProblemAnnotation problemAnnotation, IAnnotationModel iAnnotationModel) {
        try {
            if (iAnnotationModel != null) {
                SpellingAnnotation spellingAnnotation = new SpellingAnnotation((org.eclipse.ui.texteditor.spelling.SpellingProblem)new SpellingProblem(errorObj));
                problemAnnotation.setSpellingAnnotation(spellingAnnotation);
                iAnnotationModel.addAnnotation((Annotation)spellingAnnotation, position);
                iAnnotationModel.addAnnotation((Annotation)problemAnnotation, position);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearProblemAnnotations() {
        this.getEditorSite().getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void clearProblemAnnotations(IAnnotationModel iAnnotationModel) {
        if (iAnnotationModel != null) {
            ArrayList<ProblemAnnotation> arrayList = new ArrayList<ProblemAnnotation>();
            Iterator iterator = iAnnotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof ProblemAnnotation)) continue;
                arrayList.add((ProblemAnnotation)e);
            }
            for (ProblemAnnotation problemAnnotation : arrayList) {
                iAnnotationModel.removeAnnotation((Annotation)problemAnnotation.getSpellingAnnotation());
                iAnnotationModel.removeAnnotation((Annotation)problemAnnotation);
            }
        }
    }

    public void highlight(int n, int n2) {
        this.getViewer().getTextWidget().removeCaretListener(this.caretListener);
        boolean bl = this.synchOutline;
        this.synchOutline = false;
        if (n >= 0) {
            this.setHighlightRange(n, n2, true);
        } else {
            this.resetHighlightRange();
        }
        this.synchOutline = bl;
        this.getViewer().getTextWidget().addCaretListener(this.caretListener);
    }

    public boolean getDecimalPointComma() {
        return this.decPointComma;
    }

    public void setDecimalPointComma(boolean bl) {
        this.decPointComma = bl;
    }

    static /* synthetic */ int access$000(IscobolEditor iscobolEditor) {
        return iscobolEditor.lastHorizontalPixel;
    }

    static /* synthetic */ IscobolProjectionViewer access$100(IscobolEditor iscobolEditor) {
        return iscobolEditor.viewer;
    }

    static /* synthetic */ void access$200(IscobolEditor iscobolEditor, StyledText styledText) {
        iscobolEditor.rebuildImage(styledText);
    }

    static /* synthetic */ HorizontalRuler access$300(IscobolEditor iscobolEditor) {
        return iscobolEditor.horizontalRuler;
    }

    static /* synthetic */ int access$002(IscobolEditor iscobolEditor, int n) {
        iscobolEditor.lastHorizontalPixel = n;
        return iscobolEditor.lastHorizontalPixel;
    }

    static /* synthetic */ boolean access$400(IscobolEditor iscobolEditor) {
        return iscobolEditor.isActiveEditor();
    }

    static /* synthetic */ boolean access$502(IscobolEditor iscobolEditor, boolean bl) {
        iscobolEditor.isFoldingEnabled = bl;
        return iscobolEditor.isFoldingEnabled;
    }

    static /* synthetic */ void access$600(IscobolEditor iscobolEditor) {
        iscobolEditor.restoreFoldingStructure();
    }

    static /* synthetic */ int access$702(IscobolEditor iscobolEditor, int n) {
        iscobolEditor.reconcilingEnabled = n;
        return iscobolEditor.reconcilingEnabled;
    }

    static /* synthetic */ int access$700(IscobolEditor iscobolEditor) {
        return iscobolEditor.reconcilingEnabled;
    }

    static /* synthetic */ void access$800(IscobolEditor iscobolEditor) {
        iscobolEditor.doReconcile();
    }

    static /* synthetic */ boolean access$902(IscobolEditor iscobolEditor, boolean bl) {
        iscobolEditor.isSyntaxHighlightingEnabled = bl;
        return iscobolEditor.isSyntaxHighlightingEnabled;
    }

    static /* synthetic */ boolean access$1002(IscobolEditor iscobolEditor, boolean bl) {
        iscobolEditor.isSourceFormatEnabled = bl;
        return iscobolEditor.isSourceFormatEnabled;
    }

    static /* synthetic */ boolean access$1102(IscobolEditor iscobolEditor, boolean bl) {
        iscobolEditor.isShowVerticalLinesEnabled = bl;
        return iscobolEditor.isShowVerticalLinesEnabled;
    }

    static /* synthetic */ String access$1200(IscobolEditor iscobolEditor) {
        return iscobolEditor.lastSelectedFragment;
    }

    static /* synthetic */ void access$1300(IscobolEditor iscobolEditor) {
        iscobolEditor.openIscobolExpandedEditor();
    }

    static /* synthetic */ void access$1400(IscobolEditor iscobolEditor) {
        iscobolEditor.openServiceEditor();
    }

    static /* synthetic */ int access$1502(IscobolEditor iscobolEditor, int n) {
        iscobolEditor.lastMouseDownLine = n;
        return iscobolEditor.lastMouseDownLine;
    }

    static /* synthetic */ Timer access$1600(IscobolEditor iscobolEditor) {
        return iscobolEditor.highlighterTimer;
    }

    static /* synthetic */ boolean access$1800(IscobolEditor iscobolEditor) {
        return iscobolEditor.synchOutline;
    }

    static /* synthetic */ ProjectionAnnotationModel access$1900(IscobolEditor iscobolEditor) {
        return iscobolEditor.annotationModel;
    }

    static /* synthetic */ int access$2002(IscobolEditor iscobolEditor, int n) {
        iscobolEditor.lastTextEventOffs = n;
        return iscobolEditor.lastTextEventOffs;
    }

    static /* synthetic */ int access$2202(IscobolEditor iscobolEditor, int n) {
        iscobolEditor.format = n;
        return iscobolEditor.format;
    }

    static /* synthetic */ Hashtable access$2300(IscobolEditor iscobolEditor) {
        return iscobolEditor.problemAnnotations;
    }
}

