/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor;

import com.iscobol.plugins.editor.IscobolNature;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.util.ProjectSettingList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IscobolNatureExt
extends IscobolNature {
    public static final String ID = "IscobolNatureExt";
    public static final String OPTFILENAME = ".iscoboloptions";
    private IProject project;
    private IFile optionFile;
    private ProjectSettingList settings;
    private long timestamp;

    public void configure() throws CoreException {
        this.loadOptions();
    }

    public boolean checkExists() throws CoreException {
        this.optionFile.refreshLocal(0, null);
        if (!this.optionFile.exists()) {
            PluginUtilities.createFile((IFile)this.optionFile);
            this.project.refreshLocal(1, null);
            return false;
        }
        return true;
    }

    public void loadOptions() {
        InputStream inputStream = null;
        try {
            this.optionFile.refreshLocal(0, null);
            if (this.settings == null || this.optionFile.getLocalTimeStamp() > this.timestamp) {
                if (this.settings == null) {
                    this.settings = new ProjectSettingList();
                }
                if (this.optionFile.exists()) {
                    inputStream = this.optionFile.getContents();
                    this.settings.load(inputStream);
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.timestamp = System.currentTimeMillis();
    }

    public static ProjectSettingList loadOptions(InputStream inputStream) {
        try {
            ProjectSettingList projectSettingList = new ProjectSettingList();
            projectSettingList.load(inputStream);
            return projectSettingList;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void saveOptions() {
        if (this.settings == null) {
            return;
        }
        try {
            this.checkExists();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.settings.save((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            PluginUtilities.modifyFile((IFile)this.optionFile, (InputStream)byteArrayInputStream, (boolean)false, (boolean)false);
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.timestamp = System.currentTimeMillis();
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
        this.optionFile = this.project != null ? this.project.getFile((IPath)new Path(OPTFILENAME)) : null;
    }

    public ProjectSettingList getProjectSettings() {
        this.loadOptions();
        return this.settings;
    }

    public void setProjectSettings(ProjectSettingList projectSettingList) {
        this.settings = projectSettingList;
        this.saveOptions();
    }
}

