/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IscobolOutlinePage;
import com.iscobol.plugins.editor.actions.SortAction;
import com.iscobol.plugins.editor.util.IsFragment;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.util.editorinputs.IOFileStorage;
import com.iscobol.plugins.editor.util.editorinputs.IOFileStorageEditorInput;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class IscobolOutlinePage
extends ContentOutlinePage {
    public static final String rcsid = "$Id: IscobolOutlinePage.java,v 1.10 2009/03/09 11:14:00 gianni Exp $";
    protected IscobolEditor editor;
    private IsFragment input;
    private MyContentProvider contentProvider;
    private IPropertyChangeListener propchangelist;
    private SortAction sortAction;
    private boolean highlightEditorRange = true;

    public IscobolOutlinePage(IscobolEditor iscobolEditor) {
        this.editor = iscobolEditor;
    }

    public void dispose() {
        if (this.propchangelist != null) {
            IscobolEditorPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propchangelist);
        }
        super.dispose();
    }

    public TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        super.selectionChanged(selectionChangedEvent);
        ISelection iSelection = selectionChangedEvent.getSelection();
        IsFragment isFragment = null;
        if (!iSelection.isEmpty()) {
            isFragment = (IsFragment)((IStructuredSelection)iSelection).getFirstElement();
        }
        this.selectionChanged(isFragment, iSelection);
    }

    public void selectionChanged(IsFragment isFragment, ISelection iSelection) {
        if (!this.highlightEditorRange) {
            return;
        }
        if (isFragment != null) {
            Object object;
            Object object2;
            IFile iFile;
            IscobolEditor iscobolEditor = this.editor;
            if (isFragment.getFilename() != null && this.editor.getProject() != null) {
                try {
                    iFile = PluginUtilities.getFileForLocation((String)isFragment.getFilename());
                    object = iFile != null ? new FileEditorInput(iFile) : (((File)(object2 = new File(isFragment.getFilename()))).exists() ? new IOFileStorageEditorInput(new IOFileStorage((File)object2, false)) : null);
                    if (object != null && !object.equals(this.editor.getEditorInput())) {
                        iscobolEditor = (IscobolEditor)this.editor.getEditorSite().getPage().openEditor((IEditorInput)object, IscobolEditor.ID, true, 3);
                        if (this.editor.getProject() != null && iscobolEditor.getProject() == null) {
                            iscobolEditor.setProject(this.editor.getProject());
                        }
                        object2 = (IscobolOutlinePage)iscobolEditor.getOutlinePage();
                        object2.setInput(this.getInput());
                        object2.getTreeViewer().setExpandedElements(this.getTreeViewer().getExpandedElements());
                    }
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
            object = isFragment.getPosition();
            try {
                if (object != null) {
                    iscobolEditor.highlight(object.getOffset(), object.getLength());
                } else {
                    try {
                        iFile = iscobolEditor.getViewer().getDocument();
                        object2 = iFile.getLineInformation(isFragment.getStartLine());
                        int n = isFragment.getEndLine() >= 0 ? isFragment.getEndLine() : iFile.getNumberOfLines();
                        IRegion iRegion = iFile.getLineInformation(n);
                        iscobolEditor.highlight(object2.getOffset(), iRegion.getOffset() + iRegion.getLength() - object2.getOffset());
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                iscobolEditor.highlight(-1, -1);
            }
            if (iscobolEditor.getOutlinePage().getControl() != null) {
                iscobolEditor.getOutlinePage().setFocus();
            }
            if (iscobolEditor != this.editor) {
                iFile = iscobolEditor;
                new /* Unavailable Anonymous Inner Class!! */.start();
            }
        } else {
            this.editor.resetHighlightRange();
        }
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        TreeViewer treeViewer = this.getTreeViewer();
        this.contentProvider = new MyContentProvider(null);
        treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)new MyDecoratingLabelProvider((ILabelProvider)new MyLabelProvider(null), (ILabelDecorator)new MyLabelDecorator(null)));
        this.propchangelist = new /* Unavailable Anonymous Inner Class!! */;
        IscobolEditorPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propchangelist);
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setInput(this.input);
    }

    public boolean getHighlightEditorRange() {
        return this.highlightEditorRange;
    }

    public void setHighlightEditorRange(boolean bl) {
        this.highlightEditorRange = bl;
    }

    public IsFragment getInput() {
        return this.input;
    }

    public void makeContributions(IMenuManager iMenuManager, IToolBarManager iToolBarManager, IStatusLineManager iStatusLineManager) {
        this.addSortAction(iToolBarManager);
    }

    public void addSortAction(IToolBarManager iToolBarManager) {
        if (this.sortAction == null) {
            this.sortAction = new SortAction();
            this.sortAction.setId("com.iscobol.plugins.editor.actions.SortAction");
            this.sortAction.setChecked(IscobolEditorPlugin.getDefault().getPreferenceStore().getBoolean("iscobol.outlinesort.enabled"));
            iToolBarManager.add((IAction)this.sortAction);
        }
    }

    public void removeSortAction(IToolBarManager iToolBarManager) {
        if (this.sortAction != null) {
            iToolBarManager.remove(this.sortAction.getId());
            this.sortAction = null;
        }
    }

    public void setInput(IsFragment isFragment) {
        this.input = isFragment;
        this.update();
    }

    protected IsFragment[] getRootNodes(IsFragment isFragment) {
        if (isFragment != null) {
            return new IsFragment[]{isFragment};
        }
        return null;
    }

    public void update() {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null) {
            if (this.input != null) {
                Control control = treeViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    control.setRedraw(false);
                    if (this.input.getType() == 1) {
                        treeViewer.setAutoExpandLevel(3);
                    } else if (this.input.getType() == 6) {
                        treeViewer.setAutoExpandLevel(5);
                    } else if (this.input.getType() == 17) {
                        treeViewer.setAutoExpandLevel(2);
                    }
                    treeViewer.setInput((Object)new RootObject(this.getRootNodes(this.input)));
                    control.setRedraw(true);
                }
            } else {
                Control control = treeViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    control.setRedraw(false);
                    treeViewer.setInput((Object)new RootObject(null));
                    control.setRedraw(true);
                }
            }
        }
    }

    static /* synthetic */ MyContentProvider access$300(IscobolOutlinePage iscobolOutlinePage) {
        return iscobolOutlinePage.contentProvider;
    }
}

