/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor;

import com.iscobol.plugins.editor.DisplayCobolElementTextHover;
import com.iscobol.plugins.editor.IscobolAutoEditStrategy;
import com.iscobol.plugins.editor.IscobolCompletionProcessor;
import com.iscobol.plugins.editor.IscobolDoubleClickSelector;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IscobolReconcilingStrategy;
import com.iscobol.plugins.editor.annotations.CopyAnnotation;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;

public class IscobolSourceViewerConfiguration
extends SourceViewerConfiguration {
    public static final String rcsid = "$Id: IscobolSourceViewerConfiguration.java,v 1.18 2009/03/09 11:14:40 gianni Exp $";
    protected IscobolEditor editor;
    private MonoReconciler reconciler;
    private IAnnotationHover annotationHover;
    private IscobolCompletionProcessor iscobolCompletionProcessor;

    public IscobolSourceViewerConfiguration() {
    }

    public IscobolSourceViewerConfiguration(IscobolEditor iscobolEditor) {
        this.editor = iscobolEditor;
    }

    public void dispose() {
        if (this.iscobolCompletionProcessor != null) {
            this.iscobolCompletionProcessor.dispose();
        }
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer iSourceViewer) {
        return null;
    }

    public IscobolEditor getEditor() {
        return this.editor;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer iSourceViewer, String string) {
        return new IAutoEditStrategy[]{new IscobolAutoEditStrategy(this)};
    }

    private Annotation[] findAnnotations(ISourceViewer iSourceViewer, int n) {
        try {
            IRegion iRegion = iSourceViewer.getDocument().getLineInformation(n);
            IAnnotationModel iAnnotationModel = iSourceViewer.getAnnotationModel();
            if (iAnnotationModel != null) {
                Annotation[] annotationArray;
                Iterator iterator = iAnnotationModel.getAnnotationIterator();
                Vector<Annotation[]> vector = new Vector<Annotation[]>(2);
                while (iterator.hasNext()) {
                    annotationArray = (Annotation[])iterator.next();
                    Position position = iAnnotationModel.getPosition((Annotation)annotationArray);
                    if (position == null || !position.overlapsWith(iRegion.getOffset(), iRegion.getLength())) continue;
                    vector.addElement(annotationArray);
                }
                annotationArray = new Annotation[vector.size()];
                vector.toArray(annotationArray);
                int n2 = 0;
                for (int i = 1; i < annotationArray.length; ++i) {
                    if (!(annotationArray[i] instanceof CopyAnnotation) || n2 >= i) continue;
                    Annotation annotation = annotationArray[i];
                    annotationArray[i] = annotationArray[n2];
                    annotationArray[n2] = annotation;
                    ++n2;
                }
                return annotationArray;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return new Annotation[0];
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer iSourceViewer) {
        if (this.annotationHover == null) {
            this.annotationHover = new /* Unavailable Anonymous Inner Class!! */;
        }
        return this.annotationHover;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer iSourceViewer) {
        return "__iscobol_partitioning";
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return new String[]{"__dftl_partition_content_type", "", ""};
    }

    public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
        ContentAssistant contentAssistant = new ContentAssistant();
        contentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.createIscobolCompletionProcessor(), "__dftl_partition_content_type");
        contentAssistant.enableAutoActivation(true);
        contentAssistant.setAutoActivationDelay(500);
        contentAssistant.setProposalPopupOrientation(10);
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setContextInformationPopupBackground(IscobolEditorPlugin.getDefault().getColorProvider().getColor(new RGB(150, 150, 0)));
        contentAssistant.setInformationControlCreator(this.getInformationControlCreator(iSourceViewer));
        return contentAssistant;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer iSourceViewer) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String getDefaultPrefix(ISourceViewer iSourceViewer, String string) {
        return "__dftl_partition_content_type".equals(string) ? "//" : null;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        return new IscobolDoubleClickSelector();
    }

    public String[] getIndentPrefixes(ISourceViewer iSourceViewer, String string) {
        return new String[]{this.editor.getTabSpaces()};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        presentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)IscobolEditorPlugin.getDefault().getIscobolCodeScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__dftl_partition_content_type");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__dftl_partition_content_type");
        return presentationReconciler;
    }

    public int getTabWidth(ISourceViewer iSourceViewer) {
        return this.editor.getTabWidth();
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string) {
        return new DisplayCobolElementTextHover(this.editor);
    }

    protected IscobolReconcilingStrategy getIscobolStrategy() {
        return new IscobolReconcilingStrategy();
    }

    protected IscobolCompletionProcessor createIscobolCompletionProcessor() {
        return new IscobolCompletionProcessor(this.editor);
    }

    public IscobolCompletionProcessor getIscobolCompletionProcessor() {
        if (this.iscobolCompletionProcessor == null) {
            this.iscobolCompletionProcessor = this.createIscobolCompletionProcessor();
        }
        return this.iscobolCompletionProcessor;
    }

    public IReconciler getReconciler(ISourceViewer iSourceViewer) {
        if (this.reconciler != null) {
            return this.reconciler;
        }
        IscobolReconcilingStrategy iscobolReconcilingStrategy = this.getIscobolStrategy();
        iscobolReconcilingStrategy.setEditor(this.editor);
        this.reconciler = new MonoReconciler((IReconcilingStrategy)iscobolReconcilingStrategy, false);
        this.reconciler.setDelay(1000);
        return this.reconciler;
    }

    public IUndoManager getUndoManager(ISourceViewer iSourceViewer) {
        IPreferenceStore iPreferenceStore;
        int n = 200;
        if (this.editor != null && (iPreferenceStore = this.editor.getEditorPreferences()) != null) {
            n = iPreferenceStore.getInt("undoHistorySize");
        }
        return new TextViewerUndoManager(n);
    }

    static /* synthetic */ Annotation[] access$000(IscobolSourceViewerConfiguration iscobolSourceViewerConfiguration, ISourceViewer iSourceViewer, int n) {
        return iscobolSourceViewerConfiguration.findAnnotations(iSourceViewer, n);
    }
}

