/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor;

import com.iscobol.plugins.editor.ITextDataTransfer;
import com.iscobol.plugins.editor.IscobolEditor;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;

public class IscobolStyledText
extends StyledText {
    IscobolEditor editor;
    private boolean redraw = true;
    private Clipboard clipboard;

    public IscobolStyledText(Composite composite, int n) {
        super(composite, n);
        super.setIndent(0);
        super.setLeftMargin(0);
        this.clipboard = new Clipboard(this.getDisplay());
    }

    void setMyRedraw(boolean bl) {
        this.redraw = bl;
    }

    public void setLeftMargin(int n) {
    }

    public int getLeftMargin() {
        return 0;
    }

    public void setIndent(int n) {
    }

    public void redraw() {
        if (this.redraw) {
            super.redraw();
        }
    }

    public int getIndent() {
        return 0;
    }

    public void addLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
    }

    public void removeLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
    }

    public int getTabs() {
        return this.editor != null ? this.editor.getTabWidth() : super.getTabs();
    }

    void addMyLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
        super.addLineBackgroundListener(lineBackgroundListener);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.editor != null) {
            this.editor.refreshEditor();
        }
    }

    public void copy() {
        ITextDataTransfer iTextDataTransfer;
        super.copy();
        if (this.editor != null && (iTextDataTransfer = (ITextDataTransfer)this.editor.getAdapter(ITextDataTransfer.class)) != null) {
            iTextDataTransfer.copy(this.editor);
        }
    }

    public void copy(int n) {
        ITextDataTransfer iTextDataTransfer;
        super.copy(n);
        if (n == 1 && this.editor != null && (iTextDataTransfer = (ITextDataTransfer)this.editor.getAdapter(ITextDataTransfer.class)) != null) {
            iTextDataTransfer.copy(this.editor);
        }
    }

    public void paste() {
        String string;
        ITextDataTransfer iTextDataTransfer;
        if (this.editor != null && (iTextDataTransfer = (ITextDataTransfer)this.editor.getAdapter(ITextDataTransfer.class)) != null && (string = iTextDataTransfer.paste(this.editor)) != null) {
            TextTransfer textTransfer = TextTransfer.getInstance();
            Object[] objectArray = new Object[]{string};
            Transfer[] transferArray = new Transfer[]{textTransfer};
            this.clipboard.setContents(objectArray, transferArray, 1);
        }
        super.paste();
    }

    public void dispose() {
        this.clipboard.dispose();
        super.dispose();
    }

    public void cut() {
        ITextDataTransfer iTextDataTransfer;
        if (this.editor != null && (iTextDataTransfer = (ITextDataTransfer)this.editor.getAdapter(ITextDataTransfer.class)) != null) {
            iTextDataTransfer.copy(this.editor);
        }
        super.cut();
    }
}

