/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.builder;

import com.iscobol.compiler.ErrorInCompilationException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.Pcc;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.builder.EdbiisBuilder;
import com.iscobol.plugins.editor.preferences.EasyDBOptionList;
import com.iscobol.plugins.editor.util.InternalErrorException;
import com.iscobol.plugins.editor.util.OptionListExt;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.IOConsole;

/*
 * Exception performing whole class analysis ignored.
 */
public class EdbiisBuilder {
    private static final String eol = System.getProperty("line.separator", "\n");
    private static final Set<String> excludedOptionKeys;
    private IProject project;

    public EdbiisBuilder(IProject iProject) {
        this.project = iProject;
    }

    public void build(IProgressMonitor iProgressMonitor) throws CoreException {
        this.build(null, iProgressMonitor);
    }

    public void build(Shell shell) throws CoreException {
        this.build(shell, null);
    }

    public void build(Shell shell, IProgressMonitor iProgressMonitor) throws CoreException {
        IContainer iContainer = PluginUtilities.getEFDFolder((IProject)this.project);
        if (iContainer == null || !iContainer.exists()) {
            throw new InternalErrorException("EdbiisBuilder: XML folder not found in '" + this.project.getName() + "' project");
        }
        IResource[] iResourceArray = iContainer.members();
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        for (int i = 0; i < iResourceArray.length; ++i) {
            IFile iFile;
            if (iResourceArray[i].getType() != 1 || (iFile = (IFile)iResourceArray[i]).getFileExtension() == null || !iFile.getFileExtension().equals("xml")) continue;
            arrayList.add(iFile);
        }
        this.build(shell, iProgressMonitor, arrayList, false);
    }

    public void build(Shell shell, IProgressMonitor iProgressMonitor, List<IFile> list, boolean bl) throws CoreException {
        String string;
        String string2;
        if (list.size() == 0) {
            return;
        }
        String string3 = IscobolEditorPlugin.getStringFromStore((String)"iscobol.easydb.exec");
        File file = new File(string3);
        if (!(file.exists() && file.isFile() && file.canExecute())) {
            throw new InternalErrorException("Invalid EasyDB Executable Path: '" + string3 + "'. Please check it in 'Window/Preferences/isCOBOL/Database Bridge'");
        }
        String string4 = IscobolEditorPlugin.getStringFromStore((String)"easydb.-ld");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        if (string4 != null && string4.length() > 0) {
            arrayList.add("-ld=" + string4);
        }
        ArrayList arrayList2 = this.getEDBOptions(EasyDBOptionList.getGenericOptions());
        LinkedHashMap<String, ArrayList> linkedHashMap = new LinkedHashMap<String, ArrayList>();
        for (String string5 : EasyDBOptionList.getDatabaseOptions()) {
            String string6 = PluginUtilities.getPersistentProperty((IResource)this.project, (String)"Default", (String)("easydb." + string5));
            if (string6 == null || !string6.equals("___iscobol.option.true")) continue;
            ArrayList<String> arrayList3 = new ArrayList<String>(arrayList2);
            arrayList3.add(string5);
            if (EasyDBOptionList.isOracle((String)string5)) {
                arrayList3.addAll(this.getEDBOptions(EasyDBOptionList.getOracleOptions()));
            } else if (EasyDBOptionList.isMySQL((String)string5)) {
                arrayList3.addAll(this.getEDBOptions(EasyDBOptionList.getMySqlOptions()));
            } else if (EasyDBOptionList.isInformix((String)string5)) {
                arrayList3.addAll(this.getEDBOptions(EasyDBOptionList.getInformixOptions()));
            } else if (EasyDBOptionList.isSQLServer((String)string5)) {
                arrayList3.addAll(this.getEDBOptions(EasyDBOptionList.getSqlServerOptions()));
            } else if (EasyDBOptionList.isPostgreSql((String)string5)) {
                arrayList3.addAll(this.getEDBOptions(EasyDBOptionList.getPostgreOptions()));
            }
            linkedHashMap.put(string5, arrayList3);
        }
        String string7 = PluginUtilities.getPersistentProperty((IResource)this.project, (String)"Default", (String)"easydb.Generic");
        if (string7 != null && string7.equals("___iscobol.option.true")) {
            linkedHashMap.put("Generic", arrayList2);
        }
        if ((string2 = PluginUtilities.getPersistentProperty((IResource)this.project, (String)(string = PluginUtilities.getCurrentSettingMode((IResource)this.project)), (String)"-dx")) == null || string2.equals("___iscobol.option.false")) {
            string2 = PluginUtilities.getPersistentProperty((IResource)this.project, (String)string, (String)"-d");
        }
        if (shell != null) {
            String string5;
            string5 = new ProgressMonitorDialog(shell);
            try {
                string5.run(true, true, (IRunnableWithProgress)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            this.build(arrayList, linkedHashMap, list, bl, iProgressMonitor);
        }
        this.project.refreshLocal(2, null);
    }

    private ArrayList<String> getEDBOptions(String[] stringArray) throws CoreException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = PluginUtilities.getPersistentProperty((IResource)this.project, (String)"Default", (String)("easydb." + stringArray[i]));
            if (string == null || string.equals("___iscobol.option.false")) continue;
            if (EasyDBOptionList.hasValue((String)stringArray[i])) {
                File file;
                if (EasyDBOptionList.isFolder((String)stringArray[i]) && !(file = new File(string)).isAbsolute()) {
                    string = PluginUtilities.getProjectRootDir((IProject)this.project) + File.separator + string;
                }
                arrayList.add(stringArray[i] + "=" + string);
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    private IFolder createFolder(IContainer iContainer, String string) {
        IFolder iFolder = iContainer.getFolder((IPath)new Path(string));
        if (!iFolder.exists()) {
            PluginUtilities.createFolder((IFolder)iFolder);
        }
        return iFolder;
    }

    private static ArrayList<String> getOptionList(IProject iProject, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = OptionList.getAllOptionKeys((boolean)false);
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = enumeration.nextElement().toString();
            if (excludedOptionKeys.contains(string3) || (string2 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)string, (String)string3)) == null || string2.equals("___iscobol.option.false")) continue;
            if (PluginUtilities.isFileSystemOption((String)string3)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((CharSequence)PluginUtilities.buildAbsolutePathList((String)string2, (IProject)iProject));
                arrayList.add(string3 + stringBuilder.toString());
                continue;
            }
            if (OptionList.hasValue((String)string3)) {
                arrayList.add(string3 + string2);
                continue;
            }
            arrayList.add(string3);
        }
        return arrayList;
    }

    private void build(List<String> list, Map<String, List<String>> map, List<IFile> list2, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        ArrayList arrayList = EdbiisBuilder.getOptionList((IProject)this.project, (String)PluginUtilities.getCurrentSettingMode((IResource)this.project));
        String string = PluginUtilities.getProjectRootDir((IProject)this.project) + File.separator + "edbiis-output" + File.separator;
        IFolder iFolder = this.createFolder((IContainer)this.project, "edbiis-output");
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask("Launch Edbiis", list2.size() * (map.size() + 1));
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string2 : map.keySet()) {
            String string3;
            String string4;
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.addAll(list);
            arrayList3.addAll((Collection)map.get(string2));
            if (string2.equals("Generic")) {
                string4 = "Generic DB";
                string3 = "generic";
            } else {
                string4 = EasyDBOptionList.getDescription((String)string2);
                string3 = EasyDBOptionList.getDatabaseFolderName((String)string2);
            }
            IFolder iFolder2 = this.createFolder((IContainer)iFolder, string3);
            IFolder iFolder3 = this.createFolder((IContainer)iFolder2, "source");
            IFolder iFolder4 = this.createFolder((IContainer)iFolder2, "classes");
            this.createFolder((IContainer)iFolder2, "sql");
            IFolder iFolder5 = this.createFolder((IContainer)iFolder2, "copy");
            for (int i = 0; i < list2.size(); ++i) {
                if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IFile iFile = list2.get(i);
                if (!bl && !this.needsGeneration(iFile, iFolder3)) continue;
                ArrayList<String> arrayList4 = new ArrayList<String>();
                arrayList4.addAll(arrayList3);
                arrayList4.add("-od=" + string + File.separator + string3 + File.separator + "source");
                arrayList4.add("-oc=" + string + File.separator + string3 + File.separator + "copy");
                arrayList4.add("-os=" + string + File.separator + string3 + File.separator + "sql");
                arrayList4.add(iFile.getLocation().toOSString());
                if (iProgressMonitor != null) {
                    iProgressMonitor.subTask("Generate " + iFile.getName() + " for " + string4 + "...");
                }
                Process process = DebugPlugin.exec((String[])arrayList4.toArray(new String[arrayList4.size()]), null);
                IOConsole iOConsole = IscobolEditorPlugin.getDefault().getConsole();
                PrintStream printStream = new PrintStream((OutputStream)iOConsole.newOutputStream());
                printStream.print("[edbiis] ");
                for (String string5 : arrayList4) {
                    printStream.print(string5 + " ");
                }
                printStream.println();
                StringWriter stringWriter = EdbiisBuilder.redirOutputToConsole((PrintStream)printStream, (InputStream)process.getErrorStream());
                int n = -1;
                try {
                    n = process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n == 0) {
                    iFolder3.refreshLocal(1, null);
                    IFile iFile2 = this.findGeneratedFile(iFile.getName(), iFolder3);
                    if (iFile2 != null) {
                        String string6 = this.compileCobolSource(iFile2.getLocation().toOSString(), iFolder5, arrayList, iFolder4);
                        if (string6 != null) {
                            arrayList2.add(string6);
                        }
                    } else {
                        PluginUtilities.log((String)("Error executing Edbiis with '" + iFile.getName() + "':" + eol + stringWriter));
                    }
                } else {
                    PluginUtilities.log((String)("Error executing Edbiis with '" + iFile.getName() + "':" + eol + stringWriter));
                }
                if (iProgressMonitor == null) continue;
                iProgressMonitor.worked(1);
            }
            this.compileJavaSources(arrayList2);
            arrayList2.clear();
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.worked(list2.size());
            iProgressMonitor.done();
        }
    }

    private void compileJavaSources(ArrayList<String> arrayList) throws CoreException {
        if (arrayList.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(IscobolEditorPlugin.getDefault().getJavacCompiler());
        arrayList2.add("-classpath");
        arrayList2.add(PluginUtilities.getIscobolLibraryPath());
        arrayList2.addAll(arrayList);
        Process process = DebugPlugin.exec((String[])arrayList2.toArray(new String[arrayList2.size()]), null);
        IOConsole iOConsole = IscobolEditorPlugin.getDefault().getConsole();
        PrintStream printStream = new PrintStream((OutputStream)iOConsole.newOutputStream());
        EdbiisBuilder.redirOutputToConsole((PrintStream)printStream, (InputStream)process.getErrorStream());
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            new File(arrayList.get(i)).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String compileCobolSource(String string, IFolder iFolder, ArrayList<String> arrayList, IFolder iFolder2) throws CoreException {
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        IOConsoleForwarderOutputStream iOConsoleForwarderOutputStream = new IOConsoleForwarderOutputStream(IscobolEditorPlugin.getDefault().getConsole());
        System.setOut(new PrintStream((OutputStream)iOConsoleForwarderOutputStream));
        System.setErr(new PrintStream((OutputStream)iOConsoleForwarderOutputStream));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(arrayList);
        arrayList2.add("-jj");
        arrayList2.add("-sa");
        StringBuilder stringBuilder = new StringBuilder("-sp=");
        stringBuilder.append(iFolder.getLocation().toOSString());
        IContainer[] iContainerArray = PluginUtilities.getCopyFolders((IProject)this.project, (String)PluginUtilities.getCurrentSettingMode((IResource)this.project));
        for (int i = 0; i < iContainerArray.length; ++i) {
            stringBuilder.append(File.pathSeparator).append(iContainerArray[i].getLocation().toOSString());
        }
        arrayList2.add(stringBuilder.toString());
        arrayList2.add("-od=" + iFolder2.getLocation().toOSString());
        arrayList2.add(string);
        OptionListExt optionListExt = OptionListExt.newInstance((String[])arrayList2.toArray(new String[arrayList2.size()]));
        try {
            Pcc pcc = Pcc.run((String)string, (String)(iFolder2.getLocation().toOSString() + File.separator), (OptionList)optionListExt, (String)null, (Errors)new Errors(), (Reader)null, (boolean)true, null);
            String string2 = iFolder2.getLocation().toOSString() + File.separator + pcc.getClassName() + ".java";
            return string2;
        }
        catch (ErrorInCompilationException errorInCompilationException) {
            Vector vector = errorInCompilationException.pcc.getErrors().getAllMessages();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println("Error compiling '" + new File(string).getName() + "':");
            for (Object e : vector) {
                if (!e.toString().startsWith("--S: ")) continue;
                printWriter.println(e);
            }
            printWriter.close();
            PluginUtilities.log((String)stringWriter.toString());
            Iterator iterator = null;
            return iterator;
        }
        finally {
            System.setOut(printStream);
            System.setErr(printStream2);
            try {
                iOConsoleForwarderOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean needsGeneration(IFile iFile, IFolder iFolder) throws CoreException {
        IFile iFile2 = this.findGeneratedFile(iFile.getName(), iFolder);
        if (iFile2 != null && iFile2.exists()) {
            File file = iFile2.getLocation().toFile();
            File file2 = iFile.getLocation().toFile();
            return file.lastModified() < file2.lastModified();
        }
        return true;
    }

    private IFile findGeneratedFile(String string, IFolder iFolder) throws CoreException {
        string = new Path(string).removeFileExtension().toString();
        IResource[] iResourceArray = iFolder.members();
        for (int i = 0; i < iResourceArray.length; ++i) {
            if (iResourceArray[i].getType() != 1) continue;
            IFile iFile = (IFile)iResourceArray[i];
            String string2 = new Path(iFile.getName()).removeFileExtension().toString();
            if (string2.startsWith("EDBI-")) {
                string2 = string2.substring(5);
            }
            if (!string2.equals(string)) continue;
            return iFile;
        }
        return null;
    }

    private static StringWriter redirOutputToConsole(PrintStream printStream, InputStream inputStream) {
        StringWriter stringWriter = new StringWriter();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return stringWriter;
    }

    static /* synthetic */ void access$000(EdbiisBuilder edbiisBuilder, List list, Map map, List list2, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        edbiisBuilder.build(list, map, list2, bl, iProgressMonitor);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("-cax");
        hashSet.add("-ce=");
        hashSet.add("-cfl");
        hashSet.add("-coe");
        hashSet.add("-ef");
        hashSet.add("-efc");
        hashSet.add("-efd");
        hashSet.add("-efo=");
        hashSet.add("-eo=");
        hashSet.add("-es");
        hashSet.add("-exec=");
        hashSet.add("-flsu");
        hashSet.add("-fsv");
        hashSet.add("-g");
        hashSet.add("-help");
        hashSet.add("-helpx");
        hashSet.add("-jj");
        hashSet.add("-jc");
        hashSet.add("-jo=");
        hashSet.add("-la");
        hashSet.add("-ld");
        hashSet.add("-lf");
        hashSet.add("-lfo");
        hashSet.add("-lo=");
        hashSet.add("-noexec");
        hashSet.add("-od=");
        hashSet.add("-rw=");
        hashSet.add("-sa");
        hashSet.add("-st");
        hashSet.add("-sf");
        hashSet.add("-smat");
        hashSet.add("-sp=");
        hashSet.add("-v");
        hashSet.add("-wd2");
        hashSet.add("-wu");
        hashSet.add("-xcv");
        hashSet.add("-xms");
        hashSet.add("-xmsn");
        hashSet.add("-xo0");
        hashSet.add("-xosrt");
        hashSet.add("-xwca");
        hashSet.add("-xwh");
        hashSet.add("-xwhc");
        hashSet.add("-xwhj");
        hashSet.add("-ze");
        hashSet.add("-zi");
        hashSet.add("-zy");
        excludedOptionKeys = Collections.unmodifiableSet(hashSet);
    }
}

