/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.copyexpansion;

import com.iscobol.plugins.editor.copyexpansion.ExpandedCopyDocument;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class ExpandedCopyAnnotationModel
extends ResourceMarkerAnnotationModel {
    private IResourceChangeListener listener = new /* Unavailable Anonymous Inner Class!! */;

    public ExpandedCopyAnnotationModel(IFile iFile) {
        super((IResource)iFile);
    }

    protected Position createPositionFromMarker(IMarker iMarker) {
        if (this.fDocument instanceof ExpandedCopyDocument) {
            ExpandedCopyDocument expandedCopyDocument = (ExpandedCopyDocument)this.fDocument;
            try {
                return expandedCopyDocument.getDocumentPosition(iMarker.getAttribute("lineNumber", 0), (IFile)iMarker.getResource());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return super.createPositionFromMarker(iMarker);
    }

    protected void update(IMarkerDelta[] iMarkerDeltaArray) {
        super.update(iMarkerDeltaArray);
    }

    protected boolean isAcceptable(IMarker iMarker) {
        boolean bl = super.isAcceptable(iMarker);
        if (!bl && this.fDocument instanceof ExpandedCopyDocument) {
            ExpandedCopyDocument expandedCopyDocument = (ExpandedCopyDocument)this.fDocument;
            for (IFile iFile : expandedCopyDocument.getCopyFiles()) {
                boolean bl2 = bl = iMarker != null && iFile.equals(iMarker.getResource());
                if (bl) break;
            }
        }
        return bl;
    }

    protected void listenToMarkerChanges(boolean bl) {
        super.listenToMarkerChanges(bl);
        if (bl) {
            this.getResource().getWorkspace().addResourceChangeListener(this.listener);
        } else {
            this.getResource().getWorkspace().removeResourceChangeListener(this.listener);
        }
    }

    protected void catchupAllMarkers() throws CoreException {
        IMarker[] iMarkerArray = this.getAnnotationIterator(false);
        while (iMarkerArray.hasNext()) {
            Annotation annotation = (Annotation)iMarkerArray.next();
            if (!(annotation instanceof MarkerAnnotation)) continue;
            this.removeAnnotation(annotation, false);
        }
        iMarkerArray = this.retrieveMarkers();
        if (iMarkerArray != null) {
            for (int i = 0; i < iMarkerArray.length; ++i) {
                this.addMarkerAnnotation(iMarkerArray[i]);
            }
        }
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        for (IMarker iMarker : this.getResource().findMarkers("org.eclipse.core.resources.marker", true, 0)) {
            arrayList.add(iMarker);
        }
        if (this.fDocument instanceof ExpandedCopyDocument) {
            ExpandedCopyDocument expandedCopyDocument = (ExpandedCopyDocument)this.fDocument;
            for (IFile iFile : expandedCopyDocument.getCopyFiles()) {
                for (IMarker iMarker : iFile.findMarkers("org.eclipse.core.resources.marker", true, 0)) {
                    arrayList.add(iMarker);
                }
            }
        }
        return arrayList.toArray(new IMarker[arrayList.size()]);
    }

    static /* synthetic */ IDocument access$000(ExpandedCopyAnnotationModel expandedCopyAnnotationModel) {
        return expandedCopyAnnotationModel.fDocument;
    }

    static /* synthetic */ IDocument access$100(ExpandedCopyAnnotationModel expandedCopyAnnotationModel) {
        return expandedCopyAnnotationModel.fDocument;
    }
}

