/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.copyexpansion;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IscobolProjectionViewer;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.copyexpansion.ExpandedCopyConfiguration;
import com.iscobol.plugins.editor.copyexpansion.ExpandedCopyDocument;
import com.iscobol.plugins.editor.copyexpansion.ExpandedCopyDocumentProvider;
import com.iscobol.plugins.editor.copyexpansion.IscobolExpandedCopyEditor;
import com.iscobol.plugins.editor.util.ColorProvider;
import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class IscobolExpandedCopyEditor
extends IscobolEditor {
    public static final String ID = "com.iscobol.plugins.editor.IscobolExpandedCopyEditor";
    private Color[] copyFileBackground;
    private IPropertyChangeListener listener;

    public IscobolExpandedCopyEditor() {
        this.setDocumentProvider((IDocumentProvider)ExpandedCopyDocumentProvider.getInstance());
        this.setRulerContextMenuId("#ExpandedCopyEditorTextRulerContext");
        this.loadCopyFileColors();
        this.listener = new /* Unavailable Anonymous Inner Class!! */;
        IscobolEditorPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.listener);
    }

    public void dispose() {
        IscobolEditorPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.listener);
        super.dispose();
    }

    private void loadCopyFileColors() {
        String string = IscobolEditorPlugin.getStringFromStore((String)"iscobol.copysource.colors");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        this.copyFileBackground = new Color[stringTokenizer.countTokens()];
        ColorProvider colorProvider = IscobolEditorPlugin.getDefault().getColorProvider();
        for (int i = 0; i < this.copyFileBackground.length; ++i) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ",");
            int n = Integer.parseInt(stringTokenizer2.nextToken());
            int n2 = Integer.parseInt(stringTokenizer2.nextToken());
            int n3 = Integer.parseInt(stringTokenizer2.nextToken());
            this.copyFileBackground[i] = colorProvider.getColor(new RGB(n, n2, n3));
        }
    }

    protected void initializeConfiguration() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new ExpandedCopyConfiguration(this));
    }

    public void lineGetBackground(LineBackgroundEvent lineBackgroundEvent) {
        ExpandedCopyDocument expandedCopyDocument = (ExpandedCopyDocument)this.getViewer().getDocument();
        try {
            IscobolProjectionViewer iscobolProjectionViewer;
            int n = -1;
            int n2 = lineBackgroundEvent.lineOffset;
            if (this.getViewer() instanceof ITextViewerExtension5 && (n2 = (iscobolProjectionViewer = this.getViewer()).widgetOffset2ModelOffset(n2)) < 0) {
                n2 = lineBackgroundEvent.lineOffset;
            }
            if ((n = expandedCopyDocument.getCopyFileLevelOfOffset(n2) - 1) >= 0) {
                lineBackgroundEvent.lineBackground = this.copyFileBackground[n % this.copyFileBackground.length];
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        super.lineGetBackground(lineBackgroundEvent);
    }

    protected void intRulerContextMenuAboutToShow(IMenuManager iMenuManager) {
        IAction iAction = this.getAction("RulerClick");
        if (iAction != null) {
            iMenuManager.add(iAction);
        }
    }

    public boolean isReconcilingEnabled() {
        return false;
    }

    public boolean isSourceFormatEnabled() {
        return false;
    }

    public boolean isShowVerticalLinesEnabled() {
        return true;
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        super.doSetInput(iEditorInput);
    }

    public boolean isDirty() {
        return false;
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.editorContextMenuAboutToShow(iMenuManager);
        if (this.getViewer() != null && this.getViewer().getTextWidget() != null) {
            3 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
            var2_2.setText(IsresourceBundle.getString((String)"open_is_editor_lbl") + "\tF4");
            iMenuManager.add((IAction)var2_2);
        }
    }

    protected void createActions() {
        super.createActions();
        if (this.getViewer() != null && this.getViewer().getTextWidget() != null) {
            this.getViewer().getTextWidget().addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected boolean canOpenIscobolCopyViewEditor() {
        return false;
    }

    private void openIscobolEditor() {
        int n = this.getLastMouseDownLine();
        ExpandedCopyDocument expandedCopyDocument = (ExpandedCopyDocument)this.getViewer().getDocument();
        IFile iFile = expandedCopyDocument.getCopyFile(n);
        if (iFile == null) {
            iFile = this.getFileEditorInput().getFile();
        }
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(iFile), IscobolEditor.ID, true, 3);
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    public void setDebugCurrentLine(int n, String string) {
        ExpandedCopyDocument expandedCopyDocument = (ExpandedCopyDocument)this.getViewer().getDocument();
        n = expandedCopyDocument.getDocumentLine(n + 1, new File(string).getName());
        super.setDebugCurrentLine(n, string);
    }

    static /* synthetic */ void access$000(IscobolExpandedCopyEditor iscobolExpandedCopyEditor) {
        iscobolExpandedCopyEditor.loadCopyFileColors();
    }

    static /* synthetic */ void access$100(IscobolExpandedCopyEditor iscobolExpandedCopyEditor) {
        iscobolExpandedCopyEditor.openIscobolEditor();
    }
}

