/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.debug;

import com.iscobol.debugger.DebugResponse;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.debug.IscobolDebugTarget;
import com.iscobol.plugins.editor.util.IsFragment;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.util.VarDecl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;

public class DisplayVariableTextHover
implements ITextHover {
    private IscobolEditor editor;

    public DisplayVariableTextHover(IscobolEditor iscobolEditor) {
        this.editor = iscobolEditor;
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        if (iRegion != null) {
            try {
                IscobolDebugTarget iscobolDebugTarget = IscobolDebugTarget.getCurrent();
                if (iscobolDebugTarget != null && iscobolDebugTarget.isSuspended()) {
                    IRegion iRegion2 = iTextViewer.getDocument().getLineInformationOfOffset(iRegion.getOffset());
                    int n = iRegion.getOffset() - iRegion2.getOffset();
                    String string = iTextViewer.getDocument().get(iRegion2.getOffset(), iRegion2.getLength());
                    String string2 = PluginUtilities.findVariableName((String)string, (int)n, (boolean)true);
                    if (string2 != null && string2.length() > 0) {
                        DebugResponse debugResponse;
                        boolean bl = IscobolEditorPlugin.getDefault().getPreferenceStore().getBoolean("iscobol.variableview.showhex");
                        String string3 = "display";
                        if (bl) {
                            string3 = string3 + " -x";
                        }
                        if ((debugResponse = iscobolDebugTarget.processCommand(string3 = string3 + " " + string2)) != null && debugResponse.getReturnCode() == 0) {
                            IsFragment isFragment = this.editor.findSelectedFragment(string2.trim());
                            if (isFragment != null && isFragment.getType() == 13) {
                                VarDecl varDecl = (VarDecl)isFragment;
                                return "______STANDARD_CONTENT_TYPE" + IscobolDebugTarget.getDescription((VarDecl)varDecl, (String)debugResponse.getVarValue());
                            }
                            return "______STANDARD_CONTENT_TYPE" + string2 + " = " + debugResponse.getVarValue();
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        Point point = iTextViewer.getSelectedRange();
        if (point.x <= n && n < point.x + point.y) {
            return new Region(point.x, point.y);
        }
        return new Region(n, 0);
    }
}

