/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.debug;

import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.debugger.CobolRef;
import com.iscobol.debugger.DebugLine;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.Listing;
import com.iscobol.debugger.ListingException;
import com.iscobol.debugger.ThreadObject;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.Watch;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.GetInfoCommand;
import com.iscobol.debugger.commands.GetVariablesCommand;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.interfaces.debugger.IFileLoader;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.Tokens;
import com.iscobol.plugins.editor.builder.IIscobolProjectBuilder;
import com.iscobol.plugins.editor.copyexpansion.ExpandedCopyDocument;
import com.iscobol.plugins.editor.copyexpansion.IscobolExpandedCopyEditor;
import com.iscobol.plugins.editor.debug.IDebugHelper;
import com.iscobol.plugins.editor.debug.IscobolBreakpoint;
import com.iscobol.plugins.editor.debug.IscobolDebugElement;
import com.iscobol.plugins.editor.debug.IscobolDebugTarget;
import com.iscobol.plugins.editor.debug.IscobolStackFrame;
import com.iscobol.plugins.editor.debug.IscobolThread;
import com.iscobol.plugins.editor.debug.IscobolValue;
import com.iscobol.plugins.editor.debug.IscobolVariable;
import com.iscobol.plugins.editor.debug.IscobolWatchpoint;
import com.iscobol.plugins.editor.sourceproviders.VariableSourceProvider;
import com.iscobol.plugins.editor.util.IsFragment;
import com.iscobol.plugins.editor.util.IscobolAdaptable;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.util.VarDecl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

/*
 * Exception performing whole class analysis ignored.
 */
public class IscobolDebugTarget
extends IscobolDebugElement
implements IDebugTarget,
IDebugElement,
IDisconnect {
    private static final int MAX_ATTEMPTS = 10;
    public static final String ATTR_SKIP_EVENT = "SKIP_EVENT";
    public static final String ISWATCHPOINT_MARKER_TYPE = "com.iscobol.plugins.editor.IscobolEditor.IscobolWatchpointMarker";
    public static final String ISBREAKPOINT_MARKER_TYPE = "com.iscobol.plugins.editor.IscobolEditor.IscobolBreakpointMarker";
    private static LinkedHashMap<String, VarName> addedVarnames = new LinkedHashMap();
    private DebuggerInvoker invoker;
    private PrintStream debugOutputStream;
    private EventDispatchJob job;
    private String name;
    private IProcess process;
    private IProject project;
    private int port;
    private int maxAttempts;
    private ClassReloaderThread classReloaderThread;
    private String host;
    private IscobolThread currThread;
    private boolean suspended;
    private boolean disconnected = true;
    private String lastCommandStr;
    private DebugCommand lastCommand;
    private DebugTM tm;
    private IBreakpoint lastBreakpoint;
    private boolean terminated;
    private List<String> breakpointCommands = new ArrayList();
    private Map<Integer, IscobolThread> threads = new HashMap();
    private ArrayList<IscobolVariable> variables = new ArrayList();
    private Map<String, IscobolWatchpoint> monitorTable = new HashMap();
    private Map<String, MyDebugInfo> debugInfos = new HashMap();
    private boolean tracingEnabled;
    private IIscobolProjectBuilder ipb;
    private static IOConsoleReaderThread ioConsoleReaderThread = null;
    private static Vector<IscobolDebugTarget> debugTargets = new Vector();

    public IscobolDebugTarget(String string, IProject iProject, IProcess iProcess, String string2, int n, int n2, ILaunch iLaunch) {
        this(string, iProject, iProcess, string2, n, n2, 10, iLaunch);
    }

    public IscobolDebugTarget(String string, IProject iProject, IProcess iProcess, String string2, int n, int n2, int n3, ILaunch iLaunch) {
        super(null, iLaunch);
        this.name = string;
        this.project = iProject;
        this.process = iProcess;
        this.launch = iLaunch;
        this.host = string2;
        this.port = n;
        this.maxAttempts = n3;
        if (n2 > 0) {
            try {
                this.classReloaderThread = new ClassReloaderThread(this, string2, n2);
                this.classReloaderThread.start();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.ipb = (IIscobolProjectBuilder)IscobolAdaptable.getInstance().getAdapter(IIscobolProjectBuilder.class);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public IIscobolProjectBuilder getIscobolProjectBuilder() {
        return this.ipb;
    }

    int showReloadClassError(String string, String string2) {
        int[] nArray = new int[]{0};
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return nArray[0];
    }

    private void start() {
        debugTargets.add(this);
        this.terminated = false;
        DebugResponse debugResponse = null;
        boolean bl = false;
        this.invoker = new DebuggerInvoker();
        if (this.getProcess() == null) {
            this.debugOutputStream = new PrintStream((OutputStream)IscobolEditorPlugin.getDefault().getConsole().newOutputStream());
        }
        for (int i = 1; !(bl = (debugResponse = this.invoker.invokeRemote(this.host, this.port, this.debugOutputStream)).getReturnCode() != 106) && i != this.maxAttempts - 1; ++i) {
            if (this.terminated) {
                this.removeTargetInstance();
                return;
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (debugResponse.getReturnCode() == 103 || debugResponse.getReturnCode() == 104) {
            String string = debugResponse.getMessage();
            if (string == null || string.length() == 0) {
                string = "Program Finished";
            }
            PluginUtilities.logError((String)string);
            this.invoker.exitDebug();
            this.removeTargetInstance();
            return;
        }
        if (!bl) {
            PluginUtilities.logError((String)(IsresourceBundle.getString((String)"conn_refused_msg") + " " + this.port));
            this.invoker.exitDebug();
            this.removeTargetInstance();
            return;
        }
        if (this.getProcess() == null) {
            this.disconnected = false;
            Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            if (ioConsoleReaderThread == null) {
                ioConsoleReaderThread = new IOConsoleReaderThread();
                ioConsoleReaderThread.start();
            }
        }
        this.variables.add(new IscobolVariable(IscobolVariable.SpecialType.CURRENT_VARIABLES, (IDebugTarget)this, this.getLaunch()));
        this.variables.add(new IscobolVariable(IscobolVariable.SpecialType.WATCHED_VARIABLES, (IDebugTarget)this, this.getLaunch()));
        ISourceLookupResult iSourceLookupResult = null;
        String string = debugResponse.getLastFile();
        if (string != null && string.length() > 0) {
            IscobolStackFrame iscobolStackFrame = new IscobolStackFrame("", string, debugResponse.getLine(), debugResponse.getLastProgram(), null, (IDebugTarget)this, this.getLaunch());
            iSourceLookupResult = DebugUITools.lookupSource((Object)iscobolStackFrame, (ISourceLocator)this.getLaunch().getSourceLocator());
        }
        if (iSourceLookupResult != null) {
            IscobolDebugTarget.openEditor((IEditorInput)iSourceLookupResult.getEditorInput());
        }
        debugResponse = this.invoker.getResponse();
        this.suspended = true;
        if (debugResponse != null) {
            debugResponse.getReturnCode();
            if (debugResponse.getReturnCode() != 106 && debugResponse.getReturnCode() != 103) {
                DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
                this.invoker.setCheckFileOfBreakpoints(false);
                this.job = new EventDispatchJob(this, debugResponse);
                this.job.schedule();
                this.installDeferredBreakpoints();
            } else {
                this.removeTargetInstance();
            }
        } else {
            this.removeTargetInstance();
        }
    }

    public static IscobolEditor openEditor(IEditorInput iEditorInput) {
        IscobolEditor[] iscobolEditorArray = new IscobolEditor[1];
        new /* Unavailable Anonymous Inner Class!! */.start();
        return iscobolEditorArray[0];
    }

    public static final IscobolDebugTarget getCurrent() {
        IscobolDebugTarget iscobolDebugTarget = VariableSourceProvider.getCurrentDebugTarget();
        if (iscobolDebugTarget != null && debugTargets.contains(iscobolDebugTarget)) {
            return iscobolDebugTarget;
        }
        return null;
    }

    public DebuggerInvoker getInvoker() {
        return this.invoker;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public void setLastBreakpoint(IBreakpoint iBreakpoint) {
        this.lastBreakpoint = iBreakpoint;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public static void refreshVariablesView() {
        IscobolDebugTarget.refreshDebugView((String)"org.eclipse.debug.ui.VariableView");
    }

    public static void refreshBreakpointView() {
        IscobolDebugTarget.refreshDebugView((String)"org.eclipse.debug.ui.BreakpointView");
    }

    public static void refreshDebugView(String string) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public IThread[] getThreads() throws DebugException {
        IThread[] iThreadArray = new IThread[this.threads.size()];
        this.threads.values().toArray(iThreadArray);
        return iThreadArray;
    }

    public boolean hasThreads() throws DebugException {
        if (this.getProcess() != null) {
            return !this.getProcess().isTerminated() && !this.threads.isEmpty();
        }
        return !this.isDisconnected() && !this.threads.isEmpty();
    }

    public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
        return this.isSuspended();
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public boolean canTerminate() {
        if (this.getProcess() != null) {
            return this.getProcess().canTerminate();
        }
        return false;
    }

    public boolean isTerminated() {
        if (this.getProcess() != null) {
            return this.getProcess().isTerminated();
        }
        return false;
    }

    public void terminate() throws DebugException {
        this.terminated();
    }

    private boolean isHtmlProject() {
        try {
            return this.getProject() != null && this.getProject().getNature("com.iscobol.plugins.HtmlAndroid.IscobolHtmlAndroidNature") != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void removeTargetInstance() {
        debugTargets.remove(this);
        this.invoker = null;
        if (this.debugOutputStream != null) {
            this.debugOutputStream.close();
            this.debugOutputStream = null;
        }
    }

    private void terminated() {
        String string;
        String string2;
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        this.tracingEnabled = false;
        IPreferenceStore iPreferenceStore = this.monitorTable.values().iterator();
        while (iPreferenceStore.hasNext()) {
            IscobolWatchpoint iscobolWatchpoint = (IscobolWatchpoint)iPreferenceStore.next();
            iscobolWatchpoint.setValue(null);
        }
        this.monitorTable.clear();
        this.fireTerminateEvent();
        try {
            this.removeTerminatedThreads(new ThreadObject[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resetCurrentLine();
        this.variables.clear();
        try {
            if (this.getProcess() != null) {
                this.getProcess().terminate();
            } else {
                if (this.getLaunch() instanceof Launch) {
                    ((Launch)this.getLaunch()).disconnect();
                }
                this.disconnected = true;
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        if (this.invoker != null) {
            this.invoker.exitDebug();
        }
        if (this.job != null) {
            this.job.cancel();
            if (this.job.getThread() != null) {
                this.job.getThread().interrupt();
            }
            this.job = null;
        }
        this.suspended = false;
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.removeTargetInstance();
        if (this.classReloaderThread != null) {
            this.classReloaderThread.close();
            this.classReloaderThread = null;
        }
        int n = (iPreferenceStore = IscobolEditorPlugin.getDefault().getPreferenceStore()).contains("iscobol.switchback.ispersp") ? iPreferenceStore.getInt("iscobol.switchback.ispersp") : iPreferenceStore.getDefaultInt("iscobol.switchback.ispersp");
        boolean[] blArray = new boolean[]{false};
        if (this.isHtmlProject()) {
            string2 = "isCOBOL HTML";
            string = "IscobolHtmlAndroidNature";
        } else {
            string2 = "isCOBOL";
            string = "IscobolPerspective";
        }
        if (n == 2) {
            Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        } else if (n == 0) {
            blArray[0] = true;
        }
        if (blArray[0]) {
            Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.currThread = null;
    }

    public void reloadClasses(String[] stringArray) {
        if (this.classReloaderThread == null) {
            return;
        }
        this.classReloaderThread.reloadClasses(stringArray);
    }

    public boolean canResume() {
        if (this.getProcess() != null) {
            return !this.getProcess().isTerminated() && this.isSuspended();
        }
        return !this.isDisconnected() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void resume() throws DebugException {
        this.putCommand("continue");
    }

    public void suspend() throws DebugException {
        this.invoker.suspend();
    }

    public void putInput(String string) {
        this.invoker.putInput(string);
    }

    public void putCommand(String string) {
        if (this.job != null) {
            this.job.setCommandLine(string);
        }
    }

    private void started() {
        this.fireCreationEvent();
    }

    private void installDeferredBreakpoints() {
        int n;
        IDebugHelper iDebugHelper = (IDebugHelper)this.getAdapter(IDebugHelper.class);
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("IscobolDebugModel");
        DebugResponse debugResponse = null;
        for (n = 0; n < iBreakpointArray.length; ++n) {
            if (!(iBreakpointArray[n] instanceof IscobolBreakpoint)) continue;
            debugResponse = this.installDeferredBreakpoint(iBreakpointArray[n], iDebugHelper);
        }
        for (n = 0; n < iBreakpointArray.length; ++n) {
            if (!(iBreakpointArray[n] instanceof IscobolWatchpoint) || (debugResponse = this.installDeferredBreakpoint(iBreakpointArray[n], iDebugHelper)).getReturnCode() != 0) continue;
            IscobolWatchpoint iscobolWatchpoint = (IscobolWatchpoint)iBreakpointArray[n];
            this.monitorTable.put(this.getKey(iscobolWatchpoint), iscobolWatchpoint);
        }
        this.updateMonitors(debugResponse);
    }

    private DebugResponse installDeferredBreakpoint(IBreakpoint iBreakpoint, IDebugHelper iDebugHelper) {
        DebugResponse debugResponse = null;
        try {
            debugResponse = null;
            String string = this.makeCommand(iBreakpoint, iDebugHelper);
            if (string != null) {
                debugResponse = this.processCommand(string);
            }
            if (debugResponse != null && debugResponse.getReturnCode() != 0) {
                iBreakpoint.getMarker().setAttribute("SKIP_EVENT", true);
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(iBreakpoint, true);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return debugResponse;
    }

    private void suspended(int n) {
        this.suspended = true;
        if (this.currThread != null) {
            this.currThread.fireSuspendEvent(n);
        }
    }

    private void resumed(int n) {
        this.suspended = false;
        if (this.currThread != null) {
            this.currThread.fireResumeEvent(n);
        }
        this.resetCurrentLine();
    }

    public void breakpointAdded(IBreakpoint iBreakpoint) {
        try {
            if (iBreakpoint.getMarker().getAttribute("SKIP_EVENT", false)) {
                return;
            }
            if (iBreakpoint instanceof IscobolBreakpoint) {
                IDebugHelper iDebugHelper = (IDebugHelper)this.getAdapter(IDebugHelper.class);
                String string = this.makeBreakpointCommand((IscobolBreakpoint)iBreakpoint, iDebugHelper);
                if (this.job != null && this.job.getCommandLine() == null) {
                    this.putCommand(string);
                } else {
                    this.breakpointCommands.add(string);
                }
            } else if (iBreakpoint instanceof IscobolWatchpoint) {
                IscobolWatchpoint iscobolWatchpoint = (IscobolWatchpoint)iBreakpoint;
                String string = this.makeWatchpointCommand(iscobolWatchpoint);
                this.monitorTable.put(this.getKey(iscobolWatchpoint), iscobolWatchpoint);
                if (this.job != null && this.job.getCommandLine() == null) {
                    this.putCommand(string);
                } else {
                    this.breakpointCommands.add(string);
                }
            }
            PluginUtilities.showView((String)"org.eclipse.debug.ui.BreakpointView");
        }
        catch (CoreException coreException) {
            PluginUtilities.log((Throwable)coreException);
        }
    }

    private String makeCommand(IBreakpoint iBreakpoint, IDebugHelper iDebugHelper) throws CoreException {
        if (iBreakpoint instanceof IscobolBreakpoint) {
            return this.makeBreakpointCommand((IscobolBreakpoint)iBreakpoint, iDebugHelper);
        }
        if (iBreakpoint instanceof IscobolWatchpoint) {
            return this.makeWatchpointCommand((IscobolWatchpoint)iBreakpoint);
        }
        return null;
    }

    private String makeWatchpointCommand(IscobolWatchpoint iscobolWatchpoint) {
        return iscobolWatchpoint.getDebugCommand();
    }

    private String makeBreakpointCommand(IscobolBreakpoint iscobolBreakpoint, IDebugHelper iDebugHelper) throws CoreException {
        StringBuilder stringBuilder = new StringBuilder();
        if (iscobolBreakpoint.getProgramName() != null) {
            stringBuilder.append("b0");
            if (!iscobolBreakpoint.isEnabled()) {
                stringBuilder.append(" -d");
            }
            stringBuilder.append(" ").append(iscobolBreakpoint.getProgramName());
        } else {
            stringBuilder.append("break");
            if (!iscobolBreakpoint.isEnabled()) {
                stringBuilder.append(" -d");
            }
            int n = iDebugHelper.getLineNumber(iscobolBreakpoint);
            stringBuilder.append(" " + n);
            String string = iDebugHelper.getFileName(iscobolBreakpoint);
            stringBuilder.append(" " + string);
            String string2 = iscobolBreakpoint.getVariableName();
            String string3 = iscobolBreakpoint.getEnvName();
            if (string2 != null || string3 != null) {
                stringBuilder.append(" when");
                if (string3 != null) {
                    stringBuilder.append(" -env " + string3);
                } else {
                    boolean bl = iscobolBreakpoint.isHexadecimal();
                    if (bl) {
                        stringBuilder.append(" -x ");
                    }
                    stringBuilder.append(" " + string2);
                }
            }
        }
        return stringBuilder.toString();
    }

    public void breakpointChanged(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        this.breakpointAdded(iBreakpoint);
    }

    public void breakpointRemoved(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        if (iBreakpoint.getMarker().getAttribute("SKIP_EVENT", false)) {
            return;
        }
        if (iBreakpoint instanceof IscobolBreakpoint) {
            this.removeBreakpoint((IscobolBreakpoint)iBreakpoint);
        } else if (iBreakpoint instanceof IscobolWatchpoint) {
            this.removeMonitor((IscobolWatchpoint)iBreakpoint);
        }
    }

    private void removeBreakpoint(IscobolBreakpoint iscobolBreakpoint) {
        String string = "clear";
        string = string + " " + iscobolBreakpoint.getLineNumber();
        string = string + " " + iscobolBreakpoint.getFilename();
        if (this.job != null && this.job.getCommandLine() == null) {
            this.putCommand(string);
        } else {
            this.breakpointCommands.add(string);
        }
    }

    private void removeMonitor(IscobolWatchpoint iscobolWatchpoint) {
        String string = iscobolWatchpoint.getDebugDelCommand();
        if (this.job != null && this.job.getCommandLine() == null) {
            this.putCommand(string);
        } else {
            this.breakpointCommands.add(string);
        }
        this.monitorTable.remove(this.getKey(iscobolWatchpoint));
    }

    public boolean canDisconnect() {
        return !this.disconnected;
    }

    public void disconnect() throws DebugException {
        this.terminate();
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public IMemoryBlock getMemoryBlock(long l, long l2) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "com.iscobol.plugins.editor.IscobolEditor", 5011, IsresourceBundle.getString((String)"op_not_supported_msg"), null));
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    void setTextCommand(String string) {
        if (string != null) {
            if (string.length() == 0 && this.lastCommandStr != null) {
                string = this.lastCommandStr;
            }
            if (string.length() > 0) {
                this.lastCommandStr = string.trim();
                this.tm = new DebugTM(this.lastCommandStr, " ,;(:=)+*\"<>", DebuggerInvoker.standardCommands);
                int n = -1;
                try {
                    n = this.tm.getCommand(this.tm.getToken());
                }
                catch (DebuggerException debuggerException) {
                    PluginUtilities.logError((String)debuggerException.getMessage());
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    PluginUtilities.logError((String)(IsresourceBundle.getString((String)"internal_error_msg") + " " + this.lastCommandStr));
                    return;
                }
                this.process(n);
            }
        }
    }

    private Collection<VarName> getCurrentVarnames(int n, String string, int n2, int n3, int n4, int n5) {
        DebugResponse debugResponse;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        MyDebugInfo myDebugInfo = (MyDebugInfo)this.debugInfos.get(string);
        if (myDebugInfo == null && (debugResponse = this.processCommand((DebugCommand)new GetInfoCommand(154, string))) != null && debugResponse.getInfo() != null) {
            myDebugInfo = new MyDebugInfo(null);
            this.debugInfos.put(string, myDebugInfo);
            myDebugInfo.info = debugResponse.getInfo();
            int n6 = 0;
            String[] stringArray = debugResponse.getInfo().getCompilerOptions();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-st")) {
                    n6 = 2;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-sa")) {
                    n6 = 1;
                    continue;
                }
                if (!stringArray[i].equalsIgnoreCase("-sf")) continue;
                n6 = 3;
            }
            Object object = this.project != null ? new ProjectFileLoader(this.project) : new WorkspaceFileLoader();
            try {
                myDebugInfo.listing = new Listing((IFileLoader)object, debugResponse.getInfo().getCopyfiles(), new Filename(debugResponse.getInfo().getSourcefile()), n6, false);
                myDebugInfo.lines = myDebugInfo.listing.getLines();
            }
            catch (ListingException listingException) {
                return linkedHashMap.values();
            }
        }
        if (myDebugInfo == null || myDebugInfo.listing == null) {
            return linkedHashMap.values();
        }
        linkedHashMap.putAll(this.getStatementVarNames(n2, n3, myDebugInfo, n));
        if (n4 > 0) {
            linkedHashMap.putAll(this.getStatementVarNames(n4, n5, myDebugInfo, n));
        }
        return linkedHashMap.values();
    }

    Map<String, VarName> getStatementVarNames(int n, int n2, MyDebugInfo myDebugInfo, int n3) {
        CobolRef cobolRef;
        int n4 = -1;
        Listing listing = myDebugInfo.listing;
        DebugLine[] debugLineArray = myDebugInfo.info.getLines();
        int n5 = listing.getLength();
        for (int i = 0; i < debugLineArray.length; ++i) {
            if (debugLineArray[i].getLineNumber() != n || debugLineArray[i].getFileIndex() != n2) continue;
            n4 = listing.toListingLine(debugLineArray[i].getLineNumber(), n2);
            if (i >= debugLineArray.length - 1) break;
            n5 = listing.toListingLine(debugLineArray[i + 1].getLineNumber(), debugLineArray[i + 1].getFileIndex()) - 1;
            break;
        }
        LinkedHashMap<String, VarName> linkedHashMap = new LinkedHashMap<String, VarName>();
        if (n4 < 0) {
            return linkedHashMap;
        }
        for (int i = n4; i <= n5 && (cobolRef = listing.toCobolLine(i)) != null; ++i) {
            List list = this.getVarnames(myDebugInfo.lines[i], n3, Collections.EMPTY_SET, new Hashtable());
            for (String string : list) {
                try {
                    VarName varName = IscobolDebugTarget.createVarName((String)string);
                    linkedHashMap.put(string.toLowerCase(), varName);
                }
                catch (DebuggerException debuggerException) {}
            }
        }
        return linkedHashMap;
    }

    /*
     * Unable to fully structure code
     */
    private List<String> getVarnames(String var1_1, int var2_2, Set<String> var3_3, Hashtable var4_4) {
        var7_5 = new ArrayList<String>();
        var8_6 = new TokenList();
        PreProcessor.tokenizer((TokenList)var8_6, (StringBuffer)new StringBuffer(var1_1), (int)0, (String)"", (boolean)false, (char)'.', null, (boolean)false, (boolean)true, (int)var2_2, (boolean)false);
        var9_7 = var8_6.getFirst();
        while (var9_7 != null) {
            if (var9_7.getToknum() == 10000) {
                var9_7.putKeyword(var4_4);
            }
            var9_7 = var8_6.getNext();
        }
        var9_7 = null;
        var10_8 = var8_6.getFirst();
        while (var10_8 != null) {
            block12: {
                block13: {
                    if (var10_8.getToknum() != 10009) break block12;
                    var11_11 = var8_6.getCurrentIndex();
                    var9_7 = new StringBuffer();
                    var9_7.append(var10_8.getOriginalWord()).append(" ");
                    var12_12 = var8_6.getNext();
                    while (var12_12 != null && (var12_12.getToknum() == 603 || var12_12.getToknum() == 522)) {
                        var9_7.append(var12_12.getOriginalWord()).append(" ");
                        var12_12 = var8_6.getNext();
                        if (var12_12 != null && var12_12.getToknum() == 10009) {
                            var9_7.append(var12_12.getOriginalWord()).append(" ");
                            var12_12 = var8_6.getNext();
                            continue;
                        }
                        var9_7 = null;
                        var10_8 = var8_6.getAt(var11_11);
                        break block12;
                    }
                    if (var12_12 == null || var12_12.getToknum() != 40) ** GOTO lbl-1000
                    var13_13 = 1;
                    var9_7.append(var12_12.getOriginalWord()).append(" ");
                    var12_12 = var8_6.getNext();
                    while (var12_12 != null) {
                        var9_7.append(var12_12.getOriginalWord()).append(" ");
                        if (var12_12.getToknum() == 40) {
                            ++var13_13;
                        }
                        if (var12_12.getToknum() == 41 && --var13_13 <= 0) break;
                        var12_12 = var8_6.getNext();
                    }
                    if (var13_13 == 0) break block13;
                    var9_7 = null;
                    var10_8 = var8_6.getAt(var11_11);
                    break block12;
                }
                var14_14 = var8_6.getNext();
                if (var14_14 == null || var14_14.getToknum() != 40) ** GOTO lbl-1000
                var13_13 = 1;
                var9_7.append(var14_14.getOriginalWord()).append(" ");
                var14_14 = var8_6.getNext();
                while (var14_14 != null) {
                    var9_7.append(var14_14.getOriginalWord()).append(" ");
                    if (var14_14.getToknum() == 40) {
                        ++var13_13;
                    }
                    if (var14_14.getToknum() == 41 && --var13_13 <= 0) break;
                    var14_14 = var8_6.getNext();
                }
                if (var13_13 != 0) {
                    var9_7 = null;
                    var10_8 = var8_6.getAt(var11_11);
                } else lbl-1000:
                // 3 sources

                {
                    if (var4_4.contains(var6_10 = (var5_9 = var9_7.toString().trim()).toUpperCase()) || !Tokens.statements.contains(var6_10) && !Tokens.keywords.contains(var6_10) && !var3_3.contains(var6_10)) {
                        var7_5.add(var5_9);
                    }
                    var10_8 = var8_6.getAt(var11_11);
                }
            }
            var10_8 = var8_6.getNext();
        }
        return var7_5;
    }

    private void process(int n) {
        try {
            this.lastCommand = this.invoker.parseCommand(n, this.tm);
        }
        catch (DebuggerException debuggerException) {
            PluginUtilities.logError((String)debuggerException.getMessage());
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PluginUtilities.logError((String)(IsresourceBundle.getString((String)"internal_error_msg") + " " + this.lastCommandStr));
            return;
        }
        int n2 = -1;
        int n3 = this.lastCommand.getId();
        switch (n3) {
            case 1: 
            case 12: 
            case 16: {
                n2 = 32;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
            case 10: 
            case 11: {
                n2 = 4;
            }
        }
        this.genericCommand(n2);
    }

    private void genericCommand(int n) {
        if (n >= 0) {
            this.resumed(n);
        }
        DebugResponse debugResponse = null;
        debugResponse = this.processCommand(this.lastCommand);
        this.handleResponse(debugResponse);
    }

    boolean isCurrentThread(IscobolThread iscobolThread) {
        return this.currThread == iscobolThread;
    }

    public IscobolThread getCurrentThread() {
        return this.currThread;
    }

    private void handleResponse(DebugResponse debugResponse) {
        IscobolStackFrame iscobolStackFrame = null;
        IscobolEditor iscobolEditor = null;
        boolean bl = debugResponse != null ? debugResponse.getReturnCode() == 103 || debugResponse.getReturnCode() == 104 || debugResponse.getReturnCode() == 105 : true;
        if (bl) {
            this.terminated();
            if (debugResponse.getReturnCode() == 104) {
                iscobolStackFrame = new IscobolStackFrame("", debugResponse.getLastFile(), debugResponse.getLine(), debugResponse.getLastProgram(), this.currThread, (IDebugTarget)this, this.getLaunch());
                iscobolEditor = this.getEditor(iscobolStackFrame);
                this.setDebugCurrentLine(iscobolEditor, debugResponse);
            }
            return;
        }
        int n = debugResponse.getReturnCode();
        int n2 = debugResponse.getLastCmd();
        switch (n) {
            case 0: 
            case 20: {
                break;
            }
            case 101: {
                break;
            }
            case 102: {
                PluginUtilities.logMessage((String)(IsresourceBundle.getString((String)"change_var_msg") + " " + debugResponse.getVarName()), (int)2);
                break;
            }
            default: {
                switch (n2) {
                    case 0: 
                    case 13: {
                        if (this.lastBreakpoint == null) break;
                        try {
                            this.lastBreakpoint.getMarker().setAttribute("SKIP_EVENT", true);
                            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(this.lastBreakpoint, true);
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                        if (!(this.lastBreakpoint instanceof IscobolWatchpoint)) break;
                        this.monitorTable.remove(this.getKey((IscobolWatchpoint)this.lastBreakpoint));
                    }
                }
                PluginUtilities.logError((String)debugResponse.getMessage().substring(2));
                return;
            }
        }
        IscobolThread iscobolThread = this.currThread;
        this.executeBreakpointCommands();
        switch (n2) {
            case 1: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 29: {
                ThreadObject[] threadObjectArray = debugResponse.getThreads();
                String string = debugResponse.getLastFile();
                if (this.project != null && string != null) {
                    string = PluginUtilities.makeRelative((String)string, (IProject)this.project);
                }
                if (threadObjectArray != null) {
                    try {
                        this.removeTerminatedThreads(threadObjectArray);
                        this.addNewThreads(threadObjectArray);
                        this.initThreads(threadObjectArray);
                        this.currThread = (IscobolThread)this.threads.get(new Integer(debugResponse.getCurrentThread().getId()));
                        if (this.currThread != null) {
                            iscobolStackFrame = this.currThread.frames != null && this.currThread.frames.length > 0 ? this.currThread.frames[0] : new IscobolStackFrame("", debugResponse.getLastFile(), debugResponse.getLine(), debugResponse.getLastProgram(), this.currThread, (IDebugTarget)this, this.getLaunch());
                        }
                    }
                    catch (DebugException debugException) {
                        // empty catch block
                    }
                }
                if (iscobolStackFrame != null) {
                    iscobolEditor = this.getEditor(iscobolStackFrame);
                }
                if (iscobolEditor != null) {
                    int n3;
                    int n4;
                    if (this.currThread != null && this.currThread.frames.length == 0) {
                        this.setDebugCurrentLine(iscobolEditor, debugResponse);
                    }
                    if (debugResponse.getLastProgram().equals(debugResponse.getOldProgram())) {
                        n4 = debugResponse.getOldLine();
                        n3 = debugResponse.getOldFileIndex();
                    } else {
                        n4 = -1;
                        n3 = -1;
                    }
                    Collection collection = this.getCurrentVarnames(iscobolEditor.getFormat(), debugResponse.getLastClass(), debugResponse.getLine(), debugResponse.getLastFileIndex(), n4, n3);
                    this.getVariables(collection, ((IscobolVariable)this.variables.get(0)).getVariables());
                }
                this.getVariables(addedVarnames.values(), ((IscobolVariable)this.variables.get(1)).getVariables());
                break;
            }
            case 5: {
                if (debugResponse.getVarName() != null || debugResponse.getTree() != null) {
                    String string = debugResponse.getVarName();
                    String string2 = debugResponse.getVarValue();
                    this.displayMessage(string + " = " + string2);
                    break;
                }
                this.handleDisplayEnvCommand(debugResponse);
                break;
            }
            case 26: {
                this.handleDisplayEnvCommand(debugResponse);
                break;
            }
            case 6: {
                if (debugResponse.getVarName() != null) break;
                this.displayMessage(debugResponse.getMessage().substring(2));
                break;
            }
        }
        this.updateMonitors(debugResponse);
        this.lastBreakpoint = null;
        switch (n) {
            case 101: 
            case 102: {
                this.suspended(16);
                break;
            }
            default: {
                if (iscobolThread != this.currThread) {
                    this.suspended(16);
                    break;
                }
                this.suspended(8);
            }
        }
    }

    private void setDebugCurrentLine(IscobolEditor iscobolEditor, DebugResponse debugResponse) {
        IscobolEditor iscobolEditor2 = iscobolEditor;
        DebugResponse debugResponse2 = debugResponse;
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private IscobolEditor getEditor(IscobolStackFrame iscobolStackFrame) {
        IscobolEditor iscobolEditor = null;
        if (iscobolStackFrame != null) {
            IFile iFile;
            ISourceLookupResult iSourceLookupResult = DebugUITools.lookupSource((Object)iscobolStackFrame, (ISourceLocator)this.getLaunch().getSourceLocator());
            Object object = iSourceLookupResult.getSourceElement();
            if (object instanceof IFile && "isp".equals((iFile = (IFile)object).getFileExtension()) && this.ipb != null) {
                iscobolEditor = this.ipb.getIscobolEditor(iFile);
            }
            if (iscobolEditor == null) {
                iscobolEditor = PluginUtilities.findIscobolEditorForInput((IEditorInput)iSourceLookupResult.getEditorInput());
            }
            if (iscobolEditor == null) {
                iscobolEditor = IscobolDebugTarget.openEditor((IEditorInput)iSourceLookupResult.getEditorInput());
            }
        }
        return iscobolEditor;
    }

    private void getVariables(Collection<VarName> collection, List<IscobolVariable> list) {
        TreeNode[] treeNodeArray;
        if (collection.isEmpty()) {
            list.clear();
            return;
        }
        int n = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.maxhexdumplength");
        int n2 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.hexdumpstartoffset");
        int n3 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.maxarraylength");
        int n4 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.startarrayindex");
        int n5 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.maxtextlength");
        GetVariablesCommand getVariablesCommand = new GetVariablesCommand(collection.toArray(new VarName[collection.size()]), n, n2, n3, n4, n5);
        DebugResponse debugResponse = this.processCommand((DebugCommand)getVariablesCommand);
        Tree tree = debugResponse.getTree();
        if (tree != null && (treeNodeArray = tree.getRoot().getChildren()).length > 0) {
            IscobolVariable iscobolVariable;
            int n6;
            ArrayList<IscobolVariable> arrayList = new ArrayList<IscobolVariable>();
            ArrayList<TreeNode> arrayList2 = new ArrayList<TreeNode>();
            for (n6 = 0; n6 < treeNodeArray.length; ++n6) {
                iscobolVariable = new IscobolVariable(treeNodeArray[n6], null, (IDebugTarget)this, this.getLaunch());
                arrayList.add(iscobolVariable);
                arrayList2.add(treeNodeArray[n6]);
            }
            n6 = 0;
            while (n6 < list.size()) {
                iscobolVariable = list.get(n6);
                int n7 = arrayList.indexOf(iscobolVariable);
                if (n7 < 0) {
                    list.remove(n6);
                    continue;
                }
                iscobolVariable.setValue((TreeNode)arrayList2.get(n7), true);
                arrayList.remove(n7);
                arrayList2.remove(n7);
                ++n6;
            }
            list.addAll(arrayList);
        }
    }

    public static VarName createVarName(String string) throws DebuggerException {
        DebugTM debugTM = new DebugTM(string, " ,;(:=)+*\"<>", new DebugCommand[0]);
        return new VarName(debugTM);
    }

    public void refreshVariables() {
        if (this.variables.isEmpty()) {
            return;
        }
        for (IscobolVariable iscobolVariable : this.variables) {
            this.refreshVariables((Collection)IscobolDebugTarget.getVarnames((List)iscobolVariable.getVariables()), iscobolVariable.getVariables());
        }
    }

    private static List<VarName> getVarnames(List<IscobolVariable> list) {
        ArrayList<VarName> arrayList = new ArrayList<VarName>();
        for (IscobolVariable iscobolVariable : list) {
            try {
                arrayList.add(IscobolDebugTarget.createVarName((String)iscobolVariable.getName()));
            }
            catch (DebuggerException debuggerException) {}
        }
        return arrayList;
    }

    private void refreshVariables(Collection<VarName> collection, List<IscobolVariable> list) {
        IscobolVariable iscobolVariable2;
        if (collection.isEmpty()) {
            return;
        }
        int n = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.maxhexdumplength");
        int n2 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.hexdumpstartoffset");
        int n3 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.maxarraylength");
        int n4 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.startarrayindex");
        int n5 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.maxtextlength");
        for (IscobolVariable iscobolVariable2 : list) {
            try {
                ((IscobolValue)iscobolVariable2.getValue()).setNeedRefresh(true);
            }
            catch (DebugException debugException) {}
        }
        GetVariablesCommand getVariablesCommand = new GetVariablesCommand(collection.toArray(new VarName[collection.size()]), n, n2, n3, n4, n5);
        iscobolVariable2 = this.processCommand((DebugCommand)getVariablesCommand);
        Tree tree = iscobolVariable2.getTree();
        if (tree != null) {
            TreeNode[] treeNodeArray = tree.getRoot().getChildren();
            for (int i = 0; i < treeNodeArray.length; ++i) {
                Object object2;
                IscobolVariable iscobolVariable3 = null;
                for (Object object2 : list) {
                    if (!object2.getName().equals(treeNodeArray[i].getVarName())) continue;
                    iscobolVariable3 = object2;
                    break;
                }
                if (iscobolVariable3 == null) {
                    iscobolVariable3 = new IscobolVariable(treeNodeArray[i], null, (IDebugTarget)this, this.getLaunch());
                    list.add(0, iscobolVariable3);
                }
                DebugUtilities.VarValue varValue = DebugUtilities.parseVarValue((String)treeNodeArray[i].getVarValue());
                iscobolVariable3.setHexDump(varValue.hexDump);
                object2 = IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.variableview.showhex") ? IscobolDebugTarget.getValueString((String)varValue.hexDump) : varValue.textValue;
                try {
                    ((IscobolValue)iscobolVariable3.getValue()).setValueString((String)object2);
                    continue;
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
            }
        }
    }

    public static String getValueString(String string) {
        String string2;
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                int n = string3.indexOf(58) + 1;
                int n2 = string3.indexOf(45);
                int n3 = n2 >= 0 ? Math.min(string3.indexOf(91), n2) : string3.indexOf(91);
                char[] cArray = string3.toCharArray();
                for (int i = n + 1; i < n3; ++i) {
                    if (cArray[i] == ' ') continue;
                    stringBuilder.append(cArray[i]);
                }
                string3 = bufferedReader.readLine();
            }
            string2 = stringBuilder.toString();
        }
        catch (IOException iOException) {
            string2 = "";
        }
        return string2;
    }

    void handleDisplayEnvCommand(DebugResponse debugResponse) {
        String string = debugResponse.getMessage().substring(2);
        String string2 = "";
        int n = string.indexOf(61);
        if (n >= 0) {
            string2 = n < string.length() - 1 ? string.substring(n + 1).trim() : "";
            string = string.substring(0, n).trim();
        }
        this.displayMessage(string + " = " + string2);
    }

    public synchronized DebugResponse processCommand(String string) {
        return this.invoker.processCommand(string);
    }

    public synchronized DebugResponse processCommand(DebugCommand debugCommand) {
        return this.invoker.processCommand(debugCommand);
    }

    private void updateMonitors(DebugResponse debugResponse) {
        if (debugResponse == null) {
            return;
        }
        Watch[] watchArray = debugResponse.getMonitors();
        if (watchArray != null) {
            for (int i = 0; i < watchArray.length; ++i) {
                IscobolWatchpoint iscobolWatchpoint = (IscobolWatchpoint)this.monitorTable.get(this.getKey(watchArray[i]));
                if (iscobolWatchpoint == null) continue;
                iscobolWatchpoint.setValue(watchArray[i].getValue());
            }
            IscobolDebugTarget.refreshBreakpointView();
        }
    }

    private void displayMessage(String string) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private String getKey(IscobolWatchpoint iscobolWatchpoint) {
        String string = iscobolWatchpoint.getEnvName();
        if (string != null) {
            return string.toUpperCase();
        }
        string = iscobolWatchpoint.getClassName() + "." + iscobolWatchpoint.getVariableName("");
        String string2 = iscobolWatchpoint.getPropertyName();
        if (string2 != null) {
            string = string + "." + string2;
        }
        return string.toUpperCase();
    }

    private String getKey(Watch watch) {
        String string = watch.getEnvProperty();
        if (string != null) {
            return string.toUpperCase();
        }
        string = watch.getClassname() + "." + watch.getFullName();
        String string2 = watch.getPropName();
        if (string2 != null) {
            string = string + "." + string2;
        }
        return string.toUpperCase();
    }

    private void executeBreakpointCommands() {
        int n = this.breakpointCommands.size();
        for (int i = 0; i < n; ++i) {
            this.processCommand((String)this.breakpointCommands.get(i));
        }
        this.breakpointCommands.clear();
    }

    public IProject getProject() {
        return this.project;
    }

    private void removeTerminatedThreads(ThreadObject[] threadObjectArray) throws DebugException {
        Vector<IscobolThread> vector = new Vector<IscobolThread>();
        IscobolThread[] iscobolThreadArray = this.threads.values().toArray(new IscobolThread[this.threads.size()]);
        for (IscobolThread iscobolThread : iscobolThreadArray) {
            boolean bl = false;
            for (ThreadObject threadObject : threadObjectArray) {
                if (iscobolThread.getId() != threadObject.getId()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            vector.addElement(iscobolThread);
        }
        for (IscobolThread iscobolThread : vector) {
            this.threads.remove(new Integer(iscobolThread.getId()));
            iscobolThread.fireTerminateEvent();
        }
    }

    void addNewThreads(ThreadObject[] threadObjectArray) throws DebugException {
        int n;
        Vector<IscobolThread> vector = new Vector<IscobolThread>();
        for (n = 0; n < threadObjectArray.length; ++n) {
            Integer n2 = new Integer(threadObjectArray[n].getId());
            if (this.threads.get(n2) != null) continue;
            IscobolThread iscobolThread = new IscobolThread((IDebugTarget)this, this.getLaunch());
            vector.addElement(iscobolThread);
            this.threads.put(n2, iscobolThread);
        }
        n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((IscobolThread)vector.elementAt(i)).fireCreationEvent();
        }
    }

    void initThreads(ThreadObject[] threadObjectArray) throws DebugException {
        for (int i = 0; i < threadObjectArray.length; ++i) {
            ((IscobolThread)this.threads.get(new Integer(threadObjectArray[i].getId()))).init(threadObjectArray[i]);
        }
    }

    private void resetCurrentLine() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean hasVariables() {
        return this.variables.size() > 0;
    }

    public IVariable[] getVariables() {
        return this.variables.toArray(new IVariable[this.variables.size()]);
    }

    public static void toggleLineBreakpoints(IEditorPart iEditorPart, TextSelection textSelection) throws CoreException {
        IscobolDebugTarget.toggleLineBreakpoints((IEditorPart)iEditorPart, (int)textSelection.getStartLine());
    }

    public static IscobolBreakpoint toggleLineBreakpoints(IEditorPart iEditorPart, int n) throws CoreException {
        if (iEditorPart != null) {
            IFile iFile;
            IBreakpoint[] iBreakpointArray;
            IStorage iStorage = (IStorage)iEditorPart.getEditorInput().getAdapter(IResource.class);
            if (iStorage == null) {
                iStorage = (IStorage)iEditorPart.getEditorInput().getAdapter(IStorage.class);
            }
            if (iEditorPart instanceof IscobolExpandedCopyEditor) {
                iBreakpointArray = (IBreakpoint[])iEditorPart;
                ExpandedCopyDocument expandedCopyDocument = (ExpandedCopyDocument)iBreakpointArray.getViewer().getDocument();
                iFile = expandedCopyDocument.getCopyFile(n);
                if (iFile != null) {
                    iStorage = iFile;
                }
                n = expandedCopyDocument.getFileRelativeLine(n - 1);
            }
            iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("IscobolDebugModel");
            for (int i = 0; i < iBreakpointArray.length; ++i) {
                if (!(iBreakpointArray[i] instanceof IscobolBreakpoint) || !((IscobolBreakpoint)iBreakpointArray[i]).equals(iStorage, n + 1)) continue;
                iBreakpointArray[i].delete();
                return null;
            }
            IscobolBreakpoint iscobolBreakpoint = new IscobolBreakpoint(iStorage, n + 1, iEditorPart);
            iFile = IscobolDebugTarget.getCurrent();
            if (iFile != null) {
                iFile.setLastBreakpoint((IBreakpoint)iscobolBreakpoint);
            }
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)iscobolBreakpoint);
            return iscobolBreakpoint;
        }
        return null;
    }

    public static boolean canToggleLineBreakpoints(IscobolEditor iscobolEditor, TextSelection textSelection) {
        if (iscobolEditor != null) {
            int n = textSelection.getStartLine();
            IDocument iDocument = iscobolEditor.getViewer().getDocument();
            String string = null;
            try {
                string = iDocument.get(iDocument.getLineOffset(n), iDocument.getLineLength(n));
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            return IscobolDebugTarget.canToggleLineBreakpoints((String)string);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canToggleLineBreakpoints(IFile iFile, int n) {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            inputStream = iFile.getContents();
            bufferedReader = new LineNumberReader(new InputStreamReader(inputStream));
            String string = ((LineNumberReader)bufferedReader).readLine();
            while (true) {
                if (string != null) {
                    if (((LineNumberReader)bufferedReader).getLineNumber() == n) {
                        boolean bl = IscobolDebugTarget.canToggleLineBreakpoints((String)string);
                        return bl;
                    }
                    string = ((LineNumberReader)bufferedReader).readLine();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static boolean canToggleLineBreakpoints(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        boolean bl = false;
        TokenList tokenList = PreProcessor.tokenizer((StringBuffer)new StringBuffer(string), (char)'.', (boolean)true, null);
        Token token = tokenList.getFirst();
        while (token != null && !bl) {
            if (IscobolEditor.isStatement((String)token.getWord())) {
                bl = true;
            }
            token = tokenList.getNext();
        }
        return bl;
    }

    public static IscobolWatchpoint findWatchpoint(IscobolEditor iscobolEditor, String string) throws CoreException {
        if (iscobolEditor != null) {
            IStorage iStorage = (IStorage)iscobolEditor.getEditorInput().getAdapter(IResource.class);
            if (iStorage == null) {
                iStorage = (IStorage)iscobolEditor.getEditorInput().getAdapter(IStorage.class);
            }
            IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("IscobolDebugModel");
            for (int i = 0; i < iBreakpointArray.length; ++i) {
                if (!(iBreakpointArray[i] instanceof IscobolWatchpoint) || !((IscobolWatchpoint)iBreakpointArray[i]).equals(iStorage, string, "", "")) continue;
                return (IscobolWatchpoint)iBreakpointArray[i];
            }
        }
        return null;
    }

    public static void toggleWatchpoints(IscobolEditor iscobolEditor, String string) throws CoreException {
        if (iscobolEditor != null) {
            IsFragment isFragment;
            IStorage iStorage = (IStorage)iscobolEditor.getEditorInput().getAdapter(IResource.class);
            if (iStorage == null) {
                iStorage = (IStorage)iscobolEditor.getEditorInput().getAdapter(IStorage.class);
            }
            if ((isFragment = iscobolEditor.findSelectedFragment(string)) != null && isFragment.getType() == 13) {
                int n = isFragment.getStartLine();
                IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("IscobolDebugModel");
                for (int i = 0; i < iBreakpointArray.length; ++i) {
                    if (!(iBreakpointArray[i] instanceof IscobolWatchpoint) || !((IscobolWatchpoint)iBreakpointArray[i]).equals(iStorage, string, "", "")) continue;
                    iBreakpointArray[i].delete();
                    return;
                }
                IscobolWatchpoint iscobolWatchpoint = new IscobolWatchpoint(string, iStorage, n + 1, iscobolEditor);
                IscobolDebugTarget iscobolDebugTarget = IscobolDebugTarget.getCurrent();
                if (iscobolDebugTarget != null) {
                    iscobolDebugTarget.setLastBreakpoint((IBreakpoint)iscobolWatchpoint);
                }
                DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)iscobolWatchpoint);
            }
        }
    }

    public static boolean canToggleWatchpoints(TextSelection textSelection) {
        return IscobolDebugTarget.canToggleWatchpoints((String)textSelection.getText());
    }

    public static boolean canToggleWatchpoints(String string) {
        boolean bl;
        IscobolDebugTarget iscobolDebugTarget = IscobolDebugTarget.getCurrent();
        boolean bl2 = bl = iscobolDebugTarget != null && iscobolDebugTarget.isSuspended() && string.length() > 0;
        if (!bl) {
            return false;
        }
        DebugResponse debugResponse = iscobolDebugTarget.processCommand("display " + string);
        return debugResponse != null && debugResponse.getReturnCode() == 0;
    }

    public static String getDescription(VarDecl varDecl, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(varDecl.getName());
        if (varDecl.hasChildren()) {
            stringBuilder.append(" group-item");
        } else if (varDecl.isObjectReference()) {
            stringBuilder.append(" object reference " + varDecl.getTypename());
        } else {
            if (varDecl.getPicture() != null) {
                stringBuilder.append(" pic " + varDecl.getPicture());
            }
            if (varDecl.getUsage() != null) {
                stringBuilder.append(" " + varDecl.getUsage());
            }
        }
        stringBuilder.append(" = " + string);
        return stringBuilder.toString();
    }

    public boolean isTracingEnabled() {
        return this.tracingEnabled;
    }

    public void setTracingEnabled(boolean bl) {
        this.tracingEnabled = bl;
    }

    public static void addVarName(VarName varName) {
        String string = varName.getFullName().toLowerCase();
        if (!addedVarnames.containsKey(string)) {
            addedVarnames.put(string, varName);
            IscobolDebugTarget iscobolDebugTarget = IscobolDebugTarget.getCurrent();
            List list = ((IscobolVariable)iscobolDebugTarget.variables.get(1)).getVariables();
            iscobolDebugTarget.refreshVariables(addedVarnames.values(), list);
            IscobolDebugTarget.refreshVariablesView();
            boolean bl = false;
            for (IscobolVariable iscobolVariable : list) {
                if (!iscobolVariable.getName().equalsIgnoreCase(varName.getFullName())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                PluginUtilities.logMessage((String)("Variable '" + varName.getFullName() + "' cannot be added"), (int)1);
            }
        } else {
            PluginUtilities.logMessage((String)("Variable '" + varName.getFullName() + "' has been already added"), (int)1);
        }
    }

    public static void removeVarName(VarName varName) {
        String string = varName.getFullName().toLowerCase();
        if (addedVarnames.containsKey(string)) {
            addedVarnames.remove(string);
            IscobolDebugTarget iscobolDebugTarget = IscobolDebugTarget.getCurrent();
            List list = ((IscobolVariable)iscobolDebugTarget.variables.get(1)).getVariables();
            for (IscobolVariable iscobolVariable : list) {
                if (!iscobolVariable.getName().equalsIgnoreCase(varName.getFullName())) continue;
                list.remove(iscobolVariable);
                break;
            }
            iscobolDebugTarget.refreshVariables(addedVarnames.values(), list);
            IscobolDebugTarget.refreshVariablesView();
        } else {
            PluginUtilities.logMessage((String)("Variable '" + varName.getFullName() + "' cannot be removed"), (int)1);
        }
    }

    static /* synthetic */ void access$000(IscobolDebugTarget iscobolDebugTarget) {
        iscobolDebugTarget.started();
    }

    static /* synthetic */ void access$100(IscobolDebugTarget iscobolDebugTarget, DebugResponse debugResponse) {
        iscobolDebugTarget.handleResponse(debugResponse);
    }

    static /* synthetic */ void access$200(IscobolDebugTarget iscobolDebugTarget) {
        iscobolDebugTarget.terminated();
    }

    static /* synthetic */ DebuggerInvoker access$300(IscobolDebugTarget iscobolDebugTarget) {
        return iscobolDebugTarget.invoker;
    }

    static /* synthetic */ boolean access$400(IscobolDebugTarget iscobolDebugTarget) {
        return iscobolDebugTarget.suspended;
    }

    static /* synthetic */ void access$500(IscobolDebugTarget iscobolDebugTarget) {
        iscobolDebugTarget.start();
    }
}

