/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.debug;

import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.util.editorinputs.IOFileStorage;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;

public class IscobolSourceContainer
extends AbstractSourceContainer {
    private IProject project;

    public IscobolSourceContainer(IProject iProject) {
        this.project = iProject;
    }

    public Object[] findSourceElements(String string) throws CoreException {
        File file = new File(string);
        if (file.isAbsolute()) {
            IFile iFile = PluginUtilities.getFileForLocation((String)file.getAbsolutePath());
            if (iFile != null) {
                return new Object[]{iFile};
            }
            return new Object[]{new IOFileStorage(file, false)};
        }
        IFile iFile = this.project.getFile((IPath)new Path(string));
        if (iFile.exists()) {
            return new Object[]{iFile};
        }
        string = file.getName();
        iFile = this.findFile((IContainer)this.project, string);
        if (iFile != null) {
            return new Object[]{iFile};
        }
        return new Object[0];
    }

    private IFile findFile(IContainer iContainer, String string) throws CoreException {
        IResource[] iResourceArray = iContainer.members();
        for (int i = 0; i < iResourceArray.length; ++i) {
            IFile iFile;
            if (iResourceArray[i] instanceof IFile) {
                if (!iResourceArray[i].exists() || !iResourceArray[i].getName().equals(string)) continue;
                return (IFile)iResourceArray[i];
            }
            if (!(iResourceArray[i] instanceof IFolder) || (iFile = this.findFile((IContainer)((IFolder)iResourceArray[i]), string)) == null) continue;
            return iFile;
        }
        return null;
    }

    public String getName() {
        return "isCOBOL Source Container";
    }

    public ISourceContainerType getType() {
        return null;
    }
}

