/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.debug;

import com.iscobol.plugins.editor.builder.IIscobolProjectBuilder;
import com.iscobol.plugins.editor.builder.SourceLocation;
import com.iscobol.plugins.editor.debug.IscobolDebugElement;
import com.iscobol.plugins.editor.debug.IscobolDebugTarget;
import com.iscobol.plugins.editor.debug.IscobolThread;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class IscobolStackFrame
extends IscobolDebugElement
implements IStackFrame,
IDisconnect {
    private String name;
    private int lineNumber;
    private IscobolThread thread;
    private String filename;
    private String progname;
    private String basefilename;

    public IscobolStackFrame(String string, String string2, int n, String string3, IscobolThread iscobolThread, IDebugTarget iDebugTarget, ILaunch iLaunch) {
        super(iDebugTarget, iLaunch);
        SourceLocation sourceLocation;
        IIscobolProjectBuilder iIscobolProjectBuilder;
        IFile iFile;
        this.name = string;
        this.lineNumber = n;
        this.thread = iscobolThread;
        this.filename = string2;
        this.basefilename = new File(this.filename).getName();
        this.progname = string3;
        IscobolDebugTarget iscobolDebugTarget = (IscobolDebugTarget)iDebugTarget;
        if (iscobolDebugTarget.getProject() != null && (iFile = iscobolDebugTarget.getProject().getFile(this.filename)).exists() && (iIscobolProjectBuilder = iscobolDebugTarget.getIscobolProjectBuilder()) != null && (sourceLocation = iIscobolProjectBuilder.getScreenProgramLocation(iFile, this.lineNumber)) != null) {
            this.filename = sourceLocation.getFile().getProjectRelativePath().toString();
            this.lineNumber = sourceLocation.getLineNumber();
            this.basefilename = sourceLocation.getFile().getName();
        }
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getLineNumber() throws DebugException {
        return this.lineNumber;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getBaseFilename() {
        return this.basefilename;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        return ((IscobolDebugTarget)this.getDebugTarget()).getVariables();
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return this.thread.isSuspended() && ((IscobolDebugTarget)this.getDebugTarget()).hasVariables();
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public boolean canDisconnect() {
        return this.thread.canDisconnect();
    }

    public boolean isDisconnected() {
        return this.thread.isDisconnected();
    }

    public void disconnect() throws DebugException {
        this.thread.disconnect();
    }

    public boolean equals(Object object) {
        if (!(object instanceof IscobolStackFrame)) {
            return false;
        }
        IscobolStackFrame iscobolStackFrame = (IscobolStackFrame)object;
        return this.name.equalsIgnoreCase(iscobolStackFrame.name) && this.basefilename.equalsIgnoreCase(iscobolStackFrame.basefilename) && this.lineNumber == iscobolStackFrame.lineNumber;
    }

    public String toString() {
        return this.name + " [" + this.progname + "]";
    }

    public void stepOutProgram() {
        this.thread.stepOutProgram();
    }

    public boolean canStepOutProgram() {
        return this.thread.canStepOutProgram();
    }
}

