/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.debug;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.debug.IscobolWatchpoint;
import com.iscobol.plugins.editor.util.PluginUtilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IWatchpoint;

public class IscobolWatchpoint
extends Breakpoint
implements IWatchpoint {
    public static final String rcsid = "$Id: IscobolWatchpoint.java,v 1.5 2008/10/02 11:53:37 gianni Exp $";
    public static final String PROPERTY_NAME = "propertyname";
    public static final String VAR_NAME = "varname";
    public static final String ENV_NAME = "envname";
    public static final String HEXADECIMAL = "hexadecimal";
    public static final String CONDITION_TYPE = "condition_type";
    public static final String CONDITION_VALUE = "condition_value";
    private String value;
    private String className;
    private IStorage storage;

    public IscobolWatchpoint() {
    }

    public IscobolWatchpoint(String string, String string2, String string3, boolean bl, boolean bl2, String string4, String string5, IStorage iStorage, int n, IscobolEditor iscobolEditor) throws CoreException {
        this.storage = iStorage;
        1 var11_11 = new /* Unavailable Anonymous Inner Class!! */;
        if (this.storage instanceof IFile) {
            this.run(this.getMarkerRule((IResource)((IFile)this.storage)), (IWorkspaceRunnable)var11_11);
        } else {
            this.run(null, (IWorkspaceRunnable)var11_11);
        }
    }

    public IscobolWatchpoint(String string, IStorage iStorage, int n, IscobolEditor iscobolEditor) throws CoreException {
        this(null, null, string, false, true, null, null, iStorage, n, iscobolEditor);
    }

    public void setLineNumber(int n) throws CoreException {
        this.getMarker().setAttribute("lineNumber", n);
    }

    public int getLineNumber() {
        return this.getMarker().getAttribute("lineNumber", 0);
    }

    public boolean isAccess() throws CoreException {
        return false;
    }

    public boolean isModification() throws CoreException {
        return true;
    }

    public void setAccess(boolean bl) throws CoreException {
    }

    public void setModification(boolean bl) throws CoreException {
    }

    public boolean supportsAccess() {
        return false;
    }

    public boolean supportsModification() {
        return true;
    }

    public String getModelIdentifier() {
        return "IscobolDebugModel";
    }

    public String getVariableName() {
        return this.getVariableName(null);
    }

    public String getVariableName(String string) {
        return this.getMarker().getAttribute(VAR_NAME, string);
    }

    public void setVariableName(String string) throws CoreException {
        this.getMarker().setAttribute(VAR_NAME, (Object)string);
    }

    public String getPropertyName() {
        return this.getPropertyName(null);
    }

    public String getPropertyName(String string) {
        return this.getMarker().getAttribute(PROPERTY_NAME, string);
    }

    public void setPropertyName(String string) throws CoreException {
        this.getMarker().setAttribute(PROPERTY_NAME, (Object)string);
    }

    public String getConditionType() {
        return this.getConditionType(null);
    }

    public String getConditionType(String string) {
        return this.getMarker().getAttribute(CONDITION_TYPE, string);
    }

    public void setConditionType(String string) throws CoreException {
        this.getMarker().setAttribute(CONDITION_TYPE, (Object)string);
    }

    public String getConditionValue() {
        return this.getConditionValue(null);
    }

    public String getConditionValue(String string) {
        return this.getMarker().getAttribute(CONDITION_VALUE, string);
    }

    public void setConditionValue(String string) throws CoreException {
        this.getMarker().setAttribute(CONDITION_VALUE, (Object)string);
    }

    public String getEnvName() {
        return this.getEnvName(null);
    }

    public String getEnvName(String string) {
        return this.getMarker().getAttribute(ENV_NAME, string);
    }

    public void setEnvName(String string) throws CoreException {
        this.getMarker().setAttribute(ENV_NAME, (Object)string);
    }

    public boolean isHexadecimal() {
        return this.isHexadecimal(false);
    }

    public boolean isHexadecimal(boolean bl) {
        return this.getMarker().getAttribute(HEXADECIMAL, bl);
    }

    public void setHexadecimal(boolean bl) throws CoreException {
        this.getMarker().setAttribute(HEXADECIMAL, bl);
    }

    public String getDebugCommand() {
        StringBuilder stringBuilder = new StringBuilder("monitor");
        boolean bl = true;
        try {
            bl = this.isEnabled();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (bl) {
            stringBuilder.append(" -e ");
        } else {
            stringBuilder.append(" -d ");
        }
        String string = this.getEnvName();
        if (string != null) {
            stringBuilder.append(" -env " + string);
        } else {
            stringBuilder.append(" -c " + this.getClassName());
            if (this.isHexadecimal()) {
                stringBuilder.append(" -x ");
            }
            stringBuilder.append(" " + this.getVariableName(""));
            string = this.getPropertyName();
            if (string != null) {
                stringBuilder.append(" property " + string);
            }
        }
        string = this.getConditionType();
        if (string != null) {
            stringBuilder.append(" when " + string + " " + this.getConditionValue(""));
        }
        return stringBuilder.toString();
    }

    public String getDebugDelCommand() {
        StringBuilder stringBuilder = new StringBuilder("unmonitor");
        String string = this.getEnvName();
        if (string != null) {
            stringBuilder.append(" -env " + string);
        } else {
            stringBuilder.append(" -c " + this.getClassName());
            stringBuilder.append(" " + this.getVariableName(""));
            string = this.getPropertyName();
            if (string != null) {
                stringBuilder.append(" property " + string);
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getEnvName();
        if (string != null) {
            stringBuilder.append("env::" + string);
        } else {
            stringBuilder.append(this.getClassName());
            stringBuilder.append(".");
            stringBuilder.append(this.getVariableName(""));
            string = this.getPropertyName();
            if (string != null) {
                stringBuilder.append("::" + string);
            }
        }
        stringBuilder.append(" = ");
        stringBuilder.append(this.value);
        return stringBuilder.toString();
    }

    public void setValue(String string) {
        this.value = string;
    }

    protected IMarker ensureMarker() throws DebugException {
        return this.getMarker();
    }

    public String getClassName() {
        if (this.className == null) {
            this.className = PluginUtilities.getIscobolClassName((String)this.getStorage().getName());
        }
        return this.className;
    }

    public IStorage getStorage() {
        if (this.storage != null) {
            return this.storage;
        }
        IResource iResource = this.getMarker().getResource();
        if (iResource instanceof IFile) {
            return (IFile)iResource;
        }
        return null;
    }

    public boolean equals(IStorage iStorage, String string, String string2, String string3) {
        return this.equals((Object)this.getStorage(), (Object)iStorage) && this.getVariableName("").equalsIgnoreCase(string) && this.getPropertyName("").equalsIgnoreCase(string2) && this.getEnvName("").equalsIgnoreCase(string3);
    }

    private boolean equals(Object object, Object object2) {
        if (object != null) {
            if (object2 != null) {
                return object.equals(object2);
            }
            return false;
        }
        return object2 == null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IscobolWatchpoint)) {
            return false;
        }
        IscobolWatchpoint iscobolWatchpoint = (IscobolWatchpoint)object;
        return this.equals(iscobolWatchpoint.getStorage(), iscobolWatchpoint.getVariableName(""), iscobolWatchpoint.getPropertyName(""), iscobolWatchpoint.getEnvName(""));
    }

    static /* synthetic */ IStorage access$000(IscobolWatchpoint iscobolWatchpoint) {
        return iscobolWatchpoint.storage;
    }
}

