/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.dialogs;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ChangeVariableValueInputDialog
extends Dialog {
    private String title;
    private String message;
    private String value;
    private IInputValidator validator;
    private Button okButton;
    private Text text;
    private Label errorMessageLabel;

    public ChangeVariableValueInputDialog(Shell shell, String string, String string2, String string3, IInputValidator iInputValidator) {
        super(shell);
        this.title = string;
        this.message = string2;
        this.value = string3;
        this.validator = iInputValidator;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int n) {
        this.value = n == 0 ? this.text.getText() : null;
        super.buttonPressed(n);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
            this.text.selectAll();
        }
    }

    protected Control createDialogArea(Composite composite) {
        Label label;
        Font font = composite.getFont();
        Composite composite2 = (Composite)super.createDialogArea(composite);
        if (this.message != null) {
            label = new Label(composite2, 64);
            label.setText(this.message);
            GridData gridData = new GridData(772);
            gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)gridData);
            label.setFont(font);
        }
        this.text = new Text(composite2, 2818);
        label = new GridData(1808);
        label.heightHint = 50;
        label.widthHint = 100;
        this.text.setLayoutData((Object)label);
        this.text.setFont(font);
        this.text.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.errorMessageLabel = new Label(composite2, 0);
        this.errorMessageLabel.setLayoutData((Object)new GridData(768));
        this.errorMessageLabel.setFont(font);
        return composite2;
    }

    protected Label getErrorMessageLabel() {
        return this.errorMessageLabel;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected Text getText() {
        return this.text;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        String string = null;
        if (this.validator != null) {
            string = this.validator.isValid(this.text.getText());
        }
        this.errorMessageLabel.setText(string == null ? "" : string);
        this.okButton.setEnabled(string == null);
        this.errorMessageLabel.getParent().update();
    }

    protected void okPressed() {
        this.validateInput();
        if (this.okButton.isEnabled()) {
            super.okPressed();
        }
    }

    protected String getDialogSettingsSectionName() {
        return "com.iscobol.plugins.editor.IscobolEditor.CHANGE_VARIABLE_VALUE_DIALOG_SECTION";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings iDialogSettings = IscobolEditorPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(this.getDialogSettingsSectionName());
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(this.getDialogSettingsSectionName());
        }
        return iDialogSettings2;
    }

    protected void handleShellCloseEvent() {
        this.value = null;
        super.handleShellCloseEvent();
    }

    static /* synthetic */ Button access$000(ChangeVariableValueInputDialog changeVariableValueInputDialog) {
        return changeVariableValueInputDialog.okButton;
    }

    static /* synthetic */ Label access$100(ChangeVariableValueInputDialog changeVariableValueInputDialog) {
        return changeVariableValueInputDialog.errorMessageLabel;
    }
}

