/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.dialogs;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.launch.externaltools.CopyGenManager;
import com.iscobol.plugins.editor.launch.externaltools.ExternalToolManager;
import com.iscobol.plugins.editor.util.ClasspathItem;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CopyGenDialog
extends Dialog {
    private Text fileSystemOutputTxt;
    private Text workspaceOutputTxt;
    private Button workspaceOutputBtn;
    private Button fileSystemOutputBtn;
    private Button workspaceOutputBrowseBtn;
    private Button fileSystemOutputBrowseBtn;
    private Text packageTxt;
    private List classList;
    private Button addBtn;
    private Button removeBtn;
    private Button removeAllBtn;
    private String pkg;
    private String outputDir;
    private String[] classNames;
    private ClassLoader cLoader;

    public CopyGenDialog(Shell shell) {
        super(shell);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        CopyGenManager copyGenManager = (CopyGenManager)ExternalToolManager.getInstance(CopyGenManager.class);
        for (ClasspathItem classpathItem : copyGenManager.getClasspath()) {
            if (!classpathItem.exists) continue;
            try {
                if (classpathItem.resource != null) {
                    arrayList.add(classpathItem.resource.getLocationURI().toURL());
                    continue;
                }
                arrayList.add(new File(classpathItem.path).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.cLoader = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), this.getClass().getClassLoader());
    }

    public String getOutputDirectory() {
        return this.outputDir;
    }

    public String getPackage() {
        return this.pkg;
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public void okPressed() {
        boolean bl = true;
        bl = this.workspaceOutputBtn.getSelection() ? (bl &= this.validateWorkspaceOutput()) : (bl &= this.validateFileSystemOutput());
        if (bl &= this.validateClassList()) {
            this.outputDir = this.workspaceOutputBtn.getSelection() ? ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(this.workspaceOutputTxt.getText())).getLocation().toString() : this.fileSystemOutputTxt.getText();
            this.classNames = this.classList.getItems();
            this.pkg = this.packageTxt.getText();
            super.okPressed();
        }
    }

    private void showErrorMessage(String string) {
        MessageBox messageBox = new MessageBox(this.getShell(), 33);
        messageBox.setText("Error");
        messageBox.setMessage(string);
        messageBox.open();
    }

    private boolean validateFileSystemOutput() {
        if (this.fileSystemOutputTxt.getText().length() > 0) {
            File file = new File(this.fileSystemOutputTxt.getText());
            if (file.exists() && file.isDirectory()) {
                return true;
            }
            this.showErrorMessage("Invalid Filesystem Output Directory");
            return false;
        }
        this.showErrorMessage("Set Filesystem Output Directory");
        return false;
    }

    private boolean validateClassList() {
        if (this.classList.getItemCount() == 0) {
            this.showErrorMessage("Set at least a Class Name");
            return false;
        }
        for (String string : this.classList.getItems()) {
            String string2 = this.validateClassName0(string);
            if (string2 == null) continue;
            this.showErrorMessage(string2);
            return false;
        }
        return true;
    }

    private String validateClassName(String string) {
        for (String string2 : this.classList.getItems()) {
            if (!string2.equals(string)) continue;
            return "Class already inserted";
        }
        return this.validateClassName0(string);
    }

    private String validateClassName0(String string) {
        String string2 = string;
        if (this.packageTxt.getText().length() > 0) {
            string2 = this.packageTxt.getText() + "." + string;
        }
        try {
            Class.forName(string2, false, this.cLoader);
            return null;
        }
        catch (Exception exception) {
            return "Class not found '" + string2 + "'";
        }
    }

    private boolean validateWorkspaceOutput() {
        if (this.workspaceOutputTxt.getText().length() > 0) {
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.workspaceOutputTxt.getText()));
            if (iResource instanceof IContainer) {
                return true;
            }
            this.showErrorMessage("Invalid Workspace Output Directory");
            return false;
        }
        this.showErrorMessage("Set Workspace Output Directory");
        return false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(IsresourceBundle.getString((String)"copygen_lbl") + " Utility");
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        Button button = super.createButton(composite, n, string, bl);
        if (n == 0) {
            button.setText("Run");
        }
        return button;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Package");
        this.packageTxt = new Text(composite2, 2048);
        this.packageTxt.setLayoutData((Object)new GridData(768));
        Group group = new Group(composite2, 0);
        group.setText("Class Names");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        this.classList = new List((Composite)group, 2564);
        gridData = new GridData(768);
        gridData.verticalSpan = 3;
        gridData.heightHint = 150;
        this.classList.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData();
        gridData2.widthHint = 100;
        gridData2.verticalAlignment = 128;
        this.addBtn = new Button((Composite)group, 8);
        this.addBtn.setText("Add");
        this.addBtn.setLayoutData((Object)gridData2);
        this.removeBtn = new Button((Composite)group, 8);
        this.removeBtn.setText("Remove");
        this.removeBtn.setLayoutData((Object)gridData2);
        this.removeAllBtn = new Button((Composite)group, 8);
        this.removeAllBtn.setText("Remove All");
        this.removeAllBtn.setLayoutData((Object)gridData2);
        Group group2 = new Group(composite2, 0);
        group2.setText("Output Directory");
        gridData = new GridData(768);
        group2.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group2.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        group2.setLayoutData((Object)gridData);
        this.workspaceOutputBtn = new Button((Composite)group2, 16);
        this.workspaceOutputBtn.setText("Workspace:");
        this.workspaceOutputBtn.setSelection(true);
        this.workspaceOutputTxt = new Text((Composite)group2, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 500;
        this.workspaceOutputTxt.setLayoutData((Object)gridData);
        this.workspaceOutputBrowseBtn = new Button((Composite)group2, 8);
        this.workspaceOutputBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.fileSystemOutputBtn = new Button((Composite)group2, 16);
        this.fileSystemOutputBtn.setText("Filesystem:");
        this.fileSystemOutputTxt = new Text((Composite)group2, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 500;
        this.fileSystemOutputTxt.setLayoutData((Object)gridData);
        this.fileSystemOutputTxt.setEnabled(false);
        this.fileSystemOutputBrowseBtn = new Button((Composite)group2, 8);
        this.fileSystemOutputBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.fileSystemOutputBrowseBtn.setEnabled(false);
        this.workspaceOutputBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileSystemOutputBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.workspaceOutputBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileSystemOutputBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeAllBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    static /* synthetic */ Text access$000(CopyGenDialog copyGenDialog) {
        return copyGenDialog.workspaceOutputTxt;
    }

    static /* synthetic */ Button access$100(CopyGenDialog copyGenDialog) {
        return copyGenDialog.workspaceOutputBrowseBtn;
    }

    static /* synthetic */ Text access$200(CopyGenDialog copyGenDialog) {
        return copyGenDialog.fileSystemOutputTxt;
    }

    static /* synthetic */ Button access$300(CopyGenDialog copyGenDialog) {
        return copyGenDialog.fileSystemOutputBrowseBtn;
    }

    static /* synthetic */ String access$400(CopyGenDialog copyGenDialog, String string) {
        return copyGenDialog.validateClassName(string);
    }

    static /* synthetic */ List access$500(CopyGenDialog copyGenDialog) {
        return copyGenDialog.classList;
    }
}

