/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.dialogs;

import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.debugger.tree.UserObject;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.debug.IscobolDebugTarget;
import com.iscobol.plugins.editor.debug.IscobolWatchpoint;
import com.iscobol.plugins.editor.dialogs.AcceptVariableDialog;
import com.iscobol.plugins.editor.dialogs.MonitorDialog;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class QuickWatchDialog
extends Dialog {
    private Combo varCmb;
    private Text propTxt;
    private Button hexChk;
    private Button refreshBtn;
    private Button modifyBtn;
    private Button addMonBtn;
    private Tree varTree;
    private String initVarname;
    private String[] itemsToAdd;
    private String currVarname;
    private static ArrayList items = new ArrayList();

    public QuickWatchDialog(Shell shell, String string, String[] stringArray) {
        super(shell);
        this.initVarname = string;
        this.itemsToAdd = stringArray;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(IsresourceBundle.getString((String)"quickwatch_title"));
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            string = IsresourceBundle.getString((String)"close_lbl");
        }
        return super.createButton(composite, n, string, bl);
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.getShell().setDefaultButton(this.refreshBtn);
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        int n;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(1808));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite3, 0);
        label.setText(IsresourceBundle.getString((String)"varname_lbl"));
        this.varCmb = new Combo(composite3, 0);
        this.varCmb.setLayoutData((Object)new GridData(768));
        label = new Label(composite3, 0);
        label.setText(IsresourceBundle.getString((String)"propname_lbl"));
        this.propTxt = new Text(composite3, 0);
        this.propTxt.setLayoutData((Object)new GridData(768));
        this.hexChk = new Button(composite3, 32);
        this.hexChk.setText(IsresourceBundle.getString((String)"display_var_as_hex_lbl"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.hexChk.setLayoutData((Object)gridData);
        this.varTree = new Tree(composite3, 68356);
        this.varTree.setLinesVisible(true);
        this.varTree.setHeaderVisible(true);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 505;
        gridData.heightHint = 400;
        this.varTree.setLayoutData((Object)gridData);
        TreeColumn treeColumn = new TreeColumn(this.varTree, 0);
        treeColumn.setWidth(150);
        treeColumn.setText("Name");
        TreeColumn treeColumn2 = new TreeColumn(this.varTree, 0);
        treeColumn2.setWidth(350);
        treeColumn2.setText("Value");
        Composite composite4 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        composite4.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        composite4.setLayoutData((Object)gridData);
        this.refreshBtn = new Button(composite4, 8);
        this.refreshBtn.setText(IsresourceBundle.getString((String)"refresh_lbl"));
        this.modifyBtn = new Button(composite4, 8);
        this.modifyBtn.setText(IsresourceBundle.getString((String)"modify_value_lbl"));
        this.addMonBtn = new Button(composite4, 8);
        this.addMonBtn.setText(IsresourceBundle.getString((String)"add_monitor_lbl"));
        for (n = 0; n < items.size(); ++n) {
            this.varCmb.add(items.get(n).toString());
        }
        if (this.itemsToAdd != null) {
            for (n = 0; n < this.itemsToAdd.length; ++n) {
                this.addItem(this.itemsToAdd[n]);
            }
        }
        if (this.initVarname != null && this.initVarname.length() > 0) {
            this.addItem(this.initVarname);
        }
        this.hexChk.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMonBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.modifyBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.varTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private String itemToVarname(TreeItem treeItem) {
        UserObject userObject = (UserObject)treeItem.getData();
        String string = userObject.getVarName();
        int n = string.indexOf(40);
        String string2 = null;
        if (n >= 0) {
            string2 = string.substring(n);
            string = string.substring(0, n).trim();
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (treeItem = treeItem.getParentItem(); treeItem != null; treeItem = treeItem.getParentItem()) {
            userObject = (UserObject)treeItem.getData();
            string = userObject.getVarName();
            n = string.indexOf(40);
            if (n >= 0) {
                string = string.substring(0, n).trim();
            }
            stringBuilder.append(" of " + string);
        }
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString().trim();
    }

    private void updateVarCmb(TreeItem treeItem) {
        String string = this.itemToVarname(treeItem);
        int n = string.indexOf("::");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        this.varCmb.setText(string);
    }

    private void error(String string) {
        PluginUtilities.logMessage((String)string, (int)2);
    }

    private void refresh() {
        String string = this.varCmb.getText();
        if (string.length() > 0) {
            String string2 = this.propTxt.getText();
            if (this.hexChk.getSelection() && string2.length() > 0) {
                this.error(IsresourceBundle.getString((String)"confl_opt_msg"));
            } else {
                String string3 = this.getDisplayCommand(string);
                if (string3 != null) {
                    this.handleResponse(IscobolDebugTarget.getCurrent().getInvoker().processCommand(string3), 5);
                    this.currVarname = string;
                }
            }
            this.addItem(string);
        }
    }

    private void handleResponse(DebugResponse debugResponse, int n) {
        if (debugResponse.getReturnCode() == 0) {
            switch (n) {
                case 5: {
                    this.updateVarTree(debugResponse, true);
                    break;
                }
                case 6: {
                    this.refreshCurrent();
                    break;
                }
            }
        } else {
            this.error(debugResponse.getMessage().substring(2));
        }
    }

    private TreeItem createTreeItem(TreeNode treeNode, TreeItem treeItem, boolean bl) {
        TreeItem treeItem2 = treeItem != null ? new TreeItem(treeItem, 0) : new TreeItem(this.varTree, 0);
        this.setItemData(treeItem2, treeNode, bl);
        return treeItem2;
    }

    private void setItemData(TreeItem treeItem, TreeNode treeNode, boolean bl) {
        if (treeNode.getVarName() != null) {
            treeItem.setText(0, treeNode.getVarName());
        } else {
            treeItem.setText(0, "");
        }
        if (treeNode.getVarValue() != null) {
            treeItem.setText(1, treeNode.getVarValue());
        } else {
            treeItem.setText(1, "");
        }
        UserObject userObject = new UserObject(treeNode.getVarName(), treeNode.getVarValue());
        userObject.setHex(bl);
        treeItem.setData((Object)userObject);
    }

    private void addTreeItems(TreeNode[] treeNodeArray, TreeItem treeItem, boolean bl) {
        for (int i = 0; i < treeNodeArray.length; ++i) {
            TreeItem treeItem2 = this.createTreeItem(treeNodeArray[i], treeItem, bl);
            this.addTreeItems(treeNodeArray[i].getChildren(), treeItem2, bl);
        }
    }

    private void updateTreeItems(TreeNode[] treeNodeArray, TreeItem treeItem, boolean bl) {
        for (int i = 0; i < treeNodeArray.length; ++i) {
            TreeItem treeItem2 = treeItem != null ? treeItem.getItem(i) : this.varTree.getItem(i);
            this.setItemData(treeItem2, treeNodeArray[i], bl);
            this.updateTreeItems(treeNodeArray[i].getChildren(), treeItem2, bl);
        }
    }

    private void updateVarTree(DebugResponse debugResponse, boolean bl) {
        com.iscobol.debugger.tree.Tree tree;
        if (bl) {
            this.varTree.removeAll();
        }
        if ((tree = debugResponse.getTree()) != null) {
            if (tree.getRoot().getChildCount() == 1 && tree.getRoot().getChildren()[0].getChildCount() == 0) {
                if (bl) {
                    this.createTreeItem(tree.getRoot().getChildren()[0], null, false);
                } else {
                    TreeItem treeItem = this.varTree.getItem(0);
                    this.setItemData(treeItem, tree.getRoot().getChildren()[0], false);
                }
            } else if (bl) {
                this.addTreeItems(tree.getRoot().getChildren(), null, this.hexChk.getSelection());
            } else {
                this.updateTreeItems(tree.getRoot().getChildren(), null, this.hexChk.getSelection());
            }
        } else {
            String string;
            String string2;
            String string3 = debugResponse.getMessage().substring(2);
            int n = string3.indexOf(61);
            if (n >= 0) {
                string2 = string3.substring(0, n).trim();
                string = string3.substring(n + 1).trim();
            } else {
                string2 = string3;
                string = null;
            }
            TreeItem treeItem = bl ? new TreeItem(this.varTree, 0) : this.varTree.getItem(0);
            if (string2 != null) {
                treeItem.setText(0, string2);
            } else {
                treeItem.setText(0, "");
            }
            if (string != null) {
                treeItem.setText(1, string);
            } else {
                treeItem.setText(1, "");
            }
            treeItem.setData((Object)new UserObject(string2, string));
        }
        if (bl) {
            this.expandAll(this.varTree.getItems());
        }
    }

    private void expandAll(TreeItem[] treeItemArray) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            treeItemArray[i].setExpanded(true);
            this.expandAll(treeItemArray[i].getItems());
        }
    }

    private void refreshCurrent() {
        if (this.currVarname != null) {
            String string = this.getDisplayCommand(this.currVarname);
            DebugResponse debugResponse = IscobolDebugTarget.getCurrent().getInvoker().processCommand(string);
            if (debugResponse != null && debugResponse.getReturnCode() == 0) {
                this.updateVarTree(debugResponse, false);
            }
        }
    }

    private IscobolWatchpoint findWatchpoint(int n) {
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints();
        for (int i = 0; i < iBreakpointArray.length; ++i) {
            IscobolWatchpoint iscobolWatchpoint;
            if (!(iBreakpointArray[i] instanceof IscobolWatchpoint) || (iscobolWatchpoint = (IscobolWatchpoint)iBreakpointArray[i]).getLineNumber() != n) continue;
            return iscobolWatchpoint;
        }
        return null;
    }

    private void addMonitor() {
        String string = this.varCmb.getText();
        if (string.length() > 0) {
            String string2 = this.propTxt.getText();
            if (this.hexChk.getSelection() && string2.length() > 0) {
                this.error(IsresourceBundle.getString((String)"confl_opt_msg"));
            } else {
                MonitorDialog monitorDialog = new MonitorDialog(this.getShell(), IsresourceBundle.getString((String)"set_mon_title"), null, string, string2, false);
                monitorDialog.open();
                IscobolWatchpoint iscobolWatchpoint = monitorDialog.getWatchpoint();
                if (iscobolWatchpoint != null) {
                    try {
                        IscobolDebugTarget.getCurrent().setLastBreakpoint((IBreakpoint)iscobolWatchpoint);
                        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                        IscobolWatchpoint iscobolWatchpoint2 = this.findWatchpoint(iscobolWatchpoint.getLineNumber());
                        if (iscobolWatchpoint2 != null) {
                            iBreakpointManager.removeBreakpoint((IBreakpoint)iscobolWatchpoint2, true);
                        }
                        iBreakpointManager.addBreakpoint((IBreakpoint)iscobolWatchpoint);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
            this.addItem(string);
        }
    }

    private void modifyValue() {
        String string = this.varCmb.getText();
        if (string.length() > 0) {
            String string2 = this.propTxt.getText();
            if (this.hexChk.getSelection() && string2.length() > 0) {
                this.error(IsresourceBundle.getString((String)"confl_opt_msg"));
            } else {
                DebuggerInvoker debuggerInvoker;
                DebugResponse debugResponse;
                String string3 = null;
                String string4 = "display";
                if (this.hexChk.getSelection()) {
                    string4 = string4 + " -x";
                }
                string4 = string4 + " " + string;
                if (string2.length() > 0) {
                    string4 = string4 + " property " + string2;
                }
                if ((debugResponse = (debuggerInvoker = IscobolDebugTarget.getCurrent().getInvoker()).processCommand(string4)) != null && debugResponse.getReturnCode() == 0) {
                    string3 = debugResponse.getVarValue().trim();
                }
                AcceptVariableDialog acceptVariableDialog = new AcceptVariableDialog(this.getShell(), IsresourceBundle.getString((String)"accept_var_title"), string, string3, string2, this.hexChk.getSelection());
                acceptVariableDialog.open();
                string4 = acceptVariableDialog.getCommandString();
                if (string4 != null) {
                    this.handleResponse(debuggerInvoker.processCommand(string4), 6);
                }
            }
            this.addItem(string);
        }
    }

    private void addItem(String string) {
        int n = this.varCmb.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!this.varCmb.getItem(i).equalsIgnoreCase(string)) continue;
            items.remove(i);
            this.varCmb.remove(i);
            break;
        }
        this.varCmb.add(string, 0);
        items.add(0, string);
        this.varCmb.setText(string);
    }

    private String getDisplayCommand(String string) {
        String string2 = this.propTxt.getText();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("display");
        stringBuilder.append(" ");
        if (string2.length() > 0) {
            stringBuilder.append(string);
            stringBuilder.append(" ");
            stringBuilder.append("property");
            stringBuilder.append(" ");
            stringBuilder.append(string2);
        } else {
            stringBuilder.append("-tree");
            if (this.hexChk.getSelection()) {
                stringBuilder.append(" ");
                stringBuilder.append("-x");
            }
            stringBuilder.append(" ");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ Button access$000(QuickWatchDialog quickWatchDialog) {
        return quickWatchDialog.hexChk;
    }

    static /* synthetic */ Text access$100(QuickWatchDialog quickWatchDialog) {
        return quickWatchDialog.propTxt;
    }

    static /* synthetic */ void access$200(QuickWatchDialog quickWatchDialog, String string) {
        quickWatchDialog.error(string);
    }

    static /* synthetic */ void access$300(QuickWatchDialog quickWatchDialog) {
        quickWatchDialog.refreshCurrent();
    }

    static /* synthetic */ void access$400(QuickWatchDialog quickWatchDialog) {
        quickWatchDialog.refresh();
    }

    static /* synthetic */ void access$500(QuickWatchDialog quickWatchDialog) {
        quickWatchDialog.addMonitor();
    }

    static /* synthetic */ void access$600(QuickWatchDialog quickWatchDialog) {
        quickWatchDialog.modifyValue();
    }

    static /* synthetic */ Tree access$700(QuickWatchDialog quickWatchDialog) {
        return quickWatchDialog.varTree;
    }

    static /* synthetic */ void access$800(QuickWatchDialog quickWatchDialog, TreeItem treeItem) {
        quickWatchDialog.updateVarCmb(treeItem);
    }
}

