/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.dialogs;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RemoteCompilerConfigurationDialog
extends Dialog {
    private String host;
    private String port;
    private String preprocessorList;
    private boolean generateClass;
    private boolean generateError;
    private boolean generateListing;
    private Text hostTxt;
    private Text portTxt;
    private List ppList;
    private Button addBtn;
    private Button removeBtn;
    private Button removeAllBtn;
    private Button genClsBtn;
    private Button genErrBtn;
    private Button genLstBtn;
    private Button useAllPPBtn;
    private Button dontUsePPBtn;
    private Button ppListBtn;

    public RemoteCompilerConfigurationDialog(Shell shell, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        super(shell);
        this.host = string;
        if (this.host == null || this.host.length() == 0) {
            this.host = "localhost";
        }
        this.port = string2;
        if (this.port == null || this.port.length() == 0) {
            this.port = "11999";
        }
        this.preprocessorList = string3;
        this.generateClass = bl;
        this.generateError = bl2;
        this.generateListing = bl3;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setText("Server");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        Label label = new Label((Composite)group, 0);
        label.setText(IsresourceBundle.getString((String)"hostname_lbl") + ":");
        this.hostTxt = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.widthHint = 200;
        this.hostTxt.setLayoutData((Object)gridData);
        label = new Label((Composite)group, 0);
        label.setText(IsresourceBundle.getString((String)"portnumber_lbl") + ":");
        this.portTxt = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.widthHint = 50;
        this.portTxt.setLayoutData((Object)gridData);
        Group group2 = new Group(composite2, 0);
        group2.setText("PreProcessors");
        gridLayout = new GridLayout();
        group2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        group2.setLayoutData((Object)gridData);
        this.useAllPPBtn = new Button((Composite)group2, 16);
        this.useAllPPBtn.setText(IsresourceBundle.getString((String)"use_all_pp_lbl"));
        this.dontUsePPBtn = new Button((Composite)group2, 16);
        this.dontUsePPBtn.setText(IsresourceBundle.getString((String)"dont_use_pp_lbl"));
        this.ppListBtn = new Button((Composite)group2, 16);
        this.ppListBtn.setText(IsresourceBundle.getString((String)"use_pp_list_lbl"));
        Composite composite3 = new Composite((Composite)group2, 0);
        gridData = new GridData(768);
        composite3.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        this.ppList = new List(composite3, 2048);
        gridData = new GridData(768);
        gridData.heightHint = 150;
        this.ppList.setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite3, 0);
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        composite4.setLayoutData((Object)gridData);
        composite4.setLayout((Layout)new GridLayout());
        this.addBtn = new Button(composite4, 8);
        this.addBtn.setText(IsresourceBundle.getString((String)"add_lbl"));
        gridData = new GridData(768);
        this.addBtn.setLayoutData((Object)gridData);
        this.addBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn = new Button(composite4, 8);
        this.removeBtn.setText(IsresourceBundle.getString((String)"remove_lbl"));
        this.removeBtn.setLayoutData((Object)gridData);
        this.removeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeAllBtn = new Button(composite4, 8);
        this.removeAllBtn.setText(IsresourceBundle.getString((String)"remove_all_lbl"));
        this.removeAllBtn.setLayoutData((Object)gridData);
        this.removeAllBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Group group3 = new Group(composite2, 0);
        group3.setText("Options");
        gridLayout = new GridLayout();
        group3.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        group3.setLayoutData((Object)gridData);
        this.genClsBtn = new Button((Composite)group3, 32);
        this.genClsBtn.setText(IsresourceBundle.getString((String)"gen_cls_lbl"));
        gridData = new GridData();
        this.genClsBtn.setLayoutData((Object)gridData);
        this.genLstBtn = new Button((Composite)group3, 32);
        this.genLstBtn.setText(IsresourceBundle.getString((String)"gen_lst_lbl"));
        gridData = new GridData();
        this.genLstBtn.setLayoutData((Object)gridData);
        this.genErrBtn = new Button((Composite)group3, 32);
        this.genErrBtn.setText(IsresourceBundle.getString((String)"gen_err_lbl"));
        gridData = new GridData();
        this.genErrBtn.setLayoutData((Object)gridData);
        if (this.host != null) {
            this.hostTxt.setText(this.host);
        }
        if (this.port != null) {
            this.portTxt.setText(this.port);
        }
        this.genClsBtn.setSelection(this.generateClass);
        this.genLstBtn.setSelection(this.generateListing);
        this.genErrBtn.setSelection(this.generateError);
        if (this.preprocessorList != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.preprocessorList, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.equalsIgnoreCase("ALL")) {
                    this.setUseAllPP();
                    this.ppList.removeAll();
                    break;
                }
                if (string.equalsIgnoreCase("NONE")) {
                    this.setDontUsePP();
                    this.ppList.removeAll();
                    break;
                }
                this.setUsePPList();
                this.ppList.add(string);
            }
            if (!this.useAllPPBtn.getSelection() && !this.dontUsePPBtn.getSelection()) {
                this.ppListBtn.setSelection(true);
            }
        } else {
            this.setUseAllPP();
        }
        this.useAllPPBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dontUsePPBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.ppListBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private void setUseAllPP() {
        this.useAllPPBtn.setSelection(true);
        this.dontUsePPBtn.setSelection(false);
        this.ppListBtn.setSelection(false);
        this.ppList.setEnabled(false);
        this.addBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.removeAllBtn.setEnabled(false);
        this.genClsBtn.setEnabled(true);
    }

    private void setDontUsePP() {
        this.useAllPPBtn.setSelection(false);
        this.dontUsePPBtn.setSelection(true);
        this.ppListBtn.setSelection(false);
        this.ppList.setEnabled(false);
        this.addBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.removeAllBtn.setEnabled(false);
        this.genClsBtn.setEnabled(false);
        this.genClsBtn.setSelection(true);
    }

    private void setUsePPList() {
        this.useAllPPBtn.setSelection(false);
        this.dontUsePPBtn.setSelection(false);
        this.ppListBtn.setSelection(true);
        this.ppList.setEnabled(true);
        this.addBtn.setEnabled(true);
        this.removeBtn.setEnabled(true);
        this.removeAllBtn.setEnabled(true);
        this.genClsBtn.setEnabled(true);
    }

    public void okPressed() {
        if (!PluginUtilities.validateHostName((String)this.hostTxt.getText())) {
            PluginUtilities.logError((String)IsresourceBundle.getString((String)"invalid_host_msg"));
            return;
        }
        if (!PluginUtilities.validatePortNumber((String)this.portTxt.getText())) {
            PluginUtilities.logError((String)IsresourceBundle.getString((String)"invalid_port_msg"));
            return;
        }
        if (this.ppListBtn.getSelection() && this.ppList.getItemCount() == 0) {
            PluginUtilities.logError((String)IsresourceBundle.getString((String)"add_pp_msg"));
            return;
        }
        this.host = this.hostTxt.getText();
        this.port = this.portTxt.getText();
        this.generateClass = this.genClsBtn.getSelection();
        this.generateError = this.genErrBtn.getSelection();
        this.generateListing = this.genLstBtn.getSelection();
        if (this.useAllPPBtn.getSelection()) {
            this.preprocessorList = "ALL";
        } else if (this.dontUsePPBtn.getSelection()) {
            this.preprocessorList = "NONE";
        } else {
            this.preprocessorList = this.ppList.getItem(0);
            for (int i = 1; i < this.ppList.getItemCount(); ++i) {
                this.preprocessorList = this.preprocessorList + "," + this.ppList.getItem(i);
            }
        }
        super.okPressed();
    }

    public String getPreprocessorList() {
        return this.preprocessorList;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public boolean isGenerateClass() {
        return this.generateClass;
    }

    public boolean isGenerateError() {
        return this.generateError;
    }

    public boolean isGenerateListing() {
        return this.generateListing;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(IsresourceBundle.getString((String)"rc_config_title"));
    }

    static /* synthetic */ List access$000(RemoteCompilerConfigurationDialog remoteCompilerConfigurationDialog) {
        return remoteCompilerConfigurationDialog.ppList;
    }

    static /* synthetic */ void access$100(RemoteCompilerConfigurationDialog remoteCompilerConfigurationDialog) {
        remoteCompilerConfigurationDialog.setUseAllPP();
    }

    static /* synthetic */ void access$200(RemoteCompilerConfigurationDialog remoteCompilerConfigurationDialog) {
        remoteCompilerConfigurationDialog.setDontUsePP();
    }

    static /* synthetic */ void access$300(RemoteCompilerConfigurationDialog remoteCompilerConfigurationDialog) {
        remoteCompilerConfigurationDialog.setUsePPList();
    }
}

