/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.dialogs;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.dialogs.SequenceNumberDialog;
import com.iscobol.plugins.editor.util.PluginUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SequenceNumberDialog
extends Dialog {
    private Text startNumberTxt;
    private Text intervalTxt;
    private Label startNumberLbl;
    private Label intervalLbl;
    private Button makeBtn;
    private Button clearBtn;
    private Button allBtn;
    private Button selectionBtn;
    private Button linesBtn;
    private Text fromTxt;
    private Text toTxt;
    private Label fromLbl;
    private Label toLbl;
    private int lineCount;
    private boolean enableSelection;
    private Params params;

    public SequenceNumberDialog(Shell shell, int n, boolean bl) {
        super(shell);
        this.lineCount = n;
        this.enableSelection = bl;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(IsresourceBundle.getString((String)"sequenceNumberAction.label"));
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setText(IsresourceBundle.getString((String)"action_lbl"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        group.setLayout((Layout)gridLayout);
        this.makeBtn = new Button((Composite)group, 16);
        this.makeBtn.setText(IsresourceBundle.getString((String)"make_lbl"));
        this.startNumberLbl = new Label((Composite)group, 0);
        this.startNumberLbl.setText(IsresourceBundle.getString((String)"starting_no_lbl"));
        this.startNumberTxt = new Text((Composite)group, 133120);
        GridData gridData = new GridData();
        gridData.widthHint = 50;
        this.startNumberTxt.setLayoutData((Object)gridData);
        this.intervalLbl = new Label((Composite)group, 0);
        this.intervalLbl.setText(IsresourceBundle.getString((String)"interval_lbl"));
        this.intervalTxt = new Text((Composite)group, 133120);
        gridData = new GridData();
        gridData.widthHint = 50;
        this.intervalTxt.setLayoutData((Object)gridData);
        this.clearBtn = new Button((Composite)group, 16);
        this.clearBtn.setText(IsresourceBundle.getString((String)"clear_lbl"));
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        this.clearBtn.setLayoutData((Object)gridData);
        Group group2 = new Group(composite2, 0);
        group2.setText(IsresourceBundle.getString((String)"line_range_lbl"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        group2.setLayout((Layout)gridLayout);
        this.allBtn = new Button((Composite)group2, 16);
        this.allBtn.setText(IsresourceBundle.getString((String)"all_lbl"));
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        this.allBtn.setLayoutData((Object)gridData);
        if (this.enableSelection) {
            this.selectionBtn = new Button((Composite)group2, 16);
            this.selectionBtn.setText(IsresourceBundle.getString((String)"selection_lbl"));
            gridData = new GridData();
            gridData.horizontalSpan = 5;
            this.selectionBtn.setLayoutData((Object)gridData);
        }
        this.linesBtn = new Button((Composite)group2, 16);
        this.linesBtn.setText(IsresourceBundle.getString((String)"lines_lbl"));
        this.fromLbl = new Label((Composite)group2, 0);
        this.fromLbl.setText(IsresourceBundle.getString((String)"from_lbl"));
        this.fromTxt = new Text((Composite)group2, 133120);
        gridData = new GridData();
        gridData.widthHint = 50;
        this.fromTxt.setLayoutData((Object)gridData);
        this.toLbl = new Label((Composite)group2, 0);
        this.toLbl.setText(IsresourceBundle.getString((String)"to_lbl"));
        this.toTxt = new Text((Composite)group2, 133120);
        gridData = new GridData();
        gridData.widthHint = 50;
        this.toTxt.setLayoutData((Object)gridData);
        this.startNumberLbl.setEnabled(false);
        this.startNumberTxt.setEnabled(false);
        this.intervalLbl.setEnabled(false);
        this.intervalTxt.setEnabled(false);
        this.fromLbl.setEnabled(false);
        this.fromTxt.setEnabled(false);
        this.toLbl.setEnabled(false);
        this.toTxt.setEnabled(false);
        this.clearBtn.setSelection(true);
        this.allBtn.setSelection(true);
        this.startNumberTxt.setText("1");
        this.intervalTxt.setText("1");
        this.fromTxt.setText("1");
        this.toTxt.setText("" + this.lineCount);
        this.makeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.linesBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    public Params openDialog() {
        this.open();
        return this.params;
    }

    public void okPressed() {
        int n;
        Params params = new Params();
        if (this.makeBtn.getSelection()) {
            try {
                n = Integer.parseInt(this.startNumberTxt.getText());
                if (n < 0 || n >= 1000000) {
                    this.logInvalidValueError("starting_no_lbl");
                    return;
                }
                params.startNumber = n;
            }
            catch (NumberFormatException numberFormatException) {
                this.logInvalidValueError("starting_no_lbl");
                return;
            }
            try {
                n = Integer.parseInt(this.intervalTxt.getText());
                if (n < 0 || n >= 1000000) {
                    this.logInvalidValueError("interval_lbl");
                    return;
                }
                params.interval = n;
            }
            catch (NumberFormatException numberFormatException) {
                this.logInvalidValueError("interval_lbl");
                return;
            }
        }
        params.clear = true;
        if (this.linesBtn.getSelection()) {
            try {
                n = Integer.parseInt(this.fromTxt.getText());
                if (n <= 0 || n > this.lineCount) {
                    this.logInvalidValueError("from_lbl");
                    return;
                }
                params.startLine = n;
            }
            catch (NumberFormatException numberFormatException) {
                this.logInvalidValueError("from_lbl");
                return;
            }
            try {
                n = Integer.parseInt(this.toTxt.getText());
                if (n < params.startLine || n > this.lineCount) {
                    this.logInvalidValueError("to_lbl");
                    return;
                }
                params.endLine = n;
            }
            catch (NumberFormatException numberFormatException) {
                this.logInvalidValueError("to_lbl");
                return;
            }
        }
        if (this.allBtn.getSelection()) {
            params.all = true;
        } else {
            params.selection = true;
        }
        this.params = params;
        super.okPressed();
    }

    private void logInvalidValueError(String string) {
        PluginUtilities.logError((String)(IsresourceBundle.getString((String)"invalid_value_msg") + "'" + IsresourceBundle.getString((String)string) + "'"));
    }

    static /* synthetic */ Button access$000(SequenceNumberDialog sequenceNumberDialog) {
        return sequenceNumberDialog.makeBtn;
    }

    static /* synthetic */ Label access$100(SequenceNumberDialog sequenceNumberDialog) {
        return sequenceNumberDialog.startNumberLbl;
    }

    static /* synthetic */ Text access$200(SequenceNumberDialog sequenceNumberDialog) {
        return sequenceNumberDialog.startNumberTxt;
    }

    static /* synthetic */ Label access$300(SequenceNumberDialog sequenceNumberDialog) {
        return sequenceNumberDialog.intervalLbl;
    }

    static /* synthetic */ Text access$400(SequenceNumberDialog sequenceNumberDialog) {
        return sequenceNumberDialog.intervalTxt;
    }

    static /* synthetic */ Button access$500(SequenceNumberDialog sequenceNumberDialog) {
        return sequenceNumberDialog.linesBtn;
    }

    static /* synthetic */ Label access$600(SequenceNumberDialog sequenceNumberDialog) {
        return sequenceNumberDialog.fromLbl;
    }

    static /* synthetic */ Text access$700(SequenceNumberDialog sequenceNumberDialog) {
        return sequenceNumberDialog.fromTxt;
    }

    static /* synthetic */ Label access$800(SequenceNumberDialog sequenceNumberDialog) {
        return sequenceNumberDialog.toLbl;
    }

    static /* synthetic */ Text access$900(SequenceNumberDialog sequenceNumberDialog) {
        return sequenceNumberDialog.toTxt;
    }
}

