/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.dialogs;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class XML2WrkDialog
extends Dialog {
    private Button disambiguateBtn;
    private Button noPrefixBtn;
    private Button defaultPrefixBtn;
    private Button prefixBtn;
    private Text prefixTxt;
    private Text workspaceInputTxt;
    private Text fileSystemInputTxt;
    private Text fileSystemOutputTxt;
    private Text workspaceOutputTxt;
    private Button workspaceInputBtn;
    private Button fileSystemInputBtn;
    private Button workspaceOutputBtn;
    private Button fileSystemOutputBtn;
    private Button workspaceInputBrowseBtn;
    private Button fileSystemInputBrowseBtn;
    private Button workspaceOutputBrowseBtn;
    private Button fileSystemOutputBrowseBtn;
    private String input;
    private String output;
    private String prefix;
    private boolean disambiguate;

    public XML2WrkDialog(Shell shell) {
        super(shell);
    }

    public String getInput() {
        return this.input;
    }

    public String getOutput() {
        return this.output;
    }

    public boolean getDisambiguateFlag() {
        return this.disambiguate;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void okPressed() {
        boolean bl = true;
        bl = this.workspaceInputBtn.getSelection() ? (bl &= this.validateWorkspaceInput()) : (bl &= this.validateFileSystemInput());
        bl = this.workspaceOutputBtn.getSelection() ? (bl &= this.validateWorkspaceOutput()) : (bl &= this.validateFileSystemOutput());
        if (bl &= this.validatePrefix()) {
            this.disambiguate = this.disambiguateBtn.getSelection();
            this.prefix = this.noPrefixBtn.getSelection() ? String.valueOf(0) : (this.defaultPrefixBtn.getSelection() ? String.valueOf(1) : this.prefixTxt.getText());
            this.input = this.workspaceInputBtn.getSelection() ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.workspaceInputTxt.getText())).getLocation().toString() : this.fileSystemInputTxt.getText();
            this.output = this.workspaceOutputBtn.getSelection() ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.workspaceOutputTxt.getText())).getLocation().toString() : this.fileSystemOutputTxt.getText();
            super.okPressed();
        }
    }

    private void showErrorMessage(String string) {
        MessageBox messageBox = new MessageBox(this.getShell(), 33);
        messageBox.setText("Error");
        messageBox.setMessage(string);
        messageBox.open();
    }

    private boolean validatePrefix() {
        if (this.prefixBtn.getSelection()) {
            if (this.prefixTxt.getText().length() > 0) {
                if (this.prefixTxt.getText().matches(".*[\\s]+.*")) {
                    this.showErrorMessage("Invalid Prefix");
                    return false;
                }
            } else {
                this.showErrorMessage("Set Prefix");
                return false;
            }
        }
        return true;
    }

    private boolean validateWorkspaceInput() {
        if (this.workspaceInputTxt.getText().length() > 0) {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.workspaceInputTxt.getText()));
            if (iFile.exists()) {
                return true;
            }
            this.showErrorMessage("Invalid Workspace Input");
            return false;
        }
        this.showErrorMessage("Set Workspace Input");
        return false;
    }

    private boolean validateFileSystemInput() {
        if (this.fileSystemInputTxt.getText().length() > 0) {
            File file = new File(this.fileSystemInputTxt.getText());
            if (file.exists() && !file.isDirectory() && file.getName().endsWith(".xml")) {
                return true;
            }
            this.showErrorMessage("Invalid Filesystem Input");
            return false;
        }
        this.showErrorMessage("Set Filesystem Input");
        return false;
    }

    private boolean validateFileSystemOutput() {
        if (this.fileSystemOutputTxt.getText().length() > 0) {
            File file = new File(this.fileSystemOutputTxt.getText());
            if (file.getParentFile() != null) {
                return true;
            }
            this.showErrorMessage("Invalid Filesystem Output");
            return false;
        }
        this.showErrorMessage("Set Filesystem Output");
        return false;
    }

    private boolean validateWorkspaceOutput() {
        if (this.workspaceOutputTxt.getText().length() > 0) {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.workspaceOutputTxt.getText()));
            if (iFile.getParent() != null && iFile.getParent().exists()) {
                return true;
            }
            this.showErrorMessage("Invalid Workspace Output");
            return false;
        }
        this.showErrorMessage("Set Workspace Output");
        return false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("XML2Wrk Utility");
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        Button button = super.createButton(composite, n, string, bl);
        if (n == 0) {
            button.setText("Run");
        }
        return button;
    }

    protected Control createDialogArea(Composite composite) {
        IFile iFile;
        IStructuredSelection iStructuredSelection;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setText("Input");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        this.workspaceInputBtn = new Button((Composite)group, 16);
        this.workspaceInputBtn.setText("Workspace:");
        this.workspaceInputBtn.setSelection(true);
        this.workspaceInputTxt = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 500;
        this.workspaceInputTxt.setLayoutData((Object)gridData);
        this.workspaceInputBrowseBtn = new Button((Composite)group, 8);
        this.workspaceInputBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.fileSystemInputBtn = new Button((Composite)group, 16);
        this.fileSystemInputBtn.setText("Filesystem:");
        this.fileSystemInputTxt = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 500;
        this.fileSystemInputTxt.setLayoutData((Object)gridData);
        this.fileSystemInputTxt.setEnabled(false);
        this.fileSystemInputBrowseBtn = new Button((Composite)group, 8);
        this.fileSystemInputBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.fileSystemInputBrowseBtn.setEnabled(false);
        Group group2 = new Group(composite2, 0);
        group2.setText("Output");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group2.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group2.setLayout((Layout)gridLayout);
        this.workspaceOutputBtn = new Button((Composite)group2, 16);
        this.workspaceOutputBtn.setText("Workspace:");
        this.workspaceOutputBtn.setSelection(true);
        this.workspaceOutputTxt = new Text((Composite)group2, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 500;
        this.workspaceOutputTxt.setLayoutData((Object)gridData);
        this.workspaceOutputBrowseBtn = new Button((Composite)group2, 8);
        this.workspaceOutputBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.fileSystemOutputBtn = new Button((Composite)group2, 16);
        this.fileSystemOutputBtn.setText("Filesystem:");
        this.fileSystemOutputTxt = new Text((Composite)group2, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 500;
        this.fileSystemOutputTxt.setLayoutData((Object)gridData);
        this.fileSystemOutputTxt.setEnabled(false);
        this.fileSystemOutputBrowseBtn = new Button((Composite)group2, 8);
        this.fileSystemOutputBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.fileSystemOutputBrowseBtn.setEnabled(false);
        Group group3 = new Group(composite2, 0);
        group3.setText("Prefix");
        group3.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group3.setLayout((Layout)gridLayout);
        this.noPrefixBtn = new Button((Composite)group3, 16);
        this.noPrefixBtn.setText("None");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.noPrefixBtn.setLayoutData((Object)gridData);
        this.defaultPrefixBtn = new Button((Composite)group3, 16);
        this.defaultPrefixBtn.setText("Default");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.defaultPrefixBtn.setLayoutData((Object)gridData);
        this.prefixBtn = new Button((Composite)group3, 16);
        this.prefixBtn.setText("Customized");
        this.prefixTxt = new Text((Composite)group3, 2048);
        gridData = new GridData(768);
        this.prefixTxt.setLayoutData((Object)gridData);
        this.disambiguateBtn = new Button(composite2, 32);
        this.disambiguateBtn.setText("Disambiguate Flag");
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        this.disambiguateBtn.setLayoutData((Object)gridData);
        this.noPrefixBtn.setSelection(true);
        this.prefixTxt.setEnabled(false);
        IFile iFile2 = null;
        ISelection iSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1 && iStructuredSelection.getFirstElement() instanceof IFile && (iFile = (IFile)iStructuredSelection.getFirstElement()).getFileExtension().equals("xml")) {
            iFile2 = iFile;
        }
        if (iFile2 != null) {
            this.setWorkspaceInputFile(iFile2);
        }
        this.workspaceInputBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileSystemInputBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.workspaceOutputBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileSystemOutputBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.workspaceInputBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileSystemInputBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.workspaceOutputBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileSystemOutputBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        iStructuredSelection = new /* Unavailable Anonymous Inner Class!! */;
        this.noPrefixBtn.addSelectionListener((SelectionListener)iStructuredSelection);
        this.defaultPrefixBtn.addSelectionListener((SelectionListener)iStructuredSelection);
        this.prefixBtn.addSelectionListener((SelectionListener)iStructuredSelection);
        return composite2;
    }

    private void setWorkspaceInputFile(IFile iFile) {
        this.workspaceInputTxt.setText(iFile.getFullPath().toString());
        try {
            if (iFile.getProject() != null && iFile.getProject().hasNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature")) {
                String string = PluginUtilities.getCurrentSettingMode((IResource)iFile.getProject());
                IContainer[] iContainerArray = PluginUtilities.getCopyFolders((IProject)iFile.getProject(), (String)string);
                if (iContainerArray != null && iContainerArray.length > 0) {
                    IFile iFile2 = iContainerArray[0].getFile((IPath)new Path(iFile.getName().substring(0, iFile.getName().length() - 5) + ".wrk"));
                    this.workspaceOutputTxt.setText(iFile2.getFullPath().toString());
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    static /* synthetic */ Text access$000(XML2WrkDialog xML2WrkDialog) {
        return xML2WrkDialog.workspaceInputTxt;
    }

    static /* synthetic */ Button access$100(XML2WrkDialog xML2WrkDialog) {
        return xML2WrkDialog.workspaceInputBrowseBtn;
    }

    static /* synthetic */ Text access$200(XML2WrkDialog xML2WrkDialog) {
        return xML2WrkDialog.fileSystemInputTxt;
    }

    static /* synthetic */ Button access$300(XML2WrkDialog xML2WrkDialog) {
        return xML2WrkDialog.fileSystemInputBrowseBtn;
    }

    static /* synthetic */ Text access$400(XML2WrkDialog xML2WrkDialog) {
        return xML2WrkDialog.workspaceOutputTxt;
    }

    static /* synthetic */ Button access$500(XML2WrkDialog xML2WrkDialog) {
        return xML2WrkDialog.workspaceOutputBrowseBtn;
    }

    static /* synthetic */ Text access$600(XML2WrkDialog xML2WrkDialog) {
        return xML2WrkDialog.fileSystemOutputTxt;
    }

    static /* synthetic */ Button access$700(XML2WrkDialog xML2WrkDialog) {
        return xML2WrkDialog.fileSystemOutputBrowseBtn;
    }

    static /* synthetic */ void access$800(XML2WrkDialog xML2WrkDialog, IFile iFile) {
        xML2WrkDialog.setWorkspaceInputFile(iFile);
    }

    static /* synthetic */ Button access$900(XML2WrkDialog xML2WrkDialog) {
        return xML2WrkDialog.prefixBtn;
    }

    static /* synthetic */ Text access$1000(XML2WrkDialog xML2WrkDialog) {
        return xML2WrkDialog.prefixTxt;
    }
}

