/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.handlers;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.debug.IscobolDebugTarget;
import com.iscobol.plugins.editor.dialogs.DisplayVariableDialog;
import com.iscobol.plugins.editor.util.PluginUtilities;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DisplayVariableHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IWorkbenchPart iWorkbenchPart = HandlerUtil.getActivePart((ExecutionEvent)executionEvent);
        if (iWorkbenchPart == null) {
            return null;
        }
        IscobolDebugTarget iscobolDebugTarget = IscobolDebugTarget.getCurrent();
        if (iWorkbenchPart instanceof IscobolEditor) {
            IscobolEditor iscobolEditor = (IscobolEditor)iWorkbenchPart;
            TextSelection textSelection = (TextSelection)iscobolEditor.getSelectionProvider().getSelection();
            String string = textSelection.getText();
            if (string.length() == 0) {
                string = iscobolEditor.getLastSelectedFragment();
            }
            if (string != null && string.length() > 0 && IscobolDebugTarget.canToggleWatchpoints((String)string)) {
                boolean bl = IscobolEditorPlugin.getDefault().getPreferenceStore().getBoolean("iscobol.variableview.showhex");
                String string2 = "display ";
                if (bl) {
                    string2 = string2 + "-x ";
                }
                if ((string2 = string2 + string) != null) {
                    iscobolDebugTarget.putCommand(string2);
                }
            } else {
                PluginUtilities.logMessage((String)IsresourceBundle.getString((String)"operation_unavailable_msg"), (int)2);
            }
        } else if (iWorkbenchPart.getSite().getId().equals("org.eclipse.debug.ui.VariableView")) {
            IscobolEditor iscobolEditor;
            IEditorPart iEditorPart = HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent);
            ISelection iSelection = null;
            String string = null;
            if (iEditorPart instanceof IscobolEditor && (iSelection = (iscobolEditor = (IscobolEditor)iEditorPart).getSelectionProvider().getSelection()) instanceof TextSelection) {
                string = ((TextSelection)iSelection).getText();
            }
            iscobolEditor = new DisplayVariableDialog(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), IsresourceBundle.getString((String)"display_var_title"), string);
            iscobolEditor.open();
            String string3 = iscobolEditor.getCommandString();
            if (string3 != null) {
                iscobolDebugTarget.putCommand(string3);
            }
        }
        return null;
    }
}

