/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.handlers;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolProjectionViewer;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.dialogs.SequenceNumberDialog;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.text.DecimalFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class SequenceNumberHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IEditorPart iEditorPart = HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent);
        if (!(iEditorPart instanceof IscobolEditor)) {
            PluginUtilities.logError((String)IsresourceBundle.getString((String)"op_not_supported_msg"));
            return null;
        }
        IscobolEditor iscobolEditor = (IscobolEditor)iEditorPart;
        if (iscobolEditor.getFormat() != 1) {
            PluginUtilities.logError((String)IsresourceBundle.getString((String)"only_ansi_msg"));
            return null;
        }
        IscobolProjectionViewer iscobolProjectionViewer = iscobolEditor.getViewer();
        int n = iscobolProjectionViewer.getDocument().getNumberOfLines();
        Point point = iscobolProjectionViewer.getSelectedRange();
        SequenceNumberDialog sequenceNumberDialog = new SequenceNumberDialog(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), n, point.x >= 0 && point.y > 0);
        SequenceNumberDialog.Params params = sequenceNumberDialog.openDialog();
        if (params != null) {
            try {
                this.sequenceNumber(params, iscobolEditor);
            }
            catch (BadLocationException badLocationException) {
                PluginUtilities.log((Throwable)badLocationException);
            }
        }
        return null;
    }

    private void sequenceNumber(SequenceNumberDialog.Params params, IscobolEditor iscobolEditor) throws BadLocationException {
        int n;
        int n2;
        IscobolProjectionViewer iscobolProjectionViewer = iscobolEditor.getViewer();
        IDocument iDocument = iscobolProjectionViewer.getDocument();
        int n3 = iDocument.getNumberOfLines();
        Point point = iscobolProjectionViewer.getSelectedRange();
        int n4 = params.startNumber;
        int n5 = params.interval;
        if (params.all) {
            n2 = 0;
            n = n3 - 1;
        } else if (params.selection) {
            n2 = iDocument.getLineOfOffset(point.x);
            n = iDocument.getLineOfOffset(point.x + point.y);
        } else {
            n2 = params.startLine - 1;
            n = params.endLine - 1;
        }
        DecimalFormat decimalFormat = new DecimalFormat("000000");
        IUndoManager iUndoManager = iscobolProjectionViewer.getUndoManager();
        iUndoManager.beginCompoundChange();
        StyledText styledText = iscobolProjectionViewer.getTextWidget();
        int n6 = n4;
        for (int i = n2; i <= n; ++i) {
            IRegion iRegion = iDocument.getLineInformation(i);
            String string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
            String string2 = params.clear ? "      " : decimalFormat.format(n6);
            styledText.replaceTextRange(iRegion.getOffset(), iRegion.getLength(), string2 + (string.length() > 6 ? string.substring(6) : ""));
            n6 = (n6 + n5) % 1000000;
        }
        iUndoManager.endCompoundChange();
    }
}

