/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.handlers;

import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.Tokens;
import com.iscobol.plugins.editor.handlers.TextCorrectIndentationHandler;
import com.iscobol.plugins.editor.util.IsFragment;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.util.VarDecl;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class TextCorrectIndentationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IEditorPart iEditorPart = HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent);
        SelectionRanges selectionRanges = this.getSelectionRanges(iEditorPart);
        if (selectionRanges.iscobolEditor != null && selectionRanges.viewer != null && selectionRanges.startLineNumber >= 0) {
            String string = selectionRanges.viewer.getTextWidget().getLineDelimiter();
            StyledText styledText = selectionRanges.viewer.getTextWidget();
            String string2 = this.indentText(selectionRanges.iscobolEditor, styledText, selectionRanges.startLineNumber, selectionRanges.endLineNumber, string);
            if (string2 != null) {
                int n = styledText.getCaretOffset();
                IUndoManager iUndoManager = selectionRanges.viewer.getUndoManager();
                iUndoManager.beginCompoundChange();
                styledText.replaceTextRange(selectionRanges.startOffset, selectionRanges.endOffset - selectionRanges.startOffset, string2);
                iUndoManager.endCompoundChange();
                styledText.setCaretOffset(n);
            }
        }
        return null;
    }

    protected String indentText(IscobolEditor iscobolEditor, StyledText styledText, int n, int n2, String string) {
        int[] nArray = new int[n2 - n + 1];
        TokenList[] tokenListArray = new TokenList[n2 - n + 1];
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i <= n2; ++i) {
            stringBuilder.append(this.indentLine(iscobolEditor, styledText, i, n, nArray, tokenListArray, string));
            if (i >= n2) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private boolean isComment(Token token, int n) {
        return token.getToknum() == 42 && (token.getOffset() == 6 && PluginUtilities.isAnsiFixedFormat((int)n) || token.getOffset() == 0 && PluginUtilities.isTerminalFormat((int)n)) || token.getWord().startsWith("*>");
    }

    protected String indentLine(IscobolEditor iscobolEditor, StyledText styledText, int n, int n2, int[] nArray, TokenList[] tokenListArray, String string) {
        int n3;
        TokenList tokenList;
        Token token;
        IsFragment isFragment = iscobolEditor.getFragmentAtLine(n);
        StringBuilder stringBuilder = new StringBuilder(styledText.getLine(n));
        int n4 = iscobolEditor.getTabWidth();
        int n5 = 0;
        if (isFragment != null) {
            n5 = isFragment.getType();
        }
        if ((token = (tokenList = this.getTokenList(n - n2, tokenListArray, n, styledText, n3 = iscobolEditor.getFormat())).getFirst()) == null || this.isComment(token, n3)) {
            return stringBuilder.toString();
        }
        boolean bl = false;
        switch (n5) {
            case 13: {
                int n6;
                Token token2;
                IsFragment isFragment2 = isFragment;
                while (isFragment2.getType() == 13) {
                    isFragment2 = isFragment2.getParent();
                }
                int n7 = ((VarDecl)isFragment).getLevel();
                if (n7 == 77 || n7 == 78) {
                    n7 = 1;
                }
                if ((token2 = this.findLevelNumberLess(n7, styledText, n - 1, n2, tokenListArray, isFragment2.getName().toUpperCase(), n3)) == null || token2.getToknum() != 10002) {
                    n6 = 0;
                    token2 = new Token('?', n, 6, "");
                } else {
                    n6 = n4;
                }
                this.indent(iscobolEditor, stringBuilder, token2, token, n, n2, nArray, n6, string);
                break;
            }
            case 5: {
                int n8;
                Token token3;
                if (token.getWord().toUpperCase().equals(isFragment.getName())) {
                    Token token4 = this.findToken(645, styledText, n - 1, n2, tokenListArray, n3);
                    this.indent(iscobolEditor, stringBuilder, token4, token, n, n2, nArray, 0, string);
                    break;
                }
                String string2 = (String)Tokens.endTokens.get(token.getWord().toUpperCase());
                if (string2 != null) {
                    token3 = this.findOpenToken(styledText, n - 1, n2, tokenListArray, string2, n3);
                    n8 = 0;
                } else {
                    token3 = this.findOpenToken(styledText, n - 1, n2, tokenListArray, n3);
                    n8 = token3 == null || token3.getToknum() == 645 ? 4 : n4;
                }
                this.indent(iscobolEditor, stringBuilder, token3, token, n, n2, nArray, n8, string);
                break;
            }
            default: {
                int n9;
                String string3;
                Token token5;
                if (token.getToknum() == 10009) {
                    token5 = tokenList.getNext();
                    if (token5 != null && token5.getToknum() == 10006) {
                        token5 = this.findToken(645, styledText, n - 1, n2, tokenListArray, n3);
                        if (token5 != null) {
                            this.indent(iscobolEditor, stringBuilder, token5, token, n, n2, nArray, 0, string);
                            bl = true;
                        }
                    } else if (token5 != null) {
                        tokenList.getPrevious();
                    }
                }
                if (!bl && (string3 = (String)Tokens.endTokens.get(token.getWord().toUpperCase())) != null && (token5 = this.findOpenToken(styledText, n - 1, n2, tokenListArray, string3, n3)) != null) {
                    this.indent(iscobolEditor, stringBuilder, token5, token, n, n2, nArray, 0, string);
                    bl = true;
                }
                if (!bl && (token5 = this.findOpenToken(styledText, n - 1, n2, tokenListArray, n3)) != null) {
                    n9 = token5.getToknum() == 645 ? 4 : n4;
                    this.indent(iscobolEditor, stringBuilder, token5, token, n, n2, nArray, n9, string);
                    bl = true;
                }
                if (bl) break;
                int n10 = Tokens.getLevelNumber((String)token.getWord());
                if (n10 == 77 || n10 == 78) {
                    n10 = 1;
                }
                if ((token5 = this.findLevelNumberLess(n10, styledText, n - 1, n2, tokenListArray, null, n3)) == null) break;
                n9 = token5.getToknum() != 10002 ? 0 : n4;
                this.indent(iscobolEditor, stringBuilder, token5, token, n, n2, nArray, n9, string);
                bl = true;
            }
        }
        return stringBuilder.toString();
    }

    private void indent(IscobolEditor iscobolEditor, StringBuilder stringBuilder, Token token, Token token2, int n, int n2, int[] nArray, int n3, String string) {
        if (token != null) {
            int n4 = token.getFLN() - 1 - n2;
            int n5 = n4 >= 0 && n4 < nArray.length ? nArray[n4] : 0;
            int n6 = token.getOffset() + n5 - token2.getOffset() + n3;
            if (n6 < 0) {
                stringBuilder.delete(token2.getOffset() + n6, token2.getOffset());
            } else if (n6 > 0) {
                stringBuilder.insert(token2.getOffset(), this.getSpaces(n6));
                if (PluginUtilities.isAnsiFixedFormat((int)iscobolEditor.getFormat()) && stringBuilder.length() > 72 && stringBuilder.charAt(71 - n6) != ' ') {
                    int n7 = stringBuilder.lastIndexOf(" ", 71 - n6);
                    stringBuilder.replace(n7, n7, string + "            ");
                }
            }
            nArray[n - n2] = n6;
        }
    }

    private String getSpaces(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    private Token cloneToken(Token token, int n) {
        return new Token(token.getToknum(), token.getWord(), n, token.getOffset(), null);
    }

    private TokenList getTokenList(int n, TokenList[] tokenListArray, int n2, StyledText styledText, int n3) {
        StringBuffer stringBuffer = new StringBuffer(styledText.getLine(n2));
        if (PluginUtilities.isAnsiFixedFormat((int)n3)) {
            if (stringBuffer.length() >= 6) {
                stringBuffer.replace(0, 7, this.getSpaces(6));
            }
            if (stringBuffer.length() > 72) {
                stringBuffer.setLength(72);
            }
        }
        if (n >= 0 && n < tokenListArray.length) {
            if (tokenListArray[n] == null) {
                tokenListArray[n] = PreProcessor.tokenizer((StringBuffer)stringBuffer, (char)'.', (boolean)true, null);
            }
            return tokenListArray[n];
        }
        return PreProcessor.tokenizer((StringBuffer)stringBuffer, (char)'.', (boolean)true, null);
    }

    private Token findOpenToken(StyledText styledText, int n, int n2, TokenList[] tokenListArray, String string, int n3) {
        int n4 = 0;
        for (int i = n; i >= 0; --i) {
            TokenList tokenList = this.getTokenList(i - n2, tokenListArray, i, styledText, n3);
            Token token = tokenList.getLast();
            Token token2 = null;
            while (token != null) {
                String string2 = token.getWord().toUpperCase();
                if (this.isFirst(tokenList) && string2.equals(string)) {
                    if (token2 == null || !string2.equals("PERFORM") || token2.getToknum() != 10009) {
                        if (n4 == 0) {
                            return this.cloneToken(token, i + 1);
                        }
                        --n4;
                    }
                } else {
                    String string3 = (String)Tokens.endTokens.get(string2);
                    if (string3 != null && string3.equals(string)) {
                        if (token2 == null || !string2.equals("PERFORM") || token2.getToknum() != 10009) {
                            ++n4;
                        }
                    } else if (this.isFirst(tokenList) && token.getToknum() == 645) {
                        return this.cloneToken(token, i + 1);
                    }
                }
                token2 = token;
                token = tokenList.getPrevious();
            }
        }
        return null;
    }

    private Token findOpenToken(StyledText styledText, int n, int n2, TokenList[] tokenListArray, int n3) {
        int n4 = 0;
        for (int i = n; i >= 0; --i) {
            TokenList tokenList = this.getTokenList(i - n2, tokenListArray, i, styledText, n3);
            Token token = tokenList.getLast();
            Token token2 = null;
            while (token != null) {
                String string = token.getWord().toUpperCase();
                if (this.isFirst(tokenList) && Tokens.openTokens.contains(string)) {
                    if (token2 == null || !string.equals("PERFORM") || token2.getToknum() != 10009) {
                        if (n4 == 0) {
                            return this.cloneToken(token, i + 1);
                        }
                        --n4;
                    }
                } else if (Tokens.endTokens.containsKey(string) || token.getToknum() == 10006) {
                    ++n4;
                } else if (this.isFirst(tokenList) && token.getToknum() == 645) {
                    return this.cloneToken(token, i + 1);
                }
                token2 = token;
                token = tokenList.getPrevious();
            }
        }
        return null;
    }

    private Token findToken(int n, StyledText styledText, int n2, int n3, TokenList[] tokenListArray, int n4) {
        for (int i = n2; i >= 0; --i) {
            TokenList tokenList = this.getTokenList(i - n3, tokenListArray, i, styledText, n4);
            Token token = tokenList.getLast();
            while (token != null) {
                if (this.isFirst(tokenList) && token.getToknum() == n) {
                    return this.cloneToken(token, i + 1);
                }
                token = tokenList.getPrevious();
            }
        }
        return null;
    }

    private boolean isFirst(TokenList tokenList) {
        boolean bl;
        boolean bl2 = bl = tokenList.getPrevious() == null;
        if (!bl) {
            tokenList.getNext();
        }
        return bl;
    }

    private Token findLevelNumberLess(int n, StyledText styledText, int n2, int n3, TokenList[] tokenListArray, String string, int n4) {
        block0: for (int i = n2; i >= 0; --i) {
            TokenList tokenList = this.getTokenList(i - n3, tokenListArray, i, styledText, n4);
            Token token = tokenList.getLast();
            while (token != null) {
                String string2 = token.getWord();
                if (this.isFirst(tokenList)) {
                    int n5 = Tokens.getLevelNumber((String)string2);
                    if (n5 == 88) continue block0;
                    if (n5 > 0 && n5 < n) {
                        return this.cloneToken(token, i + 1);
                    }
                    if (string != null && string.startsWith(string2)) {
                        return this.cloneToken(token, i + 1);
                    }
                }
                token = tokenList.getPrevious();
            }
        }
        return null;
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    private SelectionRanges getSelectionRanges(IEditorPart iEditorPart) {
        SelectionRanges selectionRanges = new SelectionRanges(null);
        if (iEditorPart != null) {
            if (iEditorPart instanceof IscobolEditor) {
                selectionRanges.iscobolEditor = (IscobolEditor)iEditorPart;
                selectionRanges.viewer = selectionRanges.iscobolEditor.getViewer();
            } else {
                selectionRanges.iscobolEditor = (IscobolEditor)iEditorPart.getAdapter(IscobolEditor.class);
                selectionRanges.viewer = selectionRanges.iscobolEditor != null ? selectionRanges.iscobolEditor.getViewer() : null;
            }
        } else {
            selectionRanges.viewer = null;
        }
        if (selectionRanges.viewer == null) {
            selectionRanges.endOffset = -1;
            selectionRanges.startOffset = -1;
            selectionRanges.endLineNumber = -1;
            selectionRanges.startLineNumber = -1;
            return selectionRanges;
        }
        StyledText styledText = selectionRanges.viewer.getTextWidget();
        if (styledText.getSelectionCount() > 0) {
            Point point = styledText.getSelectionRange();
            selectionRanges.startLineNumber = styledText.getLineAtOffset(point.x);
            selectionRanges.endLineNumber = styledText.getLineAtOffset(point.x + point.y);
            selectionRanges.startOffset = styledText.getOffsetAtLine(selectionRanges.startLineNumber);
            selectionRanges.endOffset = styledText.getOffsetAtLine(selectionRanges.endLineNumber) + styledText.getLine(selectionRanges.endLineNumber).length();
        } else {
            int n = styledText.getCaretOffset();
            selectionRanges.startLineNumber = selectionRanges.endLineNumber = styledText.getLineAtOffset(n);
            selectionRanges.startOffset = styledText.getOffsetAtLine(selectionRanges.startLineNumber);
            selectionRanges.endOffset = styledText.getOffsetAtLine(selectionRanges.startLineNumber) + styledText.getLine(selectionRanges.startLineNumber).length();
        }
        return selectionRanges;
    }
}

