/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.handlers;

import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.TraceOffCommand;
import com.iscobol.debugger.commands.TraceOnCommand;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.debug.IscobolDebugTarget;
import com.iscobol.plugins.editor.dialogs.TraceDialog;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class TraceHandler
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        State state = executionEvent.getCommand().getState("STYLE");
        Event event = (Event)executionEvent.getTrigger();
        ToolItem toolItem = (ToolItem)event.widget;
        IscobolDebugTarget iscobolDebugTarget = IscobolDebugTarget.getCurrent();
        if (state.getValue() == Boolean.FALSE) {
            TraceDialog traceDialog = new TraceDialog(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), IsresourceBundle.getString((String)"start_tr_title"));
            traceDialog.open();
            TraceOnCommand traceOnCommand = traceDialog.getCommand();
            if (traceOnCommand != null) {
                DebugResponse debugResponse = iscobolDebugTarget.processCommand((DebugCommand)traceOnCommand);
                if (debugResponse.getReturnCode() == 0) {
                    state.setValue((Object)Boolean.TRUE);
                    iscobolDebugTarget.setTracingEnabled(true);
                } else {
                    PluginUtilities.logError((String)debugResponse.getMessage().substring(2));
                    toolItem.setSelection(false);
                    iscobolDebugTarget.setTracingEnabled(false);
                }
            } else {
                toolItem.setSelection(false);
                iscobolDebugTarget.setTracingEnabled(false);
            }
        } else {
            DebugResponse debugResponse = iscobolDebugTarget.processCommand((DebugCommand)new TraceOffCommand());
            if (debugResponse.getReturnCode() == 0) {
                state.setValue((Object)Boolean.FALSE);
                iscobolDebugTarget.setTracingEnabled(true);
            } else {
                PluginUtilities.logError((String)debugResponse.getMessage().substring(2));
                toolItem.setSelection(true);
                iscobolDebugTarget.setTracingEnabled(false);
            }
        }
        return null;
    }

    public void updateElement(UIElement uIElement, Map map) {
        IscobolDebugTarget iscobolDebugTarget = IscobolDebugTarget.getCurrent();
        if (iscobolDebugTarget == null || iscobolDebugTarget.isTerminated()) {
            uIElement.setChecked(false);
        }
    }
}

