/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.launch.externaltools;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.launch.externaltools.AppServerManager;
import com.iscobol.plugins.editor.launch.externaltools.CobFileIOManager;
import com.iscobol.plugins.editor.launch.externaltools.CopyGenManager;
import com.iscobol.plugins.editor.launch.externaltools.CpkManager;
import com.iscobol.plugins.editor.launch.externaltools.ExternalToolManager;
import com.iscobol.plugins.editor.launch.externaltools.GifeManager;
import com.iscobol.plugins.editor.launch.externaltools.IsMigrateManager;
import com.iscobol.plugins.editor.launch.externaltools.IscobolToolsLaunchConfigurationDelegate;
import com.iscobol.plugins.editor.launch.externaltools.IslManager;
import com.iscobol.plugins.editor.launch.externaltools.Jdbc2FdManager;
import com.iscobol.plugins.editor.launch.externaltools.LoadBalancerManager;
import com.iscobol.plugins.editor.launch.externaltools.RemoteCompilerManager;
import com.iscobol.plugins.editor.launch.externaltools.WSDL2WrkManager;
import com.iscobol.plugins.editor.launch.externaltools.XML2WrkManager;
import com.iscobol.plugins.editor.util.ClasspathItem;
import com.iscobol.plugins.editor.util.EnvironmentItem;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.jface.preference.IPreferenceStore;

public abstract class ExternalToolManager
implements IDebugEventSetListener {
    private static final Map<Class, Item> managers;
    private ILaunch launch;

    public static <T extends ExternalToolManager> T getInstance(Class<T> clazz) {
        Item item = (Item)managers.get(clazz);
        return (T)(item != null ? item.manager : null);
    }

    public static void stopAllManagers() {
        for (Item item : managers.values()) {
            item.manager.stop(false);
        }
    }

    protected void setAttributes(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public String getClasspathPreferenceKey() {
        return null;
    }

    public String getEnvironmentPreferenceKey() {
        return null;
    }

    public String getEnvironmentCountPreferenceKey() {
        return null;
    }

    public String getEnvironmentAppendPreferenceKey() {
        return null;
    }

    public String getJvmArgumentsPreferenceKey() {
        return null;
    }

    public String getWorkingDirectoryPreferenceKey() {
        return null;
    }

    public abstract String getId();

    public abstract String getLabel();

    public String getAlreadyStartedMessage() {
        return null;
    }

    public String getNotStartedMessage() {
        return null;
    }

    public void start() {
        if (this.launch != null && !this.launch.isTerminated()) {
            PluginUtilities.logError((String)this.getAlreadyStartedMessage());
            return;
        }
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        try {
            ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType(this.getId());
            ILaunchDelegate iLaunchDelegate = iLaunchConfigurationType.getDelegates(IscobolToolsLaunchConfigurationDelegate.modeSet)[0];
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, this.getLabel());
            this.setAttributes(iLaunchConfigurationWorkingCopy);
            this.launch = new Launch((ILaunchConfiguration)iLaunchConfigurationWorkingCopy, this.getLabel(), null);
            iLaunchDelegate.getDelegate().launch((ILaunchConfiguration)iLaunchConfigurationWorkingCopy, "run", this.launch, null);
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void stop(boolean bl) {
        if (this.launch == null || this.launch.isTerminated()) {
            if (bl) {
                PluginUtilities.logError((String)this.getNotStartedMessage());
            }
        } else {
            try {
                if (DebugPlugin.getDefault() != null) {
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(this.launch);
                }
                this.launch.terminate();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        this.launch = null;
        if (DebugPlugin.getDefault() != null) {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        }
    }

    public final void stop() {
        this.stop(true);
    }

    public void restart() {
        if (this.launch != null && !this.launch.isTerminated()) {
            this.stop();
        }
        this.start();
    }

    public ClasspathItem[] getClasspath() {
        if (this.getClasspathPreferenceKey() == null) {
            return new ClasspathItem[0];
        }
        String string = IscobolEditorPlugin.getStringFromStore((String)this.getClasspathPreferenceKey());
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ClasspathItem[] classpathItemArray = new ClasspathItem[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string2.substring(0, 1));
            boolean bl = true;
            string2 = string2.substring(1);
            IProject iProject = null;
            switch (n2) {
                case 1: {
                    iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string2);
                    bl = iProject != null && iProject.exists();
                    break;
                }
                case 2: {
                    iProject = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(string2));
                    bl = iProject != null && iProject.exists();
                    break;
                }
                case 3: {
                    iProject = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string2));
                    bl = iProject != null && iProject.exists();
                    break;
                }
                case 4: {
                    File file = new File(string2);
                    bl = file.exists() && file.isDirectory();
                    break;
                }
                case 5: {
                    File file = new File(string2);
                    bl = file.exists() && file.isFile();
                }
            }
            classpathItemArray[n] = new ClasspathItem(string2, bl, n2);
            if (classpathItemArray[n].exists) {
                classpathItemArray[n].resource = iProject;
            }
            ++n;
        }
        return classpathItemArray;
    }

    public void setClasspath(ClasspathItem[] classpathItemArray) {
        if (this.getClasspathPreferenceKey() == null) {
            return;
        }
        IPreferenceStore iPreferenceStore = IscobolEditorPlugin.getDefault().getPreferenceStore();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < classpathItemArray.length; ++i) {
            stringBuilder.append(classpathItemArray[i].type);
            stringBuilder.append(classpathItemArray[i].path);
            if (i >= classpathItemArray.length - 1) continue;
            stringBuilder.append(File.pathSeparator);
        }
        iPreferenceStore.setValue(this.getClasspathPreferenceKey(), stringBuilder.toString());
    }

    public void setEnvironment(EnvironmentItem[] environmentItemArray) {
        int n;
        if (this.getEnvironmentPreferenceKey() == null || this.getEnvironmentCountPreferenceKey() == null) {
            return;
        }
        IPreferenceStore iPreferenceStore = IscobolEditorPlugin.getDefault().getPreferenceStore();
        int n2 = IscobolEditorPlugin.getIntFromStore((String)this.getEnvironmentCountPreferenceKey());
        for (n = 0; n < n2; ++n) {
            iPreferenceStore.setToDefault(this.getEnvironmentPreferenceKey() + n2);
        }
        if (environmentItemArray.length == 0) {
            iPreferenceStore.setToDefault(this.getEnvironmentCountPreferenceKey());
        } else {
            iPreferenceStore.setValue(this.getEnvironmentCountPreferenceKey(), environmentItemArray.length);
            for (n = 0; n < environmentItemArray.length; ++n) {
                iPreferenceStore.setValue(this.getEnvironmentPreferenceKey() + n, environmentItemArray[n].name + "=" + environmentItemArray[n].value);
            }
        }
    }

    public EnvironmentItem[] getEnvironment() {
        if (this.getEnvironmentPreferenceKey() == null || this.getEnvironmentCountPreferenceKey() == null) {
            return new EnvironmentItem[0];
        }
        IPreferenceStore iPreferenceStore = IscobolEditorPlugin.getDefault().getPreferenceStore();
        int n = IscobolEditorPlugin.getIntFromStore((String)this.getEnvironmentCountPreferenceKey());
        EnvironmentItem[] environmentItemArray = new EnvironmentItem[n];
        for (int i = 0; i < n; ++i) {
            String string = iPreferenceStore.getString(this.getEnvironmentPreferenceKey() + i);
            int n2 = string.indexOf(61);
            String string2 = string.substring(0, n2);
            String string3 = "";
            if (n2 < string.length() - 1) {
                string3 = string.substring(n2 + 1);
            }
            environmentItemArray[i] = new EnvironmentItem(string2, string3);
        }
        return environmentItemArray;
    }

    public boolean getAppendEnvironment() {
        if (this.getEnvironmentAppendPreferenceKey() == null) {
            return false;
        }
        return IscobolEditorPlugin.getBooleanFromStore((String)this.getEnvironmentAppendPreferenceKey());
    }

    public void setAppendEnvironment(boolean bl) {
        if (this.getEnvironmentAppendPreferenceKey() == null) {
            return;
        }
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue(this.getEnvironmentAppendPreferenceKey(), bl);
    }

    public String getWorkingDirectory() {
        if (this.getWorkingDirectoryPreferenceKey() == null) {
            return null;
        }
        return IscobolEditorPlugin.getStringFromStore((String)this.getWorkingDirectoryPreferenceKey());
    }

    public void setWorkingDirectory(String string) {
        if (this.getWorkingDirectoryPreferenceKey() == null) {
            return;
        }
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue(this.getWorkingDirectoryPreferenceKey(), string);
    }

    public String getJVMArguments() {
        if (this.getJvmArgumentsPreferenceKey() == null) {
            return null;
        }
        return IscobolEditorPlugin.getStringFromStore((String)this.getJvmArgumentsPreferenceKey());
    }

    public void setJVMArguments(String string) {
        if (this.getJvmArgumentsPreferenceKey() == null) {
            return;
        }
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue(this.getJvmArgumentsPreferenceKey(), string);
    }

    public void handleDebugEvents(DebugEvent[] debugEventArray) {
        if (this.launch != null && this.launch.isTerminated()) {
            this.stop(false);
        }
    }

    static {
        HashMap<Class, Item> hashMap = new HashMap<Class, Item>();
        hashMap.put(AppServerManager.class, new Item((ExternalToolManager)new AppServerManager()));
        hashMap.put(RemoteCompilerManager.class, new Item((ExternalToolManager)new RemoteCompilerManager()));
        hashMap.put(LoadBalancerManager.class, new Item((ExternalToolManager)new LoadBalancerManager()));
        hashMap.put(GifeManager.class, new Item((ExternalToolManager)new GifeManager()));
        hashMap.put(CpkManager.class, new Item((ExternalToolManager)new CpkManager()));
        hashMap.put(Jdbc2FdManager.class, new Item((ExternalToolManager)new Jdbc2FdManager()));
        hashMap.put(IsMigrateManager.class, new Item((ExternalToolManager)new IsMigrateManager()));
        hashMap.put(WSDL2WrkManager.class, new Item((ExternalToolManager)new WSDL2WrkManager()));
        hashMap.put(IslManager.class, new Item((ExternalToolManager)new IslManager()));
        hashMap.put(XML2WrkManager.class, new Item((ExternalToolManager)new XML2WrkManager()));
        hashMap.put(CopyGenManager.class, new Item((ExternalToolManager)new CopyGenManager()));
        hashMap.put(CobFileIOManager.class, new Item((ExternalToolManager)new CobFileIOManager()));
        managers = Collections.unmodifiableMap(hashMap);
    }
}

