/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.preferences;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AppServerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text wrkDirTxt;
    private Text hostnameTxt;
    private Button reuseAddressBtn;
    private Button enableLoggingBtn;
    private Text logFileTxt;
    private Button logFileBrowseBtn;
    private Label logFileLbl;
    private Text portTxt;
    private Text jvmArgsTxt;
    private ModifyListener ml = new /* Unavailable Anonymous Inner Class!! */;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(IsresourceBundle.getString((String)"host_lbl") + ":");
        this.hostnameTxt = new Text(composite2, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 300;
        gridData.horizontalSpan = 2;
        this.hostnameTxt.setLayoutData((Object)gridData);
        this.hostnameTxt.setText(IscobolEditorPlugin.getStringFromStore((String)"iscobol.appserver.hostname"));
        label = new Label(composite2, 0);
        label.setText(IsresourceBundle.getString((String)"port_lbl") + ":");
        this.portTxt = new Text(composite2, 133120);
        gridData = new GridData();
        gridData.widthHint = 60;
        gridData.horizontalSpan = 2;
        this.portTxt.setLayoutData((Object)gridData);
        this.portTxt.setText(IscobolEditorPlugin.getStringFromStore((String)"iscobol.appaserver.portnumber"));
        this.reuseAddressBtn = new Button(composite2, 32);
        this.reuseAddressBtn.setText(IsresourceBundle.getString((String)"reuse_address_lbl"));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.reuseAddressBtn.setLayoutData((Object)gridData);
        this.reuseAddressBtn.setSelection(IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.appserver.reuseaddr"));
        Composite composite3 = new Composite(composite2, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        composite3.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 0;
        composite3.setLayout((Layout)gridLayout);
        this.enableLoggingBtn = new Button(composite3, 32);
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        this.enableLoggingBtn.setLayoutData((Object)gridData);
        Group group = new Group(composite3, 0);
        group.setText(IsresourceBundle.getString((String)"enable_log_lbl"));
        gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        this.logFileLbl = new Label((Composite)group, 0);
        this.logFileLbl.setText(IsresourceBundle.getString((String)"log_file_lbl") + ":");
        this.logFileTxt = new Text((Composite)group, 2048);
        this.logFileTxt.setLayoutData((Object)new GridData(768));
        this.logFileBrowseBtn = new Button((Composite)group, 8);
        this.logFileBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.enableLoggingBtn.setSelection(IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.appserver.log.enabled"));
        this.setEnableLoggingGroupEnabled(this.enableLoggingBtn.getSelection());
        if (this.enableLoggingBtn.getSelection()) {
            this.logFileTxt.setText(IscobolEditorPlugin.getStringFromStore((String)"iscobol.appserver.log.file"));
        }
        Group group2 = new Group(composite2, 0);
        group2.setText(IsresourceBundle.getString((String)"jvm_args_lbl"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 50;
        group2.setLayoutData((Object)gridData);
        group2.setLayout((Layout)new FillLayout());
        this.jvmArgsTxt = new Text((Composite)group2, 2114);
        this.jvmArgsTxt.setText(IscobolEditorPlugin.getStringFromStore((String)"iscobol.appserver.jvmargs"));
        label = new Label(composite2, 0);
        label.setText(IsresourceBundle.getString((String)"workdir_lbl") + ":");
        this.wrkDirTxt = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.wrkDirTxt.setLayoutData((Object)gridData);
        this.wrkDirTxt.setText(IscobolEditorPlugin.getStringFromStore((String)"iscobol.appserver.workdir"));
        Button button = new Button(composite2, 8);
        button.setText(IsresourceBundle.getString((String)"browse_lbl"));
        button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.hostnameTxt.addModifyListener(this.ml);
        this.portTxt.addModifyListener(this.ml);
        this.wrkDirTxt.addModifyListener(this.ml);
        this.logFileTxt.addModifyListener(this.ml);
        this.enableLoggingBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.logFileBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(IscobolEditorPlugin.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setValue("iscobol.appserver.hostname", this.hostnameTxt.getText());
        iPreferenceStore.setValue("iscobol.appaserver.portnumber", this.portTxt.getText());
        iPreferenceStore.setValue("iscobol.appserver.reuseaddr", this.reuseAddressBtn.getSelection());
        iPreferenceStore.setValue("iscobol.appserver.log.enabled", this.enableLoggingBtn.getSelection());
        if (this.enableLoggingBtn.getSelection()) {
            iPreferenceStore.setValue("iscobol.appserver.log.file", this.logFileTxt.getText());
        } else {
            iPreferenceStore.setValue("iscobol.appserver.log.file", "");
        }
        iPreferenceStore.setValue("iscobol.appserver.jvmargs", this.jvmArgsTxt.getText());
        iPreferenceStore.setValue("iscobol.appserver.workdir", this.wrkDirTxt.getText());
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.hostnameTxt.setText(iPreferenceStore.getDefaultString("iscobol.appserver.hostname"));
        this.portTxt.setText(iPreferenceStore.getDefaultString("iscobol.appaserver.portnumber"));
        this.reuseAddressBtn.setSelection(iPreferenceStore.getDefaultBoolean("iscobol.appserver.reuseaddr"));
        this.enableLoggingBtn.setSelection(iPreferenceStore.getDefaultBoolean("iscobol.appserver.log.enabled"));
        if (this.enableLoggingBtn.getSelection()) {
            this.logFileTxt.setText(iPreferenceStore.getDefaultString("iscobol.appserver.log.file"));
        } else {
            this.logFileTxt.setText("");
        }
        this.setEnableLoggingGroupEnabled(this.enableLoggingBtn.getSelection());
        this.jvmArgsTxt.setText(iPreferenceStore.getDefaultString("iscobol.appserver.jvmargs"));
        this.wrkDirTxt.setText(iPreferenceStore.getDefaultString("iscobol.appserver.workdir"));
    }

    private void setEnableLoggingGroupEnabled(boolean bl) {
        this.logFileLbl.setEnabled(bl);
        this.logFileTxt.setEnabled(bl);
        this.logFileBrowseBtn.setEnabled(bl);
    }

    private void validatePage() {
        String string = this.validatePage0();
        this.setErrorMessage(string);
        this.setValid(string == null);
    }

    private String validatePage0() {
        File file;
        if (!PluginUtilities.validateHostName((String)this.hostnameTxt.getText())) {
            return IsresourceBundle.getString((String)"invalid_host_msg");
        }
        if (!PluginUtilities.validatePortNumber((String)this.portTxt.getText())) {
            return IsresourceBundle.getString((String)"invalid_port_msg");
        }
        if (this.wrkDirTxt.getText().length() > 0 && !new File(this.wrkDirTxt.getText()).exists()) {
            return "'" + this.wrkDirTxt.getText() + "': " + IsresourceBundle.getString((String)"folder_not_exist_msg");
        }
        if (this.enableLoggingBtn.getSelection() && this.logFileTxt.getText().length() > 0 && ((file = new File(this.logFileTxt.getText())).isDirectory() || file.getParentFile() == null || !file.getParentFile().exists())) {
            return "'" + this.logFileTxt.getText() + "': " + IsresourceBundle.getString((String)"invalid_log_file_msg");
        }
        return null;
    }

    static /* synthetic */ void access$000(AppServerPreferencePage appServerPreferencePage) {
        appServerPreferencePage.validatePage();
    }

    static /* synthetic */ Text access$100(AppServerPreferencePage appServerPreferencePage) {
        return appServerPreferencePage.wrkDirTxt;
    }

    static /* synthetic */ Button access$200(AppServerPreferencePage appServerPreferencePage) {
        return appServerPreferencePage.enableLoggingBtn;
    }

    static /* synthetic */ void access$300(AppServerPreferencePage appServerPreferencePage, boolean bl) {
        appServerPreferencePage.setEnableLoggingGroupEnabled(bl);
    }

    static /* synthetic */ Text access$400(AppServerPreferencePage appServerPreferencePage) {
        return appServerPreferencePage.logFileTxt;
    }
}

