/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.preferences;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.preferences.RunDebugPreferencePage;
import com.iscobol.plugins.editor.util.PluginUtilities;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class RunDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private RadioGroupFieldEditor switchBackPerspEditor;
    private Button useExternalDebugBtn;
    private Button useStandardDebugBtn;
    private int appFlags;
    private TreeItem iscobolItem;
    private TreeItem wd2Item;
    private Text maxHexDumpLengthTxt;
    private Text hexDumpStartTxt;
    private Text maxArrayLengthTxt;
    private Text arrayStartTxt;
    private Text maxTextLengthTxt;
    private BooleanFieldEditor warnDebugInfoEditor;
    private Button useRandomPortBtn;
    private Button usePortBtn;
    private Text jettyPortTxt;
    private boolean wd2PluginInstalled = Platform.getBundle((String)"com.iscobol.plugins.webdirectlauncher") != null;
    private boolean modifyListenerEnabled = true;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        PluginUtilities.addPreferenceLink((Composite)composite2, (IWorkbenchPreferenceContainer)((IWorkbenchPreferenceContainer)this.getContainer()), (String)IsresourceBundle.getString((String)"rundebug_lnk"), (String)"org.eclipse.debug.ui.LaunchingPreferencePage");
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout());
        boolean bl = IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.useextdebug");
        this.useStandardDebugBtn = new Button((Composite)group, 16);
        this.useStandardDebugBtn.setText(IsresourceBundle.getString((String)"use_standard_debugger_lbl"));
        this.useExternalDebugBtn = new Button((Composite)group, 16);
        this.useExternalDebugBtn.setText(IsresourceBundle.getString((String)"use_external_debugger_lbl"));
        if (bl) {
            this.useExternalDebugBtn.setSelection(true);
        } else {
            this.useStandardDebugBtn.setSelection(true);
        }
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite3.setLayout((Layout)gridLayout);
        String[][] stringArray = new String[][]{{"Yes", Integer.toString(0)}, {"No", Integer.toString(1)}, {"Prompt", Integer.toString(2)}};
        this.switchBackPerspEditor = new RadioGroupFieldEditor("iscobol.switchback.ispersp", IsresourceBundle.getString((String)"switch_back_lbl"), 3, stringArray, composite3, true);
        this.switchBackPerspEditor.setPage((DialogPage)this);
        this.switchBackPerspEditor.setPreferenceStore(this.getPreferenceStore());
        this.switchBackPerspEditor.load();
        this.warnDebugInfoEditor = new BooleanFieldEditor("iscobol.debug.warndebuginfonotfound", IsresourceBundle.getString((String)"warning_debug_info_not_found_lbl"), 0, composite2);
        this.warnDebugInfoEditor.setPage((DialogPage)this);
        this.warnDebugInfoEditor.setPreferenceStore(this.getPreferenceStore());
        this.warnDebugInfoEditor.load();
        this.appFlags = Integer.parseInt(IscobolEditorPlugin.getStringFromStore((String)"iscobol.rundebugas"));
        group = new Group(composite2, 0);
        group.setText(IsresourceBundle.getString((String)"run_debug_as_lbl"));
        GridData gridData = new GridData(768);
        gridData.heightHint = 80;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout());
        Tree tree = new Tree((Composite)group, 2080);
        gridData = new GridData(1808);
        tree.setLayoutData((Object)gridData);
        this.iscobolItem = new TreeItem(tree, 0);
        this.iscobolItem.setText(IsresourceBundle.getString((String)"iscobol.application.name"));
        this.iscobolItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/iscobol16x16.png"));
        if (this.wd2PluginInstalled) {
            this.wd2Item = new TreeItem(tree, 0);
            this.wd2Item.setText(IsresourceBundle.getString((String)"iscobol.wd2application.name"));
            this.wd2Item.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/wd2.png"));
        }
        group = new Group(composite2, 0);
        group.setText(IsresourceBundle.getString((String)"jetty_port_lbl"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        this.useRandomPortBtn = new Button((Composite)group, 16);
        this.useRandomPortBtn.setText(IsresourceBundle.getString((String)"use_random_port_lbl"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.useRandomPortBtn.setLayoutData((Object)gridData);
        this.usePortBtn = new Button((Composite)group, 16);
        this.usePortBtn.setText(IsresourceBundle.getString((String)"use_port_lbl"));
        this.jettyPortTxt = new Text((Composite)group, 133120);
        gridData = new GridData();
        gridData.widthHint = 50;
        this.jettyPortTxt.setLayoutData((Object)gridData);
        int n = IscobolEditorPlugin.getIntFromStore((String)"iscobol.jetty.port");
        if (n == 0) {
            this.useRandomPortBtn.setSelection(true);
            this.jettyPortTxt.setEnabled(false);
        } else {
            this.usePortBtn.setSelection(true);
            this.jettyPortTxt.setEnabled(true);
            this.jettyPortTxt.setText(Integer.toString(n));
        }
        this.useRandomPortBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.jettyPortTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        group = new Group(composite2, 0);
        group.setText(IsresourceBundle.getString((String)"details_view_settings_lbl"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        3 var11_11 = new /* Unavailable Anonymous Inner Class!! */;
        this.maxHexDumpLengthTxt = this.createTextField("iscobol.debug.maxhexdumplength", (ModifyListener)var11_11, IsresourceBundle.getString((String)"max_hex_dump_len_lbl") + ":", group);
        this.hexDumpStartTxt = this.createTextField("iscobol.debug.hexdumpstartoffset", (ModifyListener)var11_11, IsresourceBundle.getString((String)"hex_dump_start_offs_lbl") + ":", group);
        this.maxArrayLengthTxt = this.createTextField("iscobol.debug.maxarraylength", (ModifyListener)var11_11, IsresourceBundle.getString((String)"max_array_len_lbl") + ":", group);
        this.arrayStartTxt = this.createTextField("iscobol.debug.startarrayindex", (ModifyListener)var11_11, IsresourceBundle.getString((String)"array_start_offs_lbl") + ":", group);
        this.maxTextLengthTxt = this.createTextField("iscobol.debug.maxtextlength", (ModifyListener)var11_11, IsresourceBundle.getString((String)"max_text_len_lbl") + ":", group);
        this.updateItems();
        tree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private Text createTextField(String string, ModifyListener modifyListener, String string2, Group group) {
        Label label = new Label((Composite)group, 0);
        label.setText(string2);
        Text text = new Text((Composite)group, 133120);
        GridData gridData = new GridData();
        gridData.widthHint = 50;
        text.setLayoutData((Object)gridData);
        text.setText(IscobolEditorPlugin.getStringFromStore((String)string));
        text.addModifyListener(modifyListener);
        return text;
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(IscobolEditorPlugin.getDefault().getPreferenceStore());
    }

    private void validatePage() {
        String string = this.validatePage0();
        this.setErrorMessage(string);
        this.setValid(string == null);
        this.updateApplyButton();
    }

    private String validatePage0() {
        int n;
        this.appFlags = 0;
        if (this.iscobolItem.getChecked()) {
            ++this.appFlags;
        }
        if (this.wd2Item != null && this.wd2Item.getChecked()) {
            this.appFlags += 2;
        }
        if (this.usePortBtn.getSelection()) {
            String string = this.jettyPortTxt.getText();
            if (string.length() == 0) {
                return IsresourceBundle.getString((String)"set_jetty_port_msg");
            }
            try {
                int n2 = Integer.parseInt(string);
                if (n2 <= 0 || n2 > 65535) {
                    return IsresourceBundle.getString((String)"set_jetty_port2_msg");
                }
            }
            catch (NumberFormatException numberFormatException) {
                return IsresourceBundle.getString((String)"set_jetty_port2_msg");
            }
        }
        if (!(this.iscobolItem.getChecked() || this.wd2Item != null && this.wd2Item.getChecked())) {
            return IsresourceBundle.getString((String)"select_run_debug_as_app_msg");
        }
        try {
            n = Integer.parseInt(this.maxHexDumpLengthTxt.getText());
            if (n <= 0) {
                return IsresourceBundle.getString((String)"max_hex_dump_len_msg");
            }
            if (n > 1024) {
                return IsresourceBundle.getString((String)"max_hex_dump_len2_msg") + " " + 1024;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return IsresourceBundle.getString((String)"max_hex_dump_len3_msg");
        }
        try {
            n = Integer.parseInt(this.hexDumpStartTxt.getText());
            if (n <= 0) {
                return IsresourceBundle.getString((String)"hex_dump_start_offs_msg");
            }
        }
        catch (NumberFormatException numberFormatException) {
            return IsresourceBundle.getString((String)"hex_dump_start_offs2_msg");
        }
        try {
            n = Integer.parseInt(this.maxArrayLengthTxt.getText());
            if (n <= 0) {
                return IsresourceBundle.getString((String)"max_array_len_msg");
            }
            if (n > 100) {
                return IsresourceBundle.getString((String)"max_array_len2_msg") + " " + 100;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return IsresourceBundle.getString((String)"max_array_len3_msg");
        }
        try {
            n = Integer.parseInt(this.arrayStartTxt.getText());
            if (n <= 0) {
                return IsresourceBundle.getString((String)"array_start_offs_msg");
            }
        }
        catch (NumberFormatException numberFormatException) {
            return IsresourceBundle.getString((String)"array_start_offs2_msg");
        }
        try {
            n = Integer.parseInt(this.maxTextLengthTxt.getText());
            if (n <= 0) {
                return IsresourceBundle.getString((String)"max_text_len_msg");
            }
            if (n > 2048) {
                return IsresourceBundle.getString((String)"max_text_len2_msg") + " " + 2048;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return IsresourceBundle.getString((String)"max_text_len3_msg");
        }
        return null;
    }

    private void updateItems() {
        if ((this.appFlags & 1) == 1) {
            this.iscobolItem.setChecked(true);
        }
        if (this.wd2Item != null && (this.appFlags & 2) == 2) {
            this.wd2Item.setChecked(true);
        }
    }

    public boolean performOk() {
        this.switchBackPerspEditor.store();
        this.warnDebugInfoEditor.store();
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        if (this.appFlags > 0) {
            this.getPreferenceStore().setValue("iscobol.rundebugas", this.appFlags);
        }
        iPreferenceStore.setValue("iscobol.debug.maxhexdumplength", this.maxHexDumpLengthTxt.getText());
        iPreferenceStore.setValue("iscobol.debug.hexdumpstartoffset", this.hexDumpStartTxt.getText());
        iPreferenceStore.setValue("iscobol.debug.maxarraylength", this.maxArrayLengthTxt.getText());
        iPreferenceStore.setValue("iscobol.debug.startarrayindex", this.arrayStartTxt.getText());
        iPreferenceStore.setValue("iscobol.debug.maxtextlength", this.maxTextLengthTxt.getText());
        iPreferenceStore.setValue("iscobol.useextdebug", this.useExternalDebugBtn.getSelection());
        if (this.useRandomPortBtn.getSelection()) {
            iPreferenceStore.setValue("iscobol.jetty.port", 0);
        } else {
            iPreferenceStore.setValue("iscobol.jetty.port", this.jettyPortTxt.getText());
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.switchBackPerspEditor.loadDefault();
        this.warnDebugInfoEditor.loadDefault();
        this.appFlags = this.getPreferenceStore().getDefaultInt("iscobol.rundebugas");
        this.updateItems();
        this.modifyListenerEnabled = false;
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.useStandardDebugBtn.setSelection(true);
        this.useExternalDebugBtn.setSelection(false);
        this.maxHexDumpLengthTxt.setText(iPreferenceStore.getDefaultString("iscobol.debug.maxhexdumplength"));
        this.hexDumpStartTxt.setText(iPreferenceStore.getDefaultString("iscobol.debug.hexdumpstartoffset"));
        this.maxArrayLengthTxt.setText(iPreferenceStore.getDefaultString("iscobol.debug.maxarraylength"));
        this.arrayStartTxt.setText(iPreferenceStore.getDefaultString("iscobol.debug.startarrayindex"));
        this.maxTextLengthTxt.setText(iPreferenceStore.getDefaultString("iscobol.debug.maxtextlength"));
        this.useRandomPortBtn.setSelection(true);
        this.usePortBtn.setSelection(false);
        this.jettyPortTxt.setEnabled(false);
        this.jettyPortTxt.setText("");
        this.validatePage();
        this.modifyListenerEnabled = true;
    }

    static /* synthetic */ Button access$000(RunDebugPreferencePage runDebugPreferencePage) {
        return runDebugPreferencePage.useRandomPortBtn;
    }

    static /* synthetic */ Text access$100(RunDebugPreferencePage runDebugPreferencePage) {
        return runDebugPreferencePage.jettyPortTxt;
    }

    static /* synthetic */ void access$200(RunDebugPreferencePage runDebugPreferencePage) {
        runDebugPreferencePage.validatePage();
    }

    static /* synthetic */ boolean access$300(RunDebugPreferencePage runDebugPreferencePage) {
        return runDebugPreferencePage.modifyListenerEnabled;
    }
}

