/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.preferences;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PreferenceConverter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SyntaxColoringPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWizardPage {
    private static final int NONE = -1;
    private static final int SEQUENCE_NUMBER = 1;
    private static final int INDICATOR_AREA = 2;
    private static final int AREA_A = 3;
    private static final int AREA_B = 4;
    private static final int COMMENTS = 5;
    private static final int KEYWORDS = 6;
    private static final int STRINGS = 7;
    private static final int NUMBERS = 8;
    private static final int STATEMENTS = 9;
    private static final int LEVEL_NUMBER = 10;
    private static final int FIGURATIVE_CONST = 11;
    private static final int DBG_CURRENT_LINE = 12;
    private static final int IDENTIFICATION_AREA = 13;
    private Map<String, RGB> colorMap = new HashMap();
    private ColorFieldEditor sourceFormatBgEditor;
    private ColorFieldEditor sourceFormatFgEditor;
    private ColorFieldEditor syntaxHltBgEditor;
    private ColorFieldEditor syntaxHltFgEditor;
    private Composite sourceFormatColorGrp;
    private Composite syntaxHltColorGrp;
    private BooleanFieldEditor sourceFormatEnEditor;
    private BooleanFieldEditor syntaxHltEnEditor;
    private Tree sourceFormatTree;
    private Tree syntaxHltTree;
    private boolean syntaxHltEnabled;
    private boolean sourceFormatEnabled;
    private int currElement;
    private IWizardPage prevPage;
    private IWizard wizard;

    public SyntaxColoringPreferencePage() {
    }

    public SyntaxColoringPreferencePage(String string) {
        super(string);
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite composite) {
        Composite composite2;
        Composite composite3;
        ScrolledComposite scrolledComposite;
        if (this.wizard != null) {
            scrolledComposite = new ScrolledComposite(composite, 2816);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            composite3 = new Composite((Composite)scrolledComposite, 0);
            scrolledComposite.setContent((Control)composite3);
            composite2 = scrolledComposite;
        } else {
            scrolledComposite = null;
            composite2 = composite3 = new Composite(composite, 0);
        }
        GridLayout gridLayout = new GridLayout();
        composite3.setLayout((Layout)gridLayout);
        Group group = new Group(composite3, 0);
        group.setText(IsresourceBundle.getString((String)"src_format_lbl"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        Composite composite4 = new Composite((Composite)group, 0);
        this.sourceFormatEnEditor = new BooleanFieldEditor("iscobol.sourceformat.enabled", IsresourceBundle.getString((String)"src_format_en_lbl"), composite4);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        composite4.setLayoutData((Object)gridData);
        this.sourceFormatEnEditor.setPage((DialogPage)this);
        this.sourceFormatEnEditor.setPreferenceStore(this.getPreferenceStore());
        this.sourceFormatEnEditor.load();
        this.sourceFormatTree = new Tree((Composite)group, 2048);
        this.sourceFormatTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData();
        gridData.widthHint = 250;
        gridData.heightHint = 150;
        this.sourceFormatTree.setLayoutData((Object)gridData);
        this.sourceFormatEnEditor.setPropertyChangeListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sourceFormatTree.setEnabled(this.sourceFormatEnabled);
        TreeItem treeItem = new TreeItem(this.sourceFormatTree, 0);
        treeItem.setText("ANSI");
        treeItem.setData((Object)new Integer(-1));
        TreeItem treeItem2 = new TreeItem(treeItem, 0);
        treeItem2.setText("Sequence number [columns 1-6]");
        treeItem2.setData((Object)new Integer(1));
        TreeItem treeItem3 = new TreeItem(treeItem, 0);
        treeItem3.setText("Indicator area [columns 7]");
        treeItem3.setData((Object)new Integer(2));
        TreeItem treeItem4 = new TreeItem(treeItem, 0);
        treeItem4.setText("Area A [columns 8-11]");
        treeItem4.setData((Object)new Integer(3));
        TreeItem treeItem5 = new TreeItem(treeItem, 0);
        treeItem5.setText("Area B [columns 12-72]");
        treeItem5.setData((Object)new Integer(4));
        TreeItem treeItem6 = new TreeItem(treeItem, 0);
        treeItem6.setText("Identification area [columns 73-80]");
        treeItem6.setData((Object)new Integer(13));
        TreeItem treeItem7 = new TreeItem(this.sourceFormatTree, 0);
        treeItem7.setText("Terminal");
        treeItem7.setData((Object)new Integer(-1));
        treeItem3 = new TreeItem(treeItem7, 0);
        treeItem3.setText("Indicator area [column 1]");
        treeItem3.setData((Object)new Integer(2));
        treeItem4 = new TreeItem(treeItem7, 0);
        treeItem4.setText("Area A [columns 2-5]");
        treeItem4.setData((Object)new Integer(3));
        treeItem5 = new TreeItem(treeItem7, 0);
        treeItem5.setText("Area B [columns 6-EOL]");
        treeItem5.setData((Object)new Integer(4));
        this.sourceFormatColorGrp = new Composite((Composite)group, 0);
        gridData = new GridData();
        gridData.heightHint = 100;
        gridData.widthHint = 180;
        gridData.verticalAlignment = 128;
        this.sourceFormatColorGrp.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.sourceFormatColorGrp.setLayout((Layout)gridLayout);
        this.sourceFormatBgEditor = new ColorFieldEditor("NONE", IsresourceBundle.getString((String)"background_lbl") + ":", this.sourceFormatColorGrp);
        this.sourceFormatBgEditor.setPage((DialogPage)this);
        this.sourceFormatBgEditor.setPreferenceStore(this.getPreferenceStore());
        this.sourceFormatBgEditor.getColorSelector().addListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sourceFormatFgEditor = new ColorFieldEditor("NONE", IsresourceBundle.getString((String)"foreground_lbl") + ":", this.sourceFormatColorGrp);
        this.sourceFormatFgEditor.setPage((DialogPage)this);
        this.sourceFormatFgEditor.setPreferenceStore(this.getPreferenceStore());
        this.sourceFormatFgEditor.getColorSelector().addListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sourceFormatBgEditor.setEnabled(this.sourceFormatEnabled, this.sourceFormatColorGrp);
        this.sourceFormatFgEditor.setEnabled(this.sourceFormatEnabled, this.sourceFormatColorGrp);
        Group group2 = new Group(composite3, 0);
        group2.setText(IsresourceBundle.getString((String)"syntax_high_lbl"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group2.setLayout((Layout)gridLayout);
        Composite composite5 = new Composite((Composite)group2, 0);
        this.syntaxHltEnEditor = new BooleanFieldEditor("iscobol.syntaxhighlighting.enabled", IsresourceBundle.getString((String)"syntax_high_en_lbl"), composite5);
        this.syntaxHltEnEditor.setPage((DialogPage)this);
        this.syntaxHltEnEditor.setPreferenceStore(this.getPreferenceStore());
        this.syntaxHltEnEditor.load();
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        composite5.setLayoutData((Object)gridData);
        this.syntaxHltTree = new Tree((Composite)group2, 2048);
        this.syntaxHltTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData();
        gridData.widthHint = 250;
        gridData.heightHint = 150;
        this.syntaxHltTree.setLayoutData((Object)gridData);
        this.syntaxHltEnEditor.setPropertyChangeListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.syntaxHltTree.setEnabled(this.syntaxHltEnabled);
        TreeItem treeItem8 = new TreeItem(this.syntaxHltTree, 0);
        treeItem8.setText(IsresourceBundle.getString((String)"comments_lbl"));
        treeItem8.setData((Object)new Integer(5));
        TreeItem treeItem9 = new TreeItem(this.syntaxHltTree, 0);
        treeItem9.setText(IsresourceBundle.getString((String)"keywords_lbl"));
        treeItem9.setData((Object)new Integer(6));
        TreeItem treeItem10 = new TreeItem(this.syntaxHltTree, 0);
        treeItem10.setText(IsresourceBundle.getString((String)"str_const_lbl"));
        treeItem10.setData((Object)new Integer(7));
        TreeItem treeItem11 = new TreeItem(this.syntaxHltTree, 0);
        treeItem11.setText(IsresourceBundle.getString((String)"num_const_lbl"));
        treeItem11.setData((Object)new Integer(8));
        TreeItem treeItem12 = new TreeItem(this.syntaxHltTree, 0);
        treeItem12.setText(IsresourceBundle.getString((String)"statements_lbl"));
        treeItem12.setData((Object)new Integer(9));
        TreeItem treeItem13 = new TreeItem(this.syntaxHltTree, 0);
        treeItem13.setText(IsresourceBundle.getString((String)"level_numbers_lbl"));
        treeItem13.setData((Object)new Integer(10));
        TreeItem treeItem14 = new TreeItem(this.syntaxHltTree, 0);
        treeItem14.setText(IsresourceBundle.getString((String)"fig_const_lbl"));
        treeItem14.setData((Object)new Integer(11));
        TreeItem treeItem15 = new TreeItem(this.syntaxHltTree, 0);
        treeItem15.setText(IsresourceBundle.getString((String)"dbg_curr_line_lbl"));
        treeItem15.setData((Object)new Integer(12));
        this.syntaxHltColorGrp = new Composite((Composite)group2, 0);
        gridData = new GridData();
        gridData.heightHint = 100;
        gridData.widthHint = 180;
        gridData.verticalAlignment = 128;
        this.syntaxHltColorGrp.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.syntaxHltColorGrp.setLayout((Layout)gridLayout);
        this.syntaxHltBgEditor = new ColorFieldEditor("NONE", IsresourceBundle.getString((String)"background_lbl") + ":", this.syntaxHltColorGrp);
        this.syntaxHltBgEditor.setPage((DialogPage)this);
        this.syntaxHltBgEditor.setPreferenceStore(this.getPreferenceStore());
        this.syntaxHltBgEditor.getColorSelector().addListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.syntaxHltFgEditor = new ColorFieldEditor("NONE", IsresourceBundle.getString((String)"foreground_lbl") + ":", this.syntaxHltColorGrp);
        this.syntaxHltFgEditor.setPage((DialogPage)this);
        this.syntaxHltFgEditor.setPreferenceStore(this.getPreferenceStore());
        this.syntaxHltFgEditor.getColorSelector().addListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.syntaxHltBgEditor.setEnabled(this.syntaxHltEnabled, this.syntaxHltColorGrp);
        this.syntaxHltFgEditor.setEnabled(this.syntaxHltEnabled, this.syntaxHltColorGrp);
        if (this.wizard != null) {
            scrolledComposite.setMinSize(composite3.computeSize(-1, -1));
        }
        return composite2;
    }

    private void updateEditors(int n, boolean bl) {
        this.currElement = n;
        switch (this.currElement) {
            default: {
                this.unloadBackground(bl);
                this.unloadForeground(bl);
                break;
            }
            case 1: {
                this.loadBackground("iscobol.syntaxcoloring.sequencenumber.background", bl);
                this.unloadForeground(bl);
                break;
            }
            case 2: {
                this.loadBackground("iscobol.syntaxcoloring.indicatorarea.background", bl);
                this.unloadForeground(bl);
                break;
            }
            case 3: {
                this.loadBackground("iscobol.syntaxcoloring.areaa.background", bl);
                this.unloadForeground(bl);
                break;
            }
            case 4: {
                this.loadBackground("iscobol.syntaxcoloring.areab.background", bl);
                this.unloadForeground(bl);
                break;
            }
            case 13: {
                this.loadBackground("iscobol.syntaxcoloring.identificationarea.background", bl);
                this.unloadForeground(bl);
                break;
            }
            case 5: {
                this.unloadBackground(bl);
                this.loadForeground("iscobol.syntaxcoloring.comments.foreground", bl);
                break;
            }
            case 6: {
                this.unloadBackground(bl);
                this.loadForeground("iscobol.syntaxcoloring.keywords.foreground", bl);
                break;
            }
            case 7: {
                this.unloadBackground(bl);
                this.loadForeground("iscobol.syntaxcoloring.strings.foreground", bl);
                break;
            }
            case 8: {
                this.unloadBackground(bl);
                this.loadForeground("iscobol.syntaxcoloring.numbers.foreground", bl);
                break;
            }
            case 9: {
                this.unloadBackground(bl);
                this.loadForeground("iscobol.syntaxcoloring.statements.foreground", bl);
                break;
            }
            case 10: {
                this.unloadBackground(bl);
                this.loadForeground("iscobol.syntaxcoloring.levelnumber.foreground", bl);
                break;
            }
            case 11: {
                this.unloadBackground(bl);
                this.loadForeground("iscobol.syntaxcoloring.figurativeconst.foreground", bl);
                break;
            }
            case 12: {
                this.loadForeground("iscobol.syntaxcoloring.debugcurrentline.foreground", bl);
                this.loadBackground("iscobol.syntaxcoloring.debugcurrentline.background", bl);
            }
        }
    }

    private void loadForeground(String string, boolean bl) {
        if (bl) {
            this.load(this.sourceFormatFgEditor, string, this.sourceFormatColorGrp);
        } else {
            this.load(this.syntaxHltFgEditor, string, this.syntaxHltColorGrp);
        }
    }

    private void loadBackground(String string, boolean bl) {
        if (bl) {
            this.load(this.sourceFormatBgEditor, string, this.sourceFormatColorGrp);
        } else {
            this.load(this.syntaxHltBgEditor, string, this.syntaxHltColorGrp);
        }
    }

    private void load(ColorFieldEditor colorFieldEditor, String string, Composite composite) {
        RGB rGB = (RGB)this.colorMap.get(string);
        colorFieldEditor.setEnabled(true, composite);
        colorFieldEditor.setPreferenceName(string);
        colorFieldEditor.getColorSelector().setColorValue(rGB);
    }

    private void unloadForeground(boolean bl) {
        if (bl) {
            this.sourceFormatFgEditor.setEnabled(false, this.sourceFormatColorGrp);
        } else {
            this.syntaxHltFgEditor.setEnabled(false, this.syntaxHltColorGrp);
        }
    }

    private void unloadBackground(boolean bl) {
        if (bl) {
            this.sourceFormatBgEditor.setEnabled(false, this.sourceFormatColorGrp);
        } else {
            this.syntaxHltBgEditor.setEnabled(false, this.syntaxHltColorGrp);
        }
    }

    public void init(IWorkbench iWorkbench) {
        IPreferenceStore iPreferenceStore = IscobolEditorPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(iPreferenceStore);
        this.syntaxHltEnabled = iPreferenceStore.contains("iscobol.syntaxhighlighting.enabled") ? iPreferenceStore.getBoolean("iscobol.syntaxhighlighting.enabled") : iPreferenceStore.getDefaultBoolean("iscobol.syntaxhighlighting.enabled");
        this.sourceFormatEnabled = iPreferenceStore.contains("iscobol.sourceformat.enabled") ? iPreferenceStore.getBoolean("iscobol.sourceformat.enabled") : iPreferenceStore.getDefaultBoolean("iscobol.sourceformat.enabled");
        this.colorMap.put("iscobol.syntaxcoloring.areaa.background", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.areaa.background"));
        this.colorMap.put("iscobol.syntaxcoloring.areaa.foreground", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.areaa.foreground"));
        this.colorMap.put("iscobol.syntaxcoloring.areab.background", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.areab.background"));
        this.colorMap.put("iscobol.syntaxcoloring.areab.foreground", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.areab.foreground"));
        this.colorMap.put("iscobol.syntaxcoloring.indicatorarea.background", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.indicatorarea.background"));
        this.colorMap.put("iscobol.syntaxcoloring.indicatorarea.foreground", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.indicatorarea.foreground"));
        this.colorMap.put("iscobol.syntaxcoloring.identificationarea.background", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.identificationarea.background"));
        this.colorMap.put("iscobol.syntaxcoloring.identificationarea.foreground", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.identificationarea.foreground"));
        this.colorMap.put("iscobol.syntaxcoloring.sequencenumber.background", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.sequencenumber.background"));
        this.colorMap.put("iscobol.syntaxcoloring.sequencenumber.foreground", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.sequencenumber.foreground"));
        this.colorMap.put("iscobol.syntaxcoloring.comments.foreground", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.comments.foreground"));
        this.colorMap.put("iscobol.syntaxcoloring.strings.foreground", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.strings.foreground"));
        this.colorMap.put("iscobol.syntaxcoloring.numbers.foreground", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.numbers.foreground"));
        this.colorMap.put("iscobol.syntaxcoloring.statements.foreground", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.statements.foreground"));
        this.colorMap.put("iscobol.syntaxcoloring.keywords.foreground", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.keywords.foreground"));
        this.colorMap.put("iscobol.syntaxcoloring.levelnumber.foreground", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.levelnumber.foreground"));
        this.colorMap.put("iscobol.syntaxcoloring.figurativeconst.foreground", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.figurativeconst.foreground"));
        this.colorMap.put("iscobol.syntaxcoloring.debugcurrentline.background", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.debugcurrentline.background"));
        this.colorMap.put("iscobol.syntaxcoloring.debugcurrentline.foreground", PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"iscobol.syntaxcoloring.debugcurrentline.foreground"));
    }

    public boolean performOk() {
        this.store();
        IEditorPart iEditorPart = IscobolEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (iEditorPart != null && iEditorPart instanceof IscobolEditor) {
            IscobolEditor iscobolEditor = (IscobolEditor)iEditorPart;
            iscobolEditor.redraw();
            iscobolEditor.refreshEditor();
        }
        return super.performOk();
    }

    public void store() {
        for (String string : this.colorMap.keySet()) {
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)string, (RGB)((RGB)this.colorMap.get(string)));
        }
        this.getPreferenceStore().setValue("iscobol.sourceformat.enabled", this.sourceFormatEnabled);
        this.getPreferenceStore().setValue("iscobol.syntaxhighlighting.enabled", this.syntaxHltEnabled);
    }

    protected void performDefaults() {
        this.sourceFormatEnabled = this.getPreferenceStore().getDefaultBoolean("iscobol.sourceformat.enabled");
        this.sourceFormatEnEditor.loadDefault();
        this.sourceFormatTree.setEnabled(this.sourceFormatEnabled);
        this.sourceFormatBgEditor.setEnabled(this.sourceFormatEnabled, this.sourceFormatColorGrp);
        this.sourceFormatFgEditor.setEnabled(this.sourceFormatEnabled, this.sourceFormatColorGrp);
        this.syntaxHltEnabled = this.getPreferenceStore().getDefaultBoolean("iscobol.syntaxhighlighting.enabled");
        this.syntaxHltEnEditor.loadDefault();
        this.syntaxHltTree.setEnabled(this.syntaxHltEnabled);
        this.syntaxHltBgEditor.setEnabled(this.syntaxHltEnabled, this.syntaxHltColorGrp);
        this.syntaxHltFgEditor.setEnabled(this.syntaxHltEnabled, this.syntaxHltColorGrp);
        for (String string : this.colorMap.keySet()) {
            this.colorMap.put(string, PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)string));
        }
        super.performDefaults();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getNextPage() != null;
    }

    public String getName() {
        return "SyntaxColoringPreferencePage";
    }

    public IWizardPage getNextPage() {
        if (this.wizard == null) {
            return null;
        }
        return this.wizard.getNextPage((IWizardPage)this);
    }

    public IWizardPage getPreviousPage() {
        return this.prevPage;
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    public boolean isPageComplete() {
        return true;
    }

    public void setPreviousPage(IWizardPage iWizardPage) {
        this.prevPage = iWizardPage;
    }

    public void setWizard(IWizard iWizard) {
        this.wizard = iWizard;
    }

    static /* synthetic */ void access$000(SyntaxColoringPreferencePage syntaxColoringPreferencePage, int n, boolean bl) {
        syntaxColoringPreferencePage.updateEditors(n, bl);
    }

    static /* synthetic */ boolean access$102(SyntaxColoringPreferencePage syntaxColoringPreferencePage, boolean bl) {
        syntaxColoringPreferencePage.sourceFormatEnabled = bl;
        return syntaxColoringPreferencePage.sourceFormatEnabled;
    }

    static /* synthetic */ BooleanFieldEditor access$200(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.sourceFormatEnEditor;
    }

    static /* synthetic */ boolean access$100(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.sourceFormatEnabled;
    }

    static /* synthetic */ Tree access$300(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.sourceFormatTree;
    }

    static /* synthetic */ Composite access$400(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.sourceFormatColorGrp;
    }

    static /* synthetic */ ColorFieldEditor access$500(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.sourceFormatBgEditor;
    }

    static /* synthetic */ ColorFieldEditor access$600(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.sourceFormatFgEditor;
    }

    static /* synthetic */ Map access$700(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.colorMap;
    }

    static /* synthetic */ boolean access$802(SyntaxColoringPreferencePage syntaxColoringPreferencePage, boolean bl) {
        syntaxColoringPreferencePage.syntaxHltEnabled = bl;
        return syntaxColoringPreferencePage.syntaxHltEnabled;
    }

    static /* synthetic */ BooleanFieldEditor access$900(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.syntaxHltEnEditor;
    }

    static /* synthetic */ boolean access$800(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.syntaxHltEnabled;
    }

    static /* synthetic */ Tree access$1000(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.syntaxHltTree;
    }

    static /* synthetic */ Composite access$1100(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.syntaxHltColorGrp;
    }

    static /* synthetic */ ColorFieldEditor access$1200(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.syntaxHltBgEditor;
    }

    static /* synthetic */ ColorFieldEditor access$1300(SyntaxColoringPreferencePage syntaxColoringPreferencePage) {
        return syntaxColoringPreferencePage.syntaxHltFgEditor;
    }
}

