/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.sourceproviders;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.debug.IscobolDebugElement;
import com.iscobol.plugins.editor.debug.IscobolDebugTarget;
import com.iscobol.plugins.editor.sourceproviders.SelectionSourceProvider;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.services.IServiceLocator;

public class VariableSourceProvider
extends SelectionSourceProvider
implements IDebugEventSetListener {
    public static final String DEBUGGER_ENABLED = "com.iscobol.plugins.editor.variables.debugger.enabled";
    private static IscobolDebugTarget currentDebugTarget;

    public static IscobolDebugTarget getCurrentDebugTarget() {
        return currentDebugTarget;
    }

    public void initialize(IServiceLocator iServiceLocator) {
        ICommandService iCommandService;
        super.initialize(iServiceLocator);
        boolean bl = this.getEnabledState();
        Boolean bl2 = bl;
        this.setInitialState(new String[]{DEBUGGER_ENABLED}, new Object[]{bl2});
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        if (iServiceLocator != null && (iCommandService = (ICommandService)iServiceLocator.getService(ICommandService.class)) != null) {
            IPreferenceStore iPreferenceStore = IscobolEditorPlugin.getDefault().getPreferenceStore();
            boolean bl3 = iPreferenceStore.getBoolean("iscobol.variableview.showhex");
            iCommandService.getCommand("com.iscobol.plugins.editor.commands.showValuesAsHex").getState("STYLE").setValue((Object)new Boolean(bl3));
            iCommandService.refreshElements("com.iscobol.plugins.editor.commands.showValuesAsHex", null);
        }
    }

    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(DebugEvent[] debugEventArray) {
        if (debugEventArray.length == 0) {
            return;
        }
        Object object = debugEventArray[0].getSource();
        if (object instanceof IscobolDebugElement) {
            IscobolDebugElement iscobolDebugElement = (IscobolDebugElement)object;
            boolean bl = this.getEnabledState();
            Boolean bl2 = bl;
            this.setCurrentState(new String[]{DEBUGGER_ENABLED}, new Object[]{bl2});
            if (debugEventArray[0].getKind() == 4) {
                currentDebugTarget = (IscobolDebugTarget)iscobolDebugElement.getDebugTarget();
            }
            this.updateTraceCommand();
        }
    }

    private void updateTraceCommand() {
        ICommandService iCommandService;
        boolean bl = currentDebugTarget != null && currentDebugTarget.isTracingEnabled();
        IServiceLocator iServiceLocator = this.getServiceLocator();
        if (iServiceLocator != null && (iCommandService = (ICommandService)iServiceLocator.getService(ICommandService.class)) != null) {
            iCommandService.getCommand("com.iscobol.plugins.editor.commands.trace").getState("STYLE").setValue((Object)new Boolean(bl));
            iCommandService.refreshElements("com.iscobol.plugins.editor.commands.trace", null);
        }
    }

    private boolean getEnabledState() {
        boolean bl = currentDebugTarget != null && !currentDebugTarget.isTerminated() && currentDebugTarget.isSuspended();
        return bl;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement() instanceof IscobolDebugElement) {
            IscobolDebugElement iscobolDebugElement = (IscobolDebugElement)iStructuredSelection.getFirstElement();
            currentDebugTarget = (IscobolDebugTarget)iscobolDebugElement.getDebugTarget();
            this.updateTraceCommand();
        }
    }
}

