/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.util;

import com.iscobol.plugins.editor.util.PluginUtilities;

/*
 * Exception performing whole class analysis ignored.
 */
public class CobolFormatter {
    private static final int ANSI_LIMIT = 65;
    private final String eol = PluginUtilities.getLineDelimiter();
    private boolean ansiFormat;
    private int lineLimit = 250;
    private final int generationMode;
    private final boolean generationUpperCase;

    public CobolFormatter() {
        this(true, 0);
    }

    public CobolFormatter(boolean bl, int n) {
        this.ansiFormat = bl;
        this.generationMode = n;
        this.generationUpperCase = this.generationMode == 2;
    }

    private static String spaces(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    private String formatLineTerminal(String string) {
        int n;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = stringBuilder = this.generationMode != 0 ? new StringBuilder() : null;
        if (string.length() <= this.lineLimit) {
            if (stringBuilder != null) {
                this.analyzeAndReplace(string.toCharArray(), this.lineLimit, stringBuilder);
                string = stringBuilder.toString();
            }
            return stringBuilder2.append(string).append(this.eol).toString();
        }
        for (n = 0; n < string.length() && string.charAt(n) == ' '; ++n) {
        }
        if (n > this.lineLimit) {
            n -= this.lineLimit;
            string = string.substring(this.lineLimit);
        }
        while (string.length() > this.lineLimit) {
            int n2;
            char[] cArray = string.toCharArray();
            int[] nArray = this.analyzeAndReplace(cArray, this.lineLimit, stringBuilder);
            if (stringBuilder != null) {
                string = stringBuilder.toString();
                stringBuilder.delete(0, stringBuilder.length());
            }
            for (n2 = this.lineLimit; n2 >= n && (!CobolFormatter.isSeparator((char)string.charAt(n2)) || n2 >= nArray[0] && n2 <= nArray[1]); --n2) {
            }
            if (n2 >= n) {
                stringBuilder2.append(string.substring(0, n2 + 1)).append(this.eol);
                string = CobolFormatter.spaces((int)n) + string.substring(n2 + 1);
                continue;
            }
            for (n2 = this.lineLimit + 1; n2 < string.length() - 1 && (!CobolFormatter.isSeparator((char)string.charAt(n2)) || n2 >= nArray[0] && n2 <= nArray[1]); ++n2) {
            }
            if (n2 < string.length() - 1) {
                stringBuilder2.append(string.substring(0, n2 + 1)).append(this.eol);
                string = CobolFormatter.spaces((int)n) + string.substring(n2 + 1);
                continue;
            }
            stringBuilder2.append(string);
            string = "";
        }
        if (string.length() > 0) {
            if (stringBuilder != null) {
                this.analyzeAndReplace(string.toCharArray(), this.lineLimit, stringBuilder);
                string = stringBuilder.toString();
            }
            stringBuilder2.append(string);
        }
        stringBuilder2.append(this.eol);
        return stringBuilder2.toString();
    }

    private int[] analyzeAndReplace(char[] cArray, int n, StringBuilder stringBuilder) {
        int n2 = 0;
        int[] nArray = new int[]{-1, -1};
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (i >= n && !bl) {
                if (stringBuilder == null) break;
                stringBuilder.append(new String(cArray, i, cArray.length - i));
                break;
            }
            if (cArray[i] == '\"') {
                if (stringBuilder != null) {
                    stringBuilder.append(cArray[i]);
                }
                if (i < cArray.length - 1 && cArray[i + 1] == '\"') {
                    if (stringBuilder != null) {
                        stringBuilder.append(cArray[i + 1]);
                    }
                    ++i;
                    continue;
                }
                if (bl) {
                    if (n2 != 34) continue;
                    nArray[1] = i;
                    n2 = 0;
                    bl = false;
                    continue;
                }
                n2 = 34;
                nArray[0] = i;
                bl = true;
                continue;
            }
            if (cArray[i] == '\'') {
                if (stringBuilder != null) {
                    stringBuilder.append(cArray[i]);
                }
                if (i < cArray.length - 1 && cArray[i + 1] == '\'') {
                    if (stringBuilder != null) {
                        stringBuilder.append(cArray[i + 1]);
                    }
                    ++i;
                    continue;
                }
                if (bl) {
                    if (n2 != 39) continue;
                    nArray[1] = i;
                    n2 = 0;
                    bl = false;
                    continue;
                }
                n2 = 39;
                nArray[0] = i;
                bl = true;
                continue;
            }
            if (stringBuilder == null) continue;
            if (bl) {
                stringBuilder.append(cArray[i]);
                continue;
            }
            if (bl2) {
                stringBuilder.append(cArray[i]);
                if (Character.isJavaIdentifierPart(cArray[i])) continue;
                bl2 = false;
                continue;
            }
            if (cArray[i] == ':') {
                stringBuilder.append(cArray[i]);
                if (i >= cArray.length - 1 || cArray[i + 1] != '>') continue;
                stringBuilder.append(cArray[i + 1]);
                ++i;
                bl2 = true;
                continue;
            }
            if (Character.isLetter(cArray[i])) {
                if (this.generationUpperCase) {
                    stringBuilder.append(Character.toUpperCase(cArray[i]));
                    continue;
                }
                stringBuilder.append(Character.toLowerCase(cArray[i]));
                continue;
            }
            stringBuilder.append(cArray[i]);
        }
        return nArray;
    }

    private String formatLineANSI(String string) {
        char c;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = stringBuilder = this.generationMode != 0 ? new StringBuilder() : null;
        if (string.length() <= 65) {
            if (stringBuilder != null) {
                this.analyzeAndReplace(string.toCharArray(), 65, stringBuilder);
                string = stringBuilder.toString();
            }
            return stringBuilder2.append("       ").append(string).append(this.eol).toString();
        }
        for (c = '\u0000'; c < string.length() && string.charAt(c) == ' '; ++c) {
        }
        if (c > 'A') {
            c -= 65;
            string = string.substring(65);
        }
        boolean bl = false;
        while (string.length() > 65) {
            char c2;
            char[] cArray = string.toCharArray();
            int[] nArray = this.analyzeAndReplace(cArray, 65, stringBuilder);
            if (stringBuilder != null) {
                string = stringBuilder.toString();
                stringBuilder.delete(0, stringBuilder.length());
            }
            if (nArray[0] < 65 && nArray[1] >= 65) {
                stringBuilder2.append("      ");
                if (bl) {
                    stringBuilder2.append("-");
                } else {
                    stringBuilder2.append(" ");
                }
                c2 = cArray[nArray[0]];
                int n = 65;
                if (string.charAt(64) == c2) {
                    int n2 = 1;
                    int n3 = 63;
                    while (n3 >= 0 && string.charAt(n3) == c2) {
                        --n3;
                        ++n2;
                    }
                    if (n2 & true && string.charAt(65) == c2) {
                        stringBuilder2.append(' ');
                        --n;
                    }
                }
                stringBuilder2.append(string.substring(0, n)).append(this.eol);
                bl = true;
                string = CobolFormatter.spaces((int)c) + c2 + string.substring(n);
                continue;
            }
            for (c2 = 'A'; c2 >= c && !CobolFormatter.isSeparator((char)cArray[c2], (int)c2, (int[])nArray); --c2) {
            }
            if (c2 >= c) {
                stringBuilder2.append("      ");
                if (bl) {
                    stringBuilder2.append("-");
                } else {
                    stringBuilder2.append(" ");
                }
                stringBuilder2.append(string.substring(0, c2 + 1)).append(this.eol);
                string = CobolFormatter.spaces((int)c) + string.substring(c2 + 1);
                bl = false;
                continue;
            }
            stringBuilder2.append("      ");
            if (bl) {
                stringBuilder2.append("-");
            } else {
                stringBuilder2.append(" ");
            }
            stringBuilder2.append(string.substring(0, 65)).append(this.eol);
            bl = cArray.length > 65 && !CobolFormatter.isSeparator((char)cArray[65]);
            string = CobolFormatter.spaces((int)c) + string.substring(65);
        }
        if (string.length() > 0) {
            stringBuilder2.append("      ");
            if (bl) {
                stringBuilder2.append("-");
            } else {
                stringBuilder2.append(" ");
            }
            if (stringBuilder != null) {
                this.analyzeAndReplace(string.toCharArray(), 65, stringBuilder);
                string = stringBuilder.toString();
            }
            stringBuilder2.append(string);
        }
        stringBuilder2.append(this.eol);
        return stringBuilder2.toString();
    }

    private static boolean isSeparator(char c, int n, int[] nArray) {
        return CobolFormatter.isSeparator((char)c) && (n < nArray[0] || n > nArray[1]);
    }

    private static boolean isSeparator(char c) {
        return Character.isWhitespace(c);
    }

    public String formatComment(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.ansiFormat) {
            stringBuilder.append("      *");
        } else {
            stringBuilder.append("*>");
        }
        stringBuilder.append(string);
        stringBuilder.append(this.eol);
        return stringBuilder.toString();
    }

    public String formatLine(String string) {
        if (this.ansiFormat) {
            return this.formatLineANSI(string);
        }
        return this.formatLineTerminal(string);
    }

    public int getLineLimit() {
        return this.lineLimit;
    }

    public void setLineLimit(int n) {
        this.lineLimit = n;
        if (this.lineLimit <= 0 || this.lineLimit > 320) {
            this.lineLimit = 320;
        }
    }

    public boolean isAnsiFormat() {
        return this.ansiFormat;
    }

    public void setAnsiFormat(boolean bl) {
        this.ansiFormat = bl;
    }

    public int getGenerationMode() {
        return this.generationMode;
    }

    public String getLineDelimiter() {
        return this.eol;
    }

    public static String formatUsername(String string, int n) {
        switch (n) {
            case 2: {
                return string.toUpperCase();
            }
            case 1: {
                return string.toLowerCase();
            }
        }
        return string;
    }

    public static void main(String[] stringArray) {
        String string = "    move '   .rh1-lb-Report1f-RwLa-1 {position:absolute; top:120; left:20; width:630; height:40; background-color:transparent; text-align:center; font-size:24pt; font-family:MS Sans Serif;}' to print-buf";
        CobolFormatter cobolFormatter = new CobolFormatter(true, 2);
        System.out.println(cobolFormatter.formatLineANSI(string));
    }
}

