/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.util;

import com.iscobol.compiler.Errors;
import java.io.File;

public class ErrorObj {
    private int errorNumber;
    private int errorType;
    private int lineNumber;
    private int offset;
    private String message;
    private String filename;
    private String pathFilename;
    private String other;

    public ErrorObj(int n, int n2, int n3, int n4, String string, String string2, String string3) {
        this.errorNumber = n;
        this.errorType = n2;
        this.lineNumber = n3;
        this.offset = n4;
        this.message = string2;
        this.pathFilename = string = string.replace('\\', '/');
        this.filename = new File(string).getName();
        this.other = string3;
    }

    public int getErrorNumber() {
        return this.errorNumber;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPathFilename() {
        return this.pathFilename;
    }

    public String getOther() {
        return this.other;
    }

    public String getFilename() {
        return this.filename;
    }

    public String toString() {
        String string;
        if (this.errorNumber != 1001) {
            switch (this.errorType) {
                case 1: {
                    string = "--I: ";
                    break;
                }
                case 2: {
                    string = "--W: ";
                    break;
                }
                case 3: {
                    string = "--E: ";
                    break;
                }
                case 4: {
                    string = "--S: ";
                    break;
                }
                default: {
                    string = "--?: ";
                }
            }
            string = string + "#" + this.errorNumber + " ";
            string = string + Errors.getErrorDescription((int)this.errorNumber);
            if (this.other != null) {
                string = string + " " + this.other;
            }
        } else {
            string = "--Task: " + this.message;
        }
        string = string + "; file = " + this.filename;
        if (this.lineNumber > 0) {
            string = string + ", line = " + this.lineNumber;
        }
        if (this.offset > 0) {
            string = string + ", col " + this.offset;
        }
        return string;
    }
}

