/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.util;

import com.iscobol.plugins.editor.util.ImageProvider;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;

public class ImageProvider {
    private static final String PREFIX = "/";
    private HashMap<String, MyImageDesc> imageMap = new HashMap();
    private HashMap<String, Image> editorReferenceImageMap = new HashMap();
    public static final String ISCOBOL16x16_IMAGE = "/iscobol16x16.png";
    public static final String WD216x16_IMAGE = "/wd2.png";
    public static final String CLASSPATH_IMAGE = "/classpath.gif";
    public static final String GEN_PROJECT_IMAGE = "/gen_project.gif";
    public static final String FOLDER_IMAGE = "/folder.gif";
    public static final String JAR_IMAGE = "/jar.gif";
    public static final String OPTION_IMAGE = "/option.gif";
    public static final String BREAKPOINTS_IMAGE = "/breakpoints.gif";
    public static final String NEW_MONITOR_IMAGE = "/newmonitor.png";
    public static final String MONITORS_IMAGE = "/newmonitor.png";
    public static final String OPEN_COPY_IMAGE = "/opencopy.gif";
    public static final String PROGRAM_IMAGE = "/program.gif";
    public static final String OO_PROGRAM_IMAGE = "/ooprogram.png";
    public static final String FACTORY_PART_IMAGE = "/fact_obj.gif";
    public static final String OBJECT_PART_IMAGE = "/fact_obj.gif";
    public static final String METHOD_IMAGE = "/method.gif";
    public static final String PARAGRAPH_IMAGE = "/paragraph.gif";
    public static final String PUBLIC_METHOD_IMAGE = "/public_method.gif";
    public static final String PUBLIC_CONSTR_IMAGE = "/public_constr.gif";
    public static final String PUBLIC_FIELD_IMAGE = "/public_field.gif";
    public static final String STATEMENT_IMAGE = "/statement.gif";
    public static final String VARIABLE_IMAGE = "/var.gif";
    public static final String VARIABLE_77_IMAGE = "/var77.gif";
    public static final String VARIABLE_78_IMAGE = "/var78.gif";
    public static final String VARIABLE_88_IMAGE = "/var88.gif";
    public static final String VAR_GRP_IMAGE = "/vargrp.gif";
    public static final String COPY_IMAGE = "/copy.gif";
    public static final String COPYLIST_IMAGE = "/copylist.png";
    public static final String SOURCE_FOLDER_IMAGE = "/sourcefolder.gif";
    public static final String OUTPUT_FOLDER_IMAGE = "/outputfolder.gif";
    public static final String COPY_FOLDER_IMAGE = "/copyfolder.gif";
    public static final String LIST_FOLDER_IMAGE = "/listfolder.gif";
    public static final String ERR_FOLDER_IMAGE = "/errfolder.png";
    public static final String WARN_FOLDER_IMAGE = "/warnfolder.png";
    public static final String PROJECT_IMAGE = "/prj.gif";
    public static final String PROJECT_CLOSED_IMAGE = "/prj_close.gif";
    public static final String LISTFILE_IMAGE = "/list.gif";
    public static final String ERRFILE_IMAGE = "/err.gif";
    public static final String ERROR_OBJ_IMAGE = "/error_obj.gif";
    public static final String WARNING_OBJ_IMAGE = "/warning_obj.gif";
    public static final String XMLFILE_IMAGE = "/xml.gif";
    public static final String SOURCEFILE_IMAGE = "/source.gif";
    public static final String COBOL_SEC_IMAGE = "/cobolsec.gif";
    public static final String ENTRY_PNT_IMAGE = "/entrypnt.gif";
    public static final String ENTRY_PNT_LIST_IMAGE = "/entry-points.png";
    public static final String BREAKPOINT_IMAGE = "/breakpoint.gif";
    public static final String MONITOR_IMAGE = "/monitor.gif";
    public static final String ERROR_OVR_IMAGE = "/error_overlay.gif";
    public static final String WARNING_OVR_IMAGE = "/warning_overlay.gif";
    public static final String FILTER_OVR_IMAGE = "/filter_overlay.png";
    public static final String STATIC_FIELD_IMAGE = "/static_field.png";
    public static final String STATIC_METHOD_IMAGE = "/static_method.png";
    public static final String TOGGLE_COMMENT_IMAGE = "/togglecomment.png";
    public static final String ADD_COMMENT_IMAGE = "/addcomment.png";
    public static final String REMOVE_COMMENT_IMAGE = "/removecomment.png";
    public static final String FILE_OBJ_IMAGE = "/file_obj.gif";
    public static final String CHANGE_IMAGE = "/change.gif";
    public static final String ADD_REMOVE_MODE_IMAGE = "/addremovemode.gif";
    public static final String INCLUDE_IMAGE = "/include.gif";
    public static final String EXCLUDE_IMAGE = "/exclude.gif";
    public static final String SERVICE_BRIDGE_IMAGE = "/service_bridge.png";
    public static final String REST_IMAGE = "/rest.png";
    public static final String SOAP_IMAGE = "/soap.png";

    public Image getImage(String string) {
        MyImageDesc myImageDesc = this.getID(string);
        if (myImageDesc.image == null) {
            myImageDesc.image = myImageDesc.descriptor.createImage();
        }
        return myImageDesc.image;
    }

    public Image getImage(String string, String[] stringArray, int[] nArray) {
        if (stringArray == null || stringArray.length == 0 || nArray == null || nArray.length == 0 || stringArray.length != nArray.length) {
            return this.getImage(string);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append('(');
            stringBuilder.append(stringArray[i]);
            stringBuilder.append(',');
            stringBuilder.append(nArray[i]);
            stringBuilder.append(')');
        }
        MyImageDesc myImageDesc = (MyImageDesc)this.imageMap.get(stringBuilder.toString());
        Image image = null;
        if (myImageDesc != null) {
            if (myImageDesc.image == null) {
                myImageDesc.image = myImageDesc.descriptor.createImage();
            }
            image = myImageDesc.image;
        } else {
            Image image2 = this.getImage(string);
            if (image2 != null) {
                ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[stringArray.length];
                boolean bl = true;
                for (int i = 0; i < stringArray.length && bl; ++i) {
                    imageDescriptorArray[i] = this.getDescriptor(stringArray[i]);
                    bl = imageDescriptorArray[i] != null;
                }
                if (bl) {
                    ImageDescriptor[] imageDescriptorArray2 = new ImageDescriptor[5];
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] < 0 || nArray[i] >= imageDescriptorArray2.length) continue;
                        imageDescriptorArray2[nArray[i]] = imageDescriptorArray[i];
                    }
                    myImageDesc = new MyImageDesc(null);
                    myImageDesc.descriptor = new DecorationOverlayIcon(image2, imageDescriptorArray2);
                    image = myImageDesc.image = myImageDesc.descriptor.createImage();
                    this.imageMap.put(stringBuilder.toString(), myImageDesc);
                }
            }
        }
        return image;
    }

    public void dispose() {
        for (MyImageDesc myImageDesc : this.imageMap.values()) {
            if (myImageDesc.image == null) continue;
            myImageDesc.image.dispose();
        }
        this.imageMap.clear();
        Iterator iterator = this.editorReferenceImageMap.values().iterator();
        while (iterator.hasNext()) {
            ((Image)iterator.next()).dispose();
        }
        this.editorReferenceImageMap.clear();
    }

    public ImageDescriptor getDescriptor(String string) {
        return this.getID((String)string).descriptor;
    }

    private MyImageDesc getID(String string) {
        MyImageDesc myImageDesc = (MyImageDesc)this.imageMap.get(string);
        if (myImageDesc == null) {
            myImageDesc = new MyImageDesc(null);
            myImageDesc.descriptor = ImageDescriptor.createFromFile(ImageProvider.class, (String)string);
            this.imageMap.put(string, myImageDesc);
        }
        return myImageDesc;
    }

    public Image getEditorReferenceImage(ImageDescriptor imageDescriptor, String string) {
        Image image = (Image)this.editorReferenceImageMap.get(string);
        if (image == null) {
            image = imageDescriptor.createImage();
            this.editorReferenceImageMap.put(string, image);
        }
        return image;
    }
}

