/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.util;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.util.VarDecl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.Image;

public class IsFragment
implements Comparable {
    public static final int PROGRAM = 1;
    public static final int FACTORY_PART = 2;
    public static final int OBJECT_PART = 3;
    public static final int METHOD_PART = 4;
    public static final int PARAGRAPH = 5;
    public static final int CLASS = 6;
    public static final int PROCEDURE_DIVISION = 7;
    public static final int DATA_DIVISION = 8;
    public static final int WORKING_STORAGE_SECTION = 9;
    public static final int LINKAGE_SEC = 10;
    public static final int SCREEN_SECTION = 11;
    public static final int FILE_SECTION = 12;
    public static final int VARIABLE = 13;
    public static final int FILE_DESCRIPTOR = 14;
    public static final int ENTRY_POINT_LIST = 15;
    public static final int ENTRY_POINT = 16;
    public static final int COPY_BOOK = 17;
    public static final int COPY_BOOK_LIST = 18;
    public static final int ENVIRONMENT_DIV = 19;
    public static final int CONFIGURATION_SECTION = 20;
    public static final int INPUT_OUTPUT_SECTION = 21;
    public static final int REPOSITORY = 22;
    public static final int SPECIAL_NAMES = 23;
    public static final int FILE_CONTROL = 24;
    public static final int SELECT = 25;
    public static final int CLASS_DECLARATION = 26;
    public static final int DECLARATIVES = 27;
    public static final int SERVICE = 28;
    public static final int SERVICE_SOAP_PROCEDURE = 29;
    public static final int SERVICE_SOAP_ENTRY_POINT = 30;
    public static final int SERVICE_REST_PROCEDURE = 31;
    public static final int SERVICE_REST_ENTRY_POINT = 32;
    public static final int ALL_VARIABLES = 0;
    public static final int SCREEN_NAMES = 1;
    public static final int EXCLUDE_SCREEN_NAMES = 2;
    public static final int EXCLUDE_SCREEN_NAMES_AND_STATIC = 3;
    public int type;
    private Position position;
    private String name;
    private String filename;
    private IsFragment parent;
    protected List<IsFragment> children;
    private int startLine;
    private int endLine;
    private IFile file;
    private Map<String, VarDecl> variableTable;
    private String path;
    private int priority;
    private int offset;

    public IsFragment(IsFragment isFragment, int n, String string, Position position) {
        this(isFragment, n, string);
        this.position = position;
    }

    public IsFragment(IsFragment isFragment, int n, String string, int n2, int n3) {
        this(isFragment, n, string);
        this.startLine = n2;
        this.endLine = n3;
    }

    private IsFragment(IsFragment isFragment, int n, String string) {
        this.name = string;
        this.type = n;
        switch (n) {
            case 1: {
                this.priority = 0;
                break;
            }
            case 2: {
                this.priority = 0;
                break;
            }
            case 3: {
                this.priority = 1;
                break;
            }
            case 4: {
                this.priority = 0;
                break;
            }
            case 5: {
                this.priority = 2;
                break;
            }
            case 6: {
                this.priority = 0;
                break;
            }
            case 7: {
                this.priority = 2;
                break;
            }
            case 8: {
                this.priority = 1;
                break;
            }
            case 9: {
                this.priority = 1;
                break;
            }
            case 10: {
                this.priority = 2;
                break;
            }
            case 11: {
                this.priority = 3;
                break;
            }
            case 12: {
                this.priority = 0;
                break;
            }
            case 13: {
                this.priority = 0;
                break;
            }
            case 14: {
                this.priority = 0;
                break;
            }
            case 15: {
                this.priority = 0;
                break;
            }
            case 16: {
                this.priority = 0;
                break;
            }
            case 17: {
                this.priority = 0;
                break;
            }
            case 18: {
                this.priority = 2;
                break;
            }
            case 19: {
                this.priority = 0;
                break;
            }
            case 20: {
                this.priority = 0;
                break;
            }
            case 21: {
                this.priority = 1;
                break;
            }
            case 22: {
                this.priority = 1;
                break;
            }
            case 23: {
                this.priority = 0;
                break;
            }
            case 24: {
                this.priority = 0;
                break;
            }
            case 25: {
                this.priority = 0;
                break;
            }
            case 26: {
                this.priority = 0;
                break;
            }
            case 27: {
                this.priority = 1;
                break;
            }
            case 28: {
                this.priority = 1;
                break;
            }
            case 29: {
                this.priority = 0;
                break;
            }
            case 30: {
                this.priority = 1;
                break;
            }
            case 31: {
                this.priority = 0;
                break;
            }
            case 32: {
                this.priority = 1;
            }
        }
        this.setParent(isFragment);
    }

    public void setParent(IsFragment isFragment) {
        this.parent = isFragment;
        if (isFragment != null) {
            this.path = isFragment.name + "/" + this.name;
            isFragment.addChild(this);
        } else {
            this.path = this.name;
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public boolean isRoot() {
        return this.type == 1 || this.type == 6;
    }

    public boolean isServicePart() {
        switch (this.getType()) {
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public IsFragment getPartRoot() {
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this;
            }
        }
        if (this.parent != null) {
            return this.parent.getPartRoot();
        }
        return null;
    }

    public boolean containsVariables() {
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getText() {
        return this.getName();
    }

    public Image getImage() {
        switch (this.type) {
            case 1: {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/program.gif");
            }
            case 6: {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/ooprogram.png");
            }
            case 2: {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/fact_obj.gif");
            }
            case 3: {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/fact_obj.gif");
            }
            case 4: {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/method.gif");
            }
            case 5: {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/paragraph.gif");
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/cobolsec.gif");
            }
            case 16: {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/entrypnt.gif");
            }
            case 15: {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/entry-points.png");
            }
            case 17: {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/copy.gif");
            }
            case 18: {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/copylist.png");
            }
            case 28: {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/service_bridge.png");
            }
            case 29: 
            case 30: {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/soap.png");
            }
            case 31: 
            case 32: {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/rest.png");
            }
        }
        return null;
    }

    public Position getPosition() {
        return this.position;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setStartLine(int n) {
        this.startLine = n;
    }

    public void setEndLine(int n) {
        this.endLine = n;
    }

    public void setFile(IFile iFile) {
        this.file = iFile;
    }

    public IFile getFile() {
        if (this.file != null) {
            return this.file;
        }
        if (this.parent != null) {
            return this.parent.getFile();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public IsFragment getParent() {
        return this.parent;
    }

    public IsFragment[] getChildren() {
        return this.getChildren(true);
    }

    public IsFragment[] getChildren(boolean bl) {
        if (this.children == null) {
            return new IsFragment[0];
        }
        Object[] objectArray = new IsFragment[this.children.size()];
        this.children.toArray(objectArray);
        if (bl) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public IsFragment getChildAt(int n) {
        return (IsFragment)this.children.get(n);
    }

    public IsFragment removeChildAt(int n) {
        IsFragment isFragment = (IsFragment)this.children.remove(n);
        if (isFragment != null) {
            isFragment.setParent(null);
        }
        return isFragment;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public void setFilename(String string) {
        if (string != null) {
            string = string.replace('\\', '/');
        }
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    private Map<String, VarDecl> createVariableTable() {
        return new TreeMap<String, VarDecl>((Comparator<String>)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void putVarDecl(VarDecl varDecl) {
        VarDecl varDecl2;
        if (this.variableTable == null) {
            this.variableTable = this.createVariableTable();
        }
        if ((varDecl2 = (VarDecl)this.variableTable.get(varDecl.getName())) != null) {
            varDecl2.addDuplicateVar(varDecl);
            if (varDecl2.getQualifiedName() == null) {
                StringBuilder stringBuilder = new StringBuilder();
                IsFragment isFragment = varDecl2.getParent();
                if (isFragment instanceof VarDecl) {
                    stringBuilder.append(isFragment.getName());
                    isFragment = isFragment.getParent();
                    while (isFragment instanceof VarDecl) {
                        stringBuilder.append(" - ").append(isFragment.getName());
                        isFragment = isFragment.getParent();
                    }
                }
                varDecl2.setQualifiedName(stringBuilder.toString());
            }
        } else {
            this.variableTable.put(varDecl.getName(), varDecl);
        }
    }

    public VarDecl getVarDecl(String string) {
        VarDecl varDecl = null;
        if (this.variableTable != null) {
            varDecl = (VarDecl)this.variableTable.get(string);
        }
        if (varDecl == null) {
            if (this.parent != null) {
                if (this.type != 3) {
                    return this.parent.getVarDecl(string);
                }
                IsFragment[] isFragmentArray = this.parent.getChildren();
                IsFragment isFragment = null;
                for (int i = 0; i < isFragmentArray.length; ++i) {
                    if (isFragmentArray[i].type != 2) continue;
                    isFragment = isFragmentArray[i];
                    break;
                }
                if (isFragment != null) {
                    return isFragment.getVarDecl(string);
                }
                return null;
            }
            return null;
        }
        return varDecl;
    }

    public VarDecl[] getVariables() {
        return this.getVariables(0, false);
    }

    public VarDecl[] getVariables(int n, boolean bl) {
        if (this.variableTable == null) {
            return new VarDecl[0];
        }
        ArrayList arrayList = new ArrayList();
        for (VarDecl varDecl : this.variableTable.values()) {
            VarDecl.addAll((VarDecl)varDecl, arrayList, (int)n);
        }
        if (bl) {
            Collections.sort(arrayList);
        }
        return arrayList.toArray(new VarDecl[arrayList.size()]);
    }

    public IsFragment[] getScreenNames() {
        return this.getVariables(1, true);
    }

    public IsFragment[] getScreenNames(boolean bl) {
        return this.getVariables(1, bl);
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public IsFragment[] getFileDescriptors() {
        return this.getFileDescriptors(true);
    }

    public IsFragment[] getFileDescriptors(boolean bl) {
        IsFragment isFragment;
        if ((this.type == 1 || this.type == 4) && (isFragment = this.findChild(8)) != null && (isFragment = isFragment.findChild(12)) != null && isFragment.children != null) {
            Object[] objectArray = isFragment.children.toArray(new IsFragment[isFragment.children.size()]);
            if (bl) {
                Arrays.sort(objectArray);
            }
            return objectArray;
        }
        return new IsFragment[0];
    }

    private IsFragment findChild(int n) {
        if (this.children != null) {
            for (IsFragment isFragment : this.children) {
                if (isFragment.type != n) continue;
                return isFragment;
            }
        }
        return null;
    }

    public IsFragment[] getParagraphs() {
        return this.getParagraphs(true);
    }

    public IsFragment[] getParagraphs(boolean bl) {
        if (this.type != 1 && this.type != 4 || !this.hasChildren()) {
            return new IsFragment[0];
        }
        IsFragment isFragment = this.findChild(7);
        if (isFragment == null || isFragment.children == null) {
            return new IsFragment[0];
        }
        ArrayList<IsFragment> arrayList = new ArrayList<IsFragment>();
        for (IsFragment isFragment2 : isFragment.children) {
            if (isFragment2.type == 15) continue;
            if (isFragment2.type == 27) {
                if (isFragment2.children == null) continue;
                arrayList.addAll(isFragment2.children);
                continue;
            }
            arrayList.add(isFragment2);
        }
        Object[] objectArray = arrayList.toArray(new IsFragment[arrayList.size()]);
        if (bl) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IsFragment)) {
            return false;
        }
        return this.path.equals(((IsFragment)object).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private void addChild(IsFragment isFragment) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(isFragment);
    }

    public int compareTo(Object object) throws ClassCastException {
        IsFragment isFragment = (IsFragment)object;
        int n = this.priority - isFragment.priority;
        if (n != 0) {
            return n;
        }
        return this.name.compareTo(isFragment.name);
    }
}

