/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public enum PackageName {
    SIMPLE,
    QUALIFIED,
    INVALID;

    private static final Set<String> reserved;

    public static final PackageName check(String string) {
        if (string == null || string.length() == 0) {
            return INVALID;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        String string2 = null;
        int n = stringTokenizer.countTokens();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (".".equals(string3)) {
                if (string2 == null || ".".equals(string2)) {
                    return INVALID;
                }
            } else {
                if (reserved.contains(string3)) {
                    return INVALID;
                }
                if (!Character.isJavaIdentifierStart(string3.charAt(0))) {
                    return INVALID;
                }
                for (int i = 1; i < string3.length(); ++i) {
                    if (Character.isJavaIdentifierPart(string3.charAt(i))) continue;
                    return INVALID;
                }
            }
            string2 = string3;
        }
        if (".".equals(string2)) {
            return INVALID;
        }
        return n == 1 ? SIMPLE : QUALIFIED;
    }

    static {
        reserved = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "if", "goto", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while")));
    }
}

