/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.util;

import com.iscobol.interfaces.compiler.CachedFileFinder;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ProjectFileFinder
implements CachedFileFinder {
    private IContainer[] copyFolders;
    private String[] copyPaths;
    private String[] extensions;
    private Map<String, File> cache = new HashMap();

    public ProjectFileFinder(IProject iProject) {
        this(iProject, PluginUtilities.getPersistentProperty((IResource)iProject, (String)PluginUtilities.getCurrentSettingMode((IResource)iProject), (String)"-sp="), PluginUtilities.getPersistentProperty((IResource)iProject, (String)PluginUtilities.getCurrentSettingMode((IResource)iProject), (String)"-ce="));
    }

    public ProjectFileFinder(IProject iProject, String string, String string2) {
        StringTokenizer stringTokenizer;
        if (string != null && string.length() > 0) {
            stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            ArrayList<IContainer> arrayList = new ArrayList<IContainer>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                IContainer iContainer = PluginUtilities.getWorkspaceFolder((IProject)iProject, (String)string3);
                if (iContainer != null) {
                    arrayList.add(iContainer);
                }
                arrayList2.add(PluginUtilities.getWorkspaceFolderPath((IProject)iProject, (String)string3));
            }
            this.copyFolders = arrayList.toArray(new IContainer[arrayList.size()]);
            this.copyPaths = arrayList2.toArray(new String[arrayList2.size()]);
        } else {
            this.copyFolders = new IContainer[0];
            this.copyPaths = new String[0];
        }
        if (string2 != null && string2.length() > 0) {
            stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            this.extensions = new String[stringTokenizer.countTokens() + 1];
            this.extensions[0] = "";
            for (int i = 1; i < this.extensions.length; ++i) {
                this.extensions[i] = "." + stringTokenizer.nextToken();
            }
        } else {
            this.extensions = new String[]{""};
        }
    }

    public File findFile(String string) {
        if (this.cache.containsKey(string)) {
            return (File)this.cache.get(string);
        }
        File file = this.intFindFile(string);
        this.cache.put(string, file);
        return file;
    }

    public void clearCache() {
        this.cache.clear();
    }

    private File intFindFile(String string) {
        int n;
        int n2;
        File file = new File(string);
        if (file.exists() && file.isFile() && file.canRead()) {
            return file;
        }
        for (n2 = 0; n2 < this.copyFolders.length; ++n2) {
            for (n = 0; n < this.extensions.length; ++n) {
                Path path = new Path(string + this.extensions[n]);
                IResource iResource = PluginUtilities.findMember((IContainer)this.copyFolders[n2], (IPath)path);
                if (!(iResource instanceof IFile)) continue;
                return iResource.getLocation().toFile();
            }
        }
        for (n2 = 0; n2 < this.copyPaths.length; ++n2) {
            for (n = 0; n < this.extensions.length; ++n) {
                file = new File(this.copyPaths[n2] + "/" + string + this.extensions[n]);
                if (!file.exists() || file.isDirectory()) continue;
                return file;
            }
        }
        return null;
    }
}

