/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.util;

import com.iscobol.plugins.editor.util.IsXmlDecoder;
import com.iscobol.plugins.editor.util.SettingList;
import com.iscobol.plugins.editor.util.SettingMode;
import java.beans.DefaultPersistenceDelegate;
import java.beans.XMLEncoder;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProjectSettingList
extends SettingList {
    private Map fileSettingList = new LinkedHashMap();

    public ProjectSettingList(String string) {
        super(string);
        this.setCurrentMode("Debug");
    }

    public ProjectSettingList() {
        super(null);
    }

    public void setCurrentMode(String string) {
        this.currentMode = string;
        if (this.currentMode == null) {
            this.currentMode = "Debug";
        }
    }

    public void setFileSettings(Hashtable hashtable) {
        this.setFileSettings((Map)hashtable);
    }

    public void setFileSettings(Map map) {
        this.fileSettingList = map;
    }

    public Map getFileSettings() {
        return this.fileSettingList;
    }

    public SettingList getFileSettingList(String string) {
        return (SettingList)this.fileSettingList.get(string);
    }

    public void putFileSettingList(SettingList settingList) {
        this.fileSettingList.put(settingList.getName(), settingList);
    }

    public void removeFileSettingList(String string) {
        this.fileSettingList.remove(string);
    }

    public void removeMode(String string) {
        this.modes.remove(string);
        if (string.equals(this.currentMode)) {
            this.currentMode = "Debug";
        }
    }

    public void save(OutputStream outputStream) {
        XMLEncoder xMLEncoder = new XMLEncoder(outputStream);
        DefaultPersistenceDelegate defaultPersistenceDelegate = new DefaultPersistenceDelegate(new String[]{"name"});
        xMLEncoder.setPersistenceDelegate(ProjectSettingList.class, defaultPersistenceDelegate);
        xMLEncoder.setPersistenceDelegate(SettingList.class, defaultPersistenceDelegate);
        xMLEncoder.setPersistenceDelegate(SettingMode.class, defaultPersistenceDelegate);
        xMLEncoder.writeObject(this);
        xMLEncoder.close();
    }

    public void load(InputStream inputStream) {
        IsXmlDecoder isXmlDecoder = new IsXmlDecoder(inputStream);
        ProjectSettingList projectSettingList = (ProjectSettingList)isXmlDecoder.readObject();
        this.setName(projectSettingList.getName());
        this.setCurrentMode(projectSettingList.getCurrentMode());
        this.setModes(projectSettingList.getModes());
        this.setFileSettings(projectSettingList.getFileSettings());
        isXmlDecoder.close();
    }
}

