/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.wizards.AbstractImportPage;
import java.io.File;
import java.io.FileFilter;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractImportPage<T>
extends WizardPage {
    public static final int YES = 0;
    public static final int YES_ALL = 1;
    public static final int NO = 2;
    public static final int NO_ALL = 3;
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private Tree dirTree;
    private TreeItem dirTreeRootItem;
    protected Tree fileTree;
    private Button advancedBtn;
    private Section advancedSec;
    private Tree destTree;
    private TreeItem lastFileItem;
    private TreeItem lastDirItem;
    private TreeEditor fileTreeEditor;
    private Button selectAll;
    private Button deselectAll;
    private Text fromDir;
    private IResource parentResource;
    protected String[] progNames;
    protected File[] progFiles;
    public boolean existsProjects = false;
    protected int overwriteCode = 2;
    protected int greaterVersionCode = 2;
    private FileFilter filter = new /* Unavailable Anonymous Inner Class!! */;

    public AbstractImportPage(String string, String string2) {
        super(string, string2, null);
    }

    protected abstract String getLastImportDirectory();

    protected abstract void setLastImportDirectory(String var1);

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    protected boolean isIscobolProject(IProject iProject) {
        try {
            return iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean allowRenaming() {
        return true;
    }

    public void createControl(Composite composite) {
        String string;
        Object object;
        Composite composite2;
        Composite composite3 = new Composite(composite, 0);
        this.setControl((Control)composite3);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite3.setLayout((Layout)gridLayout);
        Label label = new Label(composite3, 0);
        label.setText(IsresourceBundle.getString((String)"sel_dst_prj_lbl"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.destTree = new Tree(composite3, 2048);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 80;
        gridData.minimumHeight = 80;
        this.destTree.setLayoutData((Object)gridData);
        this.loadDestinationTree(this.destTree);
        this.destTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.hasTaggedAreaControls()) {
            this.createTaggedAreaControls(composite3, 3);
        }
        label = new Label(composite3, 0);
        label.setText("From directory");
        this.fromDir = new Text(composite3, 2048);
        this.fromDir.addListener(14, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.fromDir.addTraverseListener((TraverseListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData(768);
        this.fromDir.setLayoutData((Object)gridData);
        Button button = new Button(composite3, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite composite4 = new Composite(composite3, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        composite4.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite4.setLayout((Layout)gridLayout);
        if (this.allowRenaming()) {
            label = new Label(composite4, 0);
            label = new Label(composite4, 0);
            label.setText("(" + IsresourceBundle.getString((String)"rename_help_msg") + ")");
            gridData = new GridData();
            gridData.horizontalIndent = 10;
            label.setLayoutData((Object)gridData);
        }
        this.dirTree = new Tree(composite4, 268437508);
        gridData = new GridData(1808);
        gridData.heightHint = 250;
        gridData.widthHint = 300;
        this.dirTree.setLayoutData((Object)gridData);
        this.dirTree.addListener(36, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.dirTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileTree = new Tree(composite4, 2084);
        if (this.allowRenaming()) {
            this.fileTree.setToolTipText(IsresourceBundle.getString((String)"rename_help_msg"));
            this.fileTreeEditor = new TreeEditor(this.fileTree);
            this.fileTree.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.fileTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData(1808);
        gridData.heightHint = 250;
        gridData.widthHint = 300;
        gridData.horizontalIndent = 10;
        this.fileTree.setLayoutData((Object)gridData);
        if (this.hasAdvancedControls()) {
            composite2 = new Composite(composite4, 0);
            gridData = new GridData();
            gridData.verticalSpan = 2;
            composite2.setLayoutData((Object)gridData);
            gridLayout = new GridLayout();
            composite2.setLayout((Layout)gridLayout);
            this.advancedBtn = new Button(composite2, 8);
            this.advancedBtn.setText("Advanced >>");
            this.advancedBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.advancedSec = new Section(composite2, 0);
            this.advancedSec.setExpanded(false);
            object = new Composite((Composite)this.advancedSec, 0);
            this.advancedSec.setClient((Control)object);
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            object.setLayoutData((Object)gridData);
            this.createAdvancedControls((Composite)object);
        } else {
            new Label(composite4, 0);
        }
        this.createButtonPanel(composite4);
        composite2 = null;
        if (this.selection != null && (composite2 = this.getContainer(object = this.selection.getFirstElement())) != null) {
            this.select((IResource)composite2);
        }
        if ((string = this.getLastImportDirectory()) != null) {
            this.fromDir.setText(string);
            this.loadSourceDirectoryTree(string);
        }
        this.validatePage();
    }

    protected void handleFileTreeSelection(SelectionEvent selectionEvent) {
        TreeItem treeItem;
        this.lastFileItem = treeItem = (TreeItem)selectionEvent.item;
        this.setProgramFiles();
        this.validatePage();
    }

    protected void setSelectedAll(boolean bl) {
        for (TreeItem treeItem : this.fileTree.getItems()) {
            treeItem.setChecked(bl);
            if (treeItem.getItemCount() <= 0) continue;
            PluginUtilities.checkItems((TreeItem)treeItem, (boolean)bl);
        }
        this.setProgramFiles();
        this.validatePage();
    }

    protected Composite createButtonPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.selectAll = new Button(composite2, 8);
        this.selectAll.setText("Select All");
        this.selectAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deselectAll = new Button(composite2, 8);
        this.deselectAll.setText("Deselect All");
        this.deselectAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    protected abstract void loadDestinationTree(Tree var1);

    protected boolean hasAdvancedControls() {
        return false;
    }

    protected void createAdvancedControls(Composite composite) {
    }

    protected boolean hasTaggedAreaControls() {
        return false;
    }

    protected void createTaggedAreaControls(Composite composite, int n) {
    }

    private void loadSourceDirectoryTree(String string) {
        this.dirTree.removeAll();
        this.fileTree.removeAll();
        File file = new File(string);
        this.progNames = null;
        this.progFiles = null;
        if (file.exists() && file.isDirectory()) {
            this.setLastImportDirectory(string);
            this.dirTreeRootItem = new TreeItem(this.dirTree, 0);
            this.dirTreeRootItem.setText(file.getName());
            this.dirTreeRootItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/folder.gif"));
            this.dirTreeRootItem.setData("file", (Object)file);
            File[] fileArray = PluginUtilities.listFiles((File)file, (FileFilter)this.filter);
            if (fileArray != null && fileArray.length > 0) {
                this.dirTreeRootItem.setData("children", (Object)fileArray);
                this.dirTreeRootItem.setItemCount(fileArray.length);
                this.dirTreeRootItem.setExpanded(true);
            }
            this.loadFileTree(file);
        }
        if (this.dirTree.getItemCount() > 0) {
            this.dirTree.select(this.dirTree.getItem(0));
        }
        this.validatePage();
    }

    protected void setPageValid() {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }

    protected void setPageInvalid(String string) {
        this.setErrorMessage(string);
        this.setMessage(null);
        this.setPageComplete(false);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
        this.workbench = iWorkbench;
    }

    protected File getSelectedDirectory() {
        if (this.dirTree.getSelectionCount() > 0) {
            TreeItem treeItem = this.dirTree.getSelection()[0];
            return (File)treeItem.getData("file");
        }
        return null;
    }

    protected void activateEditor(TreeItem treeItem) {
        boolean bl = true;
        Composite composite = new Composite((Composite)this.fileTree, 0);
        if (bl) {
            composite.setBackground(IscobolEditorPlugin.getDefault().getColorProvider().getColor(new RGB(0, 0, 0)));
        }
        Text text = new Text(composite, 0);
        int n = bl ? 1 : 0;
        composite.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        text.addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
        text.addTraverseListener((TraverseListener)new /* Unavailable Anonymous Inner Class!! */);
        text.addVerifyListener((VerifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileTreeEditor.setEditor((Control)composite, treeItem);
        text.setText(treeItem.getText());
        text.selectAll();
        text.setFocus();
    }

    protected boolean validatePage() {
        boolean bl;
        if (!this.existsProjects) {
            this.setPageInvalid(IsresourceBundle.getString((String)"no_projects_msg"));
            return false;
        }
        boolean bl2 = bl = this.validateParent() && this.validateSelection();
        if (bl) {
            this.setPageValid();
        }
        return bl;
    }

    protected boolean validateParent() {
        if (this.parentResource == null) {
            this.setPageInvalid(IsresourceBundle.getString((String)"select_parent_prj_msg"));
            return false;
        }
        try {
            if (this.parentResource.getProject().getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") == null) {
                this.setPageInvalid("'" + this.parentResource.getProject().getName() + "': " + IsresourceBundle.getString((String)"not_iscobol_prj_msg"));
                return false;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return true;
    }

    protected abstract boolean validateSelection();

    protected void setProgramFiles() {
        Vector<String> vector = new Vector<String>();
        Vector<File> vector2 = new Vector<File>();
        TreeItem[] treeItemArray = this.fileTree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (!treeItemArray[i].getChecked()) continue;
            vector.addElement(treeItemArray[i].getText());
            vector2.addElement((File)treeItemArray[i].getData());
        }
        if (vector2.size() == 0) {
            this.progNames = null;
            this.progFiles = null;
        } else {
            this.progNames = new String[vector.size()];
            vector.toArray(this.progNames);
            this.progFiles = new File[vector2.size()];
            vector2.toArray(this.progFiles);
        }
    }

    protected boolean exists(IResource iResource) {
        IPath iPath = iResource.getLocation();
        return iPath != null && iPath.toFile().exists();
    }

    protected abstract void createFiles(IProgressMonitor var1);

    protected void createFiles() {
        if (this.progNames == null) {
            return;
        }
        17 var1_1 = new /* Unavailable Anonymous Inner Class!! */;
        PlatformUI.getWorkbench().getProgressService().showInDialog(this.getWorkbench().getActiveWorkbenchWindow().getShell(), (Job)var1_1);
        var1_1.schedule();
    }

    public IResource getParentResource() {
        return this.parentResource;
    }

    private void select(IResource iResource) {
        if (iResource != null) {
            this.select(this.destTree.getItems(), iResource);
            this.parentResource = iResource;
        }
        this.validatePage();
    }

    private boolean select(TreeItem[] treeItemArray, IResource iResource) {
        int n;
        for (n = 0; n < treeItemArray.length; ++n) {
            if (!treeItemArray[n].getData().equals(iResource)) continue;
            this.destTree.select(treeItemArray[n]);
            return true;
        }
        for (n = 0; n < treeItemArray.length; ++n) {
            if (!this.select(treeItemArray[n].getItems(), iResource)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean validateFileName(String var1);

    protected void loadFileTree(File file) {
        File[] fileArray = PluginUtilities.listFiles((File)file, (FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.fileTree.removeAll();
        for (int i = 0; i < fileArray.length; ++i) {
            TreeItem treeItem = new TreeItem(this.fileTree, 0);
            String string = this.getFileTreeItemText(fileArray[i].getName());
            treeItem.setText(string);
            treeItem.setData((Object)fileArray[i]);
            treeItem.setImage(this.getFileTreeItemImage());
        }
        this.progNames = null;
        this.validatePage();
    }

    protected boolean isExistsProjects() {
        return this.existsProjects;
    }

    protected void setExistsProjects(boolean bl) {
        this.existsProjects = bl;
    }

    protected abstract Image getFileTreeItemImage();

    protected String getFileTreeItemText(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    protected int openMessageDialog(String string) {
        int[] nArray = new int[]{0};
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return nArray[0];
    }

    protected abstract IFile getFile(Object var1);

    protected abstract IResource getContainer(Object var1);

    protected boolean importProgramInfo(T t, File file) {
        if (this.exists((IResource)this.getFile(t))) {
            switch (this.overwriteCode) {
                case 1: {
                    return this.tryImportProgramInfo(t, file);
                }
                case 0: 
                case 2: {
                    this.overwriteCode = this.openMessageDialog("Overwrite program '" + this.getFile(t).getName() + "'");
                    if (this.overwriteCode < 0) {
                        this.overwriteCode = 2;
                    }
                    switch (this.overwriteCode) {
                        case 0: 
                        case 1: {
                            return this.tryImportProgramInfo(t, file);
                        }
                    }
                    return false;
                }
            }
            return false;
        }
        return this.tryImportProgramInfo(t, file);
    }

    protected boolean tryImportProgramInfo(T t, File file) {
        try {
            return this.importProgramInfo0(t, file);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected abstract boolean importProgramInfo0(T var1, File var2) throws Exception;

    protected boolean checkRelease(String string, String string2) {
        if (string != null && string.compareTo(PluginUtilities.getIscobolRelease()) > 0) {
            switch (this.greaterVersionCode) {
                case 1: {
                    return true;
                }
                case 0: 
                case 2: {
                    this.greaterVersionCode = this.openMessageDialog("The file '" + string2 + "' is saved with isCOBOL release '" + string + "', so some settings could be lost. Do you want to continue?");
                    if (this.greaterVersionCode < 0) {
                        this.greaterVersionCode = 2;
                    }
                    switch (this.greaterVersionCode) {
                        case 0: 
                        case 1: {
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    static /* synthetic */ IResource access$002(AbstractImportPage abstractImportPage, IResource iResource) {
        abstractImportPage.parentResource = iResource;
        return abstractImportPage.parentResource;
    }

    static /* synthetic */ Text access$100(AbstractImportPage abstractImportPage) {
        return abstractImportPage.fromDir;
    }

    static /* synthetic */ void access$200(AbstractImportPage abstractImportPage, String string) {
        abstractImportPage.loadSourceDirectoryTree(string);
    }

    static /* synthetic */ TreeItem access$300(AbstractImportPage abstractImportPage) {
        return abstractImportPage.dirTreeRootItem;
    }

    static /* synthetic */ FileFilter access$400(AbstractImportPage abstractImportPage) {
        return abstractImportPage.filter;
    }

    static /* synthetic */ Tree access$500(AbstractImportPage abstractImportPage) {
        return abstractImportPage.dirTree;
    }

    static /* synthetic */ TreeItem access$600(AbstractImportPage abstractImportPage) {
        return abstractImportPage.lastDirItem;
    }

    static /* synthetic */ TreeItem access$602(AbstractImportPage abstractImportPage, TreeItem treeItem) {
        abstractImportPage.lastDirItem = treeItem;
        return abstractImportPage.lastDirItem;
    }

    static /* synthetic */ TreeItem access$700(AbstractImportPage abstractImportPage) {
        return abstractImportPage.lastFileItem;
    }

    static /* synthetic */ Section access$800(AbstractImportPage abstractImportPage) {
        return abstractImportPage.advancedSec;
    }

    static /* synthetic */ Button access$900(AbstractImportPage abstractImportPage) {
        return abstractImportPage.advancedBtn;
    }

    static /* synthetic */ TreeEditor access$1000(AbstractImportPage abstractImportPage) {
        return abstractImportPage.fileTreeEditor;
    }
}

