/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.dialogs.ClasspathPanel;
import com.iscobol.plugins.editor.util.ClasspathItem;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;

public class ClasspathPage
extends PropertyPage
implements IWizardPage {
    private IWizard wizard;
    private IWizardPage prevPage;
    private IWizardPage nextPage;
    private ClasspathPanel panel;

    public ClasspathPage() {
        this.setTitle(IsresourceBundle.getString((String)"class_path_title"));
        this.noDefaultAndApplyButton();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public String getName() {
        return "";
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    public void setWizard(IWizard iWizard) {
        this.wizard = iWizard;
    }

    public void setNextPage(IWizardPage iWizardPage) {
        this.nextPage = iWizardPage;
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    public void setPreviousPage(IWizardPage iWizardPage) {
        this.prevPage = iWizardPage;
    }

    public IWizardPage getPreviousPage() {
        return this.prevPage;
    }

    public boolean isPageComplete() {
        return true;
    }

    private boolean isJar(String string) {
        return string.endsWith(".jar") || string.endsWith(".zip");
    }

    public Control createContents(Composite composite) {
        this.panel = new ClasspathPanel((DialogPage)this);
        Control control = this.panel.createContents(composite, "Classpath");
        String string = null;
        IProject iProject = null;
        try {
            iProject = (IProject)PluginUtilities.castOrAdapt((Object)this.getElement(), IProject.class);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        ClasspathItem[] classpathItemArray = new ClasspathItem[]{};
        if (iProject != null) {
            string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.classpath");
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            classpathItemArray = new ClasspathItem[stringTokenizer.countTokens()];
            for (int i = 0; i < classpathItemArray.length; ++i) {
                int n;
                IFile iFile;
                boolean bl;
                String string2 = stringTokenizer.nextToken();
                File file = new File(string2);
                if (file.isAbsolute()) {
                    bl = file.exists();
                    iFile = null;
                    n = this.isJar(file.getName()) ? 5 : 4;
                } else {
                    IFile iFile2;
                    Path path = new Path(string2);
                    IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    if (this.isJar(file.getName())) {
                        iFile2 = iWorkspaceRoot.getFile((IPath)path);
                        bl = iFile2 != null && iFile2.exists();
                        n = 3;
                        iFile = iFile2;
                    } else if (path.segmentCount() == 1) {
                        iFile2 = iWorkspaceRoot.getProject(string2);
                        bl = iFile2 != null && iFile2.exists();
                        n = 1;
                        iFile = iFile2;
                    } else {
                        iFile2 = iWorkspaceRoot.getFolder((IPath)path);
                        bl = iFile2 != null && iFile2.exists();
                        n = 2;
                        iFile = iFile2;
                    }
                }
                classpathItemArray[i] = new ClasspathItem(string2, bl, n);
                classpathItemArray[i].resource = iFile;
            }
        }
        this.panel.setClasspath(classpathItemArray);
        return control;
    }

    public boolean isValid() {
        return true;
    }

    public boolean performOk() {
        IProject iProject = null;
        try {
            iProject = (IProject)PluginUtilities.castOrAdapt((Object)this.getElement(), IProject.class);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this.performOk(iProject);
    }

    public boolean performOk(IProject iProject) {
        String string = this.getClasspath();
        if (iProject != null) {
            PluginUtilities.setPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.classpath", (String)string);
            PluginUtilities.saveProjectOptions((IProject)iProject);
        }
        return true;
    }

    private String getClasspath() {
        ClasspathItem[] classpathItemArray = this.panel.getClasspath();
        StringBuilder stringBuilder = new StringBuilder();
        for (ClasspathItem classpathItem : classpathItemArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(classpathItem.path);
        }
        return stringBuilder.toString();
    }
}

